/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.CommManagerStatusChangeListener;
import pt.lsts.neptus.comm.manager.CommonCommBaseImplementation;
import pt.lsts.neptus.comm.manager.SystemCommBaseInfo;
import pt.lsts.neptus.messages.IMessage;
import pt.lsts.neptus.messages.MessageFilter;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public abstract class CommBaseManager<M extends IMessage, Mi extends MessageInfo, C extends SystemCommBaseInfo<M, Mi, I>, I, L extends CommManagerStatusChangeListener>
extends CommonCommBaseImplementation<M, Mi>
implements MessageListener<Mi, M> {
    protected LinkedHashSet<L> statusListeners = new LinkedHashSet();
    protected boolean started = false;
    public static final int MANAGER_START = 0;
    public static final int MANAGER_STOP = 1;
    public static final int MANAGER_ERROR = 2;
    public static final int SYS_COMM_ON = 0;
    public static final int SYS_COMM_OFF = 1;
    public static final int SYS_NEW = 2;
    public static final int SYS_CTRL_CHANGED = 3;
    protected Thread timerThread;
    protected LinkedHashMap<I, C> commInfo = new LinkedHashMap();

    protected CommBaseManager() {
    }

    @Override
    public synchronized boolean start() {
        NeptusLog.pub().debug((Object)"Starting comms");
        if (this.started) {
            return true;
        }
        if (this.messageProcessor != null) {
            this.messageProcessor.stopProcessing();
            this.messageProcessor = null;
        }
        this.messageProcessor = new CommonCommBaseImplementation.MessageProcessor(this, this.getClass().getSimpleName() + " [" + this.hashCode() + "] :: " + CommonCommBaseImplementation.MessageProcessor.class.getSimpleName());
        this.messageProcessor.start();
        if (this.initManagerComms()) {
            if (!this.startManagerComms()) {
                this.messageProcessor.stopProcessing();
                this.messageProcessor = null;
                return false;
            }
        } else {
            this.messageProcessor.stopProcessing();
            this.messageProcessor = null;
            return false;
        }
        this.sendManagerStatusChanged(0, "");
        for (SystemCommBaseInfo vic : this.commInfo.values()) {
            vic.resumeMsgProcessing();
        }
        super.start();
        if (this.timerThread == null) {
            this.timerThread = this.getTimerThread();
            this.timerThread.setDaemon(true);
            this.timerThread.start();
        }
        this.started = true;
        return true;
    }

    public Thread getTimerThread() {
        Thread t = new Thread(this.getClass().getSimpleName() + " [" + this.hashCode() + "] - Thread"){
            long timeControl;
            {
                this.timeControl = -1L;
            }

            @Override
            public void run() {
                try {
                    long prevTime = System.currentTimeMillis();
                    while (true) {
                        if (System.currentTimeMillis() - prevTime > 2000L) {
                            if ((double)this.timeControl - CommBaseManager.this.getArrivalTimeMillisLastMsg() > 10000.0) {
                                CommBaseManager.this.setActive(false, null, null);
                            }
                            for (SystemCommBaseInfo cinf : CommBaseManager.this.commInfo.values()) {
                                if (!((double)this.timeControl - cinf.getArrivalTimeMillisLastMsg() > 10000.0)) continue;
                                cinf.setActive(false, null, null);
                            }
                            prevTime = System.currentTimeMillis();
                            this.timeControl = System.currentTimeMillis();
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        };
        return t;
    }

    @Override
    public synchronized boolean stop() {
        boolean ret;
        try {
            if (!this.started) {
                return true;
            }
            NeptusLog.pub().debug((Object)"Stopping comms");
            if (this.timerThread != null) {
                this.timerThread.interrupt();
                this.timerThread = null;
            }
            this.stopManagerComms();
            if (this.messageProcessor != null) {
                this.messageProcessor.stopProcessing();
                this.messageProcessor = null;
                this.msgQueue.clear();
                this.infoQueue.clear();
            }
            for (SystemCommBaseInfo vic : this.commInfo.values()) {
                vic.stopMsgProcessing();
            }
            this.sendManagerStatusChanged(1, "");
            this.started = false;
            ret = true;
        }
        catch (Exception e) {
            GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), e);
            NeptusLog.pub().error((Object)"CommBase Manager init error!", (Throwable)e);
            ret = false;
        }
        super.stop();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void sendManagerStatusChanged(int status, String msg) {
        LinkedHashSet<L> linkedHashSet = this.statusListeners;
        synchronized (linkedHashSet) {
            for (CommManagerStatusChangeListener sl : this.getStatusListeners()) {
                sl.managerStatusChanged(status, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendManagerVehicleStatusChanged(VehicleType vehicle, int status) {
        LinkedHashSet<L> linkedHashSet = this.statusListeners;
        synchronized (linkedHashSet) {
            for (CommManagerStatusChangeListener sl : this.statusListeners) {
                sl.managerVehicleStatusChanged(vehicle, status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendManagerVehicleAdded(VehicleType vehicle) {
        LinkedHashSet<L> linkedHashSet = this.statusListeners;
        synchronized (linkedHashSet) {
            for (CommManagerStatusChangeListener sl : this.statusListeners) {
                sl.managerVehicleAdded(vehicle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendManagerVehicleRemoved(VehicleType vehicle) {
        LinkedHashSet<L> linkedHashSet = this.statusListeners;
        synchronized (linkedHashSet) {
            for (CommManagerStatusChangeListener sl : this.statusListeners) {
                sl.managerVehicleRemoved(vehicle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendManagerSystemStatusChanged(I commId, int status) {
        LinkedHashSet<L> linkedHashSet = this.statusListeners;
        synchronized (linkedHashSet) {
            for (CommManagerStatusChangeListener sl : this.statusListeners) {
                sl.managerSystemStatusChanged(commId.toString(), status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendManagerSystemAdded(I commId) {
        LinkedHashSet<L> linkedHashSet = this.statusListeners;
        synchronized (linkedHashSet) {
            for (CommManagerStatusChangeListener sl : this.statusListeners) {
                sl.managerSystemAdded(commId.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendManagerSystemRemoved(I commId) {
        LinkedHashSet<L> linkedHashSet = this.statusListeners;
        synchronized (linkedHashSet) {
            for (CommManagerStatusChangeListener sl : this.statusListeners) {
                sl.managerSystemRemoved(commId.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedHashSet<L> getStatusListeners() {
        LinkedHashSet<L> linkedHashSet = this.statusListeners;
        synchronized (linkedHashSet) {
            return this.statusListeners;
        }
    }

    protected void setStatusListeners(LinkedHashSet<L> listeners) {
        this.statusListeners = listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatusListenersSize() {
        LinkedHashSet<L> linkedHashSet = this.statusListeners;
        synchronized (linkedHashSet) {
            return this.statusListeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addStatusListener(L listener) {
        LinkedHashSet<L> linkedHashSet = this.statusListeners;
        synchronized (linkedHashSet) {
            boolean ret = this.statusListeners.add(listener);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStatusListener(L listener) {
        LinkedHashSet<L> linkedHashSet = this.statusListeners;
        synchronized (linkedHashSet) {
            boolean ret = this.statusListeners.remove(listener);
            return ret;
        }
    }

    public String getStatusListenersAsHtmlFragment() {
        String ret = "";
        boolean first = true;
        for (CommManagerStatusChangeListener lst : this.getStatusListeners()) {
            if (!first) {
                ret = ret + "<br>";
            } else {
                first = false;
            }
            ret = ret + lst.getClass().getName() + " [" + Integer.toHexString(lst.hashCode()) + "]";
        }
        return ret;
    }

    public String getListenersAsHtmlFragment() {
        String ret = "";
        boolean first = true;
        for (MessageListener messageListener : this.getListeners()) {
            if (!first) {
                ret = ret + "<br>";
            } else {
                first = false;
            }
            ret = ret + messageListener.getClass().getName() + " [" + Integer.toHexString(messageListener.hashCode()) + "]";
            if (useListenersQueues) {
                try {
                    ret = ret + " {" + this.getListenersQueueProvider().get(messageListener).getMessageCount() + " msgs}";
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.lastListener != messageListener) continue;
            ret = ret + " working";
        }
        return ret;
    }

    public String getListenersAsHtmlFragment(I id) {
        String ret = "";
        SystemCommBaseInfo ci = (SystemCommBaseInfo)this.commInfo.get(id);
        MessageListener lastListenerForCom = ci.getLastListener();
        if (ci != null) {
            boolean first = true;
            for (MessageListener messageListener : ci.getListeners()) {
                if (!first) {
                    ret = ret + "<br>";
                } else {
                    first = false;
                }
                ret = ret + messageListener.getClass().getName() + " [" + Integer.toHexString(messageListener.hashCode()) + "]";
                if (useListenersQueues) {
                    try {
                        ret = ret + " {" + ci.getListenersQueueProvider().get(messageListener).getMessageCount() + " msgs}";
                    }
                    catch (Exception e) {
                        NeptusLog.pub().warn((Object)this.getClass().getSimpleName(), (Throwable)e);
                    }
                }
                if (lastListenerForCom != messageListener) continue;
                ret = ret + " working";
            }
        }
        return ret;
    }

    public C getCommInfoById(I id) {
        return (C)((SystemCommBaseInfo)this.getCommInfo().get(id));
    }

    public LinkedHashMap<I, C> getCommInfo() {
        return this.commInfo;
    }

    protected void setCommInfo(LinkedHashMap<I, C> commInfo) {
        this.commInfo = commInfo;
    }

    public synchronized C initSystemCommInfo(I vIdS, String inetAddress) {
        return null;
    }

    protected abstract boolean initManagerComms();

    protected abstract boolean startManagerComms();

    protected abstract boolean stopManagerComms();

    public abstract boolean sendMessageToVehicle(M var1, VehicleType var2, String var3);

    public abstract boolean sendMessageToVehicle(M var1, String var2, String var3);

    public abstract boolean sendMessage(M var1, I var2, String var3);

    public boolean addListener(MessageListener<Mi, M> listener, I vehicleCommId) {
        return this.addListener(listener, vehicleCommId, null);
    }

    public boolean addListener(MessageListener<Mi, M> listener, I vehicleCommId, MessageFilter<Mi, M> filter) {
        SystemCommBaseInfo vci = null;
        I vIdS = vehicleCommId;
        if (vehicleCommId == null) {
            return false;
        }
        vci = (SystemCommBaseInfo)this.commInfo.get(vIdS);
        if (vci == null) {
            this.initSystemCommInfo(vIdS, "");
            vci = (SystemCommBaseInfo)this.commInfo.get(vIdS);
        }
        boolean ret = false;
        if (vci != null) {
            ret = vci.addListener((MessageListener)listener, (MessageFilter)filter);
        }
        NeptusLog.pub().debug((Object)("Add listener for vehicle: " + vIdS + "."));
        return ret;
    }

    public boolean removeListener(MessageListener<Mi, M> listener, I vehicleCommId) {
        SystemCommBaseInfo vci = null;
        I vIdS = vehicleCommId;
        if (vehicleCommId == null) {
            return false;
        }
        vci = (SystemCommBaseInfo)this.commInfo.get(vIdS);
        if (vci == null) {
            return false;
        }
        boolean ret = vci.removeListener((MessageListener)listener);
        return ret;
    }

    public final boolean removeListenerFromAllSystems(MessageListener<Mi, M> listener) {
        boolean ret = false;
        int r = 0;
        for (SystemCommBaseInfo vci : this.commInfo.values()) {
            boolean rt = vci.removeListener((MessageListener)listener);
            boolean bl = ret = ret || rt;
            if (!rt) continue;
            ++r;
        }
        NeptusLog.pub().debug((Object)("Removed " + listener.getClass().getName() + " | " + r + " | " + listener.hashCode()));
        return ret;
    }

    public boolean isRunning() {
        return this.started;
    }

    public int getNumberOfSystems() {
        return this.commInfo.size();
    }
}

