/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.MessageListenerQueueProvider;
import pt.lsts.neptus.comm.manager.MessagePackage;
import pt.lsts.neptus.messages.IMessage;
import pt.lsts.neptus.messages.MessageFilter;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.conf.PreferencesListener;

abstract class CommonCommBaseImplementation<M extends IMessage, Mi extends MessageInfo>
implements MessageListener<Mi, M> {
    protected static boolean useListenersQueues = true;
    protected LinkedList<M> msgQueue = new LinkedList();
    protected LinkedList<Mi> infoQueue = new LinkedList();
    protected MessageProcessor messageProcessor = null;
    protected boolean isActive = false;
    protected double processTimeMillisLastMsg = -1.0;
    protected long processMsgsInLastSec = 0L;
    protected double processMessageFreq = -1.0;
    protected double processLastSecondMsgTime = 0.0;
    protected double processDeltaTxRxTimeNanosLastMsg = -1.0;
    protected double arrivalTimeMillisLastMsg = -1.0;
    protected long arrivalMsgsInLastSec = 0L;
    protected double arrivalMessageFreq = -1.0;
    protected double arrivalLastSecondMsgTime = 0.0;
    protected double arrivalDeltaTxRxTimeNanosLastMsg = -1.0;
    protected long counter = 0L;
    private long lastFullQueueWarning = -1L;
    protected LinkedHashSet<MessageListener<Mi, M>> listeners = new LinkedHashSet();
    protected MessageListener<Mi, M> lastListener = null;
    protected LinkedHashMap<MessageListener<Mi, M>, MessageListenerQueueProvider<Mi, M>> listenersQueueProvider = new LinkedHashMap();
    private Hashtable<String, MessagePackage<Mi, M>> lastMessagesOfType = new Hashtable();
    protected int queueMaxSize = 1024;
    protected long seqInstanceNr = 0L;
    protected long minDelay = -1L;
    protected LinkedHashMap<String, Long> lastReceivedTime = new LinkedHashMap();
    protected PreferencesListener preferencesListener = new PreferencesListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preferencesUpdated() {
            CommonCommBaseImplementation.this.queueMaxSize = GeneralPreferences.commsQueueSize;
            CommonCommBaseImplementation.this.minDelay = GeneralPreferences.commsMsgSeparationMillis;
            LinkedHashSet linkedHashSet = CommonCommBaseImplementation.this.listeners;
            synchronized (linkedHashSet) {
                for (MessageListener messageListener : CommonCommBaseImplementation.this.listeners) {
                    if (!(messageListener instanceof MessageListenerQueueProvider)) continue;
                    ((MessageListenerQueueProvider)messageListener).setQueueMaxSize(CommonCommBaseImplementation.this.queueMaxSize);
                }
            }
        }
    };

    CommonCommBaseImplementation() {
    }

    protected boolean start() {
        NeptusLog.pub().info((Object)("Starting comm. " + this.getClass().getSimpleName()));
        this.preferencesListener.preferencesUpdated();
        GeneralPreferences.addPreferencesListener(this.preferencesListener);
        return true;
    }

    protected boolean stop() {
        NeptusLog.pub().warn((Object)("Stoping comm. " + this.getClass().getSimpleName()));
        GeneralPreferences.removePreferencesListener(this.preferencesListener);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getMsgQueueLength() {
        LinkedList<M> linkedList = this.msgQueue;
        synchronized (linkedList) {
            return this.msgQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearMsgQueue() {
        LinkedList<M> linkedList = this.msgQueue;
        synchronized (linkedList) {
            this.msgQueue.clear();
            this.infoQueue.clear();
            try {
                for (MessageListener<Mi, M> msgListener : this.listenersQueueProvider.keySet()) {
                    this.listenersQueueProvider.get(msgListener).clearMessages();
                }
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e.getMessage());
            }
            this.clearLastMessageOfType();
        }
    }

    protected final LinkedHashSet<MessageListener<Mi, M>> getListeners() {
        return this.listeners;
    }

    public final int getListenersSize() {
        return this.getListeners().size();
    }

    public final MessageListener<Mi, M> getLastListener() {
        return this.lastListener;
    }

    protected final LinkedHashMap<MessageListener<Mi, M>, MessageListenerQueueProvider<Mi, M>> getListenersQueueProvider() {
        return this.listenersQueueProvider;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    protected final void setActive(boolean isActive, Mi info, M message) {
        this.isActive = isActive;
        this.triggerExtraActionOnSetActive(isActive, info, message);
    }

    protected void triggerExtraActionOnSetActive(boolean isActive, Mi info, M message) {
    }

    public final double getProcessTimeMillisLastMsg() {
        return this.processTimeMillisLastMsg;
    }

    protected final void setProcessTimeMillisLastMsg(double timeMillisLastMsgReceived) {
        this.processTimeMillisLastMsg = timeMillisLastMsgReceived;
        long time = System.currentTimeMillis();
        if ((double)time - this.processLastSecondMsgTime > 1000.0) {
            double hz = (double)this.processMsgsInLastSec * (((double)time - this.processLastSecondMsgTime) / 1000.0);
            if (this.processLastSecondMsgTime > 0.0) {
                this.processMessageFreq = hz;
            }
            this.processLastSecondMsgTime = time;
            this.processMsgsInLastSec = 0L;
        } else {
            ++this.processMsgsInLastSec;
        }
    }

    public final double getProcessDeltaTxRxTimeNanosLastMsg() {
        return this.processDeltaTxRxTimeNanosLastMsg;
    }

    protected final void setProcessDeltaTxRxTimeNanosLastMsg(double processDeltaTxRxTimeNanosLastMsg) {
        long time = System.currentTimeMillis();
        this.processDeltaTxRxTimeNanosLastMsg = (double)time - this.processTimeMillisLastMsg > 1000.0 ? processDeltaTxRxTimeNanosLastMsg : (this.processDeltaTxRxTimeNanosLastMsg + processDeltaTxRxTimeNanosLastMsg) / 2.0;
    }

    public final double getProcessMessageFreq() {
        return this.processMessageFreq;
    }

    public final double getArrivalMessageFreq() {
        return this.arrivalMessageFreq;
    }

    protected final void setArrivalMessageFreq(double arrivalMessageFreq) {
        this.arrivalMessageFreq = arrivalMessageFreq;
    }

    public final double getArrivalTimeMillisLastMsg() {
        return this.arrivalTimeMillisLastMsg;
    }

    protected final void setArrivalTimeMillisLastMsg(double arrivalTimeMillisLastMsg) {
        this.arrivalTimeMillisLastMsg = arrivalTimeMillisLastMsg;
        long time = System.currentTimeMillis();
        if ((double)time - this.arrivalLastSecondMsgTime > 1000.0) {
            double hz = (double)this.arrivalMsgsInLastSec * (((double)time - this.arrivalLastSecondMsgTime) / 1000.0);
            if (this.arrivalLastSecondMsgTime > 0.0) {
                this.arrivalMessageFreq = hz;
            }
            this.arrivalLastSecondMsgTime = time;
            this.arrivalMsgsInLastSec = 0L;
        } else {
            ++this.arrivalMsgsInLastSec;
        }
    }

    public final double getArrivalDeltaTxRxTimeNanosLastMsg() {
        return this.arrivalDeltaTxRxTimeNanosLastMsg;
    }

    public final void setArrivalDeltaTxRxTimeNanosLastMsg(double arrivalDeltaTxRxTimeNanosLastMsg) {
        long time = System.currentTimeMillis();
        this.arrivalDeltaTxRxTimeNanosLastMsg = (double)time - this.arrivalTimeMillisLastMsg > 1000.0 ? arrivalDeltaTxRxTimeNanosLastMsg : (this.arrivalDeltaTxRxTimeNanosLastMsg + arrivalDeltaTxRxTimeNanosLastMsg) / 2.0;
    }

    protected long getMinDelay() {
        return this.minDelay;
    }

    protected void setMinDelay(long minDelay) {
        this.minDelay = minDelay;
    }

    private long getLastReceivedTime(Mi i, M msg) {
        String msgname = msg instanceof IMCMessage ? ((IMCMessage)msg).getMessageType().getShortName() : msg.getClass().getSimpleName();
        String compound = i.getPublisher() + ":" + msgname;
        if (this.lastReceivedTime.containsKey(compound)) {
            return this.lastReceivedTime.get(compound);
        }
        return 0L;
    }

    private void setLastReceivedTime(Mi i, M msg) {
        String msgname = msg instanceof IMCMessage ? ((IMCMessage)msg).getMessageType().getShortName() : msg.getClass().getSimpleName();
        String compound = i.getPublisher() + ":" + msgname;
        this.lastReceivedTime.put(compound, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void warnListeners(Mi info, M msg) {
        LinkedHashMap<MessageListener<Mi, M>, MessageListenerQueueProvider<Mi, M>> listQueueProvider;
        LinkedHashSet<MessageListener<Mi, M>> listList;
        if (this.minDelay > 0L && System.currentTimeMillis() - this.getLastReceivedTime(info, msg) < this.minDelay) {
            return;
        }
        this.setLastReceivedTime(info, msg);
        LinkedHashSet<MessageListener<Mi, M>> linkedHashSet = this.listeners;
        synchronized (linkedHashSet) {
            try {
                listList = (LinkedHashSet<MessageListener<Mi, M>>)this.getListeners().clone();
            }
            catch (Exception e1) {
                listList = this.getListeners();
                e1.printStackTrace();
            }
            try {
                listQueueProvider = (LinkedHashMap<MessageListener<Mi, M>, MessageListenerQueueProvider<Mi, M>>)this.getListenersQueueProvider().clone();
            }
            catch (Exception e) {
                listQueueProvider = this.getListenersQueueProvider();
                e.printStackTrace();
            }
        }
        Iterator i$ = listList.iterator();
        while (i$.hasNext()) {
            MessageListener lt;
            this.lastListener = lt = (MessageListener)i$.next();
            try {
                if (!useListenersQueues) {
                    lt.onMessage(info, msg);
                } else {
                    MessageListenerQueueProvider<Mi, M> lqp = listQueueProvider.get(lt);
                    if (lqp != null) {
                        lqp.addMessage(info, msg);
                    }
                }
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)(this + ": Error warning listener '" + lt + "'"), (Throwable)e);
            }
            catch (Error e) {
                NeptusLog.pub().fatal((Object)(this + ": Fatal Error warning listener '" + lt + "'"), (Throwable)e);
            }
            this.lastListener = null;
        }
        listList = null;
        listQueueProvider = null;
    }

    public boolean addListener(MessageListener<Mi, M> listener) {
        return this.addListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(MessageListener<Mi, M> listener, MessageFilter<Mi, M> filter) {
        LinkedHashSet<MessageListener<Mi, M>> linkedHashSet = this.listeners;
        synchronized (linkedHashSet) {
            boolean ret = this.listeners.contains(listener);
            if (!ret) {
                ret = this.listeners.add(listener);
            }
            if (ret && useListenersQueues) {
                try {
                    MessageListenerQueueProvider<Mi, M> lqp = this.listenersQueueProvider.get(listener);
                    if (lqp != null) {
                        lqp.setFilter(filter);
                    } else {
                        lqp = new MessageListenerQueueProvider<Mi, M>(listener, filter);
                        lqp.setQueueMaxSize(this.queueMaxSize);
                        this.listenersQueueProvider.put(listener, lqp);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(MessageListener<Mi, M> listener) {
        LinkedHashSet<MessageListener<Mi, M>> linkedHashSet = this.listeners;
        synchronized (linkedHashSet) {
            boolean ret = this.listeners.remove(listener);
            if (ret && useListenersQueues) {
                try {
                    MessageListenerQueueProvider lqp = (MessageListenerQueueProvider)this.listenersQueueProvider.remove(listener);
                    if (lqp != null) {
                        lqp.cleanup();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!ret) {
                NeptusLog.pub().error((Object)(this.getClass().getSimpleName() + ": Not possible to remove listener from " + listener));
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onMessage(Mi info, M msg) {
        if (this.messageProcessor == null) {
            NeptusLog.pub().error((Object)"Comms are down. Cannot use this call!");
            return;
        }
        this.setArrivalDeltaTxRxTimeNanosLastMsg(info.getTimeReceivedNanos() - info.getTimeSentNanos());
        this.setArrivalTimeMillisLastMsg(DateTimeUtil.timeStampSeconds() * 1000.0);
        Object object = this.msgQueue;
        synchronized (object) {
            if (this.msgQueue.size() >= this.queueMaxSize) {
                long time = System.currentTimeMillis();
                if (time - this.lastFullQueueWarning > 1000L) {
                    String errorMsg = "Message queue is full [" + this.msgQueue.size() + "] :: " + this;
                    if (this.messageProcessor.isRunning()) {
                        NeptusLog.pub().warn((Object)errorMsg);
                    } else {
                        NeptusLog.pub().fatal((Object)errorMsg);
                    }
                    this.lastFullQueueWarning = time;
                }
                return;
            }
            this.msgQueue.add(msg);
            this.infoQueue.add(info);
        }
        object = this.messageProcessor;
        synchronized (object) {
            this.messageProcessor.notify();
        }
    }

    protected final void processMessage(Mi info, M msg) {
        this.addLastMessageOfType(info, msg);
        try {
            if (this.processMsgLocally(info, msg)) {
                this.warnListeners(info, msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.counter;
    }

    protected abstract boolean processMsgLocally(Mi var1, M var2);

    public final long getSeqInstanceNr() {
        return this.seqInstanceNr;
    }

    protected final void setSeqInstanceNr(long seqInstanceNr) {
        this.seqInstanceNr = seqInstanceNr;
    }

    public final long getNextSeqInstanceNr() {
        return ++this.seqInstanceNr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLastMessageOfType(Mi info, M message) {
        Hashtable<String, MessagePackage<Mi, M>> hashtable = this.lastMessagesOfType;
        synchronized (hashtable) {
            this.lastMessagesOfType.put(message.getAbbrev(), new MessagePackage<Mi, M>(info, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLastMessageOfType() {
        Hashtable<String, MessagePackage<Mi, M>> hashtable = this.lastMessagesOfType;
        synchronized (hashtable) {
            this.lastMessagesOfType.clear();
        }
    }

    protected final class MessageProcessor
    extends Thread {
        private boolean running;
        private M msgNew;
        private Mi infoNew;

        public MessageProcessor(String name) {
            super(name);
            this.running = true;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopProcessing() {
            this.running = false;
            MessageProcessor messageProcessor = this;
            synchronized (messageProcessor) {
                this.notify();
            }
        }

        public boolean isRunning() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void newMessage() {
            MessageProcessor messageProcessor = this;
            synchronized (messageProcessor) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                Object object = CommonCommBaseImplementation.this.msgQueue;
                synchronized (object) {
                    this.msgNew = CommonCommBaseImplementation.this.msgQueue.size() > 0 ? (IMessage)CommonCommBaseImplementation.this.msgQueue.remove() : null;
                    this.infoNew = this.msgNew != null ? (MessageInfo)CommonCommBaseImplementation.this.infoQueue.remove() : null;
                }
                if (this.msgNew == null) {
                    object = this;
                    synchronized (object) {
                        try {
                            this.wait(500L);
                        }
                        catch (Exception e) {
                            NeptusLog.pub().warn((Object)this, (Throwable)e);
                        }
                        continue;
                    }
                }
                try {
                    CommonCommBaseImplementation.this.setActive(true, this.infoNew, this.msgNew);
                    CommonCommBaseImplementation.this.setProcessDeltaTxRxTimeNanosLastMsg(DateTimeUtil.timeStampSeconds() * 1.0E9 - (double)this.infoNew.getTimeReceivedNanos());
                    CommonCommBaseImplementation.this.setProcessTimeMillisLastMsg(DateTimeUtil.timeStampSeconds() * 1000.0);
                    CommonCommBaseImplementation.this.processMessage(this.infoNew, this.msgNew);
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)(this + " error on child processing method"), (Throwable)e);
                }
            }
        }
    }
}

