/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager;

public class MessageFrequencyCalculator {
    private long msgCount = 0L;
    protected double timeMillisLastMsg = -1.0;
    protected long msgsInLastSec = 0L;
    protected double messageFreq = -1.0;
    protected double lastSecondMsgTime = 0.0;
    protected double deltaTxRxTimeNanosLastMsg = -1.0;

    public final double getTimeMillisLastMsg() {
        return this.timeMillisLastMsg;
    }

    public final void setTimeMillisLastMsg(double timeMillisLastMsgReceived) {
        long time;
        this.timeMillisLastMsg = timeMillisLastMsgReceived;
        ++this.msgCount;
        if (this.msgCount < 0L) {
            this.msgCount = 0L;
        }
        if ((double)(time = System.currentTimeMillis()) - this.lastSecondMsgTime > 1000.0) {
            double hz = (double)this.msgsInLastSec * (((double)time - this.lastSecondMsgTime) / 1000.0);
            if (this.lastSecondMsgTime > 0.0) {
                this.messageFreq = hz;
            }
            this.lastSecondMsgTime = time;
            this.msgsInLastSec = 0L;
        } else {
            ++this.msgsInLastSec;
        }
    }

    public long getMsgCount() {
        return this.msgCount;
    }

    public final double getDeltaTxRxTimeNanosLastMsg() {
        return this.deltaTxRxTimeNanosLastMsg;
    }

    public final void setDeltaTxRxTimeNanosLastMsg(double deltaTxRxTimeNanosLastMsg) {
        long time = System.currentTimeMillis();
        this.deltaTxRxTimeNanosLastMsg = (double)time - this.timeMillisLastMsg > 1000.0 ? deltaTxRxTimeNanosLastMsg : (this.deltaTxRxTimeNanosLastMsg + deltaTxRxTimeNanosLastMsg) / 2.0;
    }

    public final double getMessageFreq() {
        double tmpMillis = this.getTimeMillisLastMsg();
        double timeSeconds = (double)(System.currentTimeMillis() - (long)tmpMillis) / 1000.0;
        if (timeSeconds < 2.0) {
            return this.messageFreq;
        }
        return -1.0;
    }

    public static void main(String[] args) {
    }
}

