/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.messages.IMessage;
import pt.lsts.neptus.messages.MessageFilter;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageListener;

public class MessageListenerQueueProvider<Mi extends MessageInfo, M extends IMessage> {
    private Thread dispacherThread = null;
    protected MessageListener<Mi, M> listener = null;
    protected MessageFilter<Mi, M> filter = null;
    protected final Object filterLock = new Object();
    protected LinkedBlockingQueue<MessagePackage> messageList = null;
    protected int queueMaxSize = 1024;
    private long lastFullQueueWarning = -1L;

    public MessageListenerQueueProvider(MessageListener<Mi, M> listener) {
        this.initialize();
        this.listener = listener;
        this.start();
    }

    public MessageListenerQueueProvider(MessageListener<Mi, M> listener, MessageFilter<Mi, M> filter) {
        this.initialize();
        this.listener = listener;
        this.filter = filter;
        this.start();
    }

    private void initialize() {
        this.messageList = new LinkedBlockingQueue();
    }

    public int getQueueMaxSize() {
        return this.queueMaxSize;
    }

    public void setQueueMaxSize(int queueMaxSize) {
        this.queueMaxSize = queueMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(MessageFilter<Mi, M> filter) {
        Object object = this.filterLock;
        synchronized (object) {
            this.filter = filter;
        }
    }

    public void clearFilter() {
        this.setFilter(null);
    }

    private void start() {
        this.getDispacherThread();
    }

    private void stop() {
        this.clearMessages();
        if (this.dispacherThread != null) {
            this.dispacherThread.interrupt();
            this.dispacherThread = null;
        }
    }

    public void cleanup() {
        this.stop();
        this.listener = null;
        this.messageList = null;
        this.clearFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMessages() {
        LinkedBlockingQueue<MessagePackage> linkedBlockingQueue = this.messageList;
        synchronized (linkedBlockingQueue) {
            this.messageList.clear();
        }
    }

    public int getMessageCount() {
        return this.messageList.size();
    }

    public boolean addMessage(Mi info, M message) {
        MessagePackage pac = new MessagePackage(this, info, message);
        try {
            if (this.messageList.size() > this.queueMaxSize) {
                long time = System.currentTimeMillis();
                if (time - this.lastFullQueueWarning > 1000L) {
                    NeptusLog.pub().warn((Object)("Message queue provider is full [" + this.messageList.size() + "] :: " + this + " for " + this.listener));
                    this.lastFullQueueWarning = time;
                }
                return false;
            }
            return this.messageList.offer(pac, 100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDontFilterOutMessage(MessagePackage pac) {
        boolean ret = true;
        Object object = this.filterLock;
        synchronized (object) {
            ret = this.filter == null ? true : this.filter.isMessageToListen(pac.messageInfo, pac.message);
        }
        return ret;
    }

    private Thread getDispacherThread() {
        if (this.dispacherThread == null) {
            Thread listenerThread = new Thread("Queue Dispacher " + Integer.toHexString(this.hashCode()) + "for " + this.listener.getClass().getSimpleName()){

                @Override
                public synchronized void start() {
                    NeptusLog.pub().debug((Object)(this + "Dispacher Thread Started"));
                    super.start();
                }

                @Override
                public void run() {
                    block7: while (true) {
                        try {
                            while (true) {
                                MessagePackage pac;
                                MessagePackage messagePackage = pac = MessageListenerQueueProvider.this.messageList != null ? MessageListenerQueueProvider.this.messageList.take() : null;
                                if (MessageListenerQueueProvider.this.listener != null && MessageListenerQueueProvider.this.messageList != null) {
                                    try {
                                        if (!MessageListenerQueueProvider.this.isDontFilterOutMessage(pac)) continue block7;
                                        MessageListenerQueueProvider.this.listener.onMessage(pac.messageInfo, pac.message);
                                        continue block7;
                                    }
                                    catch (Exception e) {
                                        NeptusLog.pub().error((Object)(this + ": Error warning listener '" + MessageListenerQueueProvider.this.listener + "'"), (Throwable)e);
                                        continue;
                                    }
                                    catch (Error e) {
                                        NeptusLog.pub().fatal((Object)(this + ": Fatal Error warning listener '" + MessageListenerQueueProvider.this.listener + "'"), (Throwable)e);
                                        continue;
                                    }
                                }
                                try {
                                    Thread.sleep(50L);
                                    continue block7;
                                }
                                catch (Exception e) {
                                    NeptusLog.pub().error((Object)e.getMessage());
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (InterruptedException e) {
                            NeptusLog.pub().debug((Object)(this + " Thread interrupted"));
                            NeptusLog.pub().debug((Object)(this + " Thread Stopped"));
                            return;
                        }
                    }
                }
            };
            listenerThread.setPriority(2);
            listenerThread.setDaemon(true);
            listenerThread.start();
            this.dispacherThread = listenerThread;
        }
        return this.dispacherThread;
    }

    private static class MessagePackage {
        Mi messageInfo;
        M message;
        final /* synthetic */ MessageListenerQueueProvider this$0;

        public MessagePackage(Mi info, M message) {
            this.this$0 = var1_1;
            this.messageInfo = info;
            this.message = message;
        }
    }
}

