/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.util.LinkedHashMap;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.CommonCommBaseImplementation;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.messages.IMessage;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public abstract class SystemCommBaseInfo<M extends IMessage, Mi extends MessageInfo, I>
extends CommonCommBaseImplementation<M, Mi>
implements MessageListener<Mi, M>,
PropertiesProvider {
    protected String systemIdName = null;
    protected I systemCommId = null;
    protected LinkedHashMap<String, DefaultProperty> properties = new LinkedHashMap();

    public SystemCommBaseInfo() {
        this.preferencesListener.preferencesUpdated();
        GeneralPreferences.addPreferencesListener(this.preferencesListener);
        this.messageProcessor = new CommonCommBaseImplementation.MessageProcessor(this.getClass().getSimpleName() + " [" + this.hashCode() + "] :: " + CommonCommBaseImplementation.MessageProcessor.class.getSimpleName());
        this.messageProcessor.start();
    }

    public void stopMsgProcessing() {
        GeneralPreferences.removePreferencesListener(this.preferencesListener);
        this.stopSystemComms();
        if (this.messageProcessor != null) {
            this.messageProcessor.stopProcessing();
            this.messageProcessor = null;
        }
        this.msgQueue.clear();
        this.infoQueue.clear();
        this.setActive(false, null, null);
    }

    public void resumeMsgProcessing() {
        GeneralPreferences.addPreferencesListener(this.preferencesListener);
        if (this.messageProcessor != null) {
            this.messageProcessor.stopProcessing();
        }
        this.messageProcessor = new CommonCommBaseImplementation.MessageProcessor(this.getClass().getSimpleName() + " [" + this.hashCode() + "] :: " + CommonCommBaseImplementation.MessageProcessor.class.getSimpleName());
        this.messageProcessor.start();
        this.stopSystemComms();
        this.initSystemComms();
        this.startSystemComms();
    }

    public I getSystemCommId() {
        return this.systemCommId;
    }

    public void setSystemCommId(I commId) {
        this.systemCommId = commId;
    }

    public String getSystemIdName() {
        return this.systemIdName;
    }

    public void setSystemIdName(String vehicleId) {
        this.systemIdName = vehicleId;
    }

    protected abstract boolean initSystemComms();

    protected abstract boolean startSystemComms();

    protected abstract boolean stopSystemComms();

    @Override
    public DefaultProperty[] getProperties() {
        return this.properties.values().toArray(new DefaultProperty[0]);
    }

    @Override
    public void setProperties(Property[] props) {
        for (Property p : props) {
            this.properties.put(p.getName(), PropertiesEditor.getPropertyInstance(p));
        }
    }

    public void setProperty(Property prop) {
        this.properties.put(prop.getName(), PropertiesEditor.getPropertyInstance(prop));
    }

    public Object getPropertyValue(String propertyName) {
        DefaultProperty dp = this.properties.get(propertyName);
        if (dp != null) {
            return dp.getValue();
        }
        NeptusLog.pub().error((Object)(this + ": this property " + propertyName + " has not been set. Returning NULL"));
        return null;
    }

    @Override
    public String getPropertiesDialogTitle() {
        return "Communications settings for " + this.getSystemIdName() + " vehicle";
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }
}

