/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager.imc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import pt.lsts.imc.AcousticSystemsQuery;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.CommUtil;
import pt.lsts.neptus.comm.IMCSendMessageUtils;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.comm.manager.imc.MessageDeliveryListener;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.NetworkInterfacesUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class AnnounceWorker {
    public static final String NONE_IP = "NONE";
    public static final String USE_REMOTE_IP = "SENDER_REMOTE_IP";
    private Timer timer = null;
    private TimerTask ttaskAnnounceMulticast = null;
    private TimerTask ttaskAnnounceBroadcast = null;
    private TimerTask ttaskAnnounceUnicast = null;
    private TimerTask ttaskEntityListAndPlanDB = null;
    private TimerTask ttaskHeartbeat = null;
    private IMCMessage announceMessage = null;
    private int periodMulticast = 10000;
    private int periodBroadcast = 7000;
    private int periodUnicastAnnounce = 10000;
    private int periodEntityListRequest = 30000;
    private int periodHeartbeatRequest = 1000;
    private boolean useUnicastAnnounce = false;
    private ImcMsgManager imcManager = null;
    private IMCDefinition imcDefinition = null;

    public AnnounceWorker(ImcMsgManager imcManager, IMCDefinition imcDefinition) {
        this.imcManager = imcManager;
        this.imcDefinition = imcDefinition;
    }

    public IMCMessage getAnnounceMessage() {
        if (this.announceMessage == null) {
            try {
                this.announceMessage = this.imcDefinition.create("Announce", new Object[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (this.announceMessage == null) {
                return null;
            }
            this.announceMessage.setValue("sys_name", (Object)"ccu-neptus");
            this.announceMessage.setValue("sys_type", (Object)"CCU");
            this.announceMessage.setValue("owner", (Object)ImcId16.NULL_ID.longValue());
            this.announceMessage.setValue("lat", (Object)0);
            this.announceMessage.setValue("lon", (Object)0);
            this.announceMessage.setValue("height", (Object)0);
            this.announceMessage.setValue("services", (Object)"");
        }
        this.announceMessage.setValue("owner", (Object)ImcId16.NULL_ID.longValue());
        LocationType loc = new LocationType(MyState.getLocation().convertToAbsoluteLatLonDepth());
        this.announceMessage.setValue("lat", (Object)loc.getLatitudeRads());
        this.announceMessage.setValue("lon", (Object)loc.getLongitudeRads());
        this.announceMessage.setValue("height", (Object)loc.getHeight());
        return this.announceMessage;
    }

    private IMCMessage getAnnounceMessageUpdated() {
        this.getAnnounceMessage();
        this.announceMessage.setValue("owner", (Object)ImcId16.NULL_ID.longValue());
        LocationType loc = new LocationType(MyState.getLocation().convertToAbsoluteLatLonDepth());
        this.announceMessage.setValue("lat", (Object)loc.getLatitudeRads());
        this.announceMessage.setValue("lon", (Object)loc.getLongitudeRads());
        this.announceMessage.setValue("height", (Object)loc.getHeight());
        this.announceMessage.setValue("services", (Object)this.getAllServices());
        this.announceMessage.setTimestamp((double)System.currentTimeMillis() / 1000.0);
        return this.announceMessage;
    }

    public String getAllServices() {
        return this.getNeptusInstanceUniqueID() + ";" + "neptus://0.0.0.0/version/" + ConfigFetch.getNeptusVersion() + "_" + ConfigFetch.getCompilationDate() + "_r" + ConfigFetch.getScmRev() + "/;" + "imc+info://0.0.0.0/version/" + this.imcDefinition.getVersion() + "/;" + this.imcManager.getAnnounceServicesList();
    }

    public String getNeptusInstanceUniqueID() {
        return "neptus://0.0.0.0/uid/" + DateTimeUtil.getUID() + "/";
    }

    public void setAnnounceMessage(IMCMessage announceMessage) {
        this.announceMessage = announceMessage;
    }

    public long getPeriodMulticast() {
        return this.periodMulticast;
    }

    public void setPeriodMulticast(int period) {
        this.periodMulticast = period;
    }

    public long getPeriodBroadcast() {
        return this.periodBroadcast;
    }

    public void setPeriodBroadcast(int period) {
        this.periodBroadcast = period;
    }

    public int getPeriodUnicastAnnounce() {
        return this.periodUnicastAnnounce;
    }

    public void setPeriodUnicastAnnounce(int periodUnicastAnnounce) {
        this.periodUnicastAnnounce = periodUnicastAnnounce;
    }

    public long getPeriodEntityListRequest() {
        return this.periodEntityListRequest;
    }

    public void setPeriodEntityListRequest(int periodEntityListRequest) {
        this.periodEntityListRequest = periodEntityListRequest;
    }

    public long getPeriodHeartbeatRequest() {
        this.periodHeartbeatRequest = GeneralPreferences.heartbeatTimePeriodMillis;
        return this.periodHeartbeatRequest;
    }

    public boolean isUseUnicastAnnounce() {
        return this.useUnicastAnnounce;
    }

    public void setUseUnicastAnnounce(boolean useUnicastAnnounce) {
        this.useUnicastAnnounce = useUnicastAnnounce;
    }

    public synchronized boolean startAnnounceAndPeriodicRequests() {
        if (this.timer != null || this.ttaskAnnounceMulticast != null || this.ttaskAnnounceBroadcast != null) {
            return false;
        }
        this.timer = new Timer(this.getClass().getSimpleName(), true);
        this.ttaskAnnounceMulticast = this.getTtaskAnnounceMulticast();
        this.ttaskAnnounceBroadcast = this.getTtaskAnnounceBroadcast();
        this.ttaskAnnounceUnicast = this.getTtaskAnnounceUnicast();
        this.ttaskEntityListAndPlanDB = this.getTtaskEntityListAndPlanDB();
        this.ttaskHeartbeat = this.getTtaskHeartbeat();
        if (this.getPeriodMulticast() >= 0L) {
            this.timer.scheduleAtFixedRate(this.ttaskAnnounceMulticast, 500L, this.getPeriodMulticast());
        }
        if (this.getPeriodBroadcast() >= 0L) {
            this.timer.scheduleAtFixedRate(this.ttaskAnnounceBroadcast, 900L, this.getPeriodBroadcast());
        }
        if (this.getPeriodUnicastAnnounce() >= 0 && this.useUnicastAnnounce) {
            this.timer.scheduleAtFixedRate(this.ttaskAnnounceUnicast, 700L, (long)this.getPeriodUnicastAnnounce());
        }
        if (this.getPeriodEntityListRequest() >= 0L) {
            this.timer.scheduleAtFixedRate(this.ttaskEntityListAndPlanDB, 1000L, this.getPeriodEntityListRequest());
        }
        if (this.getPeriodHeartbeatRequest() >= 0L) {
            this.timer.scheduleAtFixedRate(this.ttaskHeartbeat, 2000L, this.getPeriodHeartbeatRequest());
        }
        return true;
    }

    public synchronized void stopAnnounce() {
        if (this.ttaskAnnounceMulticast != null) {
            this.ttaskAnnounceMulticast.cancel();
            this.ttaskAnnounceMulticast = null;
        }
        if (this.ttaskAnnounceBroadcast != null) {
            this.ttaskAnnounceBroadcast.cancel();
            this.ttaskAnnounceBroadcast = null;
        }
        if (this.ttaskAnnounceUnicast != null) {
            this.ttaskAnnounceUnicast.cancel();
            this.ttaskAnnounceUnicast = null;
        }
        if (this.ttaskEntityListAndPlanDB != null) {
            this.ttaskEntityListAndPlanDB.cancel();
            this.ttaskEntityListAndPlanDB = null;
        }
        if (this.ttaskHeartbeat != null) {
            this.ttaskHeartbeat.cancel();
            this.ttaskHeartbeat = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private TimerTask getTtaskAnnounceMulticast() {
        this.ttaskAnnounceMulticast = new TimerTask(){

            @Override
            public void run() {
                AnnounceWorker.this.imcManager.sendMessage(AnnounceWorker.this.getAnnounceMessageUpdated(), ImcId16.ANNOUNCE, "Multicast");
            }
        };
        return this.ttaskAnnounceMulticast;
    }

    private TimerTask getTtaskAnnounceBroadcast() {
        this.ttaskAnnounceBroadcast = new TimerTask(){

            @Override
            public void run() {
                AnnounceWorker.this.imcManager.sendMessage(AnnounceWorker.this.getAnnounceMessageUpdated(), ImcId16.ANNOUNCE, "Broadcast");
            }
        };
        return this.ttaskAnnounceBroadcast;
    }

    private TimerTask getTtaskAnnounceUnicast() {
        this.ttaskAnnounceUnicast = new TimerTask(){
            private DatagramSocket sock;
            private int[] multicastPorts = CommUtil.parsePortRangeFromString(GeneralPreferences.imcMulticastBroadcastPortRange, new int[]{6969});

            @Override
            public void run() {
                try {
                    if (this.sock == null) {
                        this.sock = new DatagramSocket();
                    }
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
                ImcSystem[] imcSysList = ImcSystemsHolder.lookupAllSystems();
                IMCMessage message = AnnounceWorker.this.getAnnounceMessageUpdated().cloneMessage();
                message.getHeader().setValue("src", (Object)AnnounceWorker.this.imcManager.getLocalId().longValue());
                message.getHeader().setValue("dst", (Object)ImcId16.ANNOUNCE);
                message.setTimestamp((double)System.currentTimeMillis() / 1000.0);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IMCOutputStream imcOs = new IMCOutputStream((OutputStream)baos);
                try {
                    message.serialize(imcOs);
                    byte[] bArray = baos.toByteArray();
                    for (ImcSystem sys : imcSysList) {
                        if (sys.isActive()) continue;
                        for (int port : this.multicastPorts) {
                            InetSocketAddress add = new InetSocketAddress(sys.getHostAddress(), port);
                            try {
                                DatagramPacket dgram = new DatagramPacket(bArray, bArray.length, add);
                                this.sock.send(dgram);
                            }
                            catch (SocketException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        return this.ttaskAnnounceUnicast;
    }

    private TimerTask getTtaskEntityListAndPlanDB() {
        this.ttaskEntityListAndPlanDB = new TimerTask(){

            @Override
            public void run() {
                for (ImcSystem sys : ImcSystemsHolder.lookupAllSystems()) {
                    AnnounceWorker.this.sendEntityListRequestMsg(sys);
                    AnnounceWorker.this.sendPlanDBMsgs(sys);
                    AnnounceWorker.this.sendBeaconsRequestMsgs(sys);
                    AnnounceWorker.this.sendAcousticSystemsQueryMsg(sys);
                }
            }
        };
        return this.ttaskEntityListAndPlanDB;
    }

    public TimerTask getTtaskHeartbeat() {
        this.ttaskHeartbeat = new TimerTask(){

            @Override
            public void run() {
                for (ImcSystem sys : ImcSystemsHolder.lookupAllSystems()) {
                    if (sys.getAuthorityState() == ImcSystem.IMCAuthorityState.NONE || sys.getAuthorityState() == ImcSystem.IMCAuthorityState.OFF) continue;
                    AnnounceWorker.this.sendHeartbeat(sys);
                }
            }
        };
        return this.ttaskHeartbeat;
    }

    public int getImcUdpPortFromMessage(IMCMessage msg) {
        InetSocketAddress[] retAdr = this.getImcIpsPortsFromMessage(msg, "imc+udp");
        if (retAdr.length == 0) {
            return 0;
        }
        return retAdr[0].getPort();
    }

    public InetSocketAddress[] getImcIpsPortsFromMessageImcUdp(IMCMessage msg) {
        return this.getImcIpsPortsFromMessage(msg, "imc+udp");
    }

    public InetSocketAddress[] getImcIpsPortsFromMessageImcTcp(IMCMessage msg) {
        return this.getImcIpsPortsFromMessage(msg, "imc+tcp");
    }

    public InetSocketAddress[] getImcIpsPortsFromMessage(IMCMessage msg, String scheme) {
        String services = msg.getString("services");
        return this.getImcIpsPortsFromMessage(services, scheme);
    }

    public InetSocketAddress[] getImcIpsPortsFromMessage(String services, String scheme) {
        String[] listSer = services.split(";");
        LinkedList<String> ipList = new LinkedList<String>();
        LinkedList<Integer> portList = new LinkedList<Integer>();
        for (String rs : listSer) {
            try {
                if (!rs.trim().startsWith(scheme + ":")) continue;
                URI url1 = URI.create(rs.trim());
                String host = url1.getHost();
                int port = url1.getPort();
                if (port == -1 || port == 0) continue;
                portList.add(port);
                ipList.add(host);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        InetSocketAddress[] addL = new InetSocketAddress[portList.size()];
        for (int i = 0; i < portList.size(); ++i) {
            addL[i] = new InetSocketAddress((String)ipList.get(i), (int)((Integer)portList.get(i)));
        }
        return addL;
    }

    public String getImcServicesFromMessage(IMCMessage msg) {
        String adInfo = msg.getString("services");
        return adInfo;
    }

    void sendEntityListRequestMsg(ImcSystem sys) {
        try {
            NeptusLog.pub().debug((Object)("Sending '" + sys.name + " | " + sys.getId() + "' EntityList request..."));
            IMCMessage msg = this.imcDefinition.create("EntityList", new Object[]{"op", 1});
            if (msg == null) {
                msg = this.imcDefinition.create("Aliases", new Object[]{"op", 1});
            }
            this.imcManager.sendMessage(msg, sys.getId(), (String)null);
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e);
        }
    }

    private void sendHeartbeat(ImcSystem sys) {
        try {
            NeptusLog.pub().debug((Object)("Sending '" + sys.name + " | " + sys.getId() + "' Heartbeat..."));
            IMCMessage msg = this.imcDefinition.create("Heartbeat", new Object[0]);
            msg.setTimestamp((double)System.currentTimeMillis() / 1000.0);
            if (sys.isUDPOn() && this.imcManager.isUdpOn()) {
                this.imcManager.sendMessage(msg, sys.getId(), "UDP", this.getMessageDeliveryListenerFor(sys.getName(), "by UDP,  @ " + sys.getHostAddress() + ":" + sys.getRemoteUDPPort()));
            }
            if (sys.isTCPOn() && this.imcManager.isTcpOn()) {
                this.imcManager.sendMessage(msg, sys.getId(), "TCP", this.getMessageDeliveryListenerFor(sys.getName(), "by TCP @ " + sys.getHostAddress() + ":" + sys.getRemoteTCPPort()));
            }
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e);
        }
    }

    private MessageDeliveryListener getMessageDeliveryListenerFor(final String systemId, final String extraInfo) {
        return new MessageDeliveryListener(){

            private String getBaseDisplayMsg(String systemId2, String extraInfo2, IMCMessage message, String result) {
                Date timeStampDate = new Date(message.getTimestampMillis());
                return "Sent result for system " + systemId2 + (extraInfo2 != null && !extraInfo2.isEmpty() ? " (" + extraInfo2 + ") " : "") + " @" + DateTimeUtil.timeFormaterUTC.format(timeStampDate) + " UTC, of message " + message.getAbbrev() + " was: " + result;
            }

            @Override
            public void deliveryUnreacheable(IMCMessage message) {
                NeptusLog.pub().debug((Object)this.getBaseDisplayMsg(systemId, extraInfo, message, "Unreacheable"));
            }

            @Override
            public void deliveryUncertain(IMCMessage message, Object msg) {
                NeptusLog.pub().debug((Object)this.getBaseDisplayMsg(systemId, extraInfo, message, "Uncertain" + (msg != null ? " :: " + msg : "")));
            }

            @Override
            public void deliveryTimeOut(IMCMessage message) {
                NeptusLog.pub().debug((Object)this.getBaseDisplayMsg(systemId, extraInfo, message, "Timeout"));
            }

            @Override
            public void deliverySuccess(IMCMessage message) {
                NeptusLog.pub().debug((Object)this.getBaseDisplayMsg(systemId, extraInfo, message, "Success"));
            }

            @Override
            public void deliveryError(IMCMessage message, Object error) {
                NeptusLog.pub().debug((Object)this.getBaseDisplayMsg(systemId, extraInfo, message, "Error" + (error != null ? " :: " + error : "")));
            }
        };
    }

    private void sendPlanDBMsgs(ImcSystem sys) {
        try {
            if (System.currentTimeMillis() - sys.getPlanDBControl().getRemoteState().getLastStateUpdated() < 20000L) {
                return;
            }
            NeptusLog.pub().debug((Object)("Sending '" + sys.name + " | " + sys.getId() + "' PlanDB request..."));
            IMCMessage msg = this.imcDefinition.create("PlanDB", new Object[]{"type", "REQUEST", "op", "GET_STATE", "request_id", IMCSendMessageUtils.getNextRequestId()});
            this.imcManager.sendMessage(msg, sys.getId(), (String)null);
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e);
        }
    }

    private void sendBeaconsRequestMsgs(ImcSystem sys) {
        try {
            if (sys.getType() != VehicleType.SystemTypeEnum.VEHICLE) {
                return;
            }
            if (sys.retrieveData("LblConfig") != null && System.currentTimeMillis() - sys.retrieveDataTimeMillis("LblConfig") < 20000L) {
                return;
            }
            NeptusLog.pub().debug((Object)("Sending '" + sys.name + " | " + sys.getId() + "' LblConfig request..."));
            IMCMessage msg = this.imcDefinition.create("LblConfig", new Object[]{"op", "GET_CFG"});
            this.imcManager.sendMessage(msg, sys.getId(), (String)null);
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e);
        }
    }

    private void sendAcousticSystemsQueryMsg(ImcSystem sys) {
        try {
            if (!sys.isServiceProvided("acoustic")) {
                return;
            }
            NeptusLog.pub().debug((Object)("Sending '" + sys.name + " | " + sys.getId() + "' AcousticSystemsQuery request..."));
            AcousticSystemsQuery msg = new AcousticSystemsQuery(this.imcDefinition);
            this.imcManager.sendMessage((IMCMessage)msg, sys.getId(), (String)null);
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e);
        }
    }

    public static final void processUidFromServices(ImcSystem sys) {
        String uid = IMCUtils.getUidFromServices(sys.getServicesProvided());
        if (sys.getLastUid() == null || "".equalsIgnoreCase(sys.getLastUid())) {
            if (uid != null) {
                sys.setLastUid(uid);
            }
            sys.setOnIdErrorState(false);
        } else if (sys.getLastUid().equalsIgnoreCase(uid)) {
            if (System.currentTimeMillis() - sys.getLastIdErrorStateReceived() > 3000L) {
                sys.setOnIdErrorState(false);
            }
        } else {
            sys.setLastUid(uid);
            sys.setOnIdErrorState(true);
        }
    }

    public static double processHeadingDegreesFromServices(ImcSystem resSys) {
        Vector<URI> sp = resSys.getServiceProvided("heading", "*");
        if (!sp.isEmpty()) {
            for (URI uri : sp) {
                String headingPath = uri.getPath();
                if (headingPath == null || headingPath.isEmpty()) continue;
                headingPath = headingPath.replace("/", "");
                try {
                    return Double.parseDouble(headingPath);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        return Double.NaN;
    }

    public static void main(String[] args) {
        URI url1 = URI.create("imc+udp://SENDER-REMOTE-IP:6002/path/ye");
        url1 = URI.create("imc+udp://192.168.106.30:6002/");
        NeptusLog.pub().info((Object)("<###> " + url1.getScheme()));
        NeptusLog.pub().info((Object)("<###> " + url1.getHost()));
        NeptusLog.pub().info((Object)("<###> " + url1.getPort()));
        NeptusLog.pub().info((Object)("<###> " + url1.getAuthority()));
        NeptusLog.pub().info((Object)("<###> " + url1.getUserInfo()));
        NeptusLog.pub().info((Object)("<###> " + url1.getRawAuthority()));
        NeptusLog.pub().info((Object)("<###> " + url1.getPath()));
        NeptusLog.pub().info((Object)("<###> " + NetworkInterfacesUtil.testForReachability(url1.getHost())));
        try {
            Enumeration<NetworkInterface> nintf = NetworkInterface.getNetworkInterfaces();
            while (nintf.hasMoreElements()) {
                NetworkInterface ni = nintf.nextElement();
                if (!ni.isUp()) continue;
                NeptusLog.pub().info((Object)("<###>>>>>  " + ni));
                NeptusLog.pub().info((Object)("<###>      isLoopback " + ni.isLoopback()));
                NeptusLog.pub().info((Object)("<###>      isPointToPoint " + ni.isPointToPoint()));
                NeptusLog.pub().info((Object)("<###>      multicast " + ni.supportsMulticast()));
                NeptusLog.pub().info((Object)("<###>      virtual " + ni.isVirtual()));
                NeptusLog.pub().info((Object)("<###>      mtu " + ni.getMTU()));
                NeptusLog.pub().info((Object)("<###>      " + ni.getInetAddresses()));
                Enumeration<InetAddress> iadde = ni.getInetAddresses();
                while (iadde.hasMoreElements()) {
                    InetAddress inetAddress = iadde.nextElement();
                    NeptusLog.pub().info((Object)("<###>            " + inetAddress.getHostAddress()));
                }
                NeptusLog.pub().info((Object)("<###>      " + ni.getInterfaceAddresses()));
                for (InterfaceAddress ia : ni.getInterfaceAddresses()) {
                    NeptusLog.pub().info((Object)("<###>            " + ia.getAddress().getHostAddress() + " " + (ia.getBroadcast() != null ? ia.getBroadcast().getHostAddress() : "")));
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        try {
            String headingStr = "heading://0.0.0.0/120.3/";
            URI hURI = new URI(headingStr);
            System.out.println(hURI.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

