/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager.imc;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.LinkedHashMap;
import java.util.Map;
import pt.lsts.imc.EntityList;

public class EntitiesResolver {
    protected static LinkedHashMap<String, BiMap<Integer, String>> entitiesMap = new LinkedHashMap();
    public static final int DEFAULT_ENTITY = 255;

    public static void setEntities(String id, EntityList message) {
        LinkedHashMap tlist = null;
        tlist = message.getList();
        HashBiMap aliases = HashBiMap.create();
        for (String key : tlist.keySet()) {
            aliases.put((Object)Integer.parseInt((String)tlist.get(key)), (Object)key);
        }
        entitiesMap.put(id, (BiMap<Integer, String>)aliases);
    }

    public static final Map<Integer, String> getEntities(Object systemId) {
        return (Map)entitiesMap.get(systemId.toString());
    }

    public static void clearAliases(Object systemId) {
        if (entitiesMap.containsKey(systemId.toString())) {
            entitiesMap.remove(systemId.toString());
        }
    }

    public static String resolveName(String systemId, Integer entityId) {
        return entitiesMap.containsKey(systemId) ? (String)entitiesMap.get(systemId).get((Object)entityId) : null;
    }

    public static int resolveId(String systemId, String entityName) {
        if (!entitiesMap.containsKey(systemId)) {
            return -1;
        }
        BiMap inverted = entitiesMap.get(systemId).inverse();
        if (!inverted.containsKey((Object)entityName)) {
            return -1;
        }
        return (Integer)inverted.get((Object)entityName);
    }
}

