/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager.imc;

import java.util.StringTokenizer;
import pt.lsts.neptus.NeptusLog;

public class ImcId16
extends Number
implements Comparable<ImcId16> {
    private static final long serialVersionUID = 4540568234437157049L;
    public static final ImcId16 BROADCAST_ID = new ImcId16(65520L);
    public static final ImcId16 ANNOUNCE = new ImcId16(0L);
    public static final ImcId16 NULL_ID = new ImcId16(65535L);
    private long id = 0L;

    public ImcId16(Object o) throws Exception {
        if (o == null) {
            throw new Exception("IMC Id not valid: null");
        }
        if (o instanceof Number) {
            this.id = ((Number)o).longValue();
        } else {
            try {
                this.id = ImcId16.parseImcId16(o.toString());
            }
            catch (Exception e) {
                throw new Exception("IMC Id not valid: " + o.toString());
            }
        }
    }

    public ImcId16(long id) {
        this.id = id;
    }

    public ImcId16(String idString) {
        try {
            this.id = ImcId16.parseImcId16(idString);
        }
        catch (NumberFormatException e) {
            NeptusLog.pub().error((Object)e.getMessage());
            this.id = 65535L;
        }
    }

    @Override
    public int compareTo(ImcId16 o) {
        return this.longValue() < o.longValue() ? -1 : (this.longValue() == o.longValue() ? 0 : 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ImcId16) {
            return this.longValue() == ((ImcId16)obj).longValue();
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    @Override
    public int intValue() {
        return (int)this.id;
    }

    @Override
    public long longValue() {
        return this.id;
    }

    @Override
    public float floatValue() {
        return this.id;
    }

    @Override
    public double doubleValue() {
        return this.id;
    }

    public String toString() {
        return this.toHexString();
    }

    public String toIntString() {
        return String.valueOf(this.id);
    }

    public String toHexString() {
        return "0x" + this.toPrettyString().replace(":", "");
    }

    public String toPrettyString() {
        String b2;
        String b1 = Long.toHexString((this.id & 0xFF00L) >> 8);
        if (b1.length() == 1) {
            b1 = "0" + b1;
        }
        if ((b2 = Long.toHexString(this.id & 0xFFL)).length() == 1) {
            b2 = "0" + b2;
        }
        return b1 + ":" + b2;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setId(String id) throws NumberFormatException {
        this.id = ImcId16.parseImcId16(id);
    }

    public static long parseImcId16(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (s.startsWith("0x")) {
            return Long.parseLong(s.replace("0x", ""), 16);
        }
        long id = 0L;
        StringTokenizer st = new StringTokenizer(s, ":");
        if (st.countTokens() != 2) {
            try {
                return Long.parseLong(s);
            }
            catch (Exception e) {
                throw new NumberFormatException("Unable to parse ImcId16: '" + s + "' (ID must have the format xx:xx hexa values)");
            }
        }
        for (int i = 0; i < 2; ++i) {
            try {
                int val = Integer.parseInt(st.nextToken(), 16);
                if (val < 0 || val > 255) {
                    throw new NumberFormatException("Unable to parse ImcId16: '" + s + "' (value " + val + " is invalid)");
                }
                id |= (long)(val << (1 - i) * 8);
                continue;
            }
            catch (Exception e) {
                id = 0L;
                throw new NumberFormatException("Unable to parse ImcId16: '" + s + "' (" + e.getMessage() + ")");
            }
        }
        return id;
    }

    public static ImcId16 valueOf(String s) throws NumberFormatException {
        return new ImcId16(ImcId16.parseImcId16(s));
    }

    public int getFirstByte() {
        return this.getByte(0);
    }

    public int getSecondByte() {
        return this.getByte(1);
    }

    public int getByte(int number) {
        int shift = (1 - number) * 8;
        int val = (this.intValue() & 255 << shift) >> shift;
        if (val < 0) {
            return 255;
        }
        return val;
    }

    public Number getValueAs(String slzType) {
        Number slzNumber = slzType.equals("uint8_t") || slzType.equals("int8_t") || slzType.equals("int16_t") ? (Number)new Short((short)this.id) : (Number)(slzType.equals("int32_t") || slzType.equals("uint16_t") ? (Number)new Integer((int)this.id) : (Number)new Long(this.id));
        return slzNumber;
    }

    public static void main(String[] args) throws Exception {
        ImcId16 id = new ImcId16("ed:01");
        NeptusLog.pub().info((Object)("<###> " + id.intValue()));
        NeptusLog.pub().info((Object)("<###> " + id.toPrettyString()));
        NeptusLog.pub().info((Object)("<###> " + id.getFirstByte()));
        NeptusLog.pub().info((Object)("<###> " + id.getSecondByte()));
        ImcId16 id1 = new ImcId16(60910L);
        NeptusLog.pub().info((Object)("<###> " + id1.intValue()));
        NeptusLog.pub().info((Object)("<###> " + id1.toPrettyString()));
        NeptusLog.pub().info((Object)("<###> " + id1.getFirstByte()));
        NeptusLog.pub().info((Object)("<###> " + id1.getSecondByte()));
        NeptusLog.pub().info((Object)("<###> " + id.equals(id1)));
        NeptusLog.pub().info((Object)("<###> " + (id == id1)));
        ImcId16 id2 = new ImcId16(334360910L);
        NeptusLog.pub().info((Object)("<###> " + id2.intValue()));
        NeptusLog.pub().info((Object)("<###> " + id2.toPrettyString()));
        ImcId16 idC1 = new ImcId16("a0:01");
        ImcId16 idC2 = new ImcId16("a0:01");
        NeptusLog.pub().info((Object)("<###> " + idC1.intValue()));
        NeptusLog.pub().info((Object)("<###> " + idC2.intValue()));
        NeptusLog.pub().info((Object)("<###> " + idC1.equals(idC2)));
        NeptusLog.pub().info((Object)("<###> " + (idC1 == idC2)));
        NeptusLog.pub().info((Object)("<###> " + (new Long(8L) == new Long(8L))));
        ImcId16 id3 = new ImcId16("0xa001");
        NeptusLog.pub().info((Object)("<###> " + id3.intValue()));
        NeptusLog.pub().info((Object)("<###> " + id3.toPrettyString()));
    }
}

