/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager.imc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.MessageEditorImc;
import pt.lsts.neptus.gui.LocationCopyPastePanel;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.ByteUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class ImcMessageSenderPanel
extends JPanel {
    private static final long serialVersionUID = 3776289592692060016L;
    private static ImageIcon ICON = new ImageIcon(ImageUtils.getImage("images/imc.png").getScaledInstance(16, 16, 4));
    private static ImageIcon ICON1 = new ImageIcon(ImageUtils.getImage("images/imc.png").getScaledInstance(48, 48, 4));
    private JComboBox<?> messagesComboBox = null;
    private JButton editMessageButton = null;
    private JButton publishButton = null;
    private JButton burstPublishButton = null;
    private JButton createButton = null;
    private LocationCopyPastePanel locCopyPastePanel = null;
    private JTextField address = new JTextField("127.0.0.1");
    private NumberFormat nf = new DecimalFormat("#####");
    private JTextField port = null;
    private JTextField bindPort = new JTextField("");
    private JTextField srcId = new JTextField("");
    private JTextField dstId = new JTextField("");
    private HashMap<String, IMCMessage> messagesPool = new HashMap();

    public ImcMessageSenderPanel() {
        this.initialize();
    }

    private void initialize() {
        this.port = new JTextField(this.nf.format(GeneralPreferences.commsLocalPortUDP));
        JPanel holder = new JPanel();
        GroupLayout layout = new GroupLayout(holder);
        holder.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JLabel addressLabel = new JLabel("Address and Port to UDP send");
        JLabel localBindLabel = new JLabel("Local Port to bind (blanc for don't care)");
        JLabel srcDstIdLabel = new JLabel("Source and Destination IMC IDs (blanc for don't care)");
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(localBindLabel).addComponent(this.bindPort)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(addressLabel).addGroup(layout.createSequentialGroup().addComponent(this.address).addComponent(this.port))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(srcDstIdLabel).addGroup(layout.createSequentialGroup().addComponent(this.srcId).addComponent(this.dstId))).addComponent(this.getMessagesComboBox()).addGroup(layout.createSequentialGroup().addComponent(this.getLocCopyPastPanel()).addComponent(this.getEditMessageButton()).addComponent(this.getCreateButton()).addComponent(this.getPublishButton()).addComponent(this.getBurstPublishButton())));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createSequentialGroup().addComponent(localBindLabel).addComponent(this.bindPort, 25, 25, 25)).addGroup(layout.createSequentialGroup().addComponent(addressLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.address, 25, 25, 25).addComponent(this.port, 25, 25, 25))).addGroup(layout.createSequentialGroup().addComponent(srcDstIdLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.srcId, 25, 25, 25).addComponent(this.dstId, 25, 25, 25))).addComponent(this.getMessagesComboBox(), 25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.getLocCopyPastPanel()).addComponent(this.getEditMessageButton()).addComponent(this.getCreateButton()).addComponent(this.getPublishButton()).addComponent(this.getBurstPublishButton())));
        layout.linkSize(0, this.getCreateButton(), this.getEditMessageButton(), this.getPublishButton(), this.getBurstPublishButton());
        layout.linkSize(1, this.getCreateButton(), this.getEditMessageButton(), this.getPublishButton(), this.getBurstPublishButton());
        this.setLayout(new BorderLayout());
        this.add((Component)holder, "Center");
    }

    private JComboBox<?> getMessagesComboBox() {
        if (this.messagesComboBox == null) {
            Vector<String> mValid = new Vector<String>();
            for (String mt : IMCDefinition.getInstance().getMessageNames()) {
                mValid.add(mt);
            }
            this.messagesComboBox = new JComboBox<String>(mValid.toArray(new String[0]));
        }
        return this.messagesComboBox;
    }

    private JButton getEditMessageButton() {
        if (this.editMessageButton == null) {
            this.editMessageButton = new JButton();
            this.editMessageButton.setText("Edit");
            this.editMessageButton.setPreferredSize(new Dimension(76, 26));
            this.editMessageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String mName = (String)ImcMessageSenderPanel.this.getMessagesComboBox().getSelectedItem();
                    IMCMessage sMsg = ImcMessageSenderPanel.this.getOrCreateMessage(mName);
                    MessageEditorImc.showProperties(sMsg, SwingUtilities.getWindowAncestor(ImcMessageSenderPanel.this), true);
                }
            });
        }
        return this.editMessageButton;
    }

    private JButton getCreateButton() {
        if (this.createButton == null) {
            this.createButton = new JButton();
            this.createButton.setText("Create");
            this.createButton.setPreferredSize(new Dimension(76, 26));
            this.createButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String mName = (String)ImcMessageSenderPanel.this.getMessagesComboBox().getSelectedItem();
                    ImcMessageSenderPanel.this.getOrCreateMessage(mName);
                }
            });
        }
        return this.createButton;
    }

    private JButton getPublishButton() {
        if (this.publishButton == null) {
            this.publishButton = new JButton();
            this.publishButton.setText("Publish");
            this.publishButton.setPreferredSize(new Dimension(76, 26));
            this.publishButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String msgName = (String)ImcMessageSenderPanel.this.messagesComboBox.getSelectedItem();
                    String msg = null;
                    IMCMessage sMsg = (IMCMessage)ImcMessageSenderPanel.this.messagesPool.get(msgName);
                    if (sMsg != null) {
                        try {
                            ImcMessageSenderPanel.this.fillSrcDstId(sMsg);
                            sMsg.setTimestampMillis(System.currentTimeMillis());
                            sMsg.dump((OutputStream)System.out);
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            IMCOutputStream ios = new IMCOutputStream((OutputStream)baos);
                            sMsg.serialize(ios);
                            ByteUtil.dumpAsHex(msgName + " [size=" + baos.size() + "]", baos.toByteArray(), System.out);
                            msg = ImcMessageSenderPanel.this.sendUdpMsg(baos.toByteArray(), baos.size());
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        if (msg != null) {
                            JOptionPane.showMessageDialog(ImcMessageSenderPanel.this.publishButton, "Error sending " + msgName + " [" + msg + "]!");
                        }
                    } else {
                        JOptionPane.showMessageDialog(ImcMessageSenderPanel.this.publishButton, "Edit first message " + msgName + " to create it!");
                    }
                }
            });
        }
        return this.publishButton;
    }

    protected void fillSrcDstId(IMCMessage sMsg) {
        int id;
        if (!"".equalsIgnoreCase(this.srcId.getText())) {
            id = -1;
            try {
                id = (int)ImcId16.parseImcId16(this.srcId.getText());
            }
            catch (NumberFormatException e) {
                try {
                    id = Integer.parseInt(this.srcId.getText());
                }
                catch (NumberFormatException e1) {
                    try {
                        id = Integer.parseInt(this.srcId.getText(), 16);
                    }
                    catch (NumberFormatException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            if (id < 0) {
                this.srcId.setText("");
            } else {
                sMsg.getHeader().setValue("src", (Object)id);
            }
        }
        if (!"".equalsIgnoreCase(this.dstId.getText())) {
            id = -1;
            try {
                id = (int)ImcId16.parseImcId16(this.dstId.getText());
            }
            catch (NumberFormatException e) {
                try {
                    id = Integer.parseInt(this.dstId.getText());
                }
                catch (NumberFormatException e1) {
                    try {
                        id = Integer.parseInt(this.dstId.getText(), 16);
                    }
                    catch (NumberFormatException e2) {
                        // empty catch block
                    }
                }
            }
            if (id < 0) {
                this.dstId.setText("");
            } else {
                sMsg.getHeader().setValue("dst", (Object)id);
            }
        }
    }

    private JButton getBurstPublishButton() {
        if (this.burstPublishButton == null) {
            this.burstPublishButton = new JButton();
            this.burstPublishButton.setText("Burst");
            this.burstPublishButton.setPreferredSize(new Dimension(76, 26));
            this.burstPublishButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImcMessageSenderPanel.this.burstPublishButton.setEnabled(false);
                    SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

                        @Override
                        protected Boolean doInBackground() throws Exception {
                            Collection mtypes = IMCDefinition.getInstance().getMessageNames();
                            Iterator i$ = mtypes.iterator();
                            while (i$.hasNext()) {
                                String mt;
                                String msgName = mt = (String)i$.next();
                                String msg = null;
                                IMCMessage sMsg = ImcMessageSenderPanel.this.getOrCreateMessage(msgName);
                                ImcMessageSenderPanel.this.fillSrcDstId(sMsg);
                                sMsg.setTimestampMillis(System.currentTimeMillis());
                                sMsg.dump((OutputStream)System.out);
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                IMCOutputStream ios = new IMCOutputStream((OutputStream)baos);
                                try {
                                    sMsg.serialize(ios);
                                    ByteUtil.dumpAsHex(msgName + " [size=" + baos.size() + "]", baos.toByteArray(), System.out);
                                    msg = ImcMessageSenderPanel.this.sendUdpMsg(baos.toByteArray(), baos.size());
                                }
                                catch (Exception e1) {
                                    System.err.println("Msg: " + msg);
                                    e1.printStackTrace();
                                }
                            }
                            return false;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                            }
                            if (ImcMessageSenderPanel.this.burstPublishButton != null) {
                                ImcMessageSenderPanel.this.burstPublishButton.setEnabled(true);
                            }
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.burstPublishButton;
    }

    private LocationCopyPastePanel getLocCopyPastPanel() {
        if (this.locCopyPastePanel == null) {
            this.locCopyPastePanel = new LocationCopyPastePanel(){
                private static final long serialVersionUID = 1809942752421373734L;

                @Override
                public void setLocationType(LocationType locationType) {
                    super.setLocationType(locationType);
                    ImcMessageSenderPanel.this.applyLocation();
                }
            };
            this.locCopyPastePanel.setPreferredSize(new Dimension(76, 26));
            this.locCopyPastePanel.setMaximumSize(new Dimension(76, 26));
            this.locCopyPastePanel.setToolTipText("Pastes to EstimatedState Message (but doesn't copy from there nor touches ref)");
        }
        return this.locCopyPastePanel;
    }

    public String sendUdpMsg(byte[] msg, int size) {
        try {
            DatagramSocket sock = null;
            if ("".equalsIgnoreCase(this.bindPort.getText())) {
                sock = new DatagramSocket();
            } else {
                int bport = Integer.parseInt(this.bindPort.getText());
                sock = new DatagramSocket(bport);
            }
            sock.connect(new InetSocketAddress(this.address.getText(), Integer.parseInt(this.port.getText())));
            sock.send(new DatagramPacket(msg, size));
            sock.close();
            return null;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return "Error sending the UDP message: " + e.getMessage();
        }
    }

    private IMCMessage getOrCreateMessage(String mName) {
        IMCMessage msg = this.messagesPool.get(mName);
        if (msg == null) {
            msg = IMCDefinition.getInstance().create(mName, new Object[0]);
            this.messagesPool.put(mName, msg);
        }
        this.applyLocation(msg);
        return msg;
    }

    private void applyLocation() {
        for (IMCMessage sMsg : this.messagesPool.values()) {
            this.applyLocation(sMsg);
        }
    }

    private void applyLocation(IMCMessage sMsg) {
        LocationType locationType = this.getLocCopyPastPanel().getLocationType();
        List<String> fieldNames = Arrays.asList(sMsg.getFieldNames());
        boolean hasLatLon = false;
        boolean hasXY = false;
        boolean hasDepthOrHeight = false;
        if (fieldNames.contains("lat") || fieldNames.contains("lon")) {
            hasLatLon = true;
        }
        if (fieldNames.contains("x") || fieldNames.contains("y")) {
            hasXY = true;
        }
        if (fieldNames.contains("depth") || fieldNames.contains("height")) {
            hasDepthOrHeight = true;
        }
        if (hasLatLon && !hasXY) {
            locationType = locationType.getNewAbsoluteLatLonDepth();
        }
        sMsg.setValue("lat", (Object)locationType.getLatitudeRads());
        sMsg.setValue("lon", (Object)locationType.getLongitudeRads());
        sMsg.setValue("depth", (Object)locationType.getDepth());
        sMsg.setValue("height", (Object)locationType.getHeight());
        double[] val = CoordinateUtil.sphericalToCartesianCoordinates(locationType.getOffsetDistance(), locationType.getAzimuth(), locationType.getZenith());
        sMsg.setValue("x", (Object)(locationType.getOffsetNorth() + val[0]));
        sMsg.setValue("y", (Object)(locationType.getOffsetEast() + val[1]));
        if (!hasDepthOrHeight) {
            sMsg.setValue("z", (Object)locationType.getAllZ());
        } else {
            sMsg.setValue("z", (Object)(locationType.getOffsetDown() + val[2]));
        }
    }

    public static JFrame getFrame() {
        JFrame frame = GuiUtils.testFrame(new ImcMessageSenderPanel());
        frame.setSize(500, 290);
        frame.setTitle("IMC Message Sender (by UDP)");
        ArrayList<Image> imageList = new ArrayList<Image>();
        imageList.add(ICON.getImage());
        imageList.add(ICON1.getImage());
        frame.setIconImages(imageList);
        frame.setDefaultCloseOperation(2);
        return frame;
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        new ImcMessageSenderPanel();
        ImcMessageSenderPanel.getFrame().setDefaultCloseOperation(3);
    }
}

