/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager.imc;

import com.google.common.eventbus.AsyncEventBus;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JFrame;
import pt.lsts.imc.Announce;
import pt.lsts.imc.EntityInfo;
import pt.lsts.imc.EntityList;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.MessagePart;
import pt.lsts.imc.lsf.LsfMessageLogger;
import pt.lsts.imc.net.IMCFragmentHandler;
import pt.lsts.imc.state.ImcSysState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.CommUtil;
import pt.lsts.neptus.comm.IMCSendMessageUtils;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.CommBaseManager;
import pt.lsts.neptus.comm.manager.CommManagerStatusChangeListener;
import pt.lsts.neptus.comm.manager.MessageFrequencyCalculator;
import pt.lsts.neptus.comm.manager.imc.AnnounceWorker;
import pt.lsts.neptus.comm.manager.imc.EntitiesResolver;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.comm.manager.imc.MessageDeliveryListener;
import pt.lsts.neptus.comm.manager.imc.MonitorIMCComms;
import pt.lsts.neptus.comm.manager.imc.SystemImcMsgCommInfo;
import pt.lsts.neptus.comm.transports.ImcTcpTransport;
import pt.lsts.neptus.comm.transports.ImcUdpTransport;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.messages.MessageFilter;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageInfoImpl;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.NetworkInterfacesUtil;
import pt.lsts.neptus.util.StringUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.conf.PreferencesListener;

public class ImcMsgManager
extends CommBaseManager<IMCMessage, MessageInfo, SystemImcMsgCommInfo, ImcId16, CommManagerStatusChangeListener> {
    public static final String TRANSPORT_UDP = "UDP";
    public static final String TRANSPORT_TCP = "TCP";
    private static final int DEFAULT_UDP_VEH_PORT = 6002;
    private static ImcMsgManager commManager = null;
    private ImcId16 localId = ImcId16.NULL_ID;
    private boolean sameIdErrorDetected = false;
    private long sameIdErrorDetectedTimeMillis = -1L;
    protected IMCFragmentHandler fragmentHandler = new IMCFragmentHandler(IMCDefinition.getInstance());
    protected ImcSysState imcState = new ImcSysState();
    private final HashMap<String, ImcId16> udpOnIpMapper;
    private boolean isFilterByPort;
    private boolean isRedirectToFirst;
    private boolean logSentMsg;
    @Deprecated
    private boolean dontIgnoreIpSourceRequest;
    private boolean multicastEnabled;
    private String multicastAddress;
    private int[] multicastPorts;
    private boolean broadcastEnabled;
    private final IMCDefinition imcDefinition;
    private AnnounceWorker announceWorker;
    private long announceLastArriveTime;
    private final PreferencesListener gplistener;
    protected ImcUdpTransport udpTransport;
    protected ImcUdpTransport multicastUdpTransport;
    protected ImcTcpTransport tcpTransport;
    private final ExecutorService service;
    protected AsyncEventBus bus;
    protected HashSet<Object> busListeners;
    private long lastNetInterfaceMillis;
    private Vector<NetworkInterfacesUtil.NInterface> netInterfaces;
    private final LinkedList<URL> registerServicesToAnnounce;
    private final MessageFrequencyCalculator toSendMessagesFreqCalc;
    private final MessageFrequencyCalculator sentMessagesFreqCalc;
    protected short lastEntityId;
    protected LinkedHashMap<String, Short> neptusEntities;
    private final ArrayList<TransportPreference> transportPreferenceToUse;
    protected Vector<String> ignoredClasses;

    public static void registerBusListener(Object listener) {
        if (!ImcMsgManager.getManager().busListeners.contains(listener)) {
            ImcMsgManager.getManager().getMessageBus().register(listener);
        }
        ImcMsgManager.getManager().busListeners.add(listener);
    }

    public static void unregisterBusListener(Object listener) {
        if (ImcMsgManager.getManager().busListeners.contains(listener)) {
            ImcMsgManager.getManager().getMessageBus().unregister(listener);
        }
        ImcMsgManager.getManager().busListeners.remove(listener);
    }

    public static ImcMsgManager getManager() {
        return ImcMsgManager.createManager();
    }

    private static synchronized ImcMsgManager createManager() {
        if (commManager == null) {
            commManager = new ImcMsgManager(IMCDefinition.getInstance());
        }
        return commManager;
    }

    public ImcMsgManager(IMCDefinition imcDefinition) {
        this.imcState.setIgnoreEntities(true);
        this.udpOnIpMapper = new HashMap();
        this.isFilterByPort = false;
        this.isRedirectToFirst = false;
        this.logSentMsg = false;
        this.dontIgnoreIpSourceRequest = true;
        this.multicastEnabled = true;
        this.multicastAddress = "224.0.75.69";
        this.multicastPorts = new int[]{6969};
        this.broadcastEnabled = true;
        this.announceLastArriveTime = -1L;
        this.udpTransport = null;
        this.multicastUdpTransport = null;
        this.tcpTransport = null;
        this.service = Executors.newCachedThreadPool(new ThreadFactory(){
            private long counter = 0L;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Message Event Bus " + this.counter++);
                t.setDaemon(true);
                return t;
            }
        });
        this.bus = new AsyncEventBus((Executor)this.service);
        this.busListeners = new HashSet();
        this.lastNetInterfaceMillis = -1L;
        this.netInterfaces = null;
        this.registerServicesToAnnounce = new LinkedList();
        this.toSendMessagesFreqCalc = new MessageFrequencyCalculator();
        this.sentMessagesFreqCalc = new MessageFrequencyCalculator();
        this.lastEntityId = 0;
        this.neptusEntities = new LinkedHashMap();
        this.transportPreferenceToUse = new ArrayList();
        this.ignoredClasses = new Vector();
        this.ignoredClasses.add(this.getClass().getName());
        this.ignoredClasses.add(ConsolePanel.class.getName());
        this.ignoredClasses.add(Thread.class.getName());
        this.ignoredClasses.add(IMCSendMessageUtils.class.getName());
        this.gplistener = new PreferencesListener(){

            @Override
            public void preferencesUpdated() {
                ImcMsgManager.this.logSentMsg = GeneralPreferences.messageLogSentMessages;
                ImcMsgManager.this.isRedirectToFirst = GeneralPreferences.redirectUnknownIdsToFirstCommVehicle;
                ImcMsgManager.this.dontIgnoreIpSourceRequest = GeneralPreferences.imcChangeBySourceIpRequest;
                ImcMsgManager.this.announceWorker.getAnnounceMessage().setValue("sys_name", (Object)StringUtils.toImcName(GeneralPreferences.imcCcuName));
                ImcMsgManager.this.announceWorker.setUseUnicastAnnounce(GeneralPreferences.imcUnicastAnnounceEnable);
                ImcMsgManager.this.localId = GeneralPreferences.imcCcuId;
            }
        };
        this.imcDefinition = imcDefinition;
        this.announceWorker = new AnnounceWorker(this, imcDefinition);
        GeneralPreferences.addPreferencesListener(this.gplistener);
        this.gplistener.preferencesUpdated();
    }

    @Override
    public synchronized boolean start() {
        if (this.started) {
            return true;
        }
        NeptusLog.pub().info((Object)"Starting IMC comms");
        boolean ret = super.start();
        if (!ret) {
            return false;
        }
        this.gplistener.preferencesUpdated();
        this.isFilterByPort = GeneralPreferences.filterUdpAlsoByPort;
        this.localId = GeneralPreferences.imcCcuId;
        this.updateUdpOnIpMapper();
        return ret;
    }

    @Override
    public synchronized boolean stop() {
        NeptusLog.pub().info((Object)"Stoping IMC comms");
        return super.stop();
    }

    public void postInternalMessage(String srcName, IMCMessage message) {
        MessageInfoImpl minfo = new MessageInfoImpl();
        minfo.setPublisher(srcName);
        minfo.setPublisherInetAddress("127.0.0.1");
        minfo.setPublisherPort(6001);
        minfo.setTimeReceivedSec((double)System.currentTimeMillis() / 1000.0);
        this.checkAndSetMessageSrcEntity(message);
        this.onMessage(minfo, message);
        this.bus.post((Object)message);
    }

    private void updateUdpOnIpMapper() {
        for (SystemImcMsgCommInfo vsci : this.commInfo.values()) {
            if (this.isUdpOn()) {
                this.udpOnIpMapper.put(vsci.getIpAddress() + (this.isFilterByPort ? ":" + vsci.getIpRemotePort() : ""), (ImcId16)vsci.getSystemCommId());
                continue;
            }
            this.udpOnIpMapper.remove(vsci.getIpAddress() + (this.isFilterByPort ? ":" + vsci.getIpRemotePort() : ""));
        }
    }

    private void updateUdpOnIpMapper(SystemImcMsgCommInfo vsci) {
        if (this.isUdpOn()) {
            this.udpOnIpMapper.put(vsci.getIpAddress() + (this.isFilterByPort ? ":" + vsci.getIpRemotePort() : ""), (ImcId16)vsci.getSystemCommId());
        } else {
            this.udpOnIpMapper.remove(vsci.getIpAddress() + (this.isFilterByPort ? ":" + vsci.getIpRemotePort() : ""));
        }
    }

    public synchronized SystemImcMsgCommInfo initVehicleCommInfo(String vehicleId, String inetAddress) {
        VehicleType veh = VehiclesHolder.getVehicleById(vehicleId);
        if (veh == null) {
            return null;
        }
        ImcId16 imcId = veh.getImcId();
        if (imcId == null) {
            return null;
        }
        return this.initSystemCommInfo(imcId, inetAddress);
    }

    @Override
    public synchronized SystemImcMsgCommInfo initSystemCommInfo(ImcId16 vIdS, String inetAddress) {
        SystemImcMsgCommInfo vci = (SystemImcMsgCommInfo)this.commInfo.get(vIdS);
        if (vci != null) {
            NeptusLog.pub().debug((Object)("System already known to manager: " + vIdS));
            return vci;
        }
        NeptusLog.pub().debug((Object)("System not yet known to manager: " + vIdS));
        SystemImcMsgCommInfo vsci = new SystemImcMsgCommInfo();
        vsci.setMessageBus(this.bus);
        vsci.setSystemCommId(vIdS);
        VehicleType vehTmp = VehiclesHolder.getVehicleWithImc(vIdS);
        if (vehTmp == null) {
            NeptusLog.pub().warn((Object)("No vehicle with IMC ID " + vIdS + "!"));
        } else {
            NeptusLog.pub().debug((Object)("Found the Vehicle: " + vehTmp.getId()));
            vsci.setSystemIdName(vehTmp.getId());
        }
        ImcSystem resSys = ImcSystemsHolder.lookupSystem(vIdS);
        if (resSys == null) {
            if (vehTmp != null) {
                resSys = new ImcSystem(vehTmp);
                resSys.setType(ImcSystem.translateSystemTypeFromMessage(vehTmp.getType().toUpperCase()));
                resSys.setTypeVehicle(ImcSystem.translateVehicleTypeFromMessage(vehTmp.getType().toUpperCase()));
                ImcSystemsHolder.registerSystem(resSys);
            } else {
                InetSocketAddress isa = ImcSystem.parseInetSocketAddress(inetAddress);
                if (isa != null) {
                    resSys = new ImcSystem(vIdS, ImcSystem.createCommMean(isa.getAddress().getHostAddress(), isa.getPort(), isa.getPort(), vIdS, true, false));
                    ImcSystemsHolder.registerSystem(resSys);
                } else {
                    resSys = new ImcSystem(vIdS);
                    ImcSystemsHolder.registerSystem(resSys);
                }
            }
        }
        if (vsci.initSystemComms()) {
            if (!vsci.startSystemComms()) {
                NeptusLog.pub().error((Object)("Error starting " + vsci.getSystemIdName()));
            }
        } else {
            NeptusLog.pub().error((Object)("Error initializing " + vsci.getSystemIdName()));
        }
        this.updateUdpOnIpMapper(vsci);
        this.commInfo.put(vIdS, vsci);
        if (vehTmp != null) {
            this.sendManagerVehicleAdded(vehTmp);
            this.sendManagerVehicleStatusChanged(vehTmp, 0);
        } else {
            this.sendManagerSystemAdded(vIdS);
            this.sendManagerSystemStatusChanged(vIdS, 0);
        }
        return vsci;
    }

    void mapUdpIpPort(SystemImcMsgCommInfo vsci) {
        if (vsci == null) {
            return;
        }
        if (this.isUdpOn()) {
            this.udpOnIpMapper.put(vsci.getIpAddress() + (this.isFilterByPort ? ":" + vsci.getIpRemotePort() : ""), (ImcId16)vsci.getSystemCommId());
        } else {
            this.udpOnIpMapper.remove(vsci.getIpAddress() + (this.isFilterByPort ? ":" + vsci.getIpRemotePort() : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAnnounceServicesList() {
        String ret = "";
        String loopbackServ = "";
        Vector<NetworkInterfacesUtil.NInterface> netInterfaces = this.getNetworkInterfaces();
        for (NetworkInterfacesUtil.NInterface ni : netInterfaces) {
            if (ni.isLoopback()) {
                if (this.getUdpTransport() != null) {
                    for (Inet4Address i4a : ni.getAddress()) {
                        loopbackServ = loopbackServ + "imc+udp://" + i4a.getHostAddress() + ":" + this.getUdpTransport().getBindPort() + "/;";
                    }
                }
                if (this.getTcpTransport() == null) continue;
                for (Inet4Address i4a : ni.getAddress()) {
                    loopbackServ = loopbackServ + "imc+tcp://" + i4a.getHostAddress() + ":" + this.getTcpTransport().getBindPort() + "/;";
                }
                continue;
            }
            if (!ni.hasIpv4Address()) continue;
            if (this.getUdpTransport() != null) {
                for (Inet4Address i4a : ni.getAddress()) {
                    ret = ret + "imc+udp://" + i4a.getHostAddress() + ":" + this.getUdpTransport().getBindPort() + "/;";
                }
            }
            if (this.getTcpTransport() != null) {
                for (Inet4Address i4a : ni.getAddress()) {
                    ret = ret + "imc+tcp://" + i4a.getHostAddress() + ":" + this.getTcpTransport().getBindPort() + "/;";
                }
            }
            LinkedList<URL> linkedList = this.registerServicesToAnnounce;
            synchronized (linkedList) {
                for (URL url : this.registerServicesToAnnounce) {
                    try {
                        URI uri = url.toURI();
                        String host = uri.getHost();
                        Vector<String> hostsStr = new Vector<String>();
                        if ("localhost".equalsIgnoreCase(host)) {
                            for (Inet4Address i4a : ni.getAddress()) {
                                hostsStr.add(i4a.getHostAddress());
                            }
                        } else {
                            hostsStr.add(host);
                        }
                        for (String hst : hostsStr) {
                            URL serv = new URI(uri.getScheme(), uri.getUserInfo(), hst, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toURL();
                            ret = ret + serv.toString() + ";";
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return ret.length() != 0 ? ret : loopbackServ;
    }

    private synchronized Vector<NetworkInterfacesUtil.NInterface> getNetworkInterfaces() {
        if (this.netInterfaces == null || System.currentTimeMillis() - this.lastNetInterfaceMillis > 3000L) {
            this.netInterfaces = NetworkInterfacesUtil.getNetworkInterfaces();
            this.lastNetInterfaceMillis = System.currentTimeMillis();
        }
        return this.netInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerService(URL service) {
        LinkedList<URL> linkedList = this.registerServicesToAnnounce;
        synchronized (linkedList) {
            if (!this.registerServicesToAnnounce.contains(service)) {
                return this.registerServicesToAnnounce.add(service);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unRegisterService(URL service) {
        LinkedList<URL> linkedList = this.registerServicesToAnnounce;
        synchronized (linkedList) {
            return this.registerServicesToAnnounce.remove(service);
        }
    }

    public String getAllServicesString() {
        return this.announceWorker.getAllServices();
    }

    @Override
    protected boolean initManagerComms() {
        String[] tks;
        String transportsToUse = GeneralPreferences.imcTransportsToUse;
        boolean udpConfig = StringUtils.isTokenInList(transportsToUse, TRANSPORT_UDP);
        if (udpConfig) {
            this.createUdpTransport();
        } else {
            this.udpTransport = null;
        }
        this.createMulticastUdpTransport();
        boolean tcpConfig = StringUtils.isTokenInList(transportsToUse, TRANSPORT_TCP);
        if (tcpConfig) {
            this.createTcpTransport();
        } else {
            this.tcpTransport = null;
        }
        this.transportPreferenceToUse.clear();
        for (String t : tks = transportsToUse.split("[ ,]+")) {
            if (TRANSPORT_UDP.equalsIgnoreCase(t) && this.isUdpOn()) {
                this.transportPreferenceToUse.add(TransportPreference.UDP);
                continue;
            }
            if (!TRANSPORT_TCP.equalsIgnoreCase(t) || !this.isTcpOn()) continue;
            this.transportPreferenceToUse.add(TransportPreference.TCP);
        }
        return true;
    }

    @Override
    protected boolean startManagerComms() {
        if (this.udpTransport != null) {
            this.udpTransport.reStart();
            this.udpTransport.addListener(this);
        }
        if (this.multicastUdpTransport != null) {
            this.multicastUdpTransport.reStart();
            this.multicastUdpTransport.addListener(this);
            if (this.announceWorker != null) {
                this.announceWorker.startAnnounceAndPeriodicRequests();
            }
        }
        if (this.tcpTransport != null) {
            this.tcpTransport.reStart();
            this.tcpTransport.addListener(this);
        }
        return true;
    }

    @Override
    protected boolean stopManagerComms() {
        if (this.udpTransport != null) {
            this.udpTransport.removeListener(this);
            this.udpTransport.stop();
        }
        if (this.multicastUdpTransport != null) {
            this.multicastUdpTransport.removeListener(this);
            this.multicastUdpTransport.stop();
            if (this.announceWorker != null) {
                this.announceWorker.stopAnnounce();
            }
        }
        if (this.tcpTransport != null) {
            this.tcpTransport.removeListener(this);
            this.tcpTransport.stop();
        }
        return true;
    }

    private void createUdpTransport() {
        int localport = GeneralPreferences.commsLocalPortUDP;
        if (this.udpTransport == null) {
            this.udpTransport = new ImcUdpTransport(localport, this.imcDefinition);
        } else {
            this.udpTransport.setBindPort(localport);
        }
        this.udpTransport.reStart();
        if (this.udpTransport.isOnBindError()) {
            for (int i = 1; i < 10; ++i) {
                this.udpTransport.stop();
                this.udpTransport.setBindPort(localport + i);
                this.udpTransport.reStart();
                if (!this.udpTransport.isOnBindError()) break;
            }
        }
    }

    private ImcUdpTransport getUdpTransport() {
        return this.udpTransport;
    }

    public boolean isUdpOn() {
        return this.udpTransport != null && this.udpTransport.isRunnning();
    }

    private void createTcpTransport() {
        int localport = GeneralPreferences.commsLocalPortTCP;
        if (this.tcpTransport == null) {
            this.tcpTransport = new ImcTcpTransport(localport, this.imcDefinition);
        } else {
            this.tcpTransport.setBindPort(localport);
        }
        this.tcpTransport.reStart();
        if (this.tcpTransport.isOnBindError()) {
            for (int i = 1; i < 10; ++i) {
                this.tcpTransport.stop();
                this.tcpTransport.setBindPort(localport + i);
                this.tcpTransport.reStart();
                if (!this.tcpTransport.isOnBindError()) break;
            }
        }
    }

    private ImcTcpTransport getTcpTransport() {
        return this.tcpTransport;
    }

    public boolean isTcpOn() {
        return this.tcpTransport != null && this.tcpTransport.isRunning();
    }

    boolean isTCPConnectionEstablished(String host, int port) {
        if (this.getTcpTransport() == null) {
            return false;
        }
        return this.getTcpTransport().isConnectionEstablished(host, port);
    }

    public long getAnnounceLastArriveTime() {
        return this.announceLastArriveTime;
    }

    private void createMulticastUdpTransport() {
        this.multicastEnabled = GeneralPreferences.imcMulticastEnable;
        this.broadcastEnabled = GeneralPreferences.imcBroadcastEnable;
        if (!this.multicastEnabled && !this.broadcastEnabled) {
            return;
        }
        this.multicastAddress = GeneralPreferences.imcMulticastAddress;
        int localport = 6969;
        this.multicastPorts = CommUtil.parsePortRangeFromString(GeneralPreferences.imcMulticastBroadcastPortRange, new int[]{6969});
        if (this.multicastUdpTransport == null) {
            this.multicastUdpTransport = new ImcUdpTransport(this.multicastPorts.length == 0 ? localport : this.multicastPorts[0], this.multicastAddress, this.imcDefinition);
        } else {
            this.multicastUdpTransport.setBindPort(this.multicastPorts.length == 0 ? localport : this.multicastPorts[0]);
            this.multicastUdpTransport.setMulticastAddress(this.multicastAddress);
        }
        this.multicastUdpTransport.setBroadcastEnable(this.broadcastEnabled);
        this.multicastUdpTransport.reStart();
        if (this.multicastUdpTransport.isOnBindError()) {
            for (int i = 1; i < this.multicastPorts.length; ++i) {
                this.multicastUdpTransport.stop();
                this.multicastUdpTransport.setBindPort(this.multicastPorts[i]);
                this.multicastUdpTransport.reStart();
                if (!this.multicastUdpTransport.isOnBindError()) break;
            }
        }
        if (!this.multicastUdpTransport.isOnBindError() && this.announceWorker == null) {
            this.announceWorker = new AnnounceWorker(this, this.imcDefinition);
        }
    }

    public boolean is2IdErrorMode() {
        return this.sameIdErrorDetected;
    }

    @Override
    protected boolean processMsgLocally(MessageInfo info, IMCMessage msg) {
        SystemImcMsgCommInfo vci = null;
        this.imcState.setMessage(msg);
        try {
            IMCMessage m;
            ImcId16 id = new ImcId16(msg.getHeader().getValue("src"));
            if (this.sameIdErrorDetectedTimeMillis < -1L || System.currentTimeMillis() - this.sameIdErrorDetectedTimeMillis > 20000L) {
                this.sameIdErrorDetected = false;
            }
            if (!ImcId16.NULL_ID.equals(this.localId) && this.localId.equals(id)) {
                if (151 == msg.getMgid()) {
                    String localUid = this.announceWorker.getNeptusInstanceUniqueID();
                    String serv = this.announceWorker.getImcServicesFromMessage(msg);
                    IMCDefinition.getInstance().getResolver().addEntry(msg.getSrc(), msg.getString("sys_name"));
                    String uid = IMCUtils.getUidFromServices(serv);
                    boolean sameHost = false;
                    Vector<NetworkInterfacesUtil.NInterface> iList = this.getNetworkInterfaces();
                    for (NetworkInterfacesUtil.NInterface nInterface : iList) {
                        Inet4Address[] lad;
                        for (Inet4Address inet4Address : lad = nInterface.getAddress()) {
                            if (!info.getPublisherInetAddress().equalsIgnoreCase(inet4Address.getHostAddress())) continue;
                            sameHost = true;
                            break;
                        }
                        if (!sameHost) continue;
                        break;
                    }
                    if (!localUid.equalsIgnoreCase(uid)) {
                        NeptusLog.pub().warn((Object)("Another node on " + (sameHost ? "this computer" : "our network") + " is advertising our node id '" + this.localId.toPrettyString() + "'"));
                        this.sameIdErrorDetected = true;
                        this.sameIdErrorDetectedTimeMillis = System.currentTimeMillis();
                    }
                }
                return false;
            }
            if (msg instanceof MessagePart && (m = this.fragmentHandler.setFragment((MessagePart)msg)) != null) {
                this.postInternalMessage(msg.getSourceName(), m);
            }
            if (this.localId.equals(id)) {
                System.out.println(msg.getAbbrev());
            }
            vci = (SystemImcMsgCommInfo)this.getCommInfoById(id);
            if (!(ImcId16.NULL_ID.equals(id) || ImcId16.BROADCAST_ID.equals(id) || ImcId16.ANNOUNCE.equals(id) || this.localId.equals(id))) {
                if (151 == msg.getMgid()) {
                    this.announceLastArriveTime = System.currentTimeMillis();
                    vci = this.processAnnounceMessage(info, (Announce)msg, vci, id);
                } else if ("EntityList".equalsIgnoreCase(msg.getAbbrev())) {
                    EntityList entityListMessage = EntityList.clone((IMCMessage)msg);
                    EntitiesResolver.setEntities(id.toString(), entityListMessage);
                    ImcSystem sys = ImcSystemsHolder.lookupSystem(id);
                    if (sys != null) {
                        EntitiesResolver.setEntities(sys.getName(), entityListMessage);
                    }
                } else if (vci == null) {
                    if (VehiclesHolder.getVehicleWithImc(id) != null) {
                        vci = this.initSystemCommInfo(id, "");
                    } else {
                        return false;
                    }
                }
                if (vci != null) {
                    NeptusLog.pub().trace((Object)(this.getClass().getSimpleName() + ": Message redirected for system comm. " + vci.getSystemCommId() + "."));
                    vci.onMessage(info, msg);
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String inetAddress = info.getPublisherInetAddress();
        String remotePortAddress = "" + info.getPublisherPort();
        NeptusLog.pub().info((Object)(this.getClass().getSimpleName() + ": No IMC system found. trying to redirected " + "by IP/Port info. " + (vci != null ? vci.getSystemCommId() + ">" : "") + inetAddress + ":" + remotePortAddress + "."));
        boolean sentToBus = false;
        if (this.udpOnIpMapper.containsKey(inetAddress + (this.isFilterByPort ? ":" + remotePortAddress : ""))) {
            ImcId16 systemId = this.udpOnIpMapper.get(inetAddress + (this.isFilterByPort ? ":" + remotePortAddress : ""));
            SystemImcMsgCommInfo vciMapper = (SystemImcMsgCommInfo)this.getCommInfoById(systemId);
            if (vciMapper != null && vci != vciMapper) {
                NeptusLog.pub().debug((Object)(this.getClass().getSimpleName() + ": Message redirected for system comm. " + vciMapper.getSystemCommId() + "."));
                vciMapper.onMessage(info, msg);
                sentToBus = true;
            }
        } else if (this.isRedirectToFirst && !this.getCommInfo().keySet().isEmpty()) {
            ImcId16 vehicleId = (ImcId16)this.getCommInfo().keySet().iterator().next();
            SystemImcMsgCommInfo vciRedirect = (SystemImcMsgCommInfo)this.getCommInfoById(vehicleId);
            NeptusLog.pub().debug((Object)(this.getClass().getSimpleName() + ": Message redirected for system comm. " + vciRedirect.getSystemCommId() + "."));
            vciRedirect.onMessage(info, msg);
            sentToBus = true;
        }
        try {
            if (!sentToBus) {
                this.bus.post((Object)msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        return true;
    }

    private SystemImcMsgCommInfo processAnnounceMessage(MessageInfo info, Announce ann, SystemImcMsgCommInfo vci, ImcId16 id) throws IOException {
        String sia = info.getPublisherInetAddress();
        NeptusLog.pub().debug((Object)("processAnnounceMessage for " + ann.getSysName() + "@" + id + " :: publisher host address " + sia));
        InetSocketAddress[] retId = this.announceWorker.getImcIpsPortsFromMessageImcUdp((IMCMessage)ann);
        int portUdp = 0;
        String hostUdp = "";
        boolean udpIpPortFound = false;
        if (retId.length > 0) {
            portUdp = retId[0].getPort();
            hostUdp = retId[0].getAddress().getHostAddress();
        }
        for (InetSocketAddress add : retId) {
            if (!sia.equalsIgnoreCase(add.getAddress().getHostAddress()) || !add.getAddress().isReachable(10)) continue;
            udpIpPortFound = true;
            portUdp = add.getPort();
            hostUdp = add.getAddress().getHostAddress();
            NeptusLog.pub().debug((Object)("processAnnounceMessage for " + ann.getSysName() + "@" + id + " :: " + "UDP reachable @ " + hostUdp + ":" + portUdp));
            break;
        }
        if (!udpIpPortFound) {
            String ipReceived;
            hostUdp = ipReceived = hostUdp.isEmpty() ? info.getPublisherInetAddress() : hostUdp;
            udpIpPortFound = true;
            NeptusLog.pub().debug((Object)("processAnnounceMessage for " + ann.getSysName() + "@" + id + " :: " + "no UDP reachable using " + hostUdp + ":" + portUdp));
        }
        InetSocketAddress[] retIdT = this.announceWorker.getImcIpsPortsFromMessageImcTcp((IMCMessage)ann);
        int portTcp = 0;
        boolean tcpIpPortFound = false;
        if (retIdT.length > 0) {
            portTcp = retIdT[0].getPort();
            if ("".equalsIgnoreCase(hostUdp)) {
                hostUdp = retIdT[0].getAddress().getHostAddress();
            }
        }
        for (InetSocketAddress add : retIdT) {
            if (!sia.equalsIgnoreCase(add.getAddress().getHostAddress())) continue;
            if ("".equalsIgnoreCase(hostUdp)) {
                if (!add.getAddress().isReachable(10)) continue;
                tcpIpPortFound = true;
                hostUdp = add.getAddress().getHostAddress();
                portTcp = add.getPort();
                NeptusLog.pub().debug((Object)("processAnnounceMessage for " + ann.getSysName() + "@" + id + " :: " + "TCP reachable @ " + hostUdp + ":" + portTcp));
                break;
            }
            portTcp = add.getPort();
            tcpIpPortFound = true;
            NeptusLog.pub().debug((Object)("processAnnounceMessage for " + ann.getSysName() + "@" + id + " :: " + "no TCP reachable using " + hostUdp + ":" + portTcp));
            break;
        }
        NeptusLog.pub().debug((Object)("processAnnounceMessage for " + ann.getSysName() + "@" + id + " :: " + "using UDP@" + hostUdp + ":" + portUdp + " and using TCP@" + hostUdp + ":" + portTcp));
        boolean requestEntityList = false;
        if (vci == null) {
            vci = this.initSystemCommInfo(id, info.getPublisherInetAddress() + ":" + (portUdp == 0 ? 6002 : portUdp));
            this.updateUdpOnIpMapper(vci);
            requestEntityList = true;
        }
        String name = ann.getSysName();
        String type = ann.getSysType().toString();
        vci.setSystemIdName(name);
        ImcSystem resSys = ImcSystemsHolder.lookupSystem(id);
        if (resSys != null) {
            Map<Integer, String> er;
            resSys.setServicesProvided(this.announceWorker.getImcServicesFromMessage((IMCMessage)ann));
            AnnounceWorker.processUidFromServices(resSys);
            if (resSys.isOnIdErrorState()) {
                EntitiesResolver.clearAliases(resSys.getName());
                EntitiesResolver.clearAliases(resSys.getId());
            }
            resSys.setName(name);
            resSys.setType(ImcSystem.translateSystemTypeFromMessage(type));
            resSys.setTypeVehicle(ImcSystem.translateVehicleTypeFromMessage(type));
            if (portUdp != 0 && udpIpPortFound) {
                resSys.setRemoteUDPPort(portUdp);
            } else if (resSys.getRemoteUDPPort() == 0) {
                resSys.setRemoteUDPPort(6002);
            }
            if (!"".equalsIgnoreCase(hostUdp) && !"NONE".equalsIgnoreCase(hostUdp)) {
                if ("SENDER_REMOTE_IP".equalsIgnoreCase(hostUdp)) {
                    if (this.dontIgnoreIpSourceRequest) {
                        resSys.setHostAddress(info.getPublisherInetAddress());
                    }
                } else if (udpIpPortFound || tcpIpPortFound) {
                    resSys.setHostAddress(hostUdp);
                }
            }
            if (portTcp != 0 && tcpIpPortFound) {
                resSys.setTCPOn(true);
                resSys.setRemoteTCPPort(portTcp);
            } else if (portTcp == 0) {
                resSys.setTCPOn(false);
            }
            if (resSys.isTCPOn() && retId.length == 0) {
                resSys.setUDPOn(false);
            } else {
                resSys.setUDPOn(true);
            }
            resSys.setOnAnnounceState(true);
            try {
                double latRad = ann.getLat();
                double lonRad = ann.getLon();
                double height = ann.getHeight();
                if (latRad != 0.0 && lonRad != 0.0) {
                    LocationType loc = new LocationType();
                    loc.setLatitudeDegs(Math.toDegrees(latRad));
                    loc.setLongitudeDegs(Math.toDegrees(lonRad));
                    loc.setHeight(height);
                    long locTime = (long)(info.getTimeSentSec() * 1000.0);
                    resSys.setLocation(loc, locTime);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            double headingDegreesFromServices = AnnounceWorker.processHeadingDegreesFromServices(resSys);
            if (!Double.isNaN(headingDegreesFromServices) && !Double.isInfinite(headingDegreesFromServices)) {
                long attTime = (long)(info.getTimeSentSec() * 1000.0);
                resSys.setAttitudeDegrees(headingDegreesFromServices, attTime);
            }
            if ((er = EntitiesResolver.getEntities(resSys.getName())) == null || er.size() == 0) {
                requestEntityList = true;
            }
            if (requestEntityList) {
                this.announceWorker.sendEntityListRequestMsg(resSys);
            }
            ImcSystemsHolder.registerSystem(resSys);
        }
        this.imcDefinition.getResolver().addEntry(ann.getSrc(), ann.getSysName());
        return vci;
    }

    public MessageFrequencyCalculator getSentMessagesFreqCalc() {
        return this.sentMessagesFreqCalc;
    }

    public MessageFrequencyCalculator getSentMessagesFreqCalc(ImcId16 id) {
        SystemImcMsgCommInfo commI = (SystemImcMsgCommInfo)this.getCommInfoById(id);
        return commI == null ? null : commI.getSentMessagesFreqCalc();
    }

    public MessageFrequencyCalculator getToSendMessagesFreqCalc() {
        return this.toSendMessagesFreqCalc;
    }

    public MessageFrequencyCalculator getToSendMessagesFreqCalc(ImcId16 id) {
        SystemImcMsgCommInfo commI = (SystemImcMsgCommInfo)this.getCommInfoById(id);
        return commI == null ? null : commI.getToSendMessagesFreqCalc();
    }

    @Override
    public boolean sendMessageToVehicle(IMCMessage message, VehicleType vehicle, String sendProperties) {
        return this.sendMessage(message, vehicle.getImcId(), sendProperties);
    }

    public boolean sendMessageToSystem(IMCMessage message, String systemName, MessageDeliveryListener listener) {
        return this.sendMessageToSystem(message, systemName, null, listener);
    }

    public boolean sendMessageToSystem(IMCMessage message, String systemName) {
        return this.sendMessageToSystem(message, systemName, null, null);
    }

    public boolean sendMessageToSystem(IMCMessage message, String systemName, String sendProperties, MessageDeliveryListener listener) {
        ImcSystem system = ImcSystemsHolder.lookupSystemByName(systemName);
        if (system != null) {
            return this.sendMessage(message, system.id, sendProperties, listener);
        }
        if (listener != null) {
            listener.deliveryUnreacheable(message);
        }
        return false;
    }

    public Future<SendResult> sendMessageReliably(IMCMessage message, String systemName) {
        final ResultWaiter waiter = new ResultWaiter(20000L);
        FutureTask<SendResult> result = new FutureTask<SendResult>((Callable)waiter){
            private long start;
            {
                super(x0);
                this.start = System.currentTimeMillis();
            }

            @Override
            public SendResult get() throws InterruptedException, ExecutionException {
                try {
                    return waiter.call();
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }

            @Override
            public SendResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                long end = this.start + unit.toMillis(timeout);
                while (System.currentTimeMillis() < end) {
                    if (waiter.result == null) {
                        Thread.sleep(100L);
                        continue;
                    }
                    try {
                        return waiter.call();
                    }
                    catch (Exception e) {
                        throw new ExecutionException(e);
                    }
                }
                throw new TimeoutException("Time out exceeded");
            }
        };
        this.sendMessageToSystem(message, systemName, TRANSPORT_TCP, waiter);
        return result;
    }

    @Override
    public boolean sendMessageToVehicle(IMCMessage message, String vehicleID, String sendProperties) {
        VehicleType vehicle = VehiclesHolder.getVehicleById(vehicleID);
        if (vehicle != null) {
            return this.sendMessage(message, vehicle.getImcId(), sendProperties);
        }
        return false;
    }

    public boolean sendReliablyBlocking(IMCMessage message, ImcId16 vehicleCommId, final MessageDeliveryListener listener) {
        final OperationResult ret2 = new OperationResult();
        boolean ret = this.sendMessage(message, vehicleCommId, TRANSPORT_TCP, new MessageDeliveryListener(){

            @Override
            public void deliveryUnreacheable(IMCMessage message) {
                if (listener != null) {
                    listener.deliveryUnreacheable(message);
                }
                ret2.result = false;
                ret2.finished = true;
            }

            @Override
            public void deliveryUncertain(IMCMessage message, Object msg) {
                if (listener != null) {
                    listener.deliveryUncertain(message, msg);
                }
                ret2.result = false;
                ret2.finished = true;
            }

            @Override
            public void deliveryTimeOut(IMCMessage message) {
                if (listener != null) {
                    listener.deliveryTimeOut(message);
                }
                ret2.result = false;
                ret2.finished = true;
            }

            @Override
            public void deliverySuccess(IMCMessage message) {
                if (listener != null) {
                    listener.deliverySuccess(message);
                }
                ret2.result = true;
                ret2.finished = true;
            }

            @Override
            public void deliveryError(IMCMessage message, Object error) {
                if (listener != null) {
                    listener.deliveryError(message, error);
                }
                ret2.result = false;
                ret2.finished = true;
            }
        });
        while (!ret2.finished) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return ret && ret2.result;
    }

    public boolean sendReliablyNonBlocking(IMCMessage message, ImcId16 vehicleCommId, MessageDeliveryListener listener) {
        return this.sendMessage(message, vehicleCommId, TRANSPORT_TCP, listener);
    }

    public boolean broadcastToCCUs(IMCMessage message) {
        ImcSystem[] ccus;
        for (ImcSystem ccu : ccus = ImcSystemsHolder.lookupActiveSystemByType(VehicleType.SystemTypeEnum.CCU)) {
            this.sendMessage(message, ccu.getId(), (String)null);
        }
        return ccus.length > 0;
    }

    public boolean sendMessage(IMCMessage message) {
        try {
            ImcId16 id = new ImcId16(message.getHeader().getValue("dst"));
            return this.sendMessage(message, id, (String)null);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return false;
        }
    }

    @Override
    public boolean sendMessage(IMCMessage message, ImcId16 vehicleCommId, String sendProperties) {
        return this.sendMessage(message, vehicleCommId, sendProperties, null);
    }

    public boolean sendMessage(IMCMessage message, ImcId16 systemCommId, String sendProperties, MessageDeliveryListener msgListener) {
        boolean sentResult;
        block33: {
            ImcSystem imcSystem;
            this.checkAndSetMessageSrcEntity(message);
            if (!this.isRunning()) {
                if (msgListener != null) {
                    msgListener.deliveryError(message, "Manager stopped!");
                }
                return false;
            }
            MessageDeliveryListener listener = this.wrapMessageDeliveryListenerForSentMessageCounter(systemCommId, msgListener);
            if (systemCommId == null) {
                System.err.println("systemCommId is null!");
                listener.deliveryError(message, new Exception("systemCommId is null!"));
                return false;
            }
            ImcSystem resSys = ImcSystemsHolder.lookupSystem(systemCommId);
            if (resSys != null && resSys.getAuthorityState() == ImcSystem.IMCAuthorityState.OFF) {
                String msg = systemCommId + " is with authority " + (Object)((Object)resSys.getAuthorityState()) + "!";
                listener.deliveryError(message, new Exception(msg));
                return false;
            }
            message.getHeader().setValue("src", (Object)this.localId.longValue());
            if (message.getHeader().getInteger("dst") == 65535) {
                message.getHeader().setValue("dst", (Object)systemCommId.longValue());
            }
            message.setTimestamp((double)System.currentTimeMillis() / 1000.0);
            if (sendProperties != null && (StringUtils.isTokenInList(sendProperties, "Multicast") || StringUtils.isTokenInList(sendProperties, "Broadcast"))) {
                boolean sentResult2;
                block32: {
                    block31: {
                        sentResult2 = true;
                        if (StringUtils.isTokenInList(sendProperties, "Multicast")) {
                            try {
                                for (int port : this.multicastPorts) {
                                    this.markMessageToSent(systemCommId);
                                    sentResult2 = this.multicastUdpTransport.sendMessage(this.multicastAddress, port, message, listener);
                                }
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                                sentResult2 = false;
                                if (listener == null) break block31;
                                listener.deliveryUncertain(message, new Exception("Multicast or broadcast used!"));
                            }
                        }
                    }
                    if (StringUtils.isTokenInList(sendProperties, "Broadcast")) {
                        try {
                            Vector<NetworkInterfacesUtil.NInterface> vecList = this.getNetworkInterfaces();
                            for (int port : this.multicastPorts) {
                                for (NetworkInterfacesUtil.NInterface nii : vecList) {
                                    if (!nii.supportsBroadcast()) continue;
                                    for (Inet4Address i4a : nii.getBroadcastAddress()) {
                                        if (i4a == null) continue;
                                        this.markMessageToSent(systemCommId);
                                        sentResult2 = this.multicastUdpTransport.sendMessage(i4a.getHostAddress(), port, message, listener);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)(ImcMsgManager.class.getName() + ": " + e), (Throwable)e);
                            sentResult2 = false;
                            if (listener == null) break block32;
                            listener.deliveryUncertain(message, new Exception("Multicast or broadcast used!"));
                        }
                    }
                }
                if (sentResult2) {
                    this.logMessage(message);
                }
                return sentResult2;
            }
            ArrayList<TransportPreference> transportChoiceToSend = new ArrayList<TransportPreference>(this.transportPreferenceToUse);
            TransportPreference transportPreferenceRequested = TransportPreference.ANY;
            if (sendProperties != null && StringUtils.isTokenInList(sendProperties, TRANSPORT_UDP)) {
                transportPreferenceRequested = TransportPreference.UDP;
            } else if (sendProperties != null && StringUtils.isTokenInList(sendProperties, TRANSPORT_TCP)) {
                transportPreferenceRequested = TransportPreference.TCP;
            }
            ImcId16 sysId = systemCommId;
            SystemImcMsgCommInfo sysComm = (SystemImcMsgCommInfo)this.commInfo.get(sysId);
            if (VehiclesHolder.getVehicleWithImc(sysId) != null) {
                this.initSystemCommInfo(sysId, "");
            }
            if (!(imcSystem = ImcSystemsHolder.lookupSystem(systemCommId)).isUDPOn() && transportChoiceToSend.contains((Object)TransportPreference.UDP)) {
                transportChoiceToSend.remove((Object)TransportPreference.UDP);
            }
            if (!imcSystem.isTCPOn() && transportChoiceToSend.contains((Object)TransportPreference.TCP)) {
                transportChoiceToSend.remove((Object)TransportPreference.TCP);
            }
            if (transportPreferenceRequested != TransportPreference.ANY && transportChoiceToSend.contains((Object)transportPreferenceRequested)) {
                transportChoiceToSend.remove((Object)transportPreferenceRequested);
                transportChoiceToSend.add(0, transportPreferenceRequested);
            }
            sentResult = true;
            try {
                if (transportChoiceToSend.isEmpty()) {
                    throw new IOException(I18n.textf("No transport available to send message %message to %system.", message.getAbbrev(), imcSystem.getName()));
                }
                this.markMessageToSent(systemCommId);
                for (TransportPreference transport : transportChoiceToSend) {
                    boolean ret;
                    if (transport == TransportPreference.UDP) {
                        ret = this.getUdpTransport().sendMessage(imcSystem.getHostAddress(), imcSystem.getRemoteUDPPort(), message.cloneMessage(), listener);
                        boolean bl = sentResult = sentResult && ret;
                        if (!ret) continue;
                    } else {
                        if (transport != TransportPreference.TCP) continue;
                        ret = this.getTcpTransport().sendMessage(imcSystem.getHostAddress(), imcSystem.getRemoteTCPPort(), message.cloneMessage(), listener);
                        boolean bl = sentResult = sentResult && ret;
                        if (!ret) continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)(this.getClass().getSimpleName() + ": Error sending message!"), (Throwable)e);
                if (listener == null) break block33;
                listener.deliveryError(message, e);
            }
        }
        if (sentResult) {
            this.logMessage(message);
        }
        return sentResult;
    }

    public static void disseminate(XmlOutputMethods object, String rootElementName) {
        IMCMessage msg = IMCDefinition.getInstance().create("mission_chunk", new Object[]{"xml_data", object.asXML(rootElementName)});
        ImcMsgManager.disseminateToCCUs(msg);
    }

    private static void disseminateToCCUs(IMCMessage msg) {
        ImcSystem[] systems;
        if (msg == null) {
            return;
        }
        for (ImcSystem s : systems = ImcSystemsHolder.lookupActiveSystemCCUs()) {
            NeptusLog.pub().info((Object)("<###>sending msg '" + msg.getAbbrev() + "' to '" + s.getName() + "'..."));
            ImcMsgManager.getManager().sendMessage(msg, s.getId(), (String)null);
        }
    }

    private void checkAndSetMessageSrcEntity(IMCMessage message) {
        String caller;
        if ((message.getSrcEnt() == 0 || message.getSrcEnt() == 255) && (caller = this.getCallerClass()) != null) {
            if (!this.neptusEntities.containsKey(caller)) {
                this.lastEntityId = (short)(this.lastEntityId + 1);
                this.neptusEntities.put(caller, this.lastEntityId);
                EntityInfo info = new EntityInfo();
                info.setId(this.lastEntityId);
                info.setComponent(caller);
                try {
                    caller = PluginUtils.getPluginName(Class.forName(caller));
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e.getMessage());
                }
                info.setLabel(caller);
                info.setSrcEnt(0);
                info.setSrc(this.getLocalId().intValue());
                LsfMessageLogger.log((IMCMessage)info);
            }
            if (this.neptusEntities.get(caller) != null) {
                message.setSrcEnt((int)this.neptusEntities.get(caller).shortValue());
            }
        }
    }

    protected String getCallerClass() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        String classname = null;
        for (int i = 0; i < trace.length; ++i) {
            if (this.ignoredClasses.contains(trace[i].getClassName())) continue;
            classname = trace[i].getClassName();
            if (!classname.contains("$")) break;
            classname = classname.substring(0, classname.indexOf("$"));
            break;
        }
        return classname;
    }

    private MessageDeliveryListener wrapMessageDeliveryListenerForSentMessageCounter(final ImcId16 systemCommId, final MessageDeliveryListener listenerToWrap) {
        MessageDeliveryListener msgLstnr = new MessageDeliveryListener(){

            @Override
            public void deliveryError(IMCMessage message, Object error) {
                if (listenerToWrap != null) {
                    listenerToWrap.deliveryError(message, error);
                }
            }

            @Override
            public void deliveryUnreacheable(IMCMessage message) {
                if (listenerToWrap != null) {
                    listenerToWrap.deliveryUnreacheable(message);
                }
            }

            @Override
            public void deliveryTimeOut(IMCMessage message) {
                if (listenerToWrap != null) {
                    listenerToWrap.deliveryTimeOut(message);
                }
            }

            @Override
            public void deliveryUncertain(IMCMessage message, Object msg) {
                if (listenerToWrap != null) {
                    listenerToWrap.deliveryUncertain(message, msg);
                }
                ImcMsgManager.this.markMessageSent(systemCommId);
            }

            @Override
            public void deliverySuccess(IMCMessage message) {
                if (listenerToWrap != null) {
                    listenerToWrap.deliverySuccess(message);
                }
                ImcMsgManager.this.markMessageSent(systemCommId);
            }
        };
        return msgLstnr;
    }

    private void markMessageSent(ImcId16 systemCommId) {
        this.sentMessagesFreqCalc.setTimeMillisLastMsg(System.currentTimeMillis());
        MessageFrequencyCalculator mfc = this.getSentMessagesFreqCalc(systemCommId);
        if (mfc != null) {
            mfc.setTimeMillisLastMsg(System.currentTimeMillis());
        }
    }

    private void markMessageToSent(ImcId16 systemCommId) {
        this.toSendMessagesFreqCalc.setTimeMillisLastMsg(System.currentTimeMillis());
        MessageFrequencyCalculator mfc = this.getToSendMessagesFreqCalc(systemCommId);
        if (mfc != null) {
            mfc.setTimeMillisLastMsg(System.currentTimeMillis());
        }
    }

    private void logMessage(IMCMessage message) {
        if (this.logSentMsg) {
            try {
                LsfMessageLogger.log((IMCMessage)message);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("Error logging message " + message.getMessageType().getShortName() + "!"), (Throwable)e);
            }
        }
    }

    public boolean registerEntity() {
        String caller = this.getCallerClass();
        if (caller != null && !this.neptusEntities.containsKey(caller)) {
            this.lastEntityId = (short)(this.lastEntityId + 1);
            this.neptusEntities.put(caller, this.lastEntityId);
            return true;
        }
        return false;
    }

    @Override
    public boolean addListener(MessageListener<MessageInfo, IMCMessage> listener, String vehicleId) {
        return this.addListener(listener, vehicleId, (MessageFilter<MessageInfo, IMCMessage>)null);
    }

    @Override
    public boolean addListener(MessageListener<MessageInfo, IMCMessage> listener, String systemId, MessageFilter<MessageInfo, IMCMessage> filter) {
        ImcId16 imcId;
        VehicleType veh = VehiclesHolder.getVehicleById(systemId);
        if (veh == null) {
            ImcSystem sys = ImcSystemsHolder.lookupSystemByName(systemId);
            if (sys == null) {
                return false;
            }
            imcId = sys.getId();
        } else {
            imcId = veh.getImcId();
        }
        if (imcId == null) {
            return false;
        }
        return super.addListener(listener, imcId, filter);
    }

    @Override
    public boolean removeListener(MessageListener<MessageInfo, IMCMessage> listener, String systemId) {
        ImcId16 imcId;
        VehicleType veh = VehiclesHolder.getVehicleById(systemId);
        if (veh == null) {
            ImcSystem sys = ImcSystemsHolder.lookupSystemByName(systemId);
            if (sys == null) {
                return false;
            }
            imcId = sys.getId();
        } else {
            imcId = veh.getImcId();
        }
        if (imcId == null) {
            return false;
        }
        return super.removeListener(listener, imcId);
    }

    public ImcSysState getState(ImcId16 id) {
        if (super.getCommInfoById(id) != null) {
            return ((SystemImcMsgCommInfo)super.getCommInfoById(id)).getImcState();
        }
        return new ImcSysState();
    }

    public ImcSysState getState(VehicleType vehicle) {
        if (vehicle != null) {
            return this.getState(vehicle.getImcId());
        }
        return new ImcSysState();
    }

    public ImcSysState getState(String vehicle) {
        VehicleType vt = VehiclesHolder.getVehicleById(vehicle);
        if (vt != null) {
            return this.getState(vt);
        }
        int imc_id = this.imcDefinition.getResolver().resolve(vehicle);
        return this.getState(new ImcId16(imc_id));
    }

    @Override
    public SystemImcMsgCommInfo getCommInfoById(String vehicleId) {
        ImcId16 imcId;
        VehicleType veh = VehiclesHolder.getVehicleById(vehicleId);
        if (veh == null) {
            ImcSystem sys = ImcSystemsHolder.lookupSystemByName(vehicleId);
            if (sys == null) {
                return null;
            }
            imcId = sys.getId();
        } else {
            imcId = veh.getImcId();
        }
        if (imcId == null) {
            return null;
        }
        return (SystemImcMsgCommInfo)super.getCommInfoById(imcId);
    }

    public ImcId16 getLocalId() {
        return this.localId;
    }

    public String getCommStatusAsHtmlFragment() {
        String ret = "";
        ret = ret + "<b>" + (this.isRunning() ? "On" : "Off") + "</b><br>";
        ret = ret + "<b>UDP: </b>" + (this.udpTransport == null ? "Off" : (!this.udpTransport.isOnBindError() ? "OK" : "BIND ERROR") + " " + (this.udpTransport.isRunnning() ? "On" : "Off") + " @" + this.udpTransport.getBindPort()) + "<br>";
        ret = ret + "<b>Multicast UDP: </b>" + (this.multicastUdpTransport == null ? "Off" : (!this.multicastUdpTransport.isOnBindError() ? "OK" : "BIND ERROR") + " " + (this.multicastUdpTransport.isRunnning() ? "On" : "Off") + " @" + this.multicastUdpTransport.getMulticastAddress() + ":" + this.multicastUdpTransport.getBindPort()) + "<br>";
        long nc = this.getTcpTransport() != null ? this.getTcpTransport().getActiveNumberOfConnections() : 0L;
        ret = ret + "<b>TCP: </b>" + (this.tcpTransport == null ? "Off" : (!this.tcpTransport.isOnBindError() ? "OK" : "BIND ERROR") + " " + (this.tcpTransport.isRunning() ? (this.tcpTransport.isRunningNormally() ? "On" : "On:Error") : "Off") + " @" + this.tcpTransport.getBindPort() + (this.tcpTransport.isRunning() ? " (" + nc + " connection" + (nc == 1L ? "" : "s") + ")" : "")) + "<br>";
        return ret;
    }

    private final AsyncEventBus getMessageBus() {
        return this.bus;
    }

    public final ImcSysState getImcState() {
        return this.imcState;
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        VehiclesHolder.loadVehicles();
        ImcMsgManager.getManager().start();
        GuiUtils.setLookAndFeel();
        JFrame frame = GuiUtils.testFrame(new MonitorIMCComms(ImcMsgManager.getManager()), "Monitor IMC Comms");
        frame.setIconImage(MonitorIMCComms.ICON_ON.getImage());
        frame.setSize(396, 466);
        ImcSystem lsys = new ImcSystem(new ImcId16(19733L));
        lsys.setCommsInfo(ImcSystem.createCommMean("127.0.0.1", 6002, 6002, new ImcId16(19733L), true, true));
        ImcSystemsHolder.registerSystem(lsys);
        int portServer = 6002;
        ImcTcpTransport tcpT = new ImcTcpTransport(portServer, IMCDefinition.getInstance());
        tcpT.addListener(new MessageListener<MessageInfo, IMCMessage>(){

            public void onMessage(MessageInfo info, IMCMessage msg) {
                info.dump(System.out);
                msg.dump((OutputStream)System.out);
                System.out.flush();
            }
        });
        int i = 0;
        while (true) {
            System.err.println("HB " + i);
            boolean ret = ImcMsgManager.getManager().sendReliablyBlocking(IMCDefinition.getInstance().create("Heartbeat", new Object[0]), new ImcId16(19733L), new MessageDeliveryListener(){

                @Override
                public void deliveryUnreacheable(IMCMessage message) {
                    System.err.println("deliveryUnreacheable");
                }

                @Override
                public void deliveryUncertain(IMCMessage message, Object msg) {
                    System.err.println("deliveryUncertain  " + msg);
                }

                @Override
                public void deliveryTimeOut(IMCMessage message) {
                    System.err.println("deliveryTimeOut");
                }

                @Override
                public void deliverySuccess(IMCMessage message) {
                    System.err.println("deliverySuccess");
                }

                @Override
                public void deliveryError(IMCMessage message, Object error) {
                    System.err.println("deliveryError  " + error);
                }
            });
            System.err.println(ret);
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    static class ResultWaiter
    implements Callable<SendResult>,
    MessageDeliveryListener {
        public SendResult result = null;
        private long timeoutMillis = 10000L;
        private long start;

        public ResultWaiter(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            this.start = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SendResult call() throws Exception {
            while (true) {
                ResultWaiter resultWaiter = this;
                synchronized (resultWaiter) {
                    if (this.result != null) {
                        return this.result;
                    }
                    if (System.currentTimeMillis() - this.start > this.timeoutMillis) {
                        return SendResult.TIMEOUT;
                    }
                }
                Thread.sleep(100L);
            }
        }

        @Override
        public void deliveryError(IMCMessage message, Object error) {
            this.result = SendResult.ERROR;
        }

        @Override
        public void deliverySuccess(IMCMessage message) {
            this.result = SendResult.SUCCESS;
        }

        @Override
        public void deliveryTimeOut(IMCMessage message) {
            this.result = SendResult.TIMEOUT;
        }

        @Override
        public void deliveryUncertain(IMCMessage message, Object msg) {
            this.result = SendResult.UNCERTAIN_DELIVERY;
        }

        @Override
        public void deliveryUnreacheable(IMCMessage message) {
            this.result = SendResult.UNREACHABLE;
        }
    }

    private static final class OperationResult {
        boolean finished = false;
        boolean result = false;

        private OperationResult() {
        }
    }

    public static enum SendResult {
        SUCCESS,
        ERROR,
        TIMEOUT,
        UNREACHABLE,
        UNCERTAIN_DELIVERY;

    }

    private static enum TransportPreference {
        ANY,
        UDP,
        TCP;

    }
}

