/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager.imc;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.CommUtil;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.console.plugins.planning.plandb.PlanDBControl;
import pt.lsts.neptus.types.comm.CommMean;
import pt.lsts.neptus.types.comm.protocol.IMCArgs;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;

public class ImcSystem
implements Comparable<ImcSystem> {
    private static final int TIMEOUT_FOR_NOT_ANNOUNCE_STATE = 12000;
    public static final String GROUND_SPEED_KEY = "Ground Speed";
    public static final String VERTICAL_SPEED_KEY = "Vertical Speed";
    public static final String TRUE_SPEED_KEY = "True Speed";
    public static final String INDICATED_SPEED_KEY = "Indicate Speed";
    public static final String RPM_MAP_ENTITY_KEY = "RPM";
    public static final String COURSE_KEY = "Course";
    public static final String HEADING_KEY = "Heading";
    public static final String FUEL_LEVEL_KEY = "Fuel Level";
    public static final String WEB_UPDATED_KEY = "Web Updated";
    public static final String LBL_CONFIG_KEY = "LblConfig";
    public static final String ACOUSTIC_SYSTEMS = "AcousticSystems";
    public static final String ENTITY_PARAMETERS = "EntityParameters";
    protected String name = ImcId16.NULL_ID.toString();
    protected ImcId16 id = ImcId16.NULL_ID;
    protected VehicleType.SystemTypeEnum type = VehicleType.SystemTypeEnum.UNKNOWN;
    protected VehicleType.VehicleTypeEnum typeVehicle = VehicleType.VehicleTypeEnum.UNKNOWN;
    protected CommMean commsInfo = null;
    protected boolean active = false;
    protected PlanType activePlan = null;
    protected final CoordinateSystem location = new CoordinateSystem();
    protected long locationTimeMillis = -1L;
    protected long attitudeTimeMillis = -1L;
    protected String emergencyPlanId = "";
    protected String emergencyStatusStr = "";
    private InetSocketAddress inetSocketAddress = null;
    private String servicesProvided = "";
    protected boolean onErrorState = false;
    protected String onErrorStateStr = "";
    protected long lastErrorStateReceived = -1L;
    protected boolean onIdErrorState = false;
    protected long lastIdErrorStateReceived = -1L;
    protected String lastUid = null;
    protected boolean onAnnounceState = false;
    protected long lastAnnounceStateReceived = -1L;
    protected final PlanDBControl planDBControl = new PlanDBControl();
    private final Map<String, Object> dataStorage = Collections.synchronizedMap(new HashMap());
    private final Map<String, Long> dataStorageTime = Collections.synchronizedMap(new HashMap());
    protected IMCAuthorityState authorityState = IMCAuthorityState.NONE;

    public ImcSystem(VehicleType vehicle) {
        this.setType(VehicleType.SystemTypeEnum.VEHICLE);
        this.setName(vehicle.getId());
        ImcId16 tmpId = vehicle.getImcId();
        this.setId(tmpId == null ? ImcId16.NULL_ID : tmpId);
        CommMean commMean = CommUtil.getActiveCommMeanForProtocol(vehicle, "imc");
        this.setCommsInfo(commMean == null ? null : commMean);
    }

    public ImcSystem(ImcId16 id) {
        this(id == null ? ImcId16.NULL_ID.toString() : id.toString(), id);
    }

    public ImcSystem(String name, ImcId16 id) {
        this.setType(VehicleType.SystemTypeEnum.UNKNOWN);
        this.setName(name);
        this.setId(id == null ? ImcId16.NULL_ID : id);
    }

    public ImcSystem(ImcId16 id, CommMean commMean) {
        this(id);
        this.setCommsInfo(commMean == null ? null : commMean);
    }

    public ImcSystem(String name, ImcId16 id, CommMean commMean) {
        this(name, id);
        this.setCommsInfo(commMean == null ? null : commMean);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.planDBControl.setRemoteSystemId(this.name);
    }

    public ImcId16 getId() {
        return this.id;
    }

    public void setId(ImcId16 id) {
        this.id = id;
    }

    public LocationType getLocation() {
        return this.location.getNewAbsoluteLatLonDepth();
    }

    public void setLocation(LocationType location) {
        this.location.setLocation(location);
        this.location.convertToAbsoluteLatLonDepth();
        this.setLocationTimeMillis(System.currentTimeMillis());
    }

    public void setLocation(LocationType location, long locationTimeMillis) {
        this.location.setLocation(location);
        this.location.convertToAbsoluteLatLonDepth();
        this.setLocationTimeMillis(locationTimeMillis);
    }

    public void setAttitudeDegrees(double rollDegrees, double pitchDegrees, double yawDegrees) {
        this.location.setRoll(rollDegrees);
        this.location.setPitch(pitchDegrees);
        this.location.setYaw(yawDegrees);
        this.setAttitudeTimeMillis(System.currentTimeMillis());
    }

    public void setAttitudeDegrees(double rollDegrees, double pitchDegrees, double yawDegrees, long locationTimeMillis) {
        this.location.setRoll(rollDegrees);
        this.location.setPitch(pitchDegrees);
        this.location.setYaw(yawDegrees);
        this.setAttitudeTimeMillis(locationTimeMillis);
    }

    public void setAttitudeDegrees(double yawDegrees) {
        this.location.setRoll(0.0);
        this.location.setPitch(0.0);
        this.location.setYaw(yawDegrees);
        this.setAttitudeTimeMillis(System.currentTimeMillis());
    }

    public void setAttitudeDegrees(double yawDegrees, long locationTimeMillis) {
        this.location.setRoll(0.0);
        this.location.setPitch(0.0);
        this.location.setYaw(yawDegrees);
        this.setAttitudeTimeMillis(locationTimeMillis);
    }

    public double getRollDegrees() {
        return this.location.getRoll();
    }

    public double getPitchDegrees() {
        return this.location.getPitch();
    }

    public double getYawDegrees() {
        return this.location.getYaw();
    }

    public long getLocationTimeMillis() {
        return this.locationTimeMillis;
    }

    public void setLocationTimeMillis(long locationTimeMillis) {
        this.locationTimeMillis = locationTimeMillis;
    }

    public long getAttitudeTimeMillis() {
        return this.attitudeTimeMillis;
    }

    public void setAttitudeTimeMillis(long attitudeTimeMillis) {
        this.attitudeTimeMillis = attitudeTimeMillis;
    }

    public VehicleType.SystemTypeEnum getType() {
        return this.type;
    }

    public void setType(VehicleType.SystemTypeEnum type) {
        this.type = type;
    }

    public VehicleType.VehicleTypeEnum getTypeVehicle() {
        return this.typeVehicle;
    }

    public void setTypeVehicle(VehicleType.VehicleTypeEnum typeVehicle) {
        this.typeVehicle = typeVehicle;
    }

    public VehicleType getVehicle() {
        if (this.type == VehicleType.SystemTypeEnum.VEHICLE) {
            return VehiclesHolder.getVehicleWithImc(this.getId());
        }
        return null;
    }

    public PlanDBControl getPlanDBControl() {
        return this.planDBControl;
    }

    public boolean isWithAuthority() {
        return this.authorityState != IMCAuthorityState.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMCAuthorityState getAuthorityState() {
        IMCAuthorityState iMCAuthorityState = this.authorityState;
        synchronized (iMCAuthorityState) {
            return this.authorityState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthorityState(IMCAuthorityState authorityState) {
        IMCAuthorityState iMCAuthorityState = authorityState;
        synchronized (iMCAuthorityState) {
            this.authorityState = authorityState;
        }
    }

    public CommMean getCommsInfo() {
        return this.commsInfo;
    }

    public void setCommsInfo(CommMean commsInfo) {
        this.commsInfo = commsInfo;
    }

    public String getHostAddress() {
        if (this.getCommsInfo() == null) {
            return null;
        }
        return this.getCommsInfo().getHostAddress();
    }

    public boolean setHostAddress(String hostAddress) {
        if (this.getCommsInfo() == null) {
            return false;
        }
        try {
            this.getCommsInfo().setHostAddress(hostAddress);
            return true;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(this.getClass().getSimpleName() + ":" + this.getId() + ": " + e.getMessage()));
            return false;
        }
    }

    public boolean isUDPOn() {
        if (this.getCommsInfo() == null) {
            return false;
        }
        try {
            return ((IMCArgs)this.getCommsInfo().getProtocolsArgs().get("imc")).isUdpOn();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(this.getClass().getSimpleName() + ":" + this.getId() + ": " + e.getMessage()));
            return false;
        }
    }

    public boolean setUDPOn(boolean on) {
        if (this.getCommsInfo() == null) {
            return false;
        }
        try {
            ((IMCArgs)this.getCommsInfo().getProtocolsArgs().get("imc")).setUdpOn(on);
            return true;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(this.getClass().getSimpleName() + ":" + this.getId() + ": " + e.getMessage()));
            return false;
        }
    }

    public boolean isTCPOn() {
        if (this.getCommsInfo() == null) {
            return false;
        }
        try {
            return ((IMCArgs)this.getCommsInfo().getProtocolsArgs().get("imc")).isTcpOn();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(this.getClass().getSimpleName() + ":" + this.getId() + ": " + e.getMessage()));
            return false;
        }
    }

    public boolean setTCPOn(boolean on) {
        if (this.getCommsInfo() == null) {
            return false;
        }
        try {
            ((IMCArgs)this.getCommsInfo().getProtocolsArgs().get("imc")).setTcpOn(on);
            return true;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(this.getClass().getSimpleName() + ":" + this.getId() + ": " + e.getMessage()));
            return false;
        }
    }

    public int getRemoteUDPPort() {
        if (this.getCommsInfo() == null) {
            return 0;
        }
        try {
            int remoteport = ((IMCArgs)this.getCommsInfo().getProtocolsArgs().get("imc")).getPort();
            return remoteport;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(this.getClass().getSimpleName() + ":" + this.getId() + ": " + e.getMessage()));
            return 0;
        }
    }

    public boolean setRemoteUDPPort(int port) {
        if (this.getCommsInfo() == null) {
            return false;
        }
        try {
            ((IMCArgs)this.getCommsInfo().getProtocolsArgs().get("imc")).setPort(port);
            return true;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(this.getClass().getSimpleName() + ":" + this.getId() + ": " + e.getMessage()));
            return false;
        }
    }

    public int getRemoteTCPPort() {
        if (this.getCommsInfo() == null) {
            return 0;
        }
        try {
            int remoteport = ((IMCArgs)this.getCommsInfo().getProtocolsArgs().get("imc")).getPortTCP();
            return remoteport;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(this.getClass().getSimpleName() + ":" + this.getId() + ": " + e.getMessage()));
            return 0;
        }
    }

    public boolean setRemoteTCPPort(int port) {
        if (this.getCommsInfo() == null) {
            return false;
        }
        try {
            ((IMCArgs)this.getCommsInfo().getProtocolsArgs().get("imc")).setPortTCP(port);
            return true;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(this.getClass().getSimpleName() + ":" + this.getId() + ": " + e.getMessage()));
            return false;
        }
    }

    public InetSocketAddress getInetSocketAddress() {
        if (this.getHostAddress() == null || this.getRemoteUDPPort() == 0) {
            return null;
        }
        if ((this.getHostAddress().equals(this.inetSocketAddress.getHostName()) || this.getHostAddress().equals(this.inetSocketAddress.getAddress())) && this.getRemoteUDPPort() == this.inetSocketAddress.getPort()) {
            return this.inetSocketAddress;
        }
        return new InetSocketAddress(this.getHostAddress(), this.getRemoteUDPPort());
    }

    public String toString() {
        return this.getName();
    }

    public static CommMean createCommMean(String hostAddress, int port, int portTCP, ImcId16 imcId, boolean udpOn, boolean tcpOn) {
        CommMean cm = new CommMean();
        cm.setName("ethernet");
        cm.setType("ethernet");
        cm.setActive(true);
        cm.setHostAddress(hostAddress);
        cm.getProtocols().add("imc");
        IMCArgs nArgs = new IMCArgs();
        nArgs.setPort(port);
        nArgs.setPortTCP(portTCP);
        nArgs.setImc3Id(imcId);
        nArgs.setUdpOn(udpOn);
        nArgs.setTcpOn(tcpOn);
        cm.getProtocolsArgs().put("imc", nArgs);
        return cm;
    }

    public static InetSocketAddress parseInetSocketAddress(String inetSocketAddress) {
        String[] lstr = inetSocketAddress.split(":");
        if (lstr.length != 2) {
            return null;
        }
        try {
            int port = Integer.parseInt(lstr[1]);
            return new InetSocketAddress(lstr[0], port);
        }
        catch (NumberFormatException e) {
            NeptusLog.pub().error((Object)e.getMessage());
            return null;
        }
    }

    @Override
    public int compareTo(ImcSystem o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public PlanType getActivePlan() {
        return this.activePlan;
    }

    public void setActivePlan(PlanType activePlan) {
        this.activePlan = activePlan;
    }

    public String getEmergencyPlanId() {
        return this.emergencyPlanId;
    }

    public void setEmergencyPlanId(String emergencyPlanId) {
        this.emergencyPlanId = emergencyPlanId;
    }

    public String getEmergencyStatusStr() {
        return this.emergencyStatusStr;
    }

    public void setEmergencyStatusStr(String emergencyStatusStr) {
        this.emergencyStatusStr = emergencyStatusStr;
    }

    public String getServicesProvided() {
        return this.servicesProvided;
    }

    public void setServicesProvided(String servicesProvided) {
        this.servicesProvided = servicesProvided;
    }

    public boolean isServiceProvided(String name) {
        return IMCUtils.isServiceProvided(this.servicesProvided, "*", name);
    }

    public boolean isServiceProvided(String scheme, String name) {
        return IMCUtils.isServiceProvided(this.servicesProvided, scheme, name);
    }

    public Vector<URI> getServiceProvided(String name) {
        return IMCUtils.getServiceProvided(this.servicesProvided, "*", name);
    }

    public Vector<URI> getServiceProvided(String scheme, String name) {
        return IMCUtils.getServiceProvided(this.servicesProvided, scheme, name);
    }

    public boolean isOnErrorState() {
        return this.onErrorState;
    }

    public void setOnErrorState(boolean onErrorState) {
        this.onErrorState = onErrorState;
        this.setLastErrorStateReceived(System.currentTimeMillis());
    }

    public String getOnErrorStateStr() {
        return this.onErrorStateStr;
    }

    public void setOnErrorStateStr(String onErrorStateStr) {
        this.onErrorStateStr = onErrorStateStr;
    }

    public long getLastErrorStateReceived() {
        return this.lastErrorStateReceived;
    }

    private void setLastErrorStateReceived(long lastErrorStateReceived) {
        this.lastErrorStateReceived = lastErrorStateReceived;
    }

    public boolean isOnIdErrorState() {
        return this.onIdErrorState;
    }

    public void setOnIdErrorState(boolean onIdErrorState) {
        this.onIdErrorState = onIdErrorState;
        this.setLastIdErrorStateReceived(System.currentTimeMillis());
    }

    public long getLastIdErrorStateReceived() {
        return this.lastIdErrorStateReceived;
    }

    private void setLastIdErrorStateReceived(long lastIdErrorStateReceived) {
        this.lastIdErrorStateReceived = lastIdErrorStateReceived;
    }

    public String getLastUid() {
        return this.lastUid;
    }

    public void setLastUid(String lastUid) {
        this.lastUid = lastUid;
    }

    public boolean isOnAnnounceState() {
        if (this.onAnnounceState && System.currentTimeMillis() - this.getLastAnnounceStateReceived() >= 12000L) {
            this.onAnnounceState = false;
        }
        return this.onAnnounceState;
    }

    public void setOnAnnounceState(boolean onAnnounceState) {
        this.onAnnounceState = onAnnounceState;
        this.setLastAnnounceStateReceived(System.currentTimeMillis());
    }

    public long getLastAnnounceStateReceived() {
        return this.lastAnnounceStateReceived;
    }

    public void setLastAnnounceStateReceived(long lastAnnounceStateReceived) {
        this.lastAnnounceStateReceived = lastAnnounceStateReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getDataStorageKeys() {
        Map<String, Object> map = this.dataStorage;
        synchronized (map) {
            return Arrays.asList(this.dataStorage.keySet().toArray(new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsData(String key) {
        Map<String, Object> map = this.dataStorage;
        synchronized (map) {
            return this.dataStorage.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsData(String key, long ageMillis) {
        Map<String, Object> map = this.dataStorage;
        synchronized (map) {
            boolean ret = this.dataStorage.containsKey(key);
            if (ret && ageMillis > 0L) {
                long time = this.dataStorageTime.get(key);
                if (System.currentTimeMillis() - time > ageMillis) {
                    return false;
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object retrieveData(String key) {
        Object ret = null;
        Map<String, Object> map = this.dataStorage;
        synchronized (map) {
            ret = this.dataStorage.get(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long retrieveDataTimeMillis(String key) {
        long ret = -1L;
        Map<String, Object> map = this.dataStorage;
        synchronized (map) {
            ret = this.dataStorage.containsKey(key) ? (this.dataStorageTime.containsKey(key) ? this.dataStorageTime.get(key) : -1L) : -1L;
        }
        return ret;
    }

    public boolean storeData(String key, Object data) {
        return this.storeData(key, data, System.currentTimeMillis(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeData(String key, Object data, long timeMillis, boolean keepNewest) {
        Map<String, Object> map = this.dataStorage;
        synchronized (map) {
            if (keepNewest && this.dataStorage.containsKey(key) && this.dataStorageTime.containsKey(key) && this.dataStorageTime.get(key) > timeMillis) {
                return false;
            }
            this.dataStorage.put(key, data);
            this.dataStorageTime.put(key, timeMillis);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeData(String key) {
        Map<String, Object> map = this.dataStorage;
        synchronized (map) {
            if (this.dataStorage.containsKey(key)) {
                this.dataStorage.remove(key);
                this.dataStorageTime.remove(key);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSimulated() {
        Map<String, Object> map = this.dataStorage;
        synchronized (map) {
            return this.containsData("SimulatedState") && System.currentTimeMillis() - this.retrieveDataTimeMillis("SimulatedState") < 60000L;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStoredData() {
        Map<String, Object> map = this.dataStorage;
        synchronized (map) {
            this.dataStorage.clear();
            this.dataStorageTime.clear();
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static VehicleType.SystemTypeEnum translateSystemTypeFromMessage(String type) {
        if (type == null) {
            return VehicleType.SystemTypeEnum.UNKNOWN;
        }
        if ("CCU".equalsIgnoreCase(type.trim())) {
            return VehicleType.SystemTypeEnum.CCU;
        }
        if ("HUMANSENSOR".equalsIgnoreCase(type)) {
            return VehicleType.SystemTypeEnum.MOBILESENSOR;
        }
        if ("UUV".equalsIgnoreCase(type)) {
            return VehicleType.SystemTypeEnum.VEHICLE;
        }
        if ("AUV".equalsIgnoreCase(type)) {
            return VehicleType.SystemTypeEnum.VEHICLE;
        }
        if ("ROV".equalsIgnoreCase(type)) {
            return VehicleType.SystemTypeEnum.VEHICLE;
        }
        if ("USV".equalsIgnoreCase(type)) {
            return VehicleType.SystemTypeEnum.VEHICLE;
        }
        if ("ASV".equalsIgnoreCase(type)) {
            return VehicleType.SystemTypeEnum.VEHICLE;
        }
        if ("UAV".equalsIgnoreCase(type)) {
            return VehicleType.SystemTypeEnum.VEHICLE;
        }
        if ("UGV".equalsIgnoreCase(type)) {
            return VehicleType.SystemTypeEnum.VEHICLE;
        }
        if ("AGV".equalsIgnoreCase(type)) {
            return VehicleType.SystemTypeEnum.VEHICLE;
        }
        if ("STATICSENSOR".equalsIgnoreCase(type)) {
            return VehicleType.SystemTypeEnum.STATICSENSOR;
        }
        if ("MOBILESENSOR".equalsIgnoreCase(type)) {
            return VehicleType.SystemTypeEnum.MOBILESENSOR;
        }
        if ("WSN".equalsIgnoreCase(type)) {
            return VehicleType.SystemTypeEnum.STATICSENSOR;
        }
        return VehicleType.SystemTypeEnum.UNKNOWN;
    }

    public static VehicleType.VehicleTypeEnum translateVehicleTypeFromMessage(String type) {
        if (type == null) {
            return VehicleType.VehicleTypeEnum.UNKNOWN;
        }
        if ("UUV".equalsIgnoreCase(type)) {
            return VehicleType.VehicleTypeEnum.UUV;
        }
        if ("AUV".equalsIgnoreCase(type)) {
            return VehicleType.VehicleTypeEnum.UUV;
        }
        if ("ROV".equalsIgnoreCase(type)) {
            return VehicleType.VehicleTypeEnum.UUV;
        }
        if ("USV".equalsIgnoreCase(type)) {
            return VehicleType.VehicleTypeEnum.USV;
        }
        if ("ASV".equalsIgnoreCase(type)) {
            return VehicleType.VehicleTypeEnum.USV;
        }
        if ("UAV".equalsIgnoreCase(type)) {
            return VehicleType.VehicleTypeEnum.UAV;
        }
        if ("UGV".equalsIgnoreCase(type)) {
            return VehicleType.VehicleTypeEnum.UGV;
        }
        if ("AGV".equalsIgnoreCase(type)) {
            return VehicleType.VehicleTypeEnum.UGV;
        }
        return VehicleType.VehicleTypeEnum.UNKNOWN;
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)("<###> " + (Object)((Object)ImcSystem.translateSystemTypeFromMessage("CCU"))));
    }

    public static enum IMCAuthorityState {
        OFF,
        NONE,
        PAYLOAD_MONITOR,
        PAYLOAD,
        SYSTEM_MONITOR,
        SYSTEM_FULL;

    }
}

