/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager.imc;

import java.util.Hashtable;
import java.util.LinkedList;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.types.vehicle.VehicleType;

public class ImcSystemsHolder {
    private static Hashtable<ImcId16, ImcSystem> lookupTable = new Hashtable();
    private static Hashtable<String, ImcSystem> namesTable = new Hashtable();

    public static boolean registerSystem(ImcSystem system) {
        ImcSystem resLook = lookupTable.get(system.getId());
        if (resLook != null) {
            namesTable.put(system.getName(), system);
            return true;
        }
        lookupTable.put(system.getId(), system);
        namesTable.put(system.getName(), system);
        return true;
    }

    public static ImcSystem lookupSystem(ImcId16 id) {
        return id == null ? null : lookupTable.get(id);
    }

    public static ImcSystem lookupSystem(int imcid) {
        return ImcSystemsHolder.lookupSystem(new ImcId16(imcid));
    }

    public static ImcSystem getSystemWithName(String name) {
        return name == null ? null : namesTable.get(name);
    }

    public static ImcSystem lookupSystemByName(String name) {
        if (name == null) {
            return null;
        }
        if ("".equalsIgnoreCase(name)) {
            return null;
        }
        LinkedList<ImcSystem> list = new LinkedList<ImcSystem>();
        for (ImcSystem is : lookupTable.values()) {
            if (!name.equalsIgnoreCase(is.getName())) continue;
            list.add(is);
            break;
        }
        return list.isEmpty() ? null : (ImcSystem)list.getFirst();
    }

    public static final ImcSystem[] lookupSystemByType(VehicleType.SystemTypeEnum type, boolean onlyActiveSystems) {
        boolean allTypes = false;
        if (type == null) {
            allTypes = true;
        }
        LinkedList<ImcSystem> list = new LinkedList<ImcSystem>();
        for (ImcSystem is : lookupTable.values()) {
            if (!allTypes && type != VehicleType.SystemTypeEnum.ALL && type != is.getType() || onlyActiveSystems && !is.isActive()) continue;
            list.add(is);
        }
        return list.toArray(new ImcSystem[list.size()]);
    }

    public static final ImcSystem[] lookupAllSystems() {
        return ImcSystemsHolder.lookupSystemByType(null, false);
    }

    public static final ImcSystem[] lookupAllActiveSystems() {
        return ImcSystemsHolder.lookupSystemByType(null, true);
    }

    public static final ImcSystem[] lookupSystemByType(VehicleType.SystemTypeEnum type) {
        return ImcSystemsHolder.lookupSystemByType(type, false);
    }

    public static final ImcSystem[] lookupActiveSystemByType(VehicleType.SystemTypeEnum type) {
        return ImcSystemsHolder.lookupSystemByType(type, true);
    }

    public static final ImcSystem[] lookupSystemCCUs() {
        return ImcSystemsHolder.lookupSystemByType(VehicleType.SystemTypeEnum.CCU);
    }

    public static final ImcSystem[] lookupActiveSystemCCUs() {
        return ImcSystemsHolder.lookupSystemByType(VehicleType.SystemTypeEnum.CCU, true);
    }

    public static final ImcSystem[] lookupSystemVehicles() {
        return ImcSystemsHolder.lookupSystemByType(VehicleType.SystemTypeEnum.VEHICLE);
    }

    public static final ImcSystem[] lookupActiveSystemVehicles() {
        return ImcSystemsHolder.lookupSystemByType(VehicleType.SystemTypeEnum.VEHICLE, true);
    }

    public static final ImcSystem[] lookupSystemByService(String service, VehicleType.SystemTypeEnum type, boolean onlyActiveSystems) {
        boolean allTypes = false;
        if (type == null) {
            allTypes = true;
        }
        LinkedList<ImcSystem> list = new LinkedList<ImcSystem>();
        for (ImcSystem is : lookupTable.values()) {
            if (!allTypes && type != VehicleType.SystemTypeEnum.ALL && type != is.getType() || onlyActiveSystems && !is.isActive() || !is.isServiceProvided(service)) continue;
            list.add(is);
        }
        return list.toArray(new ImcSystem[list.size()]);
    }

    public static String translateImcIdToSystemName(long id) {
        return ImcSystemsHolder.translateImcIdToSystemName(new ImcId16(id));
    }

    public static String translateImcIdToSystemName(ImcId16 id) {
        ImcSystem sys = ImcSystemsHolder.lookupSystem(id);
        String ret = id.toPrettyString();
        if (sys != null) {
            ret = sys.getName();
        }
        return ret;
    }

    public static void main(String[] args) {
        ImcSystem imc1 = new ImcSystem(new ImcId16("22:10"));
        ImcSystem imc2 = new ImcSystem(new ImcId16("22:11"));
        ImcSystemsHolder.registerSystem(imc1);
        ImcSystemsHolder.registerSystem(imc2);
        NeptusLog.pub().info((Object)("<###> " + ImcSystemsHolder.lookupSystem(new ImcId16("22:10"))));
    }
}

