/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager.imc;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Window;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.plugins.PluginProperty;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class MessageEditorImc
implements PropertiesProvider {
    private IMCMessage message = null;
    private boolean editable = true;

    public MessageEditorImc(IMCMessage message) {
        this.setMessage(message);
    }

    public void setMessage(IMCMessage message) {
        this.message = message;
    }

    @Override
    public DefaultProperty[] getProperties() {
        Vector<PluginProperty> properties = IMCUtils.getProperties(this.message);
        return properties.toArray(new DefaultProperty[0]);
    }

    @Override
    public String getPropertiesDialogTitle() {
        return "Properties for " + this.message.getMessageType().getShortName() + " message, with ID " + this.message.getMessageType().getId();
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        Vector errors = new Vector();
        return errors.toArray(new String[0]);
    }

    @Override
    public void setProperties(Property[] properties) {
        IMCUtils.setProperties(properties, this.message);
    }

    public static boolean showProperties(IMCMessage message, boolean editable) {
        MessageEditorImc me = new MessageEditorImc(message);
        me.setEditable(editable);
        return PropertiesEditor.editProperties(me, true);
    }

    public static boolean showProperties(IMCMessage message, Window parent, boolean editable) {
        MessageEditorImc me = new MessageEditorImc(message);
        me.setEditable(editable);
        return PropertiesEditor.editProperties((PropertiesProvider)me, parent, true);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        JFrame frame = GuiUtils.testFrame(new JButton("teste"));
        frame.setSize(100, 100);
        IMCMessage msg = IMCDefinition.getInstance().create("PlanSpecification", new Object[0]);
        msg.dump((OutputStream)System.out);
        MessageEditorImc.showProperties(msg, frame, true);
        msg.dump((OutputStream)System.out);
    }
}

