/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager.imc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.gui.ImcStatePanel;
import pt.lsts.imc.state.ImcSysState;
import pt.lsts.imc.state.ImcSystemState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.BaseAbstractCommsMonitorPanel;
import pt.lsts.neptus.comm.manager.MessageFrequencyCalculator;
import pt.lsts.neptus.comm.manager.imc.EntitiesResolver;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMessageSenderPanel;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.comm.manager.imc.SystemImcMsgCommInfo;
import pt.lsts.neptus.console.plugins.SystemsList;
import pt.lsts.neptus.console.plugins.planning.plandb.PlanDBInfo;
import pt.lsts.neptus.gui.editor.ImcId16Editor;
import pt.lsts.neptus.gui.swing.JRoundButton;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.messages.MessageFilter;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.ByteUtil;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.StringUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class MonitorIMCComms
extends BaseAbstractCommsMonitorPanel<ImcMsgManager, SystemImcMsgCommInfo, IMCMessage, MessageInfo, ImcId16> {
    private static final long serialVersionUID = -7594653589671178640L;
    public static final ImageIcon ICON_ON = new ImageIcon(ImageUtils.getImage("images/imc.png").getScaledInstance(16, 16, 4));
    public static final ImageIcon ICON_OFF = new ImageIcon(ImageUtils.getImage("images/buttons/noimc.png").getScaledInstance(16, 16, 4));
    private JPanel addHolderSystemCommPanel = null;
    private JPanel addSystemCommPanel = null;
    private JPanel addNewSystemTextFieldPanel = null;
    private JRoundButton addNewSystemRoundButton = null;
    private ImcId16Editor imcId16Editor = null;
    private JPanel addVehicleCommPanel = null;
    private JTextField addNewVehTextField = null;
    private JRoundButton addNewVehRoundButton = null;
    private JPanel addConfigSystemPanel = null;
    private JPanel addImcLocalInfoPanel = null;
    private JLabel localInfoLabel = null;
    private JLabel configLabelTop = null;
    private JLabel configLabelMiddle = null;
    private JPanel configSystemControlPanel = null;
    private ImcSysState commonSystemState = null;
    private ImcStatePanel commonSystemStatePanel = null;
    private JPanel addCommonImcMsgPanel = null;
    private JLabel commonImcMsgInfoLabel = null;
    private JScrollPane commonImcMsgScrollPane = null;
    private ImcSysState selSystemState = null;
    private ImcStatePanel selSystemStatePanel = null;
    private JPanel addSystemImcMsgPanel = null;
    private JLabel systemImcMsgInfoLabel = null;
    private JScrollPane systemImcMsgScrollPane = null;
    private SystemsList systemsListPanel = null;
    private String imcCCUName;
    long time = -1L;

    public MonitorIMCComms(ImcMsgManager imcMsgManager) {
        super(imcMsgManager);
        this.initialize();
    }

    private void initialize() {
        this.addNewActivateCommPanel(this.getAddHolderSystemCommPanel());
        this.addMonitorTab(I18n.text("All Messages"), null, this.getAddCommonImcMsgPanel(), null);
        this.addMonitorTab(I18n.text("System Messages"), null, this.getAddSystemImcMsgPanel(), null);
        this.addMonitorTab(I18n.text("System Configurations"), null, this.getAddConfigSystemPanel(), null);
        this.addMonitorTab(I18n.text("Local Info"), null, this.getAddImcLocalInfoPanel(), null);
        this.addMonitorTab(I18n.text("Systems List"), null, this.getAddSystemsListPanel(), null);
        this.imcCCUName = StringUtils.toImcName(GeneralPreferences.imcCcuName);
    }

    private JPanel getAddCommonImcMsgPanel() {
        if (this.addCommonImcMsgPanel == null) {
            this.commonImcMsgInfoLabel = new JLabel();
            this.commonImcMsgInfoLabel.setText(I18n.text("All messages"));
            this.commonImcMsgInfoLabel.setHorizontalAlignment(0);
            this.addCommonImcMsgPanel = new JPanel();
            this.addCommonImcMsgPanel.setLayout(new BorderLayout());
            this.commonImcMsgScrollPane = new JScrollPane();
            this.addCommonImcMsgPanel.add((Component)this.commonImcMsgScrollPane, "Center");
            this.addCommonImcMsgPanel.add((Component)this.commonImcMsgInfoLabel, "North");
        }
        return this.addCommonImcMsgPanel;
    }

    private void updateCommonImcMsg() {
        ImcSysState st = ((ImcMsgManager)this.getCommManager()).getImcState();
        if (st != this.commonSystemState) {
            if (this.commonSystemState != null) {
                this.commonSystemState = null;
            }
            if (this.commonSystemStatePanel != null) {
                this.commonSystemStatePanel.cleanup();
                this.commonSystemStatePanel = null;
            }
            this.commonSystemState = st;
            this.commonSystemStatePanel = new ImcStatePanel((ImcSystemState)this.commonSystemState);
            this.commonImcMsgScrollPane.setViewportView((Component)this.commonSystemStatePanel);
        }
    }

    private JPanel getAddSystemImcMsgPanel() {
        if (this.addSystemImcMsgPanel == null) {
            this.systemImcMsgInfoLabel = new JLabel();
            this.systemImcMsgInfoLabel.setText(I18n.text("No system selected"));
            this.systemImcMsgInfoLabel.setHorizontalAlignment(0);
            this.addSystemImcMsgPanel = new JPanel();
            this.addSystemImcMsgPanel.setLayout(new BorderLayout());
            this.systemImcMsgScrollPane = new JScrollPane();
            this.addSystemImcMsgPanel.add((Component)this.systemImcMsgScrollPane, "Center");
            this.addSystemImcMsgPanel.add((Component)this.systemImcMsgInfoLabel, "North");
        }
        return this.addSystemImcMsgPanel;
    }

    private void updateSystemImcMsg() {
        ImcSysState st;
        if (this.selectedSystem == null) {
            return;
        }
        ImcId16 idImc = (ImcId16)this.selectedSystem;
        if (idImc == null) {
            this.systemImcMsgInfoLabel.setText(I18n.text("No system selected"));
            this.systemImcMsgScrollPane.setViewportView(new JLabel());
            if (this.selSystemState != null) {
                this.selSystemState = null;
            }
            if (this.selSystemStatePanel != null) {
                this.selSystemStatePanel.cleanup();
                this.selSystemStatePanel = null;
            }
            return;
        }
        this.systemImcMsgInfoLabel.setText(I18n.text("System") + ": " + this.translateSystemIdToName((ImcId16)this.selectedSystem) + " [" + this.translateIdToStringId((ImcId16)this.selectedSystem) + "]");
        SystemImcMsgCommInfo ci = (SystemImcMsgCommInfo)((ImcMsgManager)this.getCommManager()).getCommInfoById(idImc);
        if (ci != null && (st = ci.getImcState()) != this.selSystemState) {
            if (this.selSystemState != null) {
                this.selSystemState = null;
            }
            if (this.selSystemStatePanel != null) {
                this.selSystemStatePanel.cleanup();
                this.selSystemStatePanel = null;
            }
            this.selSystemState = st;
            this.selSystemStatePanel = new ImcStatePanel((ImcSystemState)this.selSystemState);
            this.systemImcMsgScrollPane.setViewportView((Component)this.selSystemStatePanel);
        }
    }

    private JPanel getAddImcLocalInfoPanel() {
        if (this.addImcLocalInfoPanel == null) {
            this.addImcLocalInfoPanel = new JPanel();
            this.addImcLocalInfoPanel.setLayout(new BorderLayout(20, 20));
            this.localInfoLabel = new JLabel();
            this.localInfoLabel.setVerticalAlignment(1);
            JScrollPane jsp = new JScrollPane(this.localInfoLabel, 20, 30);
            jsp.setBorder(null);
            this.addImcLocalInfoPanel.add(jsp);
            this.addImcLocalInfoPanel.add(Box.createHorizontalGlue(), "West");
            this.addImcLocalInfoPanel.add(Box.createHorizontalGlue(), "East");
            this.addImcLocalInfoPanel.add(Box.createVerticalGlue(), "North");
            this.addImcLocalInfoPanel.add(Box.createVerticalGlue(), "South");
        }
        return this.addImcLocalInfoPanel;
    }

    private JPanel getAddConfigSystemPanel() {
        if (this.addConfigSystemPanel == null) {
            this.addConfigSystemPanel = new JPanel();
            this.addConfigSystemPanel.setLayout(new BorderLayout(20, 20));
            this.configLabelTop = new JLabel();
            this.configLabelTop.setText(I18n.text("No system selected"));
            this.configLabelTop.setHorizontalAlignment(0);
            this.configLabelTop.setVerticalAlignment(1);
            this.configLabelMiddle = new JLabel();
            this.configLabelMiddle.setVerticalAlignment(1);
            JScrollPane jsp = new JScrollPane(this.configLabelMiddle, 20, 30);
            jsp.setBorder(null);
            this.configSystemControlPanel = new JPanel();
            this.configSystemControlPanel.setLayout(new FlowLayout(1));
            this.configSystemControlPanel.add(new JButton(new AbstractAction(I18n.text("Clear Stored Data")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MonitorIMCComms.this.selectedSystem == null) {
                        return;
                    }
                    ImcSystem sys = ImcSystemsHolder.lookupSystem((ImcId16)MonitorIMCComms.this.selectedSystem);
                    if (sys != null) {
                        sys.clearStoredData();
                    }
                }
            }));
            this.addConfigSystemPanel.add(jsp);
            this.addConfigSystemPanel.add(Box.createHorizontalGlue(), "West");
            this.addConfigSystemPanel.add(Box.createHorizontalGlue(), "East");
            this.addConfigSystemPanel.add((Component)this.configLabelTop, "North");
            this.addConfigSystemPanel.add((Component)this.configSystemControlPanel, "South");
        }
        return this.addConfigSystemPanel;
    }

    private void updateLocalConfigPanel() {
        ImcId16 idImc = ((ImcMsgManager)this.getCommManager()).getLocalId();
        String ret = "<html>";
        ret = ret + "<b>" + I18n.text("Name:") + "</b> " + this.imcCCUName + "<br>";
        ret = ret + "<b>" + I18n.text("ID:") + "</b> " + idImc.toPrettyString();
        if (((ImcMsgManager)this.getCommManager()).is2IdErrorMode()) {
            ret = ret + " <b color='red'>" + I18n.text("Another node with this ID detected!") + "</b>";
        }
        ret = ret + "<br>";
        ret = ret + "<b>" + I18n.text("Services:") + "</b> " + ((ImcMsgManager)this.getCommManager()).getAllServicesString().replaceAll(";", ";<br>") + "<br><br>";
        ret = ret + "<b>" + I18n.text("Comms info:") + "</b><br>" + ((ImcMsgManager)this.getCommManager()).getCommStatusAsHtmlFragment();
        if (System.currentTimeMillis() - ((ImcMsgManager)this.getCommManager()).getAnnounceLastArriveTime() > 300000L) {
            ret = ret + "<b color='red'>" + I18n.text("Announce not arriving for some time") + "</b><br>";
        }
        ret = ret + "<br>";
        double freqS = ((ImcMsgManager)this.getCommManager()).getToSendMessagesFreqCalc().getMessageFreq();
        long countM = ((ImcMsgManager)this.getCommManager()).getToSendMessagesFreqCalc().getMsgCount();
        ret = ret + "<b>" + I18n.text("To Send messages frequency:") + " </b> " + (freqS != -1.0 ? MathMiscUtils.parseToEngineeringNotation(freqS, 1) : "-") + " Hz" + " (" + I18n.textf("%number messages", countM) + ")" + "<br>";
        freqS = ((ImcMsgManager)this.getCommManager()).getSentMessagesFreqCalc().getMessageFreq();
        countM = ((ImcMsgManager)this.getCommManager()).getSentMessagesFreqCalc().getMsgCount();
        ret = ret + "<b>" + I18n.text("Sent messages frequency:") + " </b> " + (freqS != -1.0 ? MathMiscUtils.parseToEngineeringNotation(freqS, 1) : "-") + " Hz" + " (" + I18n.textf("%number messages", countM) + ")" + "<br>";
        ret = ret + "<br><b>" + I18n.text("Location:") + "</b> ";
        ret = MyState.getLocation().isLocationEqual(LocationType.ABSOLUTE_ZERO) ? ret + "<span color='red'>" + I18n.text("Unknown location") + "</span><br>" : (System.currentTimeMillis() - MyState.getLastLocationUpdateTimeMillis() > 10000L ? ret + "<span color='red'>" + CoordinateUtil.latitudeAsPrettyString(MathMiscUtils.round(MyState.getLocation().getLatitudeDegs(), 6), false) + " " + CoordinateUtil.longitudeAsPrettyString(MathMiscUtils.round(MyState.getLocation().getLongitudeDegs(), 6), false) + "</span><br>" : ret + CoordinateUtil.latitudeAsPrettyString(MathMiscUtils.round(MyState.getLocation().getLatitudeDegs(), 6), false) + " " + CoordinateUtil.longitudeAsPrettyString(MathMiscUtils.round(MyState.getLocation().getLongitudeDegs(), 6), false) + "<br>");
        ret = ret + "<br><b>" + I18n.text("State Listeners:") + "</b><br>";
        ret = ret + ((ImcMsgManager)this.getCommManager()).getStatusListenersAsHtmlFragment();
        ret = ret + "<br><br><b>" + I18n.text("Root Messages Listeners:") + "</b><br>";
        final String txtR = ret = ret + ((ImcMsgManager)this.getCommManager()).getListenersAsHtmlFragment();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MonitorIMCComms.this.localInfoLabel.setText(txtR);
                }
            });
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e.getStackTrace());
        }
    }

    private void updateConfigPanel() {
        if (this.selectedSystem == null) {
            return;
        }
        ImcId16 idImc = (ImcId16)this.selectedSystem;
        if (idImc == null) {
            this.configLabelTop.setText(I18n.text("No system selected"));
            this.configLabelMiddle.setText("");
            this.configSystemControlPanel.setVisible(false);
            for (Component comp : this.configSystemControlPanel.getComponents()) {
                comp.setEnabled(false);
            }
            return;
        }
        ImcSystem sys = ImcSystemsHolder.lookupSystem(idImc);
        if (sys == null) {
            this.configLabelTop.setText(I18n.text("No system found"));
            this.configLabelMiddle.setText("");
            this.configSystemControlPanel.setVisible(false);
            for (Component comp : this.configSystemControlPanel.getComponents()) {
                comp.setEnabled(false);
            }
            return;
        }
        this.configSystemControlPanel.setVisible(true);
        for (Component comp : this.configSystemControlPanel.getComponents()) {
            comp.setEnabled(true);
        }
        this.configLabelTop.setText("<html><b>" + I18n.text("Name:") + " " + sys.getName() + "</b><br>" + "<b>" + I18n.text("ID:") + "</b> " + sys.getId().toPrettyString());
        String ret = "<html>";
        ret = ret + "<b>" + I18n.text("Type:") + "</b> " + (Object)((Object)sys.getType()) + "<br>";
        ret = ret + "<b>" + I18n.text("IP:") + "</b> " + sys.getHostAddress() + "<br>";
        ret = ret + "<b>" + I18n.text("UDP:") + "</b> " + (sys.isUDPOn() ? Integer.valueOf(sys.getRemoteUDPPort()) : "-") + "<br>";
        String tcpConnection = sys.isTCPOn() ? (((ImcMsgManager)this.getCommManager()).isTCPConnectionEstablished(sys.getHostAddress(), sys.getRemoteTCPPort()) ? " (" + I18n.text("connected") + ")" : " (" + I18n.text("not connected") + ")") : "";
        ret = ret + "<b>" + I18n.text("TCP:") + "</b> " + (sys.isTCPOn() ? sys.getRemoteTCPPort() + tcpConnection : "-") + "<br>";
        ret = ret + "<b>" + I18n.text("Services:") + "</b> " + sys.getServicesProvided().replaceAll(";", ";<br>") + "<br>";
        ret = ret + "<br>";
        MessageFrequencyCalculator mfc = ((ImcMsgManager)this.getCommManager()).getToSendMessagesFreqCalc(sys.getId());
        double freqS = mfc == null ? -1.0 : mfc.getMessageFreq();
        long countM = mfc == null ? 0L : mfc.getMsgCount();
        ret = ret + "<b>" + I18n.text("To Send messages frequency:") + " </b> " + (freqS != -1.0 ? MathMiscUtils.parseToEngineeringNotation(freqS, 1) : "-") + " Hz" + " (" + I18n.textf("%number messages", countM) + ")" + "<br>";
        mfc = ((ImcMsgManager)this.getCommManager()).getSentMessagesFreqCalc(sys.getId());
        freqS = mfc == null ? -1.0 : mfc.getMessageFreq();
        countM = mfc == null ? 0L : mfc.getMsgCount();
        ret = ret + "<b>" + I18n.text("Sent messages frequency:") + " </b> " + (freqS != -1.0 ? MathMiscUtils.parseToEngineeringNotation(freqS, 1) : "-") + " Hz" + " (" + I18n.textf("%number messages", countM) + ")" + "<br>";
        ret = ret + "<br><b>" + I18n.text("Location:") + "</b> ";
        ret = sys.getLocation().isLocationEqual(LocationType.ABSOLUTE_ZERO) ? ret + "<span color='red'>" + I18n.text("Unknown location") + "</span><br>" : (System.currentTimeMillis() - sys.getLocationTimeMillis() > 10000L ? ret + "<span color='red'>" + CoordinateUtil.latitudeAsPrettyString(MathMiscUtils.round(sys.getLocation().getLatitudeDegs(), 6), false) + " " + CoordinateUtil.longitudeAsPrettyString(MathMiscUtils.round(sys.getLocation().getLongitudeDegs(), 6), false) + "</span><br>" : ret + CoordinateUtil.latitudeAsPrettyString(MathMiscUtils.round(sys.getLocation().getLatitudeDegs(), 6), false) + " " + CoordinateUtil.longitudeAsPrettyString(MathMiscUtils.round(sys.getLocation().getLongitudeDegs(), 6), false) + "<br>");
        ret = ret + "<br><b>" + I18n.text("Entities:") + "</b>";
        Map<Integer, String> entLst = EntitiesResolver.getEntities(sys.getName());
        String txtEt = "";
        if (entLst != null) {
            Integer[] es;
            boolean startEt = true;
            for (Integer id : es = entLst.keySet().toArray(new Integer[0])) {
                if (startEt) {
                    txtEt = txtEt + "<ul>";
                    startEt = false;
                }
                txtEt = txtEt + "<li>" + id + " = " + entLst.get(id) + "</li>";
            }
            txtEt = !startEt ? txtEt + "</ul>" : txtEt + "<b color='red'> " + I18n.text("no info yet") + "</b>";
        } else {
            txtEt = txtEt + "<b color='red'> " + I18n.text("no info yet") + "</b>";
        }
        txtEt = txtEt + "<br>";
        ret = ret + txtEt;
        ret = ret + "<br><b>" + I18n.text("Stored Data:") + "</b><br>";
        for (String key : sys.getDataStorageKeys()) {
            Object obj = sys.retrieveData(key);
            long timeMillis = sys.retrieveDataTimeMillis(key);
            String age = timeMillis < 0L ? "" : " (\u2206t " + DateTimeUtil.milliSecondsToFormatedString(System.currentTimeMillis() - timeMillis) + ")";
            String txt = "<p>";
            try {
                String[] ks;
                Map map = (Map)obj;
                txt = txt + "<i>" + key + age + "</i>:";
                boolean start = true;
                for (String keyItem : ks = map.keySet().toArray(new String[0])) {
                    if (keyItem == null) continue;
                    if (start) {
                        txt = txt + "<ul>";
                        start = false;
                    }
                    txt = txt + "<li>" + keyItem + " = " + map.get(keyItem) + "</li>";
                }
                if (!start) {
                    txt = txt + "</ul>";
                }
                txt = txt + "<br>";
            }
            catch (Exception e) {
                txt = txt + "<i>" + key + age + "</i> = " + obj + "<br>";
            }
            ret = ret + txt;
        }
        ret = ret + "<br><b>" + I18n.text("Stored Plans:") + "</b><br>";
        String txt = "";
        try {
            Map<String, PlanDBInfo> sp = sys.getPlanDBControl().getRemoteState().getStoredPlans();
            boolean start = true;
            for (String planId : sp.keySet()) {
                if (start) {
                    txt = txt + "<ul>";
                    start = false;
                }
                PlanDBInfo pdbi = sp.get(planId);
                txt = txt + "<li>" + pdbi + " [" + I18n.text("MD5:") + " " + ByteUtil.encodeAsString(pdbi.getMd5()) + "]</li>";
            }
            if (!start) {
                txt = txt + "</ul>";
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        txt = txt + "<br>";
        ret = ret + txt;
        ret = ret + "<br><b>" + I18n.text("Listeners:") + "</b><br>";
        final String txtR = ret = ret + ((ImcMsgManager)this.getCommManager()).getListenersAsHtmlFragment(idImc);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MonitorIMCComms.this.configLabelMiddle.setText(txtR);
                }
            });
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e.getStackTrace());
        }
    }

    private SystemsList getAddSystemsListPanel() {
        if (this.systemsListPanel == null) {
            this.systemsListPanel = new SystemsList(null);
            this.systemsListPanel.systemsFilter = VehicleType.SystemTypeEnum.ALL;
            this.systemsListPanel.setEnableSelection(false);
            this.systemsListPanel.setViewEnable(false);
            this.systemsListPanel.setIconsSize(20);
            this.systemsListPanel.setIndicatorsSize(20);
        }
        return this.systemsListPanel;
    }

    private void updateSystemsList() {
        if (this.systemsListPanel == null || !this.systemsListPanel.isShowing()) {
            return;
        }
        long t1 = System.currentTimeMillis();
        if (t1 - this.time >= 600L) {
            this.systemsListPanel.update();
            this.time = t1;
        }
    }

    @Override
    protected String getCommName() {
        return "IMC";
    }

    @Override
    public ImageIcon getOnIcon() {
        return ICON_ON;
    }

    @Override
    public ImageIcon getOffIcon() {
        return ICON_OFF;
    }

    @Override
    protected String translateSystemIdToName(ImcId16 id) {
        VehicleType vehTmp = VehiclesHolder.getVehicleWithImc(id);
        ImcSystem sysImc = ImcSystemsHolder.lookupSystem(id);
        if (vehTmp != null) {
            return vehTmp.getId();
        }
        if (sysImc != null) {
            return sysImc.getName();
        }
        return id.toPrettyString();
    }

    @Override
    protected ImcId16 translateStringIdToId(String id) {
        try {
            return ImcId16.valueOf(id);
        }
        catch (NumberFormatException e) {
            NeptusLog.pub().error((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected String translateIdToStringId(ImcId16 id) {
        return id.toPrettyString();
    }

    private ImcId16Editor getImcId16Editor() {
        if (this.imcId16Editor == null) {
            this.imcId16Editor = new ImcId16Editor();
        }
        return this.imcId16Editor;
    }

    private JPanel getAddNewSystemTextField() {
        if (this.addNewSystemTextFieldPanel == null) {
            this.addNewSystemTextFieldPanel = this.getImcId16Editor().imcId16Editor;
            this.addNewSystemTextFieldPanel.setPreferredSize(new Dimension(150, 19));
            this.addNewSystemTextFieldPanel.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        MonitorIMCComms.this.getAddNewSystemRoundButton().doClick(50);
                    }
                }
            });
        }
        return this.addNewSystemTextFieldPanel;
    }

    private JTextField getAddNewVehTextField() {
        if (this.addNewVehTextField == null) {
            this.addNewVehTextField = new JTextField();
            this.addNewVehTextField.setPreferredSize(new Dimension(150, 19));
            this.addNewVehTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        MonitorIMCComms.this.getAddNewVehRoundButton().doClick(50);
                    }
                }
            });
        }
        return this.addNewVehTextField;
    }

    private JRoundButton getAddNewSystemRoundButton() {
        if (this.addNewSystemRoundButton == null) {
            this.addNewSystemRoundButton = new JRoundButton();
            this.addNewSystemRoundButton.setText(I18n.text("Add new system"));
            this.addNewSystemRoundButton.setPreferredSize(new Dimension(142, 34));
            this.addNewSystemRoundButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonitorIMCComms.this.addNewSystemRoundButton.setEnabled(false);
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            if (!((ImcMsgManager)MonitorIMCComms.this.getCommManager()).isRunning()) {
                                JOptionPane jop = new JOptionPane(I18n.text("IMC comm. manager is not running yet!"), 2);
                                JDialog dialog = jop.createDialog(MonitorIMCComms.this, I18n.text("Setup new system comms."));
                                dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                                dialog.setVisible(true);
                                return null;
                            }
                            ImcId16 newVehId = (ImcId16)MonitorIMCComms.this.getImcId16Editor().getValue();
                            ((ImcMsgManager)MonitorIMCComms.this.getCommManager()).initSystemCommInfo(newVehId, "");
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                            }
                            MonitorIMCComms.this.addNewSystemRoundButton.setEnabled(true);
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.addNewSystemRoundButton;
    }

    private JRoundButton getAddNewVehRoundButton() {
        if (this.addNewVehRoundButton == null) {
            this.addNewVehRoundButton = new JRoundButton();
            this.addNewVehRoundButton.setText(I18n.text("Add new vehicle"));
            this.addNewVehRoundButton.setPreferredSize(new Dimension(142, 34));
            this.addNewVehRoundButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonitorIMCComms.this.addNewVehRoundButton.setEnabled(false);
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            if (!((ImcMsgManager)MonitorIMCComms.this.getCommManager()).isRunning()) {
                                JOptionPane jop = new JOptionPane(I18n.text("IMC comm. manager is not running yet!"), 2);
                                JDialog dialog = jop.createDialog(MonitorIMCComms.this, I18n.text("Setup new vehicle comms."));
                                dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                                dialog.setVisible(true);
                                return null;
                            }
                            String newVehId = MonitorIMCComms.this.getAddNewVehTextField().getText();
                            ((ImcMsgManager)MonitorIMCComms.this.getCommManager()).initVehicleCommInfo(newVehId, "");
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                            }
                            MonitorIMCComms.this.addNewVehRoundButton.setEnabled(true);
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.addNewVehRoundButton;
    }

    private JPanel getAddHolderSystemCommPanel() {
        if (this.addHolderSystemCommPanel == null) {
            this.addHolderSystemCommPanel = new JPanel();
            GroupLayout layout = new GroupLayout(this.addHolderSystemCommPanel);
            this.addHolderSystemCommPanel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getAddSystemCommPanel()).addComponent(this.getAddVehicleCommPanel()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.getAddSystemCommPanel()).addComponent(this.getAddVehicleCommPanel()));
        }
        return this.addHolderSystemCommPanel;
    }

    private JPanel getAddSystemCommPanel() {
        if (this.addSystemCommPanel == null) {
            this.addSystemCommPanel = new JPanel();
            this.addSystemCommPanel.setLayout(new FlowLayout(1));
            this.addSystemCommPanel.setBorder(BorderFactory.createLineBorder(SystemColor.windowBorder, 1));
            this.addSystemCommPanel.setSize(new Dimension(355, 42));
            this.addSystemCommPanel.setLocation(new Point(15, 284));
            this.addSystemCommPanel.add((Component)this.getAddNewSystemTextField(), null);
            this.addSystemCommPanel.add((Component)this.getAddNewSystemRoundButton(), null);
        }
        return this.addSystemCommPanel;
    }

    private JPanel getAddVehicleCommPanel() {
        if (this.addVehicleCommPanel == null) {
            this.addVehicleCommPanel = new JPanel();
            this.addVehicleCommPanel.setLayout(new FlowLayout(1));
            this.addVehicleCommPanel.setBorder(BorderFactory.createLineBorder(SystemColor.windowBorder, 1));
            this.addVehicleCommPanel.setSize(new Dimension(355, 42));
            this.addVehicleCommPanel.setLocation(new Point(15, 284));
            this.addVehicleCommPanel.add((Component)this.getAddNewVehTextField(), null);
            this.addVehicleCommPanel.add((Component)this.getAddNewVehRoundButton(), null);
        }
        return this.addVehicleCommPanel;
    }

    @Override
    protected void updateVehicleCommDataPeriodicCall() {
        this.updateLocalConfigPanel();
        this.updateConfigPanel();
        this.updateSystemsList();
        this.updateCommonImcMsg();
        this.updateSystemImcMsg();
    }

    public static void main(String[] args) throws Exception {
        ConfigFetch.initialize();
        GuiUtils.setLookAndFeel();
        ImcMsgManager imcMMsgManager = ImcMsgManager.getManager();
        JFrame frame = GuiUtils.testFrame(new MonitorIMCComms(imcMMsgManager), "Monitor IMC Comms");
        frame.setIconImage(ICON_ON.getImage());
        frame.setSize(396, 466);
        imcMMsgManager.start();
        MessageListener<MessageInfo, IMCMessage> mwl = new MessageListener<MessageInfo, IMCMessage>(){

            public void onMessage(MessageInfo arg0, IMCMessage msg) {
                if (msg.getMessageType().getShortName().equalsIgnoreCase("EntityState")) {
                    for (String k : msg.getBitmask("flags").keySet()) {
                        NeptusLog.pub().info((Object)("<###> " + k + " " + msg.getBitmask("flags").get(k)));
                    }
                }
            }

            public String toString() {
                return "teste";
            }
        };
        MessageFilter<MessageInfo, IMCMessage> filter = new MessageFilter<MessageInfo, IMCMessage>(){

            @Override
            public boolean isMessageToListen(MessageInfo info, IMCMessage msg) {
                return true;
            }
        };
        imcMMsgManager.addListener(mwl, new ImcId16(22L), filter);
        ImcMessageSenderPanel.getFrame();
    }
}

