/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager.imc;

import com.google.common.eventbus.AsyncEventBus;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import pt.lsts.imc.AcousticSystems;
import pt.lsts.imc.EntityParameters;
import pt.lsts.imc.FuelLevel;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.LblConfig;
import pt.lsts.imc.lsf.LsfMessageLogger;
import pt.lsts.imc.state.ImcSysState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.MessageFrequencyCalculator;
import pt.lsts.neptus.comm.manager.SystemCommBaseInfo;
import pt.lsts.neptus.comm.manager.imc.EntitiesResolver;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.types.comm.CommMean;
import pt.lsts.neptus.types.comm.protocol.IMCArgs;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.AngleCalc;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.StringUtils;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.conf.PreferencesListener;

public class SystemImcMsgCommInfo
extends SystemCommBaseInfo<IMCMessage, MessageInfo, ImcId16> {
    private String ipAddress = null;
    private int ipRemotePort = 0;
    private boolean logReceivedMsg = false;
    private boolean useActivityCounter = true;
    private Vector<Long> activityCounter = new Vector();
    protected ImcSysState imcState = new ImcSysState();
    private PreferencesListener gplistener = new PreferencesListener(){

        @Override
        public void preferencesUpdated() {
            SystemImcMsgCommInfo.this.logReceivedMsg = GeneralPreferences.messageLogReceivedMessages;
            SystemImcMsgCommInfo.this.useActivityCounter = GeneralPreferences.commsUseNewSystemActivityCounter;
        }
    };
    private MessageFrequencyCalculator toSendMessagesFreqCalc = new MessageFrequencyCalculator();
    private MessageFrequencyCalculator sentMessagesFreqCalc = new MessageFrequencyCalculator();
    protected AsyncEventBus bus = null;

    public SystemImcMsgCommInfo() {
        GeneralPreferences.addPreferencesListener(this.gplistener);
        this.gplistener.preferencesUpdated();
    }

    public final AsyncEventBus getMessageBus() {
        return this.bus;
    }

    final void setMessageBus(AsyncEventBus bus) {
        this.bus = bus;
    }

    @Override
    protected void triggerExtraActionOnSetActive(boolean isActive, MessageInfo info, IMCMessage message) {
        ImcSystem sys = ImcSystemsHolder.lookupSystem((ImcId16)this.getSystemCommId());
        if (!(sys == null || message != null && StringUtils.isTokenInList("Announce,EntityList", message.getAbbrev()))) {
            if (!this.useActivityCounter) {
                sys.setActive(isActive);
            } else if (sys.getAuthorityState() == ImcSystem.IMCAuthorityState.OFF) {
                sys.setActive(false);
            } else if (!isActive) {
                sys.setActive(false);
            } else {
                this.activityCounter.add(System.currentTimeMillis());
                int vecSize = this.activityCounter.size();
                if (vecSize > 3) {
                    this.activityCounter.remove(0);
                }
                if ((vecSize = this.activityCounter.size()) == 3) {
                    if (this.activityCounter.get(2) - this.activityCounter.get(0) <= 3000L) {
                        sys.setActive(true);
                    } else {
                        sys.setActive(false);
                    }
                } else {
                    sys.setActive(false);
                }
            }
        }
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getIpRemotePort() {
        return this.ipRemotePort;
    }

    public void setIpRemotePort(int ipRemotePort) {
        this.ipRemotePort = ipRemotePort;
    }

    @Override
    protected boolean initSystemComms() {
        VehicleType vehicleaux = VehiclesHolder.getVehicleWithImc((ImcId16)this.getSystemCommId());
        ImcSystem resSys = ImcSystemsHolder.lookupSystem((ImcId16)this.getSystemCommId());
        if (resSys == null && vehicleaux != null) {
            resSys = new ImcSystem(vehicleaux);
            ImcSystemsHolder.registerSystem(resSys);
        }
        if (resSys == null) {
            NeptusLog.pub().error((Object)("Error creating private sending transports for " + this.getSystemCommId() + "."));
            return false;
        }
        CommMean commMean = resSys.commsInfo;
        if (commMean == null) {
            NeptusLog.pub().error((Object)("Error creating private sending transports for " + this.getSystemCommId() + "."));
            return false;
        }
        this.ipAddress = commMean.getHostAddress();
        this.ipRemotePort = ((IMCArgs)commMean.getProtocolsArgs().get("imc")).getPort();
        return true;
    }

    @Override
    protected boolean startSystemComms() {
        return true;
    }

    @Override
    protected boolean stopSystemComms() {
        return true;
    }

    @Override
    protected boolean processMsgLocally(MessageInfo info, IMCMessage msg) {
        ImcSystem resSys = ImcSystemsHolder.lookupSystem((ImcId16)this.systemCommId);
        if (resSys != null && resSys.getAuthorityState() == ImcSystem.IMCAuthorityState.OFF) {
            return false;
        }
        this.logMessage(info, msg);
        try {
            if (this.bus != null) {
                this.bus.post((Object)msg);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        catch (Error e1) {
            e1.printStackTrace();
        }
        this.imcState.setMessage(msg);
        if (resSys == null) {
            return true;
        }
        switch (msg.getMgid()) {
            case 500: {
                try {
                    int errorCount = msg.getInteger("error_count");
                    if (errorCount > 0) {
                        resSys.setOnErrorState(true);
                    } else {
                        resSys.setOnErrorState(false);
                    }
                    Object errEntStr = msg.getValue("error_ents");
                    if (errEntStr != null) {
                        resSys.setOnErrorStateStr(errEntStr.toString());
                        break;
                    }
                    resSys.setOnErrorStateStr("");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 560: {
                String planId;
                try {
                    planId = msg.getString("plan_id");
                    String maneuver = msg.getString("man_id");
                    String state = msg.getString("state");
                    PlanType plan = new PlanType(null);
                    plan.setId(planId + "|" + I18n.textc("Man", "Maneuver (short form)") + ":" + maneuver);
                    if ("EXECUTING".equalsIgnoreCase(state)) {
                        resSys.setActivePlan(plan);
                        break;
                    }
                    resSys.setActivePlan(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 555: {
                String planId;
                try {
                    planId = msg.getString("plan_id");
                    if (planId == null) {
                        planId = msg.getString("mission_id");
                    }
                    String state = msg.getString("state");
                    resSys.setEmergencyPlanId(planId);
                    resSys.setEmergencyStatusStr(state);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 350: {
                try {
                    long timeMillis = msg.getTimestampMillis();
                    double lat = msg.getDouble("lat");
                    double lon = msg.getDouble("lon");
                    double height = msg.getDouble("height");
                    msg.getDouble("depth");
                    msg.getDouble("altitude");
                    double x = msg.getDouble("x");
                    double y = msg.getDouble("y");
                    double z = msg.getDouble("z");
                    double phi = msg.getDouble("phi");
                    double theta = msg.getDouble("theta");
                    double psi = msg.getDouble("psi");
                    LocationType loc = new LocationType();
                    loc.setLatitudeRads(lat);
                    loc.setLongitudeRads(lon);
                    loc.setHeight(height);
                    loc.setOffsetNorth(x);
                    loc.setOffsetEast(y);
                    loc.setOffsetDown(z);
                    loc.convertToAbsoluteLatLonDepth();
                    if (loc != null) {
                        resSys.setLocation(loc, timeMillis);
                    }
                    resSys.setAttitudeDegrees(Math.toDegrees(phi), Math.toDegrees(theta), Math.toDegrees(psi), timeMillis);
                    double vx = msg.getDouble("vx");
                    double vy = msg.getDouble("vy");
                    double vz = msg.getDouble("vz");
                    double courseRad = AngleCalc.calcAngle(0.0, 0.0, vy, vx);
                    double groundSpeed = Math.sqrt(vx * vx + vy * vy);
                    double verticalSpeed = vz;
                    resSys.storeData("Course", (int)AngleCalc.nomalizeAngleDegrees360(MathMiscUtils.round(Math.toDegrees(courseRad), 0)), timeMillis, true);
                    resSys.storeData("Ground Speed", groundSpeed, timeMillis, true);
                    resSys.storeData("Vertical Speed", verticalSpeed, timeMillis, true);
                    double headingRad = msg.getDouble("psi");
                    resSys.storeData("Heading", (int)AngleCalc.nomalizeAngleDegrees360(MathMiscUtils.round(Math.toDegrees(headingRad), 0)), timeMillis, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 50: {
                try {
                    long timeMillis = msg.getTimestampMillis();
                    resSys.storeData(msg.getAbbrev(), msg, timeMillis, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 504: {
                try {
                    long timeMillis = msg.getTimestampMillis();
                    resSys.storeData(msg.getAbbrev(), msg, timeMillis, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 352: {
                try {
                    long timeMillis = msg.getTimestampMillis();
                    double value = msg.getDouble("value");
                    resSys.storeData("Indicate Speed", value, timeMillis, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 353: {
                try {
                    long timeMillis = msg.getTimestampMillis();
                    double value = msg.getDouble("value");
                    resSys.storeData("True Speed", value, timeMillis, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 556: {
                try {
                    resSys.getPlanDBControl().onMessage(info, msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 250: {
                try {
                    long timeMillis = msg.getTimestampMillis();
                    int entityId = (Integer)msg.getHeaderValue("src_ent");
                    int value = msg.getInteger("value");
                    if (entityId == 255) {
                        resSys.storeData("RPM", value, timeMillis, true);
                        break;
                    }
                    String entityName = EntitiesResolver.resolveName(resSys.getName(), entityId);
                    if (entityName == null) break;
                    Object obj = resSys.retrieveData("RPM");
                    if (obj == null) {
                        Map<String, Integer> map = Collections.synchronizedMap(new HashMap());
                        map.put(entityName, value);
                        resSys.storeData("RPM", map, timeMillis, true);
                        break;
                    }
                    Map rpms = (Map)resSys.retrieveData("RPM");
                    rpms.put(entityName, value);
                    resSys.storeData("RPM", rpms, timeMillis, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 279: {
                try {
                    long timeMillis = msg.getTimestampMillis();
                    FuelLevel fuelLevelMsg = (FuelLevel)msg;
                    resSys.storeData("Fuel Level", fuelLevelMsg, timeMillis, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 203: {
                try {
                    if (((LblConfig)msg).getOp() != LblConfig.OP.CUR_CFG) break;
                    resSys.storeData("LblConfig", (LblConfig)msg, msg.getTimestampMillis(), true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 213: {
                try {
                    long timeMillis = msg.getTimestampMillis();
                    AcousticSystems acousticSystemsMsg = (AcousticSystems)msg;
                    resSys.storeData("AcousticSystems", acousticSystemsMsg, timeMillis, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 802: {
                try {
                    long timeMillis = msg.getTimestampMillis();
                    EntityParameters entityParametersMsg = (EntityParameters)msg;
                    resSys.storeData("EntityParameters", entityParametersMsg, timeMillis, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        return true;
    }

    private void logMessage(MessageInfo info, IMCMessage msg) {
        if (this.logReceivedMsg) {
            try {
                String noLogStr = info.getProperty("NotToLogMessage");
                if ("true".equalsIgnoreCase(noLogStr)) {
                    NeptusLog.pub().info((Object)("Skip logging message " + msg.getMessageType().getShortName() + "!"));
                } else {
                    String strUDP = "<UDP peer identified by IP>";
                    String pub = msg.getHeaderValue("src").toString();
                    msg.getHeaderValue("dst").toString();
                    if (strUDP.equals(pub)) {
                        pub = this.getSystemIdName().toUpperCase();
                    }
                    LsfMessageLogger.log((IMCMessage)msg);
                }
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("Error logging message " + msg.getMessageType().getShortName() + "!"), (Throwable)e);
            }
        }
    }

    public MessageFrequencyCalculator getSentMessagesFreqCalc() {
        return this.sentMessagesFreqCalc;
    }

    public MessageFrequencyCalculator getToSendMessagesFreqCalc() {
        return this.toSendMessagesFreqCalc;
    }

    public String toString() {
        return this.getSystemIdName();
    }

    public final ImcSysState getImcState() {
        return this.imcState;
    }
}

