/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.proxy;

import java.awt.Window;
import java.io.File;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.ssh.SSHConnectionDialog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginUtils;

public class ProxyInfoProvider {
    @NeptusProperty
    public static boolean enableProxy = false;
    @NeptusProperty
    public static String httpProxyHost = "localhost";
    @NeptusProperty
    public static short httpProxyPort = (short)8080;
    @NeptusProperty
    public static String username = "user";
    private static String password = null;
    private static final String ROOT_PREFIX;

    private ProxyInfoProvider() {
    }

    private static synchronized void savePropertiesToDisk() {
        try {
            PluginUtils.saveProperties(ROOT_PREFIX + "conf/" + ProxyInfoProvider.class.getSimpleName().toLowerCase() + ".properties", ProxyInfoProvider.class);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)("Not possible to open \"conf/" + ProxyInfoProvider.class.getSimpleName().toLowerCase() + ".properties\" : " + e.getMessage()));
        }
    }

    public static boolean isEnableProxy() {
        return enableProxy;
    }

    public static void setEnableProxy(boolean enableProxy) {
        ProxyInfoProvider.enableProxy = enableProxy;
        ProxyInfoProvider.savePropertiesToDisk();
    }

    public static String[] showConfigurations() {
        return ProxyInfoProvider.showOrNotConfiguratonDialogAndReturnConfigurationWorker(I18n.text("Proxy Configuration"), true, null);
    }

    public static String[] showConfigurations(Window parentWindow) {
        return ProxyInfoProvider.showOrNotConfiguratonDialogAndReturnConfigurationWorker(I18n.text("Proxy Configuration"), true, parentWindow);
    }

    public static String[] getConfiguratons() {
        return enableProxy ? ProxyInfoProvider.showOrNotConfiguratonDialogAndReturnConfigurationWorker(I18n.text("Proxy Configuration"), false, null) : new String[]{};
    }

    public static String[] getConfiguratons(Window parentWindow) {
        return enableProxy ? ProxyInfoProvider.showOrNotConfiguratonDialogAndReturnConfigurationWorker(I18n.text("Proxy Configuration"), false, parentWindow) : new String[]{};
    }

    private static synchronized String[] showOrNotConfiguratonDialogAndReturnConfigurationWorker(String title, boolean forceShow, Window parentWindow) {
        if (forceShow || password == null) {
            String[] ret = SSHConnectionDialog.showConnectionDialog(httpProxyHost, username, password == null ? "" : password, httpProxyPort, title, parentWindow);
            if (ret.length == 0) {
                return new String[0];
            }
            httpProxyHost = ret[0];
            username = ret[1];
            password = ret[2];
            try {
                httpProxyPort = Short.parseShort(ret[3]);
            }
            catch (NumberFormatException e) {
                NeptusLog.pub().debug((Object)e.getMessage());
                httpProxyPort = (short)80;
            }
            ProxyInfoProvider.savePropertiesToDisk();
        }
        return new String[]{httpProxyHost, username, password, Short.toString(httpProxyPort)};
    }

    public static void setRoutePlanner(final AbstractHttpClient client) {
        client.setRoutePlanner(new HttpRoutePlanner(){

            public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
                String[] ret = ProxyInfoProvider.getConfiguratons();
                if (ret.length == 0) {
                    return new HttpRoute(target, null, target, "https".equalsIgnoreCase(target.getSchemeName()));
                }
                String proxyHost = ret[0];
                short proxyPort = Short.parseShort(ret[3]);
                String username = ret[1];
                String password = ret[2];
                client.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, (int)proxyPort), (Credentials)new UsernamePasswordCredentials(username, password));
                return new HttpRoute(target, null, new HttpHost(proxyHost, (int)proxyPort), "https".equalsIgnoreCase(target.getSchemeName()));
            }
        });
    }

    public static Credentials getProxyCredentials() {
        String[] ret = ProxyInfoProvider.getConfiguratons();
        if (ret.length == 0) {
            return new UsernamePasswordCredentials("", "");
        }
        String username = ret[1];
        String password = ret[2];
        return new UsernamePasswordCredentials(username, password);
    }

    public static void authenticateConnectionIfNeeded(HttpResponse resp, HttpContext localContext, DefaultHttpClient client) {
        if (ProxyInfoProvider.isEnableProxy()) {
            AuthState targetAuthState;
            AuthState proxyAuthState = (AuthState)localContext.getAttribute("http.auth.proxy-scope");
            if (proxyAuthState != null) {
                if (proxyAuthState.getAuthScheme() != null) {
                    NeptusLog.pub().info((Object)("<###>Proxy auth scheme: " + proxyAuthState.getAuthScheme()));
                }
                if (proxyAuthState.getCredentials() != null) {
                    NeptusLog.pub().info((Object)("<###>Proxy auth credentials: " + proxyAuthState.getCredentials()));
                }
            }
            if ((targetAuthState = (AuthState)localContext.getAttribute("http.auth.target-scope")) != null) {
                if (targetAuthState.getAuthScheme() != null) {
                    NeptusLog.pub().info((Object)("<###>Target auth scheme: " + targetAuthState.getAuthScheme()));
                }
                if (targetAuthState.getCredentials() != null) {
                    NeptusLog.pub().info((Object)("<###>Target auth credentials: " + targetAuthState.getCredentials()));
                }
            }
        }
        if (ProxyInfoProvider.isEnableProxy()) {
            int sc = resp.getStatusLine().getStatusCode();
            AuthState authState = null;
            HttpHost authhost = null;
            if (sc == 401) {
                authState = (AuthState)localContext.getAttribute("http.auth.target-scope");
                authhost = (HttpHost)localContext.getAttribute("http.target_host");
            }
            if (sc == 407) {
                authState = (AuthState)localContext.getAttribute("http.auth.proxy-scope");
                authhost = (HttpHost)localContext.getAttribute("http.proxy_host");
            }
            if (authState != null) {
                AuthScheme authscheme = authState.getAuthScheme();
                NeptusLog.pub().info((Object)("<###>Using proxy for " + authscheme.getRealm() + " ..."));
                Credentials creds = ProxyInfoProvider.getProxyCredentials();
                client.getCredentialsProvider().setCredentials(new AuthScope(authhost), creds);
            }
        }
    }

    public static void main(String[] args) {
        ProxyInfoProvider.savePropertiesToDisk();
        NeptusLog.pub().info((Object)("<###> " + enableProxy));
        NeptusLog.pub().info((Object)("<###> " + httpProxyHost));
        NeptusLog.pub().info((Object)("<###> " + httpProxyPort));
        NeptusLog.pub().info((Object)("<###> " + username));
        NeptusLog.pub().info((Object)("<###> " + password));
    }

    static {
        if (new File("../conf").exists()) {
            ROOT_PREFIX = "../";
        } else {
            ROOT_PREFIX = "";
            new File("conf").mkdir();
        }
        try {
            String confFx = ROOT_PREFIX + "conf/" + ProxyInfoProvider.class.getSimpleName().toLowerCase() + ".properties";
            if (new File(confFx).exists()) {
                PluginUtils.loadProperties(confFx, ProxyInfoProvider.class);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)("Not possible to open \"conf/" + ProxyInfoProvider.class.getSimpleName().toLowerCase() + ".properties\" : " + e.getMessage()));
        }
    }
}

