/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.ssh;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import pt.lsts.neptus.comm.ssh.IntFormat;
import pt.lsts.neptus.gui.ImagePanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class SSHConnectionDialog
extends JPanel {
    public static final Image SSH_CONNECT_IMAGE = ImageUtils.getImage("images/ssh-connect.png");
    private static final NumberFormat iFormat = new IntFormat();
    private String title = I18n.text("Connect to Remote Host");
    private String host = "localhost";
    private String username = "root";
    private String password = "";
    private int port = 22;
    private boolean isCanceled = false;
    private JDialog jDialog = null;
    private JPanel jContentPane = null;
    private ImagePanel imageConnectSSH = null;
    private JLabel hostLabel = null;
    private JLabel userLabel = null;
    private JLabel passwordLabel = null;
    private JLabel portLabel = null;
    private JTextField usernameField = null;
    private JTextField hostField = null;
    private JPasswordField passwordField = null;
    private JFormattedTextField portField = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private Window parentWindow = null;

    public SSHConnectionDialog() {
        this.initialize();
    }

    public SSHConnectionDialog(String host, String username, String password, int port) {
        this(host, username, password, port, null);
    }

    public SSHConnectionDialog(String host, String username, String password, int port, String title) {
        if (title != null) {
            this.title = title;
        }
        this.host = host;
        this.username = username;
        this.password = password;
        this.port = port > 0 ? port : 22;
        this.initialize();
    }

    private void initialize() {
        this.portLabel = new JLabel();
        this.portLabel.setBounds(new Rectangle(63, 90, 59, 16));
        this.portLabel.setText(I18n.text("Port"));
        this.hostLabel = new JLabel();
        this.hostLabel.setText(I18n.text("Host"));
        this.hostLabel.setLocation(63, 15);
        this.hostLabel.setSize(59, 16);
        this.userLabel = new JLabel();
        this.userLabel.setText(I18n.text("Username"));
        this.userLabel.setLocation(63, 40);
        this.userLabel.setSize(59, 16);
        this.passwordLabel = new JLabel();
        this.passwordLabel.setText(I18n.text("Password"));
        this.passwordLabel.setLocation(63, 65);
        this.passwordLabel.setSize(58, 16);
        this.setSize(514, 123);
        GroupLayout layout = new GroupLayout(this);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.getImageConnectSSH(), -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostLabel).addComponent(this.portLabel).addComponent(this.userLabel).addComponent(this.passwordLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 23, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getHostField(), GroupLayout.Alignment.LEADING, 220, 220, Short.MAX_VALUE).addComponent(this.getPortField(), GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.getUsernameField(), GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.getPasswordField(), GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.getOkButton(), -2, 98, -2).addComponent(this.getCancelButton(), -2, 98, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getImageConnectSSH(), -2, 50, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostLabel).addComponent(this.getHostField(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portLabel).addComponent(this.getPortField(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userLabel).addComponent(this.getUsernameField(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.getPasswordField(), -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.getOkButton()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getCancelButton()))).addGap(15)));
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        this.setLayout(layout);
    }

    private JDialog getJDialog() {
        if (this.jDialog == null) {
            if (this.parentWindow == null) {
                this.jDialog = new JDialog();
            } else if (this.parentWindow instanceof Frame) {
                this.jDialog = new JDialog((Frame)this.parentWindow);
            } else if (this.parentWindow instanceof Dialog) {
                this.jDialog = new JDialog((Dialog)this.parentWindow);
            }
            this.jDialog.setContentPane(this.getJContentPane());
            this.jDialog.setTitle(this.title);
            this.jDialog.setSize(this.getWidth() + 5, this.getHeight() + 35);
            this.jDialog.getContentPane().setLayout(new BorderLayout());
            this.jDialog.getContentPane().add((Component)this, "Center");
            GuiUtils.centerOnScreen(this.jDialog);
            this.jDialog.setModalityType(this.parentWindow != null ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.APPLICATION_MODAL);
            this.jDialog.setAlwaysOnTop(true);
            this.jDialog.setResizable(false);
            this.jDialog.setAlwaysOnTop(true);
            this.jDialog.setDefaultCloseOperation(0);
            this.jDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    SSHConnectionDialog.this.cancelAction();
                }
            });
            this.jDialog.toFront();
            this.jDialog.setFocusTraversalPolicy(new SSHConnectionFocusTraversalPolicy());
            this.jDialog.setVisible(true);
        }
        return this.jDialog;
    }

    public Window getParentWindow() {
        return this.parentWindow;
    }

    public void setParentWindow(Window parentWindow) {
        this.parentWindow = parentWindow;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
        }
        return this.jContentPane;
    }

    private JPasswordField getPasswordField() {
        if (this.passwordField == null) {
            this.passwordField = new JPasswordField();
            this.passwordField.setPreferredSize(new Dimension(150, 20));
            this.passwordField.setLocation(132, 65);
            this.passwordField.setSize(150, 20);
            this.passwordField.setText(this.password);
            this.passwordField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        SSHConnectionDialog.this.okAction();
                    }
                }
            });
            this.passwordField.setSelectionStart(0);
            this.passwordField.setSelectionEnd(this.passwordField.getPassword().length);
        }
        return this.passwordField;
    }

    private String getHost() {
        return new String(this.getHostField().getText());
    }

    private String getUsername() {
        return new String(this.getUsernameField().getText());
    }

    private String getPassword() {
        return new String(this.getPasswordField().getPassword());
    }

    private String getPort() {
        return new String(this.getPortField().getText());
    }

    public void okAction() {
        this.jDialog.setVisible(false);
        this.jDialog.dispose();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void cancelAction() {
        this.jDialog.setVisible(false);
        this.jDialog.dispose();
        this.isCanceled = true;
    }

    private JTextField getUsernameField() {
        if (this.usernameField == null) {
            this.usernameField = new JTextField();
            this.usernameField.setPreferredSize(new Dimension(150, 20));
            this.usernameField.setLocation(132, 40);
            this.usernameField.setSize(150, 20);
            this.usernameField.setEditable(true);
            this.usernameField.setText(this.username);
            this.usernameField.setFocusable(true);
            this.usernameField.setSelectionStart(0);
            this.usernameField.setSelectionEnd(this.usernameField.getText().length());
        }
        return this.usernameField;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setBounds(294, 15, 91, 22);
            this.okButton.setText(I18n.text("OK"));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SSHConnectionDialog.this.okAction();
                }
            });
            GuiUtils.reactEnterKeyPress(this.okButton);
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setBounds(294, 50, 91, 22);
            this.cancelButton.setText(I18n.text("Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SSHConnectionDialog.this.cancelAction();
                }
            });
            GuiUtils.reactEscapeKeyPress(this.cancelButton);
        }
        return this.cancelButton;
    }

    private JTextField getHostField() {
        if (this.hostField == null) {
            this.hostField = new JTextField();
            this.hostField.setSize(150, 20);
            this.hostField.setText(this.host);
            this.hostField.setEditable(true);
            this.hostField.setPreferredSize(new Dimension(150, 20));
            this.hostField.setLocation(132, 15);
            this.hostField.setSelectionStart(0);
            this.hostField.setSelectionEnd(this.hostField.getText().length());
        }
        return this.hostField;
    }

    private ImagePanel getImageConnectSSH() {
        if (this.imageConnectSSH == null) {
            this.imageConnectSSH = new ImagePanel(SSH_CONNECT_IMAGE);
            this.imageConnectSSH.setBounds(new Rectangle(7, 14, 48, 48));
        }
        return this.imageConnectSSH;
    }

    private JFormattedTextField getPortField() {
        if (this.portField == null) {
            this.portField = new JFormattedTextField(iFormat);
            this.portField.setText("" + this.port);
            this.portField.setBounds(new Rectangle(132, 90, 150, 20));
            this.portField.setSelectionStart(0);
            this.portField.setSelectionEnd(this.portField.getText().length());
        }
        return this.portField;
    }

    public static String[] showConnectionDialog(String host, String username, String password, int port) {
        return SSHConnectionDialog.showConnectionDialog(host, username, password, port, (Window)null);
    }

    public static String[] showConnectionDialog(String host, String username, String password, int port, String title) {
        return SSHConnectionDialog.showConnectionDialog(host, username, password, port, title, null);
    }

    public static String[] showConnectionDialog(String host, String username, String password, int port, Window parentWindow) {
        return SSHConnectionDialog.showConnectionDialog(host, username, password, port, null, parentWindow);
    }

    public static String[] showConnectionDialog(String host, String username, String password, int port, String title, Window parentWindow) {
        SSHConnectionDialog scd = new SSHConnectionDialog(host, username, password, port, title);
        scd.setParentWindow(parentWindow);
        scd.getJDialog();
        if (scd.isCanceled) {
            return new String[0];
        }
        String[] ret = new String[]{scd.getHost(), scd.getUsername(), scd.getPassword(), scd.getPort()};
        return ret;
    }

    public static void main(String[] args) {
        SSHConnectionDialog.showConnectionDialog("localhost", "root", "djhgjg", 80, "Proxy Configuration");
    }

    public class SSHConnectionFocusTraversalPolicy
    extends FocusTraversalPolicy {
        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(SSHConnectionDialog.this.hostField)) {
                return SSHConnectionDialog.this.usernameField;
            }
            if (aComponent.equals(SSHConnectionDialog.this.usernameField)) {
                return SSHConnectionDialog.this.passwordField;
            }
            if (aComponent.equals(SSHConnectionDialog.this.passwordField)) {
                return SSHConnectionDialog.this.portField;
            }
            if (aComponent.equals(SSHConnectionDialog.this.portField)) {
                return SSHConnectionDialog.this.okButton;
            }
            if (aComponent.equals(SSHConnectionDialog.this.okButton)) {
                return SSHConnectionDialog.this.cancelButton;
            }
            if (aComponent.equals(SSHConnectionDialog.this.cancelButton)) {
                return SSHConnectionDialog.this.hostField;
            }
            return SSHConnectionDialog.this.passwordField;
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(SSHConnectionDialog.this.hostField)) {
                return SSHConnectionDialog.this.cancelButton;
            }
            if (aComponent.equals(SSHConnectionDialog.this.usernameField)) {
                return SSHConnectionDialog.this.hostField;
            }
            if (aComponent.equals(SSHConnectionDialog.this.passwordField)) {
                return SSHConnectionDialog.this.usernameField;
            }
            if (aComponent.equals(SSHConnectionDialog.this.portField)) {
                return SSHConnectionDialog.this.passwordField;
            }
            if (aComponent.equals(SSHConnectionDialog.this.okButton)) {
                return SSHConnectionDialog.this.portField;
            }
            if (aComponent.equals(SSHConnectionDialog.this.cancelButton)) {
                return SSHConnectionDialog.this.okButton;
            }
            return SSHConnectionDialog.this.passwordField;
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return SSHConnectionDialog.this.passwordField;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return SSHConnectionDialog.this.cancelButton;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return SSHConnectionDialog.this.passwordField;
        }
    }
}

