/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.transports;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.transports.udp.UDPMessageListener;
import pt.lsts.neptus.comm.transports.udp.UDPNotification;
import pt.lsts.neptus.comm.transports.udp.UDPTransport;
import pt.lsts.neptus.messages.IMessage;
import pt.lsts.neptus.messages.IMessageProtocol;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageInfoImpl;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.util.ByteUtil;

public class IMessageUdpTransport<M extends IMessage, P extends IMessageProtocol<M>> {
    private LinkedHashSet<MessageListener<MessageInfo, M>> listeners = new LinkedHashSet();
    private P protocol = null;
    private UDPTransport udpTransport = null;
    int bindPort = 52001;
    String multicastAddress = null;

    public IMessageUdpTransport(String multicastAddress, int bindPort, P protocol) {
        this.multicastAddress = multicastAddress;
        this.protocol = protocol;
        this.bindPort = bindPort;
        this.getUdpTransport();
        this.setUDPListener();
    }

    public IMessageUdpTransport(int bindPort, P protocol) {
        this.protocol = protocol;
        this.bindPort = bindPort;
        this.getUdpTransport();
        this.setUDPListener();
    }

    private void setUDPListener() {
        this.getUdpTransport().addListener(new UDPMessageListener(){

            @Override
            public void onUDPMessageNotification(UDPNotification req) {
                try {
                    ByteUtil.dumpAsHex(req.getBuffer(), System.out);
                    Object msg = IMessageUdpTransport.this.protocol.unserialize(new ByteArrayInputStream(req.getBuffer()));
                    for (MessageListener lst : IMessageUdpTransport.this.listeners) {
                        MessageInfoImpl info = new MessageInfoImpl();
                        info.setPublisher(req.getAddress().getAddress().getHostAddress());
                        info.setPublisherInetAddress(req.getAddress().getAddress().getHostAddress());
                        info.setPublisherPort(req.getAddress().getPort());
                        info.setTimeReceivedNanos(req.getTimeMillis() * 1000000L);
                        try {
                            info.setTimeSentNanos((long)((Double)msg.getValue("TimeStamp") * 1.0E9));
                        }
                        catch (Exception e) {
                            info.setTimeSentNanos(req.getTimeMillis() * 1000000L);
                        }
                        try {
                            lst.onMessage((MessageInfo)info, msg);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        catch (Error e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public UDPTransport getUdpTransport() {
        if (this.udpTransport == null) {
            this.udpTransport = this.multicastAddress == null ? new UDPTransport(this.bindPort, 1) : new UDPTransport(this.multicastAddress, this.bindPort, 1);
        }
        return this.udpTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(MessageListener<MessageInfo, M> listener) {
        boolean ret = false;
        LinkedHashSet<MessageListener<MessageInfo, M>> linkedHashSet = this.listeners;
        synchronized (linkedHashSet) {
            ret = this.listeners.add(listener);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(MessageListener<MessageInfo, M> listener) {
        boolean ret = false;
        LinkedHashSet<MessageListener<MessageInfo, M>> linkedHashSet = this.listeners;
        synchronized (linkedHashSet) {
            ret = this.listeners.remove(listener);
        }
        return ret;
    }

    public void sendMessage(String destination, int port, M message) {
        ByteArrayOutputStream sb = new ByteArrayOutputStream();
        try {
            this.protocol.serialize(message, sb);
            byte[] buffer = sb.toByteArray();
            this.getUdpTransport().sendMessage(destination, port, Arrays.copyOf(buffer, buffer.length));
            ByteUtil.dumpAsHex(message.getAbbrev(), buffer, System.out);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
    }

    public void stopAll() {
        this.getUdpTransport().stop();
    }

    public void purgeAll() {
        this.getUdpTransport().purge();
    }

    public void reStartAll() {
        this.getUdpTransport().reStart();
    }
}

