/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.transports;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.MessageDeliveryListener;
import pt.lsts.neptus.comm.transports.DeliveryListener;
import pt.lsts.neptus.comm.transports.tcp.TCPMessageListener;
import pt.lsts.neptus.comm.transports.tcp.TCPNotification;
import pt.lsts.neptus.comm.transports.tcp.TCPTransport;
import pt.lsts.neptus.messages.IMessage;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageInfoImpl;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class ImcTcpTransport {
    private LinkedHashSet<MessageListener<MessageInfo, IMCMessage>> listeners = new LinkedHashSet();
    private IMCDefinition imcDefinition;
    private TCPTransport tcpTransport = null;
    private int bindPort = 7011;
    final HashMap<String, TCPMessageProcessor> listProc = new HashMap();

    public ImcTcpTransport(int bindPort, IMCDefinition imcDefinition) {
        this.imcDefinition = imcDefinition;
        this.bindPort = bindPort;
        this.getTcpTransport();
        this.setTCPListener();
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public void setBindPort(int bindPort) {
        this.bindPort = bindPort;
        this.getTcpTransport().setBindPort(bindPort);
    }

    public boolean isRunning() {
        return this.getTcpTransport().isRunning();
    }

    public boolean isRunningNormally() {
        return this.getTcpTransport().isRunningNormally();
    }

    private void setTCPListener() {
        this.getTcpTransport().addListener(new TCPMessageListener(){

            @Override
            public void onTCPMessageNotification(TCPNotification req) {
                String id = req.getAddress().toString();
                TCPMessageProcessor proc = ImcTcpTransport.this.listProc.get(id);
                if (proc == null) {
                    proc = new TCPMessageProcessor(id, ImcTcpTransport.this.listeners, ImcTcpTransport.this.imcDefinition);
                    ImcTcpTransport.this.listProc.put(id, proc);
                }
                if (req.isEosReceived()) {
                    ImcTcpTransport.this.listProc.remove(id);
                }
                proc.onTCPMessageNotification(req);
            }
        });
    }

    public TCPTransport getTcpTransport() {
        if (this.tcpTransport == null) {
            this.tcpTransport = new TCPTransport(this.bindPort);
        }
        return this.tcpTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(MessageListener<MessageInfo, IMCMessage> listener) {
        boolean ret = false;
        LinkedHashSet<MessageListener<MessageInfo, IMCMessage>> linkedHashSet = this.listeners;
        synchronized (linkedHashSet) {
            ret = this.listeners.add(listener);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(MessageListener<MessageInfo, IMCMessage> listener) {
        boolean ret = false;
        LinkedHashSet<MessageListener<MessageInfo, IMCMessage>> linkedHashSet = this.listeners;
        synchronized (linkedHashSet) {
            ret = this.listeners.remove(listener);
        }
        return ret;
    }

    public boolean sendMessage(String destination, int port, IMCMessage message) {
        return this.sendMessage(destination, port, message, null);
    }

    public boolean sendMessage(String destination, int port, final IMCMessage message, final MessageDeliveryListener deliveryListener) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IMCOutputStream imcOs = new IMCOutputStream((OutputStream)baos);
        try {
            boolean ret;
            int size = message.serialize(imcOs);
            DeliveryListener listener = null;
            if (deliveryListener != null) {
                listener = new DeliveryListener(){

                    @Override
                    public void deliveryResult(DeliveryListener.ResultEnum result, Exception error) {
                        switch (result) {
                            case Success: {
                                deliveryListener.deliverySuccess(message);
                                break;
                            }
                            case Error: {
                                deliveryListener.deliveryError(message, error);
                                break;
                            }
                            case TimeOut: {
                                deliveryListener.deliveryTimeOut(message);
                                break;
                            }
                            case Unreacheable: {
                                deliveryListener.deliveryUnreacheable(message);
                                break;
                            }
                            default: {
                                deliveryListener.deliveryError(message, new Exception("Delivery " + (Object)((Object)DeliveryListener.ResultEnum.UnFinished)));
                            }
                        }
                    }
                };
            }
            if (!(ret = this.getTcpTransport().sendMessage(destination, port, baos.toByteArray(), listener)) && deliveryListener != null) {
                deliveryListener.deliveryError(message, new Exception("Delivery " + (Object)((Object)DeliveryListener.ResultEnum.UnFinished) + " due to closing transport!"));
            }
            return ret;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            if (deliveryListener != null) {
                deliveryListener.deliveryError(message, e);
            }
            return false;
        }
    }

    public void stop() {
        this.getTcpTransport().stop();
        this.stopAndCleanReceiveProcessors();
    }

    public void purge() {
        this.getTcpTransport().purge();
        this.stopAndCleanReceiveProcessors();
    }

    private void stopAndCleanReceiveProcessors() {
        for (TCPMessageProcessor proc : this.listProc.values()) {
            proc.cleanup();
        }
        this.listProc.clear();
    }

    public void reStart() {
        this.getTcpTransport().reStart();
    }

    public boolean isOnBindError() {
        return this.getTcpTransport().isOnBindError();
    }

    public long getActiveNumberOfConnections() {
        return this.getTcpTransport().getActiveNumberOfConnections();
    }

    public boolean isConnectionEstablished(String host, int port) {
        return this.getTcpTransport().isConnectionEstablished(host, port);
    }

    public static void main(String[] args) throws Exception {
        ConfigFetch.initialize();
        String server = "127.0.0.1";
        int portServer = 6001;
        String server2 = "127.0.0.1";
        int portServer2 = 6002;
        ImcTcpTransport tcpT = new ImcTcpTransport(portServer, IMCDefinition.getInstance());
        ImcTcpTransport tcpT2 = new ImcTcpTransport(portServer2, IMCDefinition.getInstance());
        tcpT.addListener(new MessageListener<MessageInfo, IMCMessage>(){

            public void onMessage(MessageInfo info, IMCMessage msg) {
                info.dump(System.out);
                msg.dump((OutputStream)System.out);
            }
        });
        tcpT2.addListener(new MessageListener<MessageInfo, IMCMessage>(){

            public void onMessage(MessageInfo info, IMCMessage msg) {
                info.dump(System.err);
                msg.dump((OutputStream)System.err);
            }
        });
        MessageDeliveryListener mdlT = new MessageDeliveryListener(){

            @Override
            public void deliveryUnreacheable(IMCMessage message) {
                NeptusLog.pub().info((Object)("<###>>>> deliveryUnreacheable: " + message.getAbbrev()));
            }

            @Override
            public void deliveryTimeOut(IMCMessage message) {
                NeptusLog.pub().info((Object)("<###>>>> deliveryTimeOut: " + message.getAbbrev()));
            }

            @Override
            public void deliverySuccess(IMCMessage message) {
                NeptusLog.pub().info((Object)("<###>>>> deliverySuccess: " + message.getAbbrev()));
            }

            @Override
            public void deliveryError(IMCMessage message, Object error) {
                NeptusLog.pub().info((Object)("<###>>>> deliveryError: " + message.getAbbrev() + " " + error));
            }

            @Override
            public void deliveryUncertain(IMCMessage message, Object msg) {
                NeptusLog.pub().info((Object)("<###>>>> deliveryUncertain: " + message.getAbbrev() + " " + msg));
            }
        };
        MessageDeliveryListener mdlT2 = new MessageDeliveryListener(){

            @Override
            public void deliveryUnreacheable(IMCMessage message) {
                System.err.println(">>> deliveryUnreacheable: " + message.getAbbrev());
            }

            @Override
            public void deliveryTimeOut(IMCMessage message) {
                System.err.println(">>> deliveryTimeOut: " + message.getAbbrev());
            }

            @Override
            public void deliverySuccess(IMCMessage message) {
                System.err.println(">>> deliverySuccess: " + message.getAbbrev());
            }

            @Override
            public void deliveryError(IMCMessage message, Object error) {
                System.err.println(">>> deliveryError: " + message.getAbbrev() + " " + error);
            }

            @Override
            public void deliveryUncertain(IMCMessage message, Object msg) {
                System.err.println(">>> deliveryUncertain: " + message.getAbbrev() + " " + msg);
            }
        };
        IMCMessage msg = null;
        IMCMessage msgES = null;
        try {
            msg = IMCDefinition.getInstance().create("Abort", new Object[0]);
            msgES = IMCDefinition.getInstance().create("EstimatedState", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        msg.getHeader().setValue("src", (Object)15394);
        msgES.getHeader().setValue("src", (Object)21);
    }

    static class TCPMessageProcessor
    implements TCPMessageListener,
    Comparable<TCPMessageProcessor> {
        String id = "";
        PipedOutputStream pos;
        PipedInputStream pis;
        boolean isInputClosed = false;
        String host = "";
        int port = 0;
        LinkedHashSet<MessageListener<MessageInfo, IMCMessage>> listeners;
        IMCDefinition imcDefinition;

        public TCPMessageProcessor(String id, LinkedHashSet<MessageListener<MessageInfo, IMCMessage>> listeners, IMCDefinition imcDefinition) {
            this.imcDefinition = imcDefinition;
            this.id = id;
            this.listeners = listeners;
            this.pos = new PipedOutputStream();
            try {
                this.pis = new PipedInputStream(this.pos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            final IMCDefinition imcDef = imcDefinition;
            new Thread(ImcTcpTransport.class.getSimpleName() + " :: " + TCPMessageProcessor.class.getSimpleName() + "(" + this.hashCode() + ")"){

                @Override
                public void run() {
                    try {
                        while (!TCPMessageProcessor.this.isInputClosed && TCPMessageProcessor.this.pis.available() >= 0) {
                            if (TCPMessageProcessor.this.pis.available() == 0) {
                                try {
                                    Thread.sleep(20L);
                                }
                                catch (InterruptedException e) {}
                                continue;
                            }
                            try {
                                IMCMessage msg = imcDef.nextMessage((InputStream)TCPMessageProcessor.this.pis);
                                TCPMessageProcessor.this.msgArrived(msg);
                            }
                            catch (IOException e) {
                                if ("Unrecognized Sync word: 00".equalsIgnoreCase(e.getMessage())) continue;
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }

        public String getId() {
            return this.id;
        }

        @Override
        public void onTCPMessageNotification(TCPNotification req) {
            this.host = req.getAddress().getAddress().getHostAddress();
            this.port = req.getAddress().getPort();
            try {
                if (req.isEosReceived()) {
                    this.isInputClosed = true;
                    this.pos.flush();
                    this.pos.close();
                } else {
                    this.pos.write(req.getBuffer());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void cleanup() {
            try {
                this.pos.flush();
                this.pos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.isInputClosed = true;
        }

        public void msgArrived(IMCMessage msg) {
            MessageInfoImpl info = new MessageInfoImpl();
            info.setPublisher(this.host);
            info.setPublisherInetAddress(this.host);
            info.setPublisherPort(this.port);
            info.setTimeReceivedNanos(System.currentTimeMillis() * 1000000L);
            info.setTimeSentNanos((long)msg.getTimestamp() * 1000000000L);
            info.setProperty("Transport", "TCP");
            for (MessageListener messageListener : this.listeners) {
                try {
                    messageListener.onMessage((MessageInfo)info, (IMessage)msg);
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e);
                }
                catch (Error e) {
                    NeptusLog.pub().error((Object)e);
                }
            }
        }

        @Override
        public int compareTo(TCPMessageProcessor o) {
            return this.id.compareTo(o.id);
        }
    }
}

