/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.transports;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.CommUtil;
import pt.lsts.neptus.comm.manager.imc.MessageDeliveryListener;
import pt.lsts.neptus.comm.transports.DeliveryListener;
import pt.lsts.neptus.comm.transports.udp.UDPMessageListener;
import pt.lsts.neptus.comm.transports.udp.UDPNotification;
import pt.lsts.neptus.comm.transports.udp.UDPTransport;
import pt.lsts.neptus.messages.IMessage;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageInfoImpl;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class ImcUdpTransport {
    private LinkedHashSet<MessageListener<MessageInfo, IMCMessage>> listeners = new LinkedHashSet();
    private IMCDefinition imcDefinition;
    private UDPTransport udpTransport = null;
    private int bindPort = 6001;
    private String multicastAddress = "";
    private boolean broadcastEnable = false;

    public ImcUdpTransport(int bindPort, IMCDefinition imcDefinition) {
        this.imcDefinition = imcDefinition;
        this.bindPort = bindPort;
        this.multicastAddress = "";
        this.getUdpTransport();
        this.setUDPListener();
    }

    public ImcUdpTransport(int bindPort, String multicastAddress, IMCDefinition imcDefinition) {
        this.imcDefinition = imcDefinition;
        this.bindPort = bindPort;
        this.multicastAddress = multicastAddress;
        this.getUdpTransport();
        this.setUDPListener();
    }

    public ImcUdpTransport(int bindPort, boolean broadcastEnable, IMCDefinition imcDefinition) {
        this.imcDefinition = imcDefinition;
        this.bindPort = bindPort;
        this.broadcastEnable = broadcastEnable;
        this.getUdpTransport();
        this.setUDPListener();
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public void setBindPort(int bindPort) {
        this.bindPort = bindPort;
        this.getUdpTransport().setBindPort(bindPort);
    }

    public boolean isRunnning() {
        return this.getUdpTransport().isRunning();
    }

    public String getMulticastAddress() {
        return this.multicastAddress;
    }

    public void setMulticastAddress(String multicastAddress) {
        this.multicastAddress = multicastAddress;
    }

    public boolean isBroadcastEnable() {
        return this.broadcastEnable;
    }

    public void setBroadcastEnable(boolean broadcastEnable) {
        this.broadcastEnable = broadcastEnable;
        this.getUdpTransport().setBroadcastEnable(broadcastEnable);
    }

    private void setUDPListener() {
        this.getUdpTransport().addListener(new UDPMessageListener(){

            @Override
            public void onUDPMessageNotification(UDPNotification req) {
                IMCMessage msg;
                try {
                    msg = ImcUdpTransport.this.imcDefinition.parseMessage(req.getBuffer());
                }
                catch (IOException e) {
                    NeptusLog.pub().warn((Object)(e.getMessage() + " while unpacking message sent from " + req.getAddress().getHostString()));
                    return;
                }
                MessageInfoImpl info = new MessageInfoImpl();
                info.setPublisher(req.getAddress().getAddress().getHostAddress());
                info.setPublisherInetAddress(req.getAddress().getAddress().getHostAddress());
                info.setPublisherPort(req.getAddress().getPort());
                info.setTimeReceivedNanos(req.getTimeMillis() * 1000000L);
                info.setTimeSentNanos((long)msg.getTimestamp() * 1000000000L);
                info.setProperty("Transport", "UDP");
                for (MessageListener lst : ImcUdpTransport.this.listeners) {
                    try {
                        lst.onMessage((MessageInfo)info, (IMessage)msg);
                    }
                    catch (Exception e) {
                        NeptusLog.pub().error((Object)e);
                    }
                    catch (Error e) {
                        NeptusLog.pub().error((Object)e);
                    }
                }
            }
        });
    }

    public UDPTransport getUdpTransport() {
        if (this.udpTransport == null) {
            this.udpTransport = this.broadcastEnable ? new UDPTransport(true, this.bindPort, 1) : (this.multicastAddress == null || "".equalsIgnoreCase(this.multicastAddress) ? new UDPTransport(this.bindPort, 1) : new UDPTransport(this.multicastAddress, this.bindPort, 1));
        }
        return this.udpTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(MessageListener<MessageInfo, IMCMessage> listener) {
        boolean ret = false;
        LinkedHashSet<MessageListener<MessageInfo, IMCMessage>> linkedHashSet = this.listeners;
        synchronized (linkedHashSet) {
            ret = this.listeners.add(listener);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(MessageListener<MessageInfo, IMCMessage> listener) {
        boolean ret = false;
        LinkedHashSet<MessageListener<MessageInfo, IMCMessage>> linkedHashSet = this.listeners;
        synchronized (linkedHashSet) {
            ret = this.listeners.remove(listener);
        }
        return ret;
    }

    public boolean sendMessage(String destination, int port, IMCMessage message) {
        return this.sendMessage(destination, port, message, null);
    }

    public boolean sendMessage(String destination, int port, final IMCMessage message, final MessageDeliveryListener deliveryListener) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IMCOutputStream imcOs = new IMCOutputStream((OutputStream)baos);
        try {
            boolean ret;
            message.serialize(imcOs);
            DeliveryListener listener = null;
            if (deliveryListener != null) {
                listener = new DeliveryListener(){

                    @Override
                    public void deliveryResult(DeliveryListener.ResultEnum result, Exception error) {
                        switch (result) {
                            case Success: {
                                deliveryListener.deliveryUncertain(message, new Exception("Message delivered via UDP"));
                                break;
                            }
                            case Error: {
                                deliveryListener.deliveryError(message, error);
                                break;
                            }
                            case TimeOut: {
                                deliveryListener.deliveryTimeOut(message);
                                break;
                            }
                            case Unreacheable: {
                                deliveryListener.deliveryUnreacheable(message);
                                break;
                            }
                            default: {
                                deliveryListener.deliveryError(message, new Exception("Delivery " + (Object)((Object)DeliveryListener.ResultEnum.UnFinished)));
                            }
                        }
                    }
                };
            }
            if (!(ret = this.getUdpTransport().sendMessage(destination, port, baos.toByteArray(), listener)) && deliveryListener != null) {
                deliveryListener.deliveryError(message, new Exception("Delivery " + (Object)((Object)DeliveryListener.ResultEnum.UnFinished) + " due to closing transport!"));
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            NeptusLog.pub().error((Object)e);
            if (deliveryListener != null) {
                deliveryListener.deliveryError(message, e);
            }
            return false;
        }
    }

    public void stop() {
        this.getUdpTransport().stop();
    }

    public void purge() {
        this.getUdpTransport().purge();
    }

    public void reStart() {
        this.getUdpTransport().reStart();
    }

    public boolean isOnBindError() {
        return this.getUdpTransport().isOnBindError();
    }

    public static void main(String[] args) throws Exception {
        ConfigFetch.initialize();
        ImcUdpTransport udpT = new ImcUdpTransport(2550, IMCDefinition.getInstance());
        udpT.addListener(new MessageListener<MessageInfo, IMCMessage>(){

            public void onMessage(MessageInfo info, IMCMessage msg) {
                info.dump(System.err);
                msg.dump((OutputStream)System.err);
            }
        });
        String multicastAddress = "224.0.75.69";
        String multicastRangePortsStr = "6969-6970";
        int localport = 6969;
        int[] multicastPorts = CommUtil.parsePortRangeFromString(multicastRangePortsStr, new int[]{6969});
        ImcUdpTransport multicastUdpTransport = new ImcUdpTransport(multicastPorts.length == 0 ? localport : multicastPorts[0], multicastAddress, IMCDefinition.getInstance());
        multicastUdpTransport.reStart();
        if (!multicastUdpTransport.isOnBindError()) {
            for (int i = 1; i < multicastPorts.length; ++i) {
                multicastUdpTransport.stop();
                multicastUdpTransport.setBindPort(multicastPorts[i]);
                multicastUdpTransport.reStart();
                if (multicastUdpTransport.isOnBindError()) break;
            }
        }
        multicastUdpTransport.addListener(new MessageListener<MessageInfo, IMCMessage>(){

            public void onMessage(MessageInfo info, IMCMessage msg) {
            }
        });
    }
}

