/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.transports.tcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.transports.DeliveryListener;
import pt.lsts.neptus.comm.transports.tcp.TCPMessageListener;
import pt.lsts.neptus.comm.transports.tcp.TCPNotification;
import pt.lsts.neptus.util.ByteUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class TCPTransport {
    protected LinkedHashSet<TCPMessageListener> listeners = new LinkedHashSet();
    private LinkedBlockingQueue<TCPNotification> receptionMessageList = new LinkedBlockingQueue();
    private LinkedBlockingQueue<TCPNotification> sendmessageList = new LinkedBlockingQueue();
    private Thread sockedListenerThread = null;
    private Thread dispacherThread = null;
    private Thread senderThread = null;
    private LinkedHashMap<String, InetAddress> solvedAddresses = new LinkedHashMap();
    private int bindPort = 7011;
    private int timeoutMillis = 5000;
    private int timeoutSelectorsMillis = 100;
    private int maxBufferSize = 65506;
    private boolean purging = false;
    private ServerSocketChannel serverCh;
    private Selector selector;
    private final Vector<SocketChannel> clients = new Vector();
    private boolean isOnBindError = false;

    public TCPTransport() {
        this.initialize();
    }

    public TCPTransport(int bindPort) {
        this.setBindPort(bindPort);
        this.initialize();
    }

    private void initialize() {
        this.serverCh = null;
        this.selector = null;
        this.createReceivers();
        this.createSenders();
    }

    private void createSenders() {
        this.getSenderThread();
    }

    private void createReceivers() {
        this.getSockedListenerThread();
        this.getDispacherThread();
    }

    public boolean reStart() {
        if (this.isConnected()) {
            return false;
        }
        this.purging = false;
        this.initialize();
        return true;
    }

    protected InetAddress resolveAddress(String multicastAddress) throws UnknownHostException {
        if (!this.solvedAddresses.containsKey(multicastAddress)) {
            this.solvedAddresses.put(multicastAddress, InetAddress.getByName(multicastAddress));
        }
        return this.solvedAddresses.get(multicastAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.isConnected()) {
            this.purging = true;
            if (this.sockedListenerThread != null) {
                this.sockedListenerThread.interrupt();
                this.sockedListenerThread = null;
            }
            LinkedBlockingQueue<TCPNotification> linkedBlockingQueue = this.receptionMessageList;
            synchronized (linkedBlockingQueue) {
                this.receptionMessageList.clear();
            }
            if (this.dispacherThread != null) {
                this.dispacherThread.interrupt();
                this.dispacherThread = null;
            }
            if (this.senderThread != null) {
                this.senderThread.interrupt();
                this.senderThread = null;
            }
            Vector toClearSen = new Vector();
            this.sendmessageList.drainTo(toClearSen);
            for (TCPNotification req : toClearSen) {
                this.informDeliveryListener(req, DeliveryListener.ResultEnum.Error, new Exception("Server shutdown!!"));
            }
        }
    }

    public void purge() {
        this.purging = true;
        while (!this.receptionMessageList.isEmpty() || !this.sendmessageList.isEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketChannel getEstablishedConnectionOrConnect(String host, int port) {
        SocketChannel channel = this.getEstablishedConnection(host, port);
        if (channel == null) {
            try {
                channel = this.createAndConnectSocketChannel(new InetSocketAddress(this.resolveAddress(host), port));
            }
            catch (UnknownHostException e) {
                NeptusLog.pub().error((Object)e.getMessage());
                channel = this.createAndConnectSocketChannel(new InetSocketAddress(host, port));
            }
            if (channel != null) {
                Vector<SocketChannel> vector = this.clients;
                synchronized (vector) {
                    this.clients.add(channel);
                }
            }
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketChannel getEstablishedConnection(String host, int port) {
        SocketChannel channel = null;
        Vector<SocketChannel> vector = this.clients;
        synchronized (vector) {
            for (SocketChannel channelTmp : this.clients) {
                try {
                    if (!this.resolveAddress(host).toString().equalsIgnoreCase(channelTmp.socket().getInetAddress().toString()) || port != channelTmp.socket().getPort()) continue;
                    channel = channelTmp;
                    break;
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
        }
        return channel;
    }

    public boolean connectIfNotConnected(String host, int port) {
        return this.getEstablishedConnectionOrConnect(host, port) != null;
    }

    public boolean isConnectionEstablished(String host, int port) {
        SocketChannel channel = this.getEstablishedConnection(host, port);
        return channel != null;
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public void setBindPort(int bindPort) {
        this.bindPort = bindPort;
    }

    protected void connect() {
        block3: {
            try {
                this.serverCh = ServerSocketChannel.open();
                this.selector = Selector.open();
                this.serverCh.configureBlocking(false);
                this.serverCh.socket().setSoTimeout(this.timeoutMillis);
                this.serverCh.socket().bind(new InetSocketAddress(this.getBindPort()));
                this.serverCh.register(this.selector, 16);
                this.isOnBindError = false;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    this.isOnBindError = true;
                }
                if (this.serverCh == null) break block3;
                this.disconnect();
            }
        }
    }

    private SocketChannel createAndConnectSocketChannel(InetSocketAddress address) {
        try {
            SocketChannel channel = SocketChannel.open();
            channel.socket().setSoTimeout(this.timeoutMillis);
            try {
                channel.socket().setKeepAlive(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            channel.configureBlocking(false);
            channel.connect(address);
            while (!channel.finishConnect()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e1) {
                    NeptusLog.pub().error((Object)e1.getMessage());
                }
            }
            this.selector.wakeup();
            channel.register(this.selector, 5);
            return channel;
        }
        catch (Exception e) {
            if (e instanceof NoRouteToHostException || e instanceof ConnectException) {
                NeptusLog.pub().warn((Object)(e.toString() + ": " + address));
            } else {
                NeptusLog.pub().error((Object)e);
            }
            return null;
        }
    }

    private boolean checkConnected() {
        return this.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        Vector<SocketChannel> vector;
        this.isConnected();
        try {
            if (this.selector != null) {
                this.selector.close();
            }
            vector = this.clients;
            synchronized (vector) {
                for (SocketChannel channel : this.clients) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        NeptusLog.pub().error((Object)e.getStackTrace());
                    }
                }
            }
            this.serverCh.close();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
        this.serverCh = null;
        this.selector = null;
        vector = this.clients;
        synchronized (vector) {
            this.clients.clear();
        }
        this.purging = true;
    }

    private boolean isConnected() {
        return this.serverCh != null || this.sockedListenerThread != null || this.dispacherThread != null;
    }

    public boolean isRunning() {
        return this.isConnected();
    }

    public boolean isRunningNormally() {
        if (this.isOnBindError()) {
            return false;
        }
        return this.serverCh != null && this.sockedListenerThread != null && this.dispacherThread != null;
    }

    public boolean isOnBindError() {
        return this.isOnBindError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(TCPMessageListener listener) {
        LinkedHashSet<TCPMessageListener> linkedHashSet = this.listeners;
        synchronized (linkedHashSet) {
            boolean ret = this.listeners.add(listener);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(TCPMessageListener listener) {
        LinkedHashSet<TCPMessageListener> linkedHashSet = this.listeners;
        synchronized (linkedHashSet) {
            boolean ret = this.listeners.remove(listener);
            return ret;
        }
    }

    private Thread getSockedListenerThread() {
        if (this.sockedListenerThread == null) {
            Thread listenerThread = new Thread(TCPTransport.class.getSimpleName() + ": Listener Thread " + this.hashCode()){
                byte[] sBuffer;
                {
                    this.sBuffer = new byte[TCPTransport.this.maxBufferSize];
                }

                @Override
                public synchronized void start() {
                    NeptusLog.pub().debug((Object)"Listener Thread Started");
                    try {
                        TCPTransport.this.connect();
                    }
                    catch (Exception e) {
                        NeptusLog.pub().error((Object)e);
                        return;
                    }
                    super.start();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    try {
                        long time = System.currentTimeMillis();
                        long previousConnectedClients = -1L;
                        while (!TCPTransport.this.purging) {
                            TCPTransport.this.checkConnected();
                            int lengthReceived = 0;
                            try {
                                if (System.currentTimeMillis() - time > 10000L && previousConnectedClients != (long)TCPTransport.this.clients.size()) {
                                    NeptusLog.pub().debug((Object)(TCPTransport.class.getSimpleName() + ": Listener Thread " + TCPTransport.this.getBindPort() + " now " + TCPTransport.this.clients.size() + " clients"));
                                    time = System.currentTimeMillis();
                                    previousConnectedClients = TCPTransport.this.clients.size();
                                }
                                Vector vector = TCPTransport.this.clients;
                                // MONITORENTER : vector
                                for (SocketChannel channel : TCPTransport.this.clients.toArray(new SocketChannel[0])) {
                                    if (!channel.isOpen()) {
                                        channel.close();
                                        TCPTransport.this.clients.remove(channel);
                                        continue;
                                    }
                                    try {
                                        Object obj = channel.keyFor(TCPTransport.this.selector).attachment();
                                        if (obj == null) continue;
                                        long lastTime = (Long)obj;
                                        if (System.currentTimeMillis() - lastTime <= 20000L) continue;
                                        channel.close();
                                        channel.keyFor(TCPTransport.this.selector).cancel();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                // MONITOREXIT : vector
                                if (TCPTransport.this.selector.select(TCPTransport.this.timeoutSelectorsMillis) == 0) continue;
                                Iterator<SelectionKey> it = TCPTransport.this.selector.selectedKeys().iterator();
                                while (it.hasNext()) {
                                    SelectionKey key = it.next();
                                    it.remove();
                                    if (!key.isValid()) {
                                        if (key.channel() instanceof SocketChannel) {
                                            key.channel().close();
                                            Vector len$ = TCPTransport.this.clients;
                                            // MONITORENTER : len$
                                            TCPTransport.this.clients.remove(key.channel());
                                            // MONITOREXIT : len$
                                        }
                                    } else if ((key.readyOps() & 0x10) == 16) {
                                        SocketChannel channel = TCPTransport.this.serverCh.accept();
                                        if (channel == null) continue;
                                        channel.configureBlocking(false);
                                        channel.socket().setSoTimeout(TCPTransport.this.timeoutMillis);
                                        try {
                                            channel.socket().setKeepAlive(true);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        channel.register(TCPTransport.this.selector, 5);
                                        key.attach(System.currentTimeMillis());
                                        Vector e = TCPTransport.this.clients;
                                        // MONITORENTER : e
                                        TCPTransport.this.clients.add(channel);
                                        // MONITOREXIT : e
                                    } else if ((key.readyOps() & 1) == 1) {
                                        TCPNotification info;
                                        SocketChannel channel = (SocketChannel)key.channel();
                                        InetAddress dd = channel.socket().getInetAddress();
                                        int pp = channel.socket().getPort();
                                        try {
                                            Object recBytes;
                                            lengthReceived = channel.read(ByteBuffer.wrap(this.sBuffer, 0, this.sBuffer.length));
                                            if (lengthReceived != -1) {
                                                recBytes = Arrays.copyOf(this.sBuffer, lengthReceived);
                                                info = new TCPNotification(true, new InetSocketAddress(dd, pp), (byte[])recBytes, System.currentTimeMillis());
                                            } else {
                                                info = new TCPNotification(true, new InetSocketAddress(dd, pp), true, System.currentTimeMillis());
                                                Vector vector2 = TCPTransport.this.clients;
                                                recBytes = vector2;
                                                // MONITORENTER : vector2
                                                TCPTransport.this.clients.remove(channel);
                                                // MONITOREXIT : recBytes
                                                channel.close();
                                            }
                                            TCPTransport.this.receptionMessageList.offer(info);
                                            NeptusLog.pub().debug((Object)(TCPTransport.class.getSimpleName() + ": Listener Thread " + ">>> Channel: " + channel + " READ " + lengthReceived + "B"));
                                        }
                                        catch (IOException e) {
                                            Vector vector3 = TCPTransport.this.clients;
                                            // MONITORENTER : vector3
                                            TCPTransport.this.clients.remove(channel);
                                            // MONITOREXIT : vector3
                                            NeptusLog.pub().info((Object)(TCPTransport.class.getSimpleName() + ": Listener Thread " + "Lost touch with " + channel + " -> " + e.getMessage()));
                                            channel.close();
                                            info = new TCPNotification(true, new InetSocketAddress(dd, pp), true, System.currentTimeMillis());
                                            TCPTransport.this.receptionMessageList.offer(info);
                                        }
                                        key.attach(System.currentTimeMillis());
                                    } else if ((key.readyOps() & 4) == 4) {
                                        try {
                                            boolean sendAck = true;
                                            Object obj = key.attachment();
                                            if (obj != null) {
                                                try {
                                                    long lastTime = (Long)obj;
                                                    if (System.currentTimeMillis() - lastTime < 2000L) {
                                                        sendAck = false;
                                                    }
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                            if (sendAck) {
                                                SocketChannel channel = (SocketChannel)key.channel();
                                                ByteBuffer bf = ByteBuffer.wrap(new byte[]{-1});
                                                channel.write(bf);
                                                key.attach(System.currentTimeMillis());
                                            }
                                        }
                                        catch (IOException e) {
                                            NeptusLog.pub().error((Object)e.getMessage());
                                            SocketChannel channel = (SocketChannel)key.channel();
                                            channel.close();
                                            key.cancel();
                                        }
                                    }
                                    try {
                                        Thread.sleep(10L);
                                    }
                                    catch (Exception e) {
                                        NeptusLog.pub().error((Object)e.getMessage());
                                    }
                                }
                            }
                            catch (IOException e) {
                                NeptusLog.pub().error((Object)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        NeptusLog.pub().error((Object)e);
                        e.printStackTrace();
                    }
                    NeptusLog.pub().warn((Object)(this + " Thread Stopped"));
                    TCPTransport.this.disconnect();
                }
            };
            listenerThread.setPriority(1);
            listenerThread.setDaemon(true);
            listenerThread.start();
            this.sockedListenerThread = listenerThread;
        }
        return this.sockedListenerThread;
    }

    private Thread getDispacherThread() {
        if (this.dispacherThread == null) {
            Thread listenerThread = new Thread(TCPTransport.class.getSimpleName() + ": Dispacher Thread " + this.hashCode()){

                @Override
                public synchronized void start() {
                    NeptusLog.pub().debug((Object)"Dispacher Thread Started");
                    super.start();
                }

                @Override
                public void run() {
                    try {
                        while (!TCPTransport.this.purging || !TCPTransport.this.receptionMessageList.isEmpty()) {
                            TCPNotification req = (TCPNotification)TCPTransport.this.receptionMessageList.poll(1L, TimeUnit.SECONDS);
                            if (req == null) continue;
                            for (TCPMessageListener lst : TCPTransport.this.listeners) {
                                try {
                                    lst.onTCPMessageNotification(req);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                catch (Error e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        NeptusLog.pub().warn((Object)e.getMessage());
                    }
                    NeptusLog.pub().info((Object)(this + " Thread Stopped"));
                }
            };
            listenerThread.setPriority(2);
            listenerThread.setDaemon(true);
            listenerThread.start();
            this.dispacherThread = listenerThread;
        }
        return this.dispacherThread;
    }

    private Thread getSenderThread() {
        if (this.senderThread == null) {
            this.senderThread = new Thread(TCPTransport.class.getSimpleName() + ": Sender Thread " + this.hashCode()){
                TCPNotification req;

                @Override
                public synchronized void start() {
                    NeptusLog.pub().info((Object)"Sender Thread Started");
                    super.start();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        while (!TCPTransport.this.purging || !TCPTransport.this.sendmessageList.isEmpty()) {
                            this.req = (TCPNotification)TCPTransport.this.sendmessageList.poll(1L, TimeUnit.SECONDS);
                            if (this.req == null) continue;
                            SocketChannel channel = null;
                            try {
                                channel = TCPTransport.this.getEstablishedConnectionOrConnect(this.req.getAddress().getHostName(), this.req.getAddress().getPort());
                                if (channel == null) {
                                    TCPTransport.this.informDeliveryListener(this.req, DeliveryListener.ResultEnum.Error, new IOException("Not able to get a connection to " + this.req.getAddress().getHostName() + ":" + this.req.getAddress().getPort()));
                                    continue;
                                }
                                ByteBuffer bbuf = ByteBuffer.wrap(this.req.getBuffer());
                                int writtenBytes = channel.write(bbuf);
                                if (writtenBytes != this.req.getBuffer().length) {
                                    TCPTransport.this.informDeliveryListener(this.req, DeliveryListener.ResultEnum.Error, null);
                                    Vector vector = TCPTransport.this.clients;
                                    synchronized (vector) {
                                        try {
                                            channel.close();
                                        }
                                        catch (IOException e1) {
                                            e1.printStackTrace();
                                        }
                                        TCPTransport.this.clients.remove(channel);
                                        continue;
                                    }
                                }
                                TCPTransport.this.informDeliveryListener(this.req, DeliveryListener.ResultEnum.Success, null);
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                                TCPTransport.this.informDeliveryListener(this.req, DeliveryListener.ResultEnum.Error, e);
                                if (channel == null) continue;
                                Vector vector = TCPTransport.this.clients;
                                synchronized (vector) {
                                    try {
                                        channel.close();
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                    TCPTransport.this.clients.remove(channel);
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        NeptusLog.pub().warn((Object)(this + " Thread interrupted"));
                        TCPTransport.this.informDeliveryListener(this.req, DeliveryListener.ResultEnum.Error, e);
                    }
                    NeptusLog.pub().debug((Object)(this + " Sender Thread Stopped"));
                }
            };
            this.senderThread.setPriority(1);
            this.senderThread.setDaemon(true);
            this.senderThread.start();
        }
        return this.senderThread;
    }

    public boolean sendMessage(String destination, int port, byte[] buffer) {
        return this.sendMessage(destination, port, buffer, null);
    }

    public boolean sendMessage(String destination, int port, byte[] buffer, DeliveryListener deliveryListener) {
        if (this.purging) {
            String txt = "Not accepting any more messages. IMCMessenger is terminating";
            NeptusLog.pub().error((Object)txt);
            if (deliveryListener != null) {
                deliveryListener.deliveryResult(DeliveryListener.ResultEnum.UnFinished, new IOException(txt));
            }
            return false;
        }
        try {
            TCPNotification req = new TCPNotification(false, new InetSocketAddress(this.resolveAddress(destination), port), buffer);
            req.setDeliveryListener(deliveryListener);
            this.sendmessageList.add(req);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            if (deliveryListener != null) {
                deliveryListener.deliveryResult(DeliveryListener.ResultEnum.Unreacheable, e);
            }
            return false;
        }
        return true;
    }

    private void informDeliveryListener(TCPNotification req, DeliveryListener.ResultEnum result, Exception e) {
        if (req != null && req.getDeliveryListener() != null) {
            req.getDeliveryListener().deliveryResult(result, e);
        }
    }

    public long getActiveNumberOfConnections() {
        return this.clients.size();
    }

    public static void main(String[] args) throws Exception {
        ConfigFetch.initialize();
        final HashMap listProc = new HashMap();
        TCPTransport tcp = new TCPTransport(8082);
        tcp.addListener(new TCPMessageListener(){

            @Override
            public void onTCPMessageNotification(TCPNotification req) {
                String id = req.getAddress().toString();
                TCPMessageProcessor proc = (TCPMessageProcessor)listProc.get(id);
                if (proc == null) {
                    proc = new TCPMessageProcessor(id);
                    listProc.put(id, proc);
                }
                if (req.isEosReceived()) {
                    listProc.remove(id);
                }
                proc.onTCPMessageNotification(req);
                ByteUtil.dumpAsHex(req.getBuffer(), System.out);
            }
        });
        TCPTransport tcp2 = new TCPTransport(8083);
        tcp2.addListener(new TCPMessageListener(){

            @Override
            public void onTCPMessageNotification(TCPNotification req) {
                String id = req.getAddress().toString();
                TCPMessageProcessor proc = (TCPMessageProcessor)listProc.get(id);
                if (proc == null) {
                    proc = new TCPMessageProcessor(id);
                    listProc.put(id, proc);
                }
                if (req.isEosReceived()) {
                    listProc.remove(id);
                }
                proc.onTCPMessageNotification(req);
                ByteUtil.dumpAsHex(req.getBuffer(), System.err);
            }
        });
        IMCMessage msg = IMCDefinition.getInstance().create("Heartbeat", new Object[0]);
        IMCMessage msgES = IMCDefinition.getInstance().create("EstimatedState", new Object[0]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IMCOutputStream imcos = new IMCOutputStream((OutputStream)baos);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        IMCOutputStream imcos2 = new IMCOutputStream((OutputStream)baos2);
        msg.getHeader().setValue("src", (Object)15394);
        msgES.getHeader().setValue("src", (Object)21);
        int size = msg.serialize(imcos);
        int size2 = msgES.serialize(imcos2);
    }

    private static class TCPMessageProcessor
    implements TCPMessageListener,
    Comparable<TCPMessageProcessor> {
        String id = "";
        PipedOutputStream pos;
        PipedInputStream pis;
        boolean isInputClosed = false;

        public TCPMessageProcessor(String id) {
            this.id = id;
            this.pos = new PipedOutputStream();
            try {
                this.pis = new PipedInputStream(this.pos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            final IMCDefinition imcDef = IMCDefinition.getInstance();
            new Thread(){

                @Override
                public void run() {
                    try {
                        while (!TCPMessageProcessor.this.isInputClosed && TCPMessageProcessor.this.pis.available() >= 0) {
                            if (TCPMessageProcessor.this.pis.available() == 0) {
                                try {
                                    Thread.sleep(20L);
                                }
                                catch (InterruptedException e) {}
                                continue;
                            }
                            try {
                                IMCMessage msg = imcDef.nextMessage((InputStream)TCPMessageProcessor.this.pis);
                                msg.dump((OutputStream)System.out);
                                TCPMessageProcessor.this.msgArrived(msg);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    NeptusLog.pub().info((Object)"<###>pis.available()------------");
                    try {
                        NeptusLog.pub().info((Object)("<###>pis.available()" + TCPMessageProcessor.this.pis.available()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }

        @Override
        public void onTCPMessageNotification(TCPNotification req) {
            try {
                if (req.isEosReceived()) {
                    this.pos.flush();
                    this.pos.close();
                    this.isInputClosed = true;
                    NeptusLog.pub().info((Object)"<###>POS Closed");
                } else {
                    this.pos.write(req.getBuffer());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void msgArrived(IMCMessage message) {
            message.dump((OutputStream)System.out);
        }

        @Override
        public int compareTo(TCPMessageProcessor o) {
            return this.id.compareTo(o.id);
        }
    }
}

