/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.transports.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.transports.DeliveryListener;
import pt.lsts.neptus.comm.transports.udp.UDPMessageListener;
import pt.lsts.neptus.comm.transports.udp.UDPNotification;
import pt.lsts.neptus.util.ByteUtil;

public class UDPTransport {
    protected LinkedHashSet<UDPMessageListener> listeners = new LinkedHashSet();
    private LinkedBlockingQueue<UDPNotification> receptionMessageList = new LinkedBlockingQueue();
    private LinkedBlockingQueue<UDPNotification> sendmessageList = new LinkedBlockingQueue();
    private Thread sockedListenerThread = null;
    private Thread dispacherThread = null;
    private Vector<Thread> senderThreads = new Vector();
    private int numberOfSenderThreads = 1;
    private DatagramSocket sock;
    private LinkedHashMap<String, InetAddress> solvedAddresses = new LinkedHashMap();
    private int bindPort = 6001;
    private int timeoutMillis = 1000;
    private int maxBufferSize = 65507;
    private boolean purging = false;
    private boolean broadcastEnable = false;
    private boolean broadcastActive = false;
    private boolean multicastEnable = false;
    private boolean multicastActive = false;
    private String multicastAddress = "224.0.75.69";
    private boolean isOnBindError = false;

    public UDPTransport() {
        this.initialize();
    }

    public UDPTransport(int numberOfSenderThreads) {
        this.numberOfSenderThreads = numberOfSenderThreads;
        this.initialize();
    }

    public UDPTransport(int bindPort, int numberOfSenderThreads) {
        this.setBindPort(bindPort);
        this.initialize();
    }

    public UDPTransport(boolean isBroadcastEnable, int bindPort, int numberOfSenderThreads) {
        this.setBindPort(bindPort);
        this.setBroadcastEnable(isBroadcastEnable);
        this.initialize();
    }

    public UDPTransport(String multicastAddress, int bindPort, int numberOfSenderThreads) {
        this.setNumberOfSenderThreads(numberOfSenderThreads);
        this.setBindPort(bindPort);
        this.setMulticastAddress(multicastAddress);
        this.setMulticastEnable(true);
        this.initialize();
    }

    public UDPTransport(String multicastAddress, int bindPort) {
        this(multicastAddress, bindPort, 1);
    }

    private void initialize() {
        this.createReceivers();
        this.createSenders();
    }

    public boolean isOnBindError() {
        return this.isOnBindError;
    }

    private void setOnBindError(boolean isOnBindError) {
        this.isOnBindError = isOnBindError;
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public void setBindPort(int bindPort) {
        this.bindPort = bindPort;
    }

    public String getMulticastAddress() {
        return this.multicastAddress;
    }

    public void setMulticastAddress(String multicastAddress) {
        this.multicastAddress = multicastAddress;
    }

    public boolean isMulticastEnable() {
        return this.multicastEnable;
    }

    public void setMulticastEnable(boolean multicastEnable) {
        this.multicastEnable = multicastEnable;
    }

    protected boolean isMulticastActive() {
        return this.multicastActive;
    }

    protected void setMulticastActive(boolean multicastActive) {
        this.multicastActive = multicastActive;
    }

    public boolean isBroadcastEnable() {
        return this.broadcastEnable;
    }

    public void setBroadcastEnable(boolean broadcastEnable) {
        this.broadcastEnable = broadcastEnable;
    }

    protected boolean isBroadcastActive() {
        return this.broadcastActive;
    }

    protected void setBroadcastActive(boolean broadcastActive) {
        this.broadcastActive = broadcastActive;
    }

    public int getNumberOfSenderThreads() {
        return this.numberOfSenderThreads;
    }

    public void setNumberOfSenderThreads(int numberOfSenderThreads) {
        this.numberOfSenderThreads = numberOfSenderThreads;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    protected InetAddress resolveAddress(String multicastAddress) throws UnknownHostException {
        if (!this.solvedAddresses.containsKey(multicastAddress)) {
            this.solvedAddresses.put(multicastAddress, InetAddress.getByName(multicastAddress));
        }
        return this.solvedAddresses.get(multicastAddress);
    }

    public boolean reStart() {
        if (this.isStopping() || this.isRunning()) {
            return false;
        }
        this.purging = false;
        this.createReceivers();
        this.createSenders();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.isRunning()) {
            this.purging = true;
            if (this.sockedListenerThread != null) {
                this.sockedListenerThread.interrupt();
                this.sockedListenerThread = null;
            }
            LinkedBlockingQueue<UDPNotification> linkedBlockingQueue = this.receptionMessageList;
            synchronized (linkedBlockingQueue) {
                this.receptionMessageList.clear();
            }
            if (this.dispacherThread != null) {
                this.dispacherThread.interrupt();
                this.dispacherThread = null;
            }
            int size = this.senderThreads.size();
            for (int i = 0; i < size; ++i) {
                try {
                    this.senderThreads.get(0).interrupt();
                    this.senderThreads.remove(0);
                    continue;
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e.getMessage());
                }
            }
            Vector toClearSen = new Vector();
            this.sendmessageList.drainTo(toClearSen);
            for (UDPNotification req : toClearSen) {
                this.informDeliveryListener(req, DeliveryListener.ResultEnum.Error, new Exception("Server shutdown!!"));
            }
        }
    }

    public void purge() {
        this.purging = true;
        while (!this.receptionMessageList.isEmpty() || !this.sendmessageList.isEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.stop();
    }

    public boolean isRunning() {
        if (this.senderThreads.size() > 0) {
            return true;
        }
        return this.sockedListenerThread != null || this.dispacherThread != null;
    }

    public boolean isRunningNormally() {
        if (this.isOnBindError()) {
            return false;
        }
        if (this.senderThreads.size() == 0) {
            return false;
        }
        if (this.sockedListenerThread == null) {
            return false;
        }
        return this.dispacherThread != null;
    }

    public boolean isStopping() {
        return this.isRunning() && this.purging;
    }

    private void createSenders() {
        this.senderThreads.clear();
        for (int i = 0; i < this.numberOfSenderThreads; ++i) {
            if (i == 0) {
                this.senderThreads.add(this.getSenderThread(this.sock));
                continue;
            }
            this.senderThreads.add(this.getSenderThread(null));
        }
    }

    private void createReceivers() {
        this.setOnBindError(false);
        this.getSockedListenerThread();
        this.getDispacherThread();
    }

    private Thread getSockedListenerThread() {
        if (this.sockedListenerThread == null) {
            Thread listenerThread = new Thread(UDPTransport.class.getSimpleName() + ": Listener Thread " + this.hashCode()){
                byte[] sBuffer;
                String multicastGroup;
                {
                    this.sBuffer = new byte[UDPTransport.this.maxBufferSize];
                    this.multicastGroup = "";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public synchronized void start() {
                    NeptusLog.pub().debug((Object)"Listener Thread Started");
                    try {
                        boolean useMulticast = UDPTransport.this.isMulticastEnable();
                        UDPTransport.this.sock = !useMulticast ? new DatagramSocket(null) : new MulticastSocket(null);
                        UDPTransport.this.sock.setReuseAddress(false);
                        if (UDPTransport.this.bindPort != 0) {
                            UDPTransport.this.sock.bind(new InetSocketAddress(UDPTransport.this.bindPort));
                        } else {
                            UDPTransport.this.sock.bind(new InetSocketAddress(0));
                        }
                        try {
                            if (useMulticast) {
                                ((MulticastSocket)UDPTransport.this.sock).joinGroup(UDPTransport.this.resolveAddress(UDPTransport.this.getMulticastAddress()));
                                this.multicastGroup = UDPTransport.this.getMulticastAddress();
                            }
                            UDPTransport.this.setMulticastActive(useMulticast);
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)("Multicast socket join :: " + e.getMessage()));
                            UDPTransport.this.setMulticastActive(false);
                        }
                        UDPTransport.this.sock.setSoTimeout(UDPTransport.this.timeoutMillis);
                        if (UDPTransport.this.isBroadcastEnable()) {
                            try {
                                UDPTransport.this.sock.setBroadcast(true);
                                UDPTransport.this.setBroadcastActive(true);
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e.getMessage());
                                UDPTransport.this.setBroadcastActive(false);
                            }
                        }
                    }
                    catch (Exception e) {
                        NeptusLog.pub().error((Object)e);
                        UDPTransport.this.setOnBindError(true);
                        return;
                    }
                    finally {
                        if (UDPTransport.this.isOnBindError()) {
                            try {
                                UDPTransport.this.sock.disconnect();
                                UDPTransport.this.sock.close();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e.getStackTrace());
                            }
                        }
                    }
                    super.start();
                }

                @Override
                public void run() {
                    block10: while (true) {
                        try {
                            while (!UDPTransport.this.purging) {
                                DatagramPacket packet = new DatagramPacket(this.sBuffer, this.sBuffer.length);
                                try {
                                    UDPTransport.this.sock.receive(packet);
                                    int lengthReceived = packet.getLength();
                                    try {
                                        byte[] recBytes = Arrays.copyOf(this.sBuffer, lengthReceived);
                                        UDPNotification info = new UDPNotification(true, (InetSocketAddress)packet.getSocketAddress(), recBytes, System.currentTimeMillis());
                                        UDPTransport.this.receptionMessageList.offer(info);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    continue block10;
                                }
                                catch (SocketTimeoutException e) {
                                }
                                catch (Exception e) {
                                    NeptusLog.pub().error((Object)e);
                                    e.printStackTrace();
                                }
                                catch (Error e) {
                                    NeptusLog.pub().error((Object)e);
                                    e.printStackTrace();
                                }
                            }
                            break;
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                            break;
                        }
                    }
                    NeptusLog.pub().warn((Object)(this + " Thread Stopped"));
                    if (UDPTransport.this.isMulticastActive()) {
                        try {
                            ((MulticastSocket)UDPTransport.this.sock).leaveGroup(UDPTransport.this.resolveAddress(this.multicastGroup));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    UDPTransport.this.sock.disconnect();
                    UDPTransport.this.sock.close();
                    UDPTransport.this.sock = null;
                    UDPTransport.this.sockedListenerThread = null;
                }
            };
            listenerThread.setPriority(1);
            listenerThread.setDaemon(true);
            listenerThread.start();
            this.sockedListenerThread = listenerThread;
        }
        return this.sockedListenerThread;
    }

    private Thread getDispacherThread() {
        if (this.dispacherThread == null) {
            Thread listenerThread = new Thread(UDPTransport.class.getSimpleName() + ": Dispacher Thread " + this.hashCode()){

                @Override
                public synchronized void start() {
                    NeptusLog.pub().debug((Object)"Dispacher Thread Started");
                    super.start();
                }

                @Override
                public void run() {
                    try {
                        while (!UDPTransport.this.purging || !UDPTransport.this.receptionMessageList.isEmpty()) {
                            UDPNotification req = (UDPNotification)UDPTransport.this.receptionMessageList.poll(1L, TimeUnit.SECONDS);
                            if (req == null) continue;
                            for (UDPMessageListener lst : UDPTransport.this.listeners) {
                                try {
                                    lst.onUDPMessageNotification(req);
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    NeptusLog.pub().debug((Object)("Dispacher Thread: ArrayIndexOutOfBoundsException: onUDPMessageNotification " + e.getMessage()));
                                }
                                catch (Exception e) {
                                    String addStr = "";
                                    if (req != null && req.getBuffer() != null && (addStr = ByteUtil.dumpAsHexToString(req.getAddress().toString(), req.getBuffer())) != null && !"".equalsIgnoreCase(addStr)) {
                                        addStr = "Buffer:\n" + addStr;
                                    }
                                    NeptusLog.pub().error((Object)("Dispacher Thread: Exception: onUDPMessageNotification " + e.getMessage() + addStr), (Throwable)e);
                                }
                                catch (Error e) {
                                    NeptusLog.pub().fatal((Object)("Dispacher Thread: Error: onUDPMessageNotification " + e.getMessage()), (Throwable)e);
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        NeptusLog.pub().debug((Object)(this + " Thread interrupted"));
                    }
                    NeptusLog.pub().info((Object)(this + " Thread Stopped"));
                    UDPTransport.this.dispacherThread = null;
                }
            };
            listenerThread.setPriority(2);
            listenerThread.setDaemon(true);
            listenerThread.start();
            this.dispacherThread = listenerThread;
        }
        return this.dispacherThread;
    }

    private Thread getSenderThread(final DatagramSocket sockToUseAlreadyOpen) {
        Thread senderThread = new Thread(UDPTransport.class.getSimpleName() + ": Sender Thread " + this.hashCode()){
            DatagramSocket sock;
            DatagramPacket dgram;
            UDPNotification req;

            @Override
            public synchronized void start() {
                NeptusLog.pub().debug((Object)"Sender Thread Started");
                try {
                    this.sock = sockToUseAlreadyOpen != null ? sockToUseAlreadyOpen : new DatagramSocket();
                    super.start();
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void run() {
                try {
                    while (!UDPTransport.this.purging || !UDPTransport.this.sendmessageList.isEmpty()) {
                        this.req = (UDPNotification)UDPTransport.this.sendmessageList.poll(1L, TimeUnit.SECONDS);
                        if (this.req == null) continue;
                        try {
                            this.dgram = new DatagramPacket(this.req.getBuffer(), this.req.getBuffer().length, this.req.getAddress());
                            if (this.req.getAddress().getPort() != 0) {
                                this.sock.send(this.dgram);
                                UDPTransport.this.informDeliveryListener(this.req, DeliveryListener.ResultEnum.Success, null);
                                continue;
                            }
                            throw new Exception(this.req.getAddress() + " port is not valid");
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)(e + " :: " + this.req.getAddress()));
                            UDPTransport.this.informDeliveryListener(this.req, DeliveryListener.ResultEnum.Error, e);
                        }
                    }
                }
                catch (InterruptedException e) {
                    NeptusLog.pub().debug((Object)(this + " Thread interrupted"));
                    UDPTransport.this.informDeliveryListener(this.req, DeliveryListener.ResultEnum.Error, e);
                }
                NeptusLog.pub().info((Object)(this + " Sender Thread Stopped"));
                UDPTransport.this.senderThreads.remove(this);
            }
        };
        senderThread.setPriority(1);
        senderThread.setDaemon(true);
        senderThread.start();
        return senderThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(UDPMessageListener listener) {
        LinkedHashSet<UDPMessageListener> linkedHashSet = this.listeners;
        synchronized (linkedHashSet) {
            boolean ret = this.listeners.add(listener);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(UDPMessageListener listener) {
        LinkedHashSet<UDPMessageListener> linkedHashSet = this.listeners;
        synchronized (linkedHashSet) {
            boolean ret = this.listeners.remove(listener);
            return ret;
        }
    }

    public boolean sendMessage(String destination, int port, byte[] buffer) {
        return this.sendMessage(destination, port, buffer, null);
    }

    public boolean sendMessage(String destination, int port, byte[] buffer, DeliveryListener deliveryListener) {
        if (this.purging) {
            String txt = "Not accepting any more messages. IMCMessenger is terminating";
            NeptusLog.pub().error((Object)txt);
            if (deliveryListener != null) {
                deliveryListener.deliveryResult(DeliveryListener.ResultEnum.UnFinished, new IOException(txt));
            }
            return false;
        }
        try {
            UDPNotification req = new UDPNotification(false, new InetSocketAddress(this.resolveAddress(destination), port), buffer);
            req.setDeliveryListener(deliveryListener);
            this.sendmessageList.add(req);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            if (deliveryListener != null) {
                deliveryListener.deliveryResult(DeliveryListener.ResultEnum.Unreacheable, e);
            }
            return false;
        }
        return true;
    }

    private void informDeliveryListener(UDPNotification req, DeliveryListener.ResultEnum result, Exception e) {
        if (req != null && req.getDeliveryListener() != null) {
            req.getDeliveryListener().deliveryResult(result, e);
        }
    }

    public static void main(String[] args) throws Exception {
        UDPTransport udpTB1 = new UDPTransport(7969, 1);
        final UDPTransport udpTB = new UDPTransport(true, 6001, 1);
        udpTB.addListener(new UDPMessageListener(){

            @Override
            public void onUDPMessageNotification(UDPNotification req) {
                System.err.println(udpTB.isBroadcastActive() + " Received " + req.getBuffer().length + " bytes from " + req.getAddress() + " :: ");
                NeptusLog.pub().info((Object)("<###> " + udpTB.receptionMessageList.size()));
            }
        });
    }
}

