/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import pt.lsts.imc.state.ImcSysState;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.console.plugins.PlanChangeListener;
import pt.lsts.neptus.events.NeptusEvents;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.plugins.update.PeriodicUpdatesService;
import pt.lsts.neptus.util.ImageUtils;

public abstract class AbstractConsolePlugin
implements PropertiesProvider {
    private ConsoleLayout console;
    private ImageIcon icon;
    private Collection<IPeriodicUpdates> periodicMethods = null;

    @Override
    public final DefaultProperty[] getProperties() {
        return PluginUtils.getPluginProperties(this);
    }

    @Override
    public final void setProperties(Property[] properties) {
        PluginUtils.setPluginProperties((Object)this, properties);
    }

    @Override
    public final String getPropertiesDialogTitle() {
        return PluginUtils.getPluginName(this.getClass()) + " parameters";
    }

    @Override
    public final String[] getPropertiesErrors(Property[] properties) {
        return PluginUtils.validatePluginProperties((Object)this, properties);
    }

    public Element asElement(String rootElement) {
        Document doc = null;
        doc = DocumentHelper.createDocument();
        Element root = doc.addElement(rootElement);
        root.addAttribute("class", this.getClass().getName());
        Element properties = root.addElement("properties");
        String xml = PluginUtils.getConfigXml(this);
        try {
            Element el = DocumentHelper.parseText((String)xml).getRootElement();
            for (Object child : el.elements()) {
                Element aux = (Element)child;
                aux.detach();
                properties.add(aux);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return root;
    }

    public void parseXmlElement(Element elem) {
        PluginUtils.setConfigXml(this, elem.element("properties").asXML());
    }

    public String getName() {
        return PluginUtils.getPluginName(this.getClass());
    }

    public void init(ConsoleLayout console) {
        this.console = console;
        if (this instanceof MissionChangeListener) {
            this.getConsole().addMissionListener((MissionChangeListener)((Object)this));
        }
        if (this instanceof PlanChangeListener) {
            this.getConsole().addPlanListener((PlanChangeListener)((Object)this));
        }
        if (this instanceof IPeriodicUpdates) {
            PeriodicUpdatesService.register((IPeriodicUpdates)((Object)this));
        }
        this.periodicMethods = PeriodicUpdatesService.inspect(this);
        for (IPeriodicUpdates i : this.periodicMethods) {
            PeriodicUpdatesService.register(i);
        }
        NeptusEvents.register(this, console);
        ImcMsgManager.registerBusListener(this);
    }

    public void clean() {
        NeptusEvents.unregister(this, this.getConsole());
        if (this instanceof MissionChangeListener) {
            this.getConsole().removeMissionListener((MissionChangeListener)((Object)this));
        }
        if (this instanceof MainVehicleChangeListener) {
            this.getConsole().removeMainVehicleListener((MainVehicleChangeListener)((Object)this));
        }
        if (this instanceof PlanChangeListener) {
            this.getConsole().removePlanListener((PlanChangeListener)((Object)this));
        }
        if (this instanceof IPeriodicUpdates) {
            PeriodicUpdatesService.unregister((IPeriodicUpdates)((Object)this));
        }
        if (this.periodicMethods != null) {
            for (IPeriodicUpdates i : this.periodicMethods) {
                PeriodicUpdatesService.unregister(i);
            }
            this.periodicMethods.clear();
        }
        ImcMsgManager.unregisterBusListener(this);
    }

    protected final ImcSysState getState() {
        return ImcMsgManager.getManager().getState(this.getConsole().getMainSystem());
    }

    public final ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = ImageUtils.getIcon(PluginUtils.getPluginIcon(this.getClass()));
        }
        return this.icon;
    }

    public ConsoleLayout getConsole() {
        return this.console;
    }
}

