/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console;

import com.google.common.eventbus.Subscribe;
import pt.lsts.imc.CcuEvent;
import pt.lsts.imc.LogBookEntry;
import pt.lsts.imc.MapFeature;
import pt.lsts.imc.MapPoint;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.mission.plan.PlanType;

@PluginDescription(name="CCU Event Handler")
public class ConsoleEvents
extends ConsolePanel {
    private static final long serialVersionUID = 1L;

    public ConsoleEvents(ConsoleLayout console) {
        super(console);
    }

    @Subscribe
    public void consume(CcuEvent event) {
        if (event.getSrc() == ImcMsgManager.getManager().getLocalId().intValue()) {
            return;
        }
        block2 : switch (event.getType()) {
            case PLAN_ADDED: 
            case PLAN_CHANGED: {
                PlanType pt = IMCUtils.parsePlanSpecification(this.getConsole().getMission(), event.getArg());
                this.getConsole().getMission().getIndividualPlansList().put(event.getId(), pt);
                this.getConsole().getMission().save(false);
                this.getConsole().warnMissionListeners();
                break;
            }
            case PLAN_REMOVED: {
                break;
            }
            case LOG_ENTRY: {
                try {
                    event.getArg(LogBookEntry.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case TELEOPERATION_ENDED: {
                break;
            }
            case TELEOPERATION_STARTED: {
                break;
            }
            case MAP_FEATURE_ADDED: {
                try {
                    MapFeature feature = (MapFeature)event.getArg(MapFeature.class);
                    String fname = feature.getId();
                    MapGroup mg = MapGroup.getMapGroupInstance(this.getConsole().getMission());
                    if (mg.getMapObject(fname) != null) {
                        return;
                    }
                    switch (feature.getFeatureType()) {
                        case POI: {
                            MarkElement elem = new MarkElement(mg, mg.getMaps()[0]);
                            elem.setId(fname);
                            MapPoint point = (MapPoint)feature.getFeature().firstElement();
                            LocationType loc = new LocationType();
                            loc.setLatitudeDegs(Math.toDegrees(point.getLat()));
                            loc.setLongitudeDegs(Math.toDegrees(point.getLon()));
                            loc.setHeight(point.getAlt());
                            elem.setCenterLocation(loc);
                            elem.getParentMap().addObject(elem);
                            this.getConsole().getMission().save(false);
                            this.getConsole().warnMissionListeners();
                            break block2;
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void initSubPanel() {
    }

    @Override
    public void cleanSubPanel() {
    }
}

