/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import org.dom4j.Attribute;
import org.dom4j.Element;
import pt.lsts.neptus.console.AbstractConsolePlugin;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.IConsoleLayer;
import pt.lsts.neptus.renderer2d.StateRenderer2D;

public abstract class ConsoleLayer
extends AbstractConsolePlugin
implements IConsoleLayer {
    private float opacity = 1.0f;

    @Override
    public abstract boolean userControlsOpacity();

    public abstract void initLayer();

    public abstract void cleanLayer();

    @Override
    public float getOpacity() {
        return this.opacity;
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            this.setOpacity(0.0f);
        } else if (this.opacity <= 0.0f) {
            this.opacity = 1.0f;
        }
    }

    public boolean isVisible() {
        return this.getOpacity() > 0.0f;
    }

    @Override
    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    @Override
    public final void init(ConsoleLayout console) {
        super.init(console);
        this.initLayer();
    }

    @Override
    public final void clean() {
        super.clean();
        this.cleanLayer();
    }

    public AlphaComposite getComposite() {
        return AlphaComposite.getInstance(3, this.opacity);
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (this.opacity <= 0.0f) {
            return;
        }
        if (this.opacity < 1.0f) {
            g.setComposite(this.getComposite());
        }
    }

    @Override
    public Element asElement(String rootElement) {
        Element el = super.asElement(rootElement);
        el.addAttribute("opacity", "" + this.getOpacity());
        return el;
    }

    @Override
    public void parseXmlElement(Element elem) {
        Attribute attr = elem.attribute("opacity");
        if (attr != null) {
            this.setOpacity(Float.parseFloat(attr.getText()));
        }
        super.parseXmlElement(elem);
    }
}

