/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import pt.lsts.imc.state.ImcSysState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.CommManagerStatusChangeListener;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.ConsoleSystem;
import pt.lsts.neptus.console.ContainerSubPanel;
import pt.lsts.neptus.console.IConsoleInteraction;
import pt.lsts.neptus.console.IConsoleLayer;
import pt.lsts.neptus.console.MainPanel;
import pt.lsts.neptus.console.StatusBar;
import pt.lsts.neptus.console.actions.AboutAction;
import pt.lsts.neptus.console.actions.AutoSnapshotConsoleAction;
import pt.lsts.neptus.console.actions.ConsoleAction;
import pt.lsts.neptus.console.actions.CreateMissionConsoleAction;
import pt.lsts.neptus.console.actions.ExitAction;
import pt.lsts.neptus.console.actions.IncomingDataAction;
import pt.lsts.neptus.console.actions.LayoutEditConsoleAction;
import pt.lsts.neptus.console.actions.OpenConsoleAction;
import pt.lsts.neptus.console.actions.OpenImcMonitorAction;
import pt.lsts.neptus.console.actions.OpenMRAAction;
import pt.lsts.neptus.console.actions.OpenMissionConsoleAction;
import pt.lsts.neptus.console.actions.RunChecklistConsoleAction;
import pt.lsts.neptus.console.actions.SaveAsConsoleAction;
import pt.lsts.neptus.console.actions.SaveConsoleAction;
import pt.lsts.neptus.console.actions.SaveMissionAsConsoleAction;
import pt.lsts.neptus.console.actions.SetMainVehicleConsoleAction;
import pt.lsts.neptus.console.actions.TakeSnapshotConsoleAction;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.events.ConsoleEventMissionChanged;
import pt.lsts.neptus.console.events.ConsoleEventNewSystem;
import pt.lsts.neptus.console.events.ConsoleEventPlanChange;
import pt.lsts.neptus.console.notifications.NotificationsCollection;
import pt.lsts.neptus.console.notifications.NotificationsDialog;
import pt.lsts.neptus.console.plugins.ComponentSelector;
import pt.lsts.neptus.console.plugins.ConsoleVehicleChangeListener;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.console.plugins.PlanChangeListener;
import pt.lsts.neptus.console.plugins.PluginManager;
import pt.lsts.neptus.console.plugins.SettingsWindow;
import pt.lsts.neptus.console.plugins.SubPanelChangeEvent;
import pt.lsts.neptus.console.plugins.SubPanelChangeListener;
import pt.lsts.neptus.console.plugins.planning.MapPanel;
import pt.lsts.neptus.controllers.ControllerManager;
import pt.lsts.neptus.events.NeptusEvents;
import pt.lsts.neptus.gui.ConsoleFileChooser;
import pt.lsts.neptus.gui.HideMenusListener;
import pt.lsts.neptus.gui.Loader;
import pt.lsts.neptus.gui.MissionFileChooser;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.WaitPanel;
import pt.lsts.neptus.gui.checklist.exec.CheckListExe;
import pt.lsts.neptus.gui.system.selection.MainSystemSelectionCombo;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.loader.NeptusMain;
import pt.lsts.neptus.renderer2d.VehicleStateListener;
import pt.lsts.neptus.types.XmlInOutMethods;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.checklist.ChecklistType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.VehicleMission;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.ReflectionUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class ConsoleLayout
extends JFrame
implements XmlInOutMethods,
ComponentListener {
    private static final long serialVersionUID = -7457352031399061316L;
    public static final String DEFAULT_ROOT_ELEMENT = "console";
    private Document xmlDoc = null;
    private boolean changed = false;
    private boolean active = true;
    private boolean isOnModeEdit = false;
    private MissionType mission = null;
    private String mainVehicle = null;
    private PlanType plan = null;
    protected CommManagerStatusChangeListener imcManagerStatus = null;
    private final ImcMsgManager imcMsgManager;
    private final ConcurrentMap<String, ConsoleSystem> consoleSystems = new ConcurrentHashMap<String, ConsoleSystem>();
    private final ControllerManager controllerManager;
    private final List<ConsolePanel> subPanels = new ArrayList<ConsolePanel>();
    private final Map<IConsoleLayer, Boolean> layers = new LinkedHashMap<IConsoleLayer, Boolean>();
    private final Map<IConsoleInteraction, Boolean> interactions = new LinkedHashMap<IConsoleInteraction, Boolean>();
    protected Map<Class<? extends ConsoleAction>, ConsoleAction> actions = new HashMap<Class<? extends ConsoleAction>, ConsoleAction>();
    protected Map<String, Action> globalKeybindings = new HashMap<String, Action>();
    protected KeyEventDispatcher keyDispatcher;
    private final List<Window> onRunningFrames = new ArrayList<Window>();
    protected JMenuBar menuBar;
    protected JPanel menus;
    protected MainPanel mainPanel;
    protected StatusBar statusBar;
    protected NotificationsDialog notificationsDialog;
    protected ComponentSelector consolePluginSelector = null;
    protected MainSystemSelectionCombo mainSystemCombo;
    protected int startIndexForDynamicMenus = 0;
    private Rectangle2D minimizedBounds = null;
    private ConsolePanel maximizedPanel = null;
    protected Vector<SubPanelChangeListener> subPanelListeners = new Vector();
    protected Vector<MissionChangeListener> missionListeners = new Vector();
    protected Vector<PlanChangeListener> planListeners = new Vector();
    protected Vector<MainVehicleChangeListener> mainVehicleListeners = new Vector();
    protected Vector<ConsoleVehicleChangeListener> consoleVehicleChangeListeners = new Vector();
    public File fileName = null;
    public boolean resizableConsole = false;
    private Scriptable scope = null;

    public static ConsoleLayout forge(String consoleURL, Loader loader) {
        ConsoleLayout instance = new ConsoleLayout();
        instance.imcOn();
        ConsoleParse.parseFile(consoleURL, instance);
        PluginManager manager = new PluginManager(instance);
        manager.init();
        SettingsWindow settings = new SettingsWindow(instance);
        settings.init();
        instance.setConsoleChanged(false);
        if (loader != null) {
            loader.end();
        }
        instance.setVisible(true);
        return instance;
    }

    public static ConsoleLayout forge(String consoleURL) {
        return ConsoleLayout.forge(consoleURL, null);
    }

    public ConsoleLayout() {
        NeptusEvents.create(this);
        this.setupListeners();
        this.setupKeyBindings();
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.notificationsDialog = new NotificationsDialog(new NotificationsCollection(this), this);
        this.statusBar = new StatusBar(this, this.notificationsDialog);
        this.mainPanel = new MainPanel(this);
        this.add((Component)this.mainPanel, "Center");
        this.createMenuBar();
        this.menus = new JPanel();
        this.menus.setLayout(new BorderLayout());
        this.add((Component)this.menus, "North");
        this.add((Component)this.statusBar, "South");
        this.setIconImages(ConfigFetch.getIconImagesForFrames());
        this.setName(I18n.text("Neptus Console"));
        this.setPreferredSize(new Dimension(1600, 800));
        this.pack();
        this.setLocationRelativeTo(null);
        this.imcMsgManager = ImcMsgManager.getManager();
        this.controllerManager = new ControllerManager();
    }

    private void setupListeners() {
        this.addComponentListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JFrame frame = (JFrame)e.getComponent();
                if (ConsoleLayout.this.isConsoleChanged()) {
                    int answer = JOptionPane.showConfirmDialog(ConsoleLayout.this.getConsole(), I18n.text("<html>Do you want to save the changes to the current <strong>Console Configuration</strong>?</html>"), I18n.text("Save changes?"), 1);
                    if (answer == 0) {
                        ConsoleLayout.this.saveFile();
                        frame.setVisible(false);
                        frame.dispose();
                    } else if (answer == 1) {
                        frame.setVisible(false);
                        frame.dispose();
                    } else if (answer == 2) {
                        return;
                    }
                } else {
                    frame.setVisible(false);
                    frame.dispose();
                }
                ConsoleLayout.this.cleanup();
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
                ConsoleLayout.this.active = false;
            }

            @Override
            public void windowActivated(WindowEvent arg0) {
                ConsoleLayout.this.active = true;
                ConfigFetch.setSuperParentFrameForced(ConsoleLayout.this.getConsole());
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                ConfigFetch.setSuperParentFrameForced(ConsoleLayout.this.getConsole());
            }
        });
    }

    private void setupKeyBindings() {
        KeyEventDispatcher keyDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                int eventType = e.getID();
                Action action = ConsoleLayout.this.globalKeybindings.get(KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers()).toString());
                if (action != null && eventType == 401) {
                    action.actionPerformed(null);
                    return true;
                }
                return false;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(keyDispatcher);
    }

    private void cleanKeyBindings() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyDispatcher);
        this.globalKeybindings.clear();
    }

    public void registerGlobalKeyBinding(KeyStroke name, Action action) {
        if (this.globalKeybindings.containsKey(name.toString())) {
            NeptusLog.pub().error((Object)("Global keybind " + name + " already registered by another component"));
        } else {
            this.globalKeybindings.put(name.toString(), action);
        }
    }

    public boolean isOnModeEdit() {
        return this.isOnModeEdit;
    }

    public void setModeEdit(boolean mode) {
        if (mode) {
            if (this.consolePluginSelector == null) {
                this.consolePluginSelector = new ComponentSelector(this.mainPanel);
            }
            this.menus.setVisible(true);
            this.menus.add((Component)this.consolePluginSelector, "North");
            this.setConsoleChanged(true);
            this.mainPanel.setEditOn();
            this.isOnModeEdit = true;
        } else {
            this.menus.setVisible(false);
            this.menus.remove(this.consolePluginSelector);
            this.mainPanel.setEditOff();
            this.revalidate();
            this.repaint();
            this.isOnModeEdit = false;
        }
        this.revalidate();
        this.repaint();
    }

    public void addWindowToOppenedList(Window win) {
        this.onRunningFrames.add(win);
    }

    public void removeWindowToOppenedList(Window win) {
        this.onRunningFrames.add(win);
    }

    public void createMenuBar() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu file = new JMenu(I18n.text("File"));
        OpenConsoleAction open = new OpenConsoleAction(this);
        this.actions.put(OpenConsoleAction.class, open);
        file.add(open);
        SaveConsoleAction save = new SaveConsoleAction(this);
        this.actions.put(SaveConsoleAction.class, save);
        file.add(save);
        SaveAsConsoleAction saveAs = new SaveAsConsoleAction(this);
        this.actions.put(SaveAsConsoleAction.class, saveAs);
        file.add(saveAs);
        file.addSeparator();
        CreateMissionConsoleAction createMission = new CreateMissionConsoleAction(this);
        this.actions.put(CreateMissionConsoleAction.class, createMission);
        file.add(createMission);
        OpenMissionConsoleAction openMission = new OpenMissionConsoleAction(this);
        this.actions.put(OpenMissionConsoleAction.class, openMission);
        file.add(openMission);
        SaveMissionAsConsoleAction saveMissionAs = new SaveMissionAsConsoleAction(this);
        this.actions.put(SaveMissionAsConsoleAction.class, saveMissionAs);
        file.add(saveMissionAs);
        file.addSeparator();
        file.add(new ExitAction());
        this.menuBar.add(file);
        JMenu viewMenu = new JMenu(I18n.text("View"));
        this.menuBar.add(viewMenu);
        JMenu tools = new JMenu(I18n.text("Tools"));
        OpenMRAAction openMRA = new OpenMRAAction();
        this.actions.put(OpenMRAAction.class, openMRA);
        tools.add(openMRA);
        RunChecklistConsoleAction runChecklist = new RunChecklistConsoleAction(this);
        this.actions.put(RunChecklistConsoleAction.class, runChecklist);
        tools.add(runChecklist);
        this.menuBar.add(tools);
        JMenu advanced = new JMenu(I18n.text("Advanced"));
        TakeSnapshotConsoleAction takeSnapshot = new TakeSnapshotConsoleAction(this);
        this.actions.put(TakeSnapshotConsoleAction.class, takeSnapshot);
        advanced.add(takeSnapshot);
        AutoSnapshotConsoleAction autoSnapshot = new AutoSnapshotConsoleAction(this);
        this.actions.put(AutoSnapshotConsoleAction.class, autoSnapshot);
        advanced.add(autoSnapshot);
        advanced.addSeparator();
        LayoutEditConsoleAction layoutEdit = new LayoutEditConsoleAction(this);
        this.actions.put(LayoutEditConsoleAction.class, layoutEdit);
        advanced.add(layoutEdit);
        advanced.add(new SetMainVehicleConsoleAction(this));
        IncomingDataAction incomingData = new IncomingDataAction(this);
        this.actions.put(IncomingDataAction.class, incomingData);
        advanced.add(incomingData);
        OpenImcMonitorAction imcMonitor = new OpenImcMonitorAction(this);
        this.actions.put(OpenImcMonitorAction.class, imcMonitor);
        advanced.add(imcMonitor);
        this.menuBar.add(advanced);
        advanced.addMenuListener(HideMenusListener.forge(new Component[0], new JMenuItem[]{this.getJMenuForAction(OpenImcMonitorAction.class)}));
        this.setStartIndexForDynamicMenus();
        this.includeHelpMenu();
        this.includeExtraMainMenus();
    }

    protected boolean removeJMenuAction(Class<? extends ConsoleAction> consoleAction) {
        JMenuItem mn = this.getJMenuForAction(consoleAction);
        if (mn == null) {
            return false;
        }
        mn.getParent().remove(mn);
        return true;
    }

    protected JMenuItem getJMenuForAction(Class<? extends ConsoleAction> consoleAction) {
        ConsoleAction ca = this.actions.get(consoleAction);
        if (ca == null) {
            NeptusLog.pub().error((Object)("No action to remove from JMenuBar with class " + consoleAction.getSimpleName() + "!"));
            return null;
        }
        for (Component comp : this.menuBar.getComponents()) {
            if (!(comp instanceof JMenu)) continue;
            JMenu menu = (JMenu)comp;
            for (Component comp1 : menu.getMenuComponents()) {
                JMenuItem menuItem;
                if (!(comp1 instanceof JMenuItem) || (menuItem = (JMenuItem)comp1).getAction() != ca) continue;
                return menuItem;
            }
        }
        return null;
    }

    protected JMenu includeHelpMenu() {
        JMenu helpMenu = new JMenu();
        helpMenu.setText(I18n.text("Help"));
        AboutAction about = new AboutAction(this);
        this.actions.put(AboutAction.class, about);
        helpMenu.add(about);
        this.menuBar.add(helpMenu);
        return helpMenu;
    }

    protected void includeExtraMainMenus() {
        this.menuBar.add(Box.createHorizontalGlue());
        this.mainSystemCombo = new MainSystemSelectionCombo(this);
        this.menuBar.add(this.mainSystemCombo);
    }

    protected void setStartIndexForDynamicMenus() {
        this.startIndexForDynamicMenus = this.menuBar.getComponentCount() - 1;
    }

    public void addRender(String id, VehicleStateListener externalrender) {
        ConsoleSystem vehicle = (ConsoleSystem)this.consoleSystems.get(id);
        if (vehicle != null) {
            vehicle.addRenderFeed(externalrender);
        }
    }

    public void removeRender(String id, VehicleStateListener externalrender) {
        ConsoleSystem vehicle = (ConsoleSystem)this.consoleSystems.get(id);
        if (vehicle != null) {
            vehicle.removeRenderFeed(externalrender);
        }
    }

    public void removeRenderAll(VehicleStateListener externalrender) {
        for (Map.Entry entry : this.consoleSystems.entrySet()) {
            ((ConsoleSystem)entry.getValue()).removeRenderFeed(externalrender);
        }
    }

    public MissionType getMission() {
        return this.mission;
    }

    public void setMission(MissionType mission) {
        MissionType old = this.mission;
        this.mission = mission;
        this.setPlan(null);
        if (mission != null) {
            NeptusLog.pub().debug((Object)("Mission changed to " + mission.getId()));
        } else {
            NeptusLog.pub().info((Object)"Mission set to null");
        }
        for (MissionChangeListener mlistener : this.missionListeners) {
            try {
                mlistener.missionReplaced(mission);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        this.updateTitle();
        this.post(new ConsoleEventMissionChanged(old, this.mission));
    }

    public void setPlan(PlanType plan) {
        PlanType old = this.plan;
        if (plan != null && plan.getMissionType() != this.getMission()) {
            this.setMission(plan.getMissionType());
        }
        this.plan = plan;
        for (PlanChangeListener pobj : this.planListeners) {
            try {
                pobj.planChange(this.plan);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
                e.printStackTrace();
            }
        }
        this.post(new ConsoleEventPlanChange(old, this.plan));
    }

    public PlanType getPlan() {
        return this.plan;
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    public String getMainSystem() {
        return this.mainVehicle;
    }

    public void setMainSystem(String mainVehicle) {
        if (this.getSystem(mainVehicle) == null) {
            NeptusLog.pub().error((Object)"trying to add main system without addin it");
            return;
        }
        String old = this.mainVehicle;
        this.mainVehicle = mainVehicle;
        if (!mainVehicle.equals(old)) {
            for (MainVehicleChangeListener mlistener : this.mainVehicleListeners) {
                try {
                    mlistener.mainVehicleChange(mainVehicle);
                }
                catch (Exception ex) {
                    NeptusLog.pub().error((Object)ex, (Throwable)ex);
                }
            }
            this.post(new ConsoleEventMainSystemChange(old, this.mainVehicle));
        }
    }

    public void addSystem(String systemName) {
        VehicleType vehicleType = VehiclesHolder.getVehicleById(systemName);
        ImcSystem imcSystem = ImcSystemsHolder.lookupSystemByName(systemName);
        if (vehicleType != null && imcSystem == null) {
            this.imcMsgManager.initVehicleCommInfo(vehicleType.getId(), "");
            return;
        }
        if (imcSystem == null) {
            NeptusLog.pub().warn((Object)("tried to add a vehicle from imc with comms disabled: " + systemName));
            return;
        }
        if (imcSystem.getType() != VehicleType.SystemTypeEnum.VEHICLE) {
            return;
        }
        if (this.consoleSystems.get(systemName) != null) {
            NeptusLog.pub().warn((Object)(ReflectionUtil.getCallerStamp() + " tried to add a vehicle that already exist in the console: " + systemName));
            return;
        }
        ConsoleSystem system = new ConsoleSystem(systemName, this, imcSystem, this.imcMsgManager);
        this.consoleSystems.put(systemName, system);
        if (this.mainVehicle == null) {
            this.setMainSystem(systemName);
        }
        for (ConsoleVehicleChangeListener cvl : this.consoleVehicleChangeListeners) {
            try {
                cvl.consoleVehicleChange(vehicleType, 0);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        this.post(new ConsoleEventNewSystem(system));
        system.enableIMC();
    }

    public void removeSystem(String id) {
        ConsoleSystem vehicle = (ConsoleSystem)this.consoleSystems.remove(id);
        if (vehicle != null) {
            vehicle.clean();
            for (ConsoleVehicleChangeListener cvl : this.consoleVehicleChangeListeners) {
                try {
                    cvl.consoleVehicleChange(VehiclesHolder.getVehicleById(id), 1);
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e);
                }
            }
        }
    }

    public void initOtherMissionVehicles() {
        Collection<VehicleMission> aMap = this.mission.getVehiclesList().values();
        for (VehicleMission j : aMap) {
            if (this.getSystem(j.getId()) != null) continue;
            this.addSystem(j.getId());
        }
    }

    public void initSubPanels() {
        for (ConsolePanel sp : this.subPanels) {
            sp.init();
        }
        for (IConsoleLayer layer : this.layers.keySet()) {
            layer.init(this);
        }
        for (IConsoleInteraction inter : this.interactions.keySet()) {
            inter.init(this);
        }
    }

    public boolean saveFile() {
        if (this.fileName == null) {
            return this.saveasFile();
        }
        if (new File(this.fileName.getAbsolutePath()).exists()) {
            FileUtil.backupFile(this.fileName.getAbsolutePath());
        }
        FileUtil.saveToFile(this.fileName.getAbsolutePath(), FileUtil.getAsPrettyPrintFormatedXMLString(this.asDocument()));
        this.changed = false;
        return true;
    }

    public boolean saveasFile() {
        File file = ConsoleFileChooser.showSaveConsoleDialog(this);
        if (file == null) {
            return false;
        }
        String ext = FileUtil.getFileExtension(file);
        ext = "ncon".equalsIgnoreCase(ext) || "xml".equalsIgnoreCase(ext) ? "" : ".ncon";
        this.fileName = file = new File(file.getAbsolutePath() + ext);
        FileUtil.saveToFile(this.fileName.getAbsolutePath(), FileUtil.getAsPrettyPrintFormatedXMLString(this.asDocument()));
        this.changed = false;
        return true;
    }

    public void setMissionFile(String[] extensions) {
        final File file = MissionFileChooser.showOpenMissionDialog(extensions);
        if (file != null) {
            final WaitPanel a = new WaitPanel();
            Thread t = new Thread("loader set mission file thread"){

                @Override
                public void run() {
                    try {
                        a.start((JFrame)ConsoleLayout.this, Dialog.ModalityType.DOCUMENT_MODAL);
                        ConsoleLayout.this.setMission(new MissionType(file.getAbsolutePath()));
                        a.stop();
                    }
                    catch (Exception e) {
                        a.stop();
                        GuiUtils.errorMessage(ConsoleLayout.this.getConsole(), I18n.text("Error"), I18n.text("Error Loading Mission File.\n"));
                        NeptusLog.pub().error((Object)("Console Base open file error [" + file.getAbsolutePath() + "]"));
                        NeptusLog.pub().error((Object)e, (Throwable)e);
                    }
                }
            };
            t.start();
        }
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document doc = null;
        doc = DocumentHelper.createDocument();
        Element root = doc.addElement(rootElementName);
        root.addComment(ConfigFetch.getSaveAsCommentForXML());
        root.addAttribute("name", this.getName());
        root.addAttribute("width", "" + this.getWidth());
        root.addAttribute("height", "" + this.getHeight());
        root.addAttribute("resizable", "" + this.isResizableConsole());
        if (this.getMission() != null && !this.mission.getOriginalFilePath().equals("")) {
            root.addAttribute("mission-file", FileUtil.relativizeFilePathAsURI(this.fileName.getAbsolutePath(), this.mission.getMissionFile().getAbsolutePath()));
        }
        if (this.getMainSystem() != null) {
            root.addAttribute("main-vehicle", this.getMainSystem());
        }
        Element mainpanel = root.addElement("mainpanel");
        mainpanel.addAttribute("name", "console main panel");
        for (Component c : this.getMainPanel().getComponents()) {
            if (!(c instanceof XmlOutputMethods)) continue;
            try {
                mainpanel.add(((XmlOutputMethods)((Object)c)).asElement());
            }
            catch (Exception e) {
                GuiUtils.errorMessage(this, "Error saving XML of " + c.getName(), "[" + c.getName() + "]: " + e.getMessage());
                e.printStackTrace();
            }
        }
        Element alarmpanel = root.addElement("mainpanel");
        alarmpanel.addAttribute("name", "console alarm panel");
        if (!this.layers.isEmpty()) {
            Element layersElem = root.addElement("layers");
            for (IConsoleLayer l : this.layers.keySet()) {
                if (!this.layers.get(l).booleanValue()) continue;
                layersElem.add(l.asElement("layer"));
            }
        }
        if (!this.interactions.isEmpty()) {
            Element interactionsElem = root.addElement("interactions");
            for (IConsoleInteraction i : this.interactions.keySet()) {
                if (!this.interactions.get(i).booleanValue()) continue;
                interactionsElem.add(i.asElement("interaction"));
            }
        }
        return doc;
    }

    @Override
    public void inElement(Element elem) {
        ConsoleParse.parseElement(elem, this, this.getFileName().toString());
    }

    @Override
    public void inDocument(Document d) {
        ConsoleParse.parseDocument(d, this, this.getFileName().toString());
    }

    @Override
    public void parseXML(String d) {
        ConsoleParse.parseString(d, this, this.getFileName().toString());
    }

    public List<ConsolePanel> getSubPanels() {
        return this.subPanels;
    }

    public List<PropertiesProvider> getAllPropertiesProviders() {
        ArrayList<PropertiesProvider> ret = new ArrayList<PropertiesProvider>();
        for (ConsolePanel sp : this.subPanels) {
            if (!(sp instanceof PropertiesProvider)) continue;
            ret.add(sp);
        }
        for (IConsoleLayer ly : this.layers.keySet()) {
            if (!this.layers.get(ly).booleanValue() || !(ly instanceof PropertiesProvider)) continue;
            ret.add(ly);
        }
        for (IConsoleInteraction in : this.interactions.keySet()) {
            if (!this.interactions.get(in).booleanValue() || !(in instanceof PropertiesProvider)) continue;
            ret.add((PropertiesProvider)((Object)in));
        }
        return ret;
    }

    public <T extends ConsolePanel> Vector<T> getSubPanelsOfClass(Class<T> subPanelType) {
        try {
            Vector<T> ret = new Vector<T>();
            if (this.subPanels.isEmpty()) {
                return ret;
            }
            for (ConsolePanel sp : this.subPanels) {
                Vector<T> rSp = this.getSubPanelType(sp, subPanelType);
                if (rSp.size() <= 0) continue;
                ret.addAll(rSp);
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Vector();
        }
    }

    private <T extends ConsolePanel> Vector<T> getSubPanelType(ConsolePanel sp, Class<T> superClass) {
        Vector<ConsolePanel> ret = new Vector<ConsolePanel>();
        if (sp == null) {
            return ret;
        }
        if (sp.getClass().equals(superClass)) {
            ret.add(sp);
        } else if (superClass.isAssignableFrom(sp.getClass())) {
            ret.add(sp);
        }
        if (sp instanceof ContainerSubPanel) {
            for (ConsolePanel s : ((ContainerSubPanel)sp).getSubPanels()) {
                Vector<T> rSp = this.getSubPanelType(s, superClass);
                if (rSp.size() <= 0) continue;
                ret.addAll(rSp);
            }
        }
        return ret;
    }

    public <T> Vector<T> getSubPanelsOfInterface(Class<T> interfaceType) {
        Vector ret = new Vector();
        HashSet<T> col = new HashSet<T>();
        if (this.subPanels.isEmpty()) {
            return ret;
        }
        for (ConsolePanel sp : this.subPanels) {
            col.addAll(this.getSubPanelImplementations(sp, interfaceType));
        }
        ret.addAll(col);
        return ret;
    }

    private <T> Vector<T> getSubPanelImplementations(ConsolePanel sp, Class<T> interfaceType) {
        Vector<ConsolePanel> ret = new Vector<ConsolePanel>();
        if (ReflectionUtil.hasInterface(sp.getClass(), interfaceType)) {
            ret.add(sp);
        }
        if (ReflectionUtil.isSubclass(sp.getClass(), ContainerSubPanel.class)) {
            for (ConsolePanel s : ((ContainerSubPanel)sp).getSubPanels()) {
                Vector<T> rSp = this.getSubPanelImplementations(s, interfaceType);
                if (rSp.size() <= 0) continue;
                ret.addAll(rSp);
            }
        }
        return ret;
    }

    public void addConsoleVehicleListener(ConsoleVehicleChangeListener cvl) {
        if (!this.consoleVehicleChangeListeners.contains(cvl)) {
            this.consoleVehicleChangeListeners.add(cvl);
        }
    }

    public void removeConsoleVehicleListener(ConsoleVehicleChangeListener cvl) {
        this.consoleVehicleChangeListeners.remove(cvl);
    }

    public void addMainVehicleListener(MainVehicleChangeListener vcl) {
        if (!this.mainVehicleListeners.contains(vcl)) {
            this.mainVehicleListeners.add(vcl);
        }
    }

    public void removeMainVehicleListener(MainVehicleChangeListener vcl) {
        this.mainVehicleListeners.remove(vcl);
    }

    public void addMissionListener(MissionChangeListener mcl) {
        if (!this.missionListeners.contains(mcl)) {
            this.missionListeners.add(mcl);
        }
    }

    public void removeMissionListener(MissionChangeListener mcl) {
        this.missionListeners.remove(mcl);
    }

    public void warnMissionListeners() {
        for (MissionChangeListener mcl : this.missionListeners) {
            mcl.missionReplaced(this.getMission());
        }
    }

    public void updateMissionListeners() {
        for (MissionChangeListener mcl : this.missionListeners) {
            mcl.missionUpdated(this.getMission());
        }
    }

    public void addPlanListener(PlanChangeListener pcl) {
        if (!this.planListeners.contains(pcl)) {
            this.planListeners.add(pcl);
        }
    }

    public void removePlanListener(PlanChangeListener pcl) {
        this.planListeners.remove(pcl);
    }

    public void addSubPanelListener(SubPanelChangeListener spl) {
        if (!this.subPanelListeners.contains(spl)) {
            this.subPanelListeners.add(spl);
        }
    }

    public void removeSubPanelListener(SubPanelChangeListener spl) {
        this.subPanelListeners.remove(spl);
    }

    public void informSubPanelListener(ConsolePanel sub, SubPanelChangeEvent.SubPanelChangeAction action) {
        for (SubPanelChangeListener spcl : this.subPanelListeners) {
            spcl.subPanelChanged(new SubPanelChangeEvent(sub, action));
        }
        if (action == SubPanelChangeEvent.SubPanelChangeAction.ADDED && sub instanceof MapPanel) {
            for (IConsoleLayer layer : this.layers.keySet()) {
                ((MapPanel)sub).addPostRenderPainter(layer, layer.getName());
            }
            for (IConsoleInteraction i : this.interactions.keySet()) {
                ((MapPanel)sub).addInteraction(i);
            }
        }
    }

    public boolean addInteraction(IConsoleInteraction interaction, boolean storeInConsoleXml) {
        Vector<MapPanel> maps = this.getSubPanelsOfClass(MapPanel.class);
        if (this.interactions.containsKey(interaction)) {
            NeptusLog.pub().error((Object)"Interation was already present in this console.");
            return false;
        }
        if (maps.isEmpty()) {
            NeptusLog.pub().error((Object)"Cannot add interaction because there is no MapPanel in the console.");
            return false;
        }
        interaction.init(this);
        this.interactions.put(interaction, storeInConsoleXml);
        for (MapPanel map : maps) {
            map.addInteraction(interaction);
        }
        return true;
    }

    public boolean addInteraction(IConsoleInteraction interaction) {
        return this.addInteraction(interaction, true);
    }

    public boolean removeInteraction(IConsoleInteraction interaction) {
        if (!this.interactions.containsKey(interaction)) {
            NeptusLog.pub().error((Object)"Interaction not found in this console.");
            return false;
        }
        for (MapPanel map : this.getSubPanelsOfClass(MapPanel.class)) {
            map.removeInteraction(interaction);
        }
        interaction.clean();
        return this.interactions.remove(interaction) != null;
    }

    public boolean addMapLayer(IConsoleLayer layer, boolean storeInConsoleXml) {
        Vector<MapPanel> maps = this.getSubPanelsOfClass(MapPanel.class);
        if (this.layers.containsKey(layer)) {
            NeptusLog.pub().error((Object)"Layer was already present in this console.");
            return false;
        }
        if (maps.isEmpty()) {
            NeptusLog.pub().error((Object)"Cannot add layer beacause there is no MapPanel in the console.");
            return false;
        }
        layer.init(this);
        this.layers.put(layer, storeInConsoleXml);
        for (MapPanel map : maps) {
            map.addLayer(layer);
        }
        return true;
    }

    public boolean addMapLayer(IConsoleLayer layer) {
        return this.addMapLayer(layer, true);
    }

    public boolean removeMapLayer(IConsoleLayer layer) {
        for (MapPanel map : this.getSubPanelsOfClass(MapPanel.class)) {
            try {
                map.removeLayer(layer);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("Error removing layer '" + layer.getName() + "' from '" + MapPanel.class.getSimpleName() + "'!"), (Throwable)e);
            }
        }
        try {
            layer.clean();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)("Error calling clean from layer '" + layer.getName() + "'!"), (Throwable)e);
        }
        try {
            return this.layers.remove(layer) != null;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)("Error removing layer '" + layer.getName() + "' from console layers list!"), (Throwable)e);
            return false;
        }
    }

    public void reset() {
        this.remove(this.mainPanel);
        this.mainPanel.clean();
        this.mainPanel = new MainPanel(this);
        this.add((Component)this.mainPanel, "Center");
        this.missionListeners.clear();
        this.planListeners.clear();
        this.consoleVehicleChangeListeners.clear();
        for (ConsoleSystem vehicle : this.consoleSystems.values()) {
            vehicle.clean();
        }
        this.consoleSystems.clear();
        for (Window j : this.onRunningFrames) {
            j.dispose();
        }
        this.setMission(null);
        this.mainVehicleListeners.clear();
        this.changed = false;
        this.revalidate();
        this.repaint();
    }

    public void cleanup() {
        long start = System.currentTimeMillis();
        NeptusLog.pub().info((Object)(this.getClass().getSimpleName() + " cleanup start"));
        try {
            this.removeComponentListener(this);
            this.missionListeners.clear();
            this.planListeners.clear();
            this.consoleVehicleChangeListeners.clear();
            for (Window j : this.onRunningFrames) {
                j.setVisible(false);
                j.dispose();
            }
            this.mainVehicleListeners.clear();
            AutoSnapshotConsoleAction autosnapshot = (AutoSnapshotConsoleAction)this.actions.get(AutoSnapshotConsoleAction.class);
            autosnapshot.cleanClose();
            for (IConsoleLayer layer : this.layers.keySet().toArray(new IConsoleLayer[this.layers.size()])) {
                try {
                    layer.clean();
                    NeptusLog.pub().info((Object)("Cleaned " + layer.getName()));
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)("Error cleaning " + layer.getName() + " :: " + e.getMessage()), (Throwable)e);
                }
            }
            this.layers.clear();
            for (IConsoleInteraction interaction : this.interactions.keySet().toArray(new IConsoleInteraction[this.interactions.size()])) {
                try {
                    interaction.clean();
                    NeptusLog.pub().info((Object)("Cleaned " + interaction.getName()));
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)("Error cleaning " + interaction.getName() + " :: " + e.getMessage()), (Throwable)e);
                }
            }
            this.interactions.clear();
            for (ConsoleSystem system : this.consoleSystems.values()) {
                system.clean();
            }
            this.consoleSystems.clear();
            this.mainPanel.clean();
            this.statusBar.clean();
            this.cleanKeyBindings();
            this.imcOff();
            NeptusEvents.delete(this);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)("Error cleaning " + this.getClass().getSimpleName() + " :: " + e.getMessage()), (Throwable)e);
        }
        NeptusLog.pub().info((Object)(this.getClass().getSimpleName() + " cleanup end in " + (double)(System.currentTimeMillis() - start) / 1000.0 + "s"));
    }

    public void minimizePanel(ConsolePanel p) {
        p.setVisible(false);
        if (this.maximizedPanel != null) {
            p = this.maximizedPanel;
        }
        if (this.minimizedBounds == null) {
            return;
        }
        if (this.subPanels.indexOf(p) == -1) {
            for (ConsolePanel tmp : this.subPanels) {
                for (ConsolePanel c : tmp.getChildren()) {
                    if (!c.equals(p)) continue;
                    p = tmp;
                }
            }
        } else {
            p.setBounds(this.minimizedBounds.getBounds());
            for (ConsolePanel tmp : this.subPanels) {
                if (tmp instanceof ConsolePanel && !tmp.getVisibility()) continue;
                tmp.setVisible(true);
            }
        }
        this.minimizedBounds = null;
        this.maximizedPanel = null;
        this.mainPanel.revalidate();
    }

    public void maximizePanel(ConsolePanel p) {
        if (this.maximizedPanel != null) {
            this.minimizePanel(this.maximizedPanel);
        }
        if (this.subPanels.indexOf(p) == -1) {
            for (ConsolePanel tmp : this.subPanels) {
                for (ConsolePanel c : tmp.getChildren()) {
                    if (!c.equals(p)) continue;
                    p = tmp;
                }
            }
        } else {
            for (ConsolePanel tmp : this.subPanels) {
                if (tmp.getRootPane() == null || !tmp.getRootPane().equals(p.getRootPane())) continue;
                tmp.setVisible(false);
            }
            Container tmp = p;
            while (tmp.getParent() != this.mainPanel && tmp.getParent() != null) {
                tmp = tmp.getParent();
            }
            if (tmp instanceof ConsolePanel) {
                p = tmp;
            }
            this.minimizedBounds = p.getBounds();
            this.maximizedPanel = p;
            p.setBounds(new Rectangle(0, 0, p.getMainpanel().getWidth(), p.getMainpanel().getHeight()));
            p.setSize(this.getMainPanel().getSize());
            p.setVisible(true);
            p.getMainpanel().revalidate();
            p.getMainpanel().repaint();
        }
    }

    public ConsolePanel getMaximizedPanel() {
        return this.maximizedPanel;
    }

    public void setMaximizedPanel(ConsolePanel maximizedPanel) {
        if (maximizedPanel == this.maximizedPanel) {
            return;
        }
        if (this.maximizedPanel != null) {
            this.minimizePanel(maximizedPanel);
        }
        this.maximizePanel(maximizedPanel);
    }

    public void setFileName(File fileName) {
        this.fileName = fileName;
    }

    public File getFileName() {
        return this.fileName;
    }

    public Document getXmlDoc() {
        return this.xmlDoc;
    }

    public void setXmlDoc(Document xmlDoc) {
        this.xmlDoc = xmlDoc;
    }

    public Scriptable getScope() {
        if (this.scope == null) {
            this.scope = new Context().initStandardObjects();
            Object wrappedOut = Context.javaToJS((Object)System.out, (Scriptable)this.scope);
            Object wrappedErr = Context.javaToJS((Object)System.err, (Scriptable)this.scope);
            Object wrappedMsg = Context.javaToJS(null, (Scriptable)this.scope);
            Object wrappedConsole = Context.javaToJS((Object)this.getConsole(), (Scriptable)this.scope);
            Object wrappedManager = Context.javaToJS((Object)ImcMsgManager.getManager(), (Scriptable)this.scope);
            ScriptableObject.putProperty((Scriptable)this.scope, (String)"out", (Object)wrappedOut);
            ScriptableObject.putProperty((Scriptable)this.scope, (String)"err", (Object)wrappedErr);
            ScriptableObject.putProperty((Scriptable)this.scope, (String)"msg", (Object)wrappedMsg);
            ScriptableObject.putProperty((Scriptable)this.scope, (String)DEFAULT_ROOT_ELEMENT, (Object)wrappedConsole);
            ScriptableObject.putProperty((Scriptable)this.scope, (String)"manager", (Object)wrappedManager);
        }
        return this.scope;
    }

    public Object evaluateScript(String js) {
        Context cx = Context.enter();
        try {
            Object result = cx.evaluateString(this.getScope(), js, "<script>", 1, null);
            return result;
        }
        catch (Exception e) {
            GuiUtils.errorMessage(this.getConsole(), e);
            return e.getClass().getSimpleName() + ": " + e.getMessage();
        }
    }

    public void executeCheckList(ChecklistType ct) {
        if (this.getMission() != null && this.getMission().getCompressedFilePath() != null) {
            File file = new File(this.getMission().getCompressedFilePath());
            CheckListExe.showCheckListExeDialog(this.getMainSystem(), ct, this, file.getParent());
        }
    }

    public JMenuItem addMenuItem(String itemPath, ImageIcon icon, ActionListener actionListener) {
        String[] ptmp = itemPath.split(">");
        if (ptmp.length < 2) {
            NeptusLog.pub().error((Object)"Menu path has to have at least two components");
            return null;
        }
        String[] path = new String[ptmp.length - 1];
        System.arraycopy(ptmp, 0, path, 0, path.length);
        String menuName = ptmp[ptmp.length - 1];
        JMenu menu = this.getConsole().getOrCreateJMenu(path);
        final ActionListener l = actionListener;
        AbstractAction action = new AbstractAction(menuName){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                l.actionPerformed(e);
            }
        };
        if (icon != null) {
            action.putValue("SmallIcon", ImageUtils.getScaledIcon(icon.getImage(), 16, 16));
        }
        JMenuItem item = menu.add(action);
        return item;
    }

    public JMenu removeMenuItem(String[] menuPath) {
        int i;
        JMenu parent = null;
        for (i = 0; i < this.menuBar.getMenuCount(); ++i) {
            JMenu menu = this.getConsole().getJMenuBar().getMenu(i);
            if (menu == null || !menu.getText().equalsIgnoreCase(menuPath[0].trim())) continue;
            parent = menu;
            break;
        }
        if (parent == null) {
            return null;
        }
        i = 1;
        while (parent != null && i < menuPath.length) {
            boolean found = false;
            for (int j = 0; j < parent.getItemCount(); ++j) {
                JMenuItem child = parent.getItem(j);
                if (child == null || child.getText() == null || !child.getText().equalsIgnoreCase(menuPath[i].trim())) continue;
                found = true;
                if (++i == menuPath.length) {
                    parent.remove(child);
                    return parent;
                }
                parent = (JMenu)child;
                break;
            }
            if (found) continue;
            break;
        }
        return null;
    }

    public JMenu getOrCreateJMenu(String[] menuPath) {
        int i;
        int count = this.menuBar.getComponentCount();
        JMenu parent = null;
        for (i = 0; i < count; ++i) {
            JMenu menu;
            Component c = this.menuBar.getComponent(i);
            if (!(c instanceof JMenu) || !(menu = (JMenu)c).getText().equalsIgnoreCase(menuPath[0].trim())) continue;
            parent = menu;
            break;
        }
        if (parent == null) {
            parent = new JMenu(menuPath[0].trim());
            this.insertJMenuIntoTheMenuBarOrdered(parent);
        }
        i = 1;
        while (i < menuPath.length) {
            for (int j = 0; j < parent.getItemCount(); ++j) {
                JMenuItem child = parent.getItem(j);
                if (child == null || !(child instanceof JMenu) || child.getText() == null || !child.getText().equalsIgnoreCase(menuPath[i].trim())) continue;
                parent = (JMenu)child;
                ++i;
                break;
            }
            if (i >= menuPath.length) continue;
            JMenu tmp = new JMenu(menuPath[i]);
            parent.add(tmp);
            ++i;
            parent = tmp;
            break;
        }
        return parent;
    }

    private synchronized void insertJMenuIntoTheMenuBarOrdered(JMenu topMenu) {
        int insertM;
        int size;
        int indexEnd = 0;
        for (int i = size = this.menuBar.getComponentCount() - 1; i > this.startIndexForDynamicMenus; --i) {
            Component component = this.menuBar.getComponent(i);
            if (!(component instanceof JMenu) || !((JMenu)component).getText().equals(I18n.text("Help"))) continue;
            indexEnd = i;
        }
        for (int i = insertM = this.startIndexForDynamicMenus + 1; i < indexEnd - 1; ++i) {
            JMenu menu = this.getConsole().getJMenuBar().getMenu(i);
            if (menu == null) continue;
            String nameM = menu.getText();
            int compVal = topMenu.getText().compareTo(nameM);
            if (compVal <= 0) break;
            insertM = i + 1;
        }
        this.getConsole().getJMenuBar().add((Component)topMenu, insertM);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.notificationsDialog.setVisible(false);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.notificationsDialog.setVisible(false);
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public boolean isResizableConsole() {
        return this.resizableConsole;
    }

    public void setResizableConsole(boolean resizebleConsole) {
        this.resizableConsole = resizebleConsole;
    }

    public ImcSysState getImcState() {
        return this.getImcState(this.getMainSystem());
    }

    public ImcSysState getImcState(String system) {
        return ImcMsgManager.getManager().getState(ImcSystemsHolder.getSystemWithName(system).getId());
    }

    public void post(Object event) {
        NeptusEvents.post(event, this);
    }

    protected void updateTitle() {
        StringBuilder title = new StringBuilder();
        title.append(this.getName());
        MissionType mission = this.getMission();
        if (mission != null) {
            title.append(" | " + I18n.text("Mission") + ": ");
            title.append(mission.getName());
            title.append(" [" + mission.getCompressedFilePath() + "]");
        }
        this.setTitle(title.toString());
    }

    public void imcOn() {
        if (this.imcMsgManager.start()) {
            ImcSystem[] systems;
            for (ImcSystem imcSystem : systems = ImcSystemsHolder.lookupActiveSystemVehicles()) {
                this.addSystem(imcSystem.getName());
            }
            this.imcMsgManager.addStatusListener(this.imcManagerStatus == null ? this.setupImcListener() : this.imcManagerStatus);
            for (Map.Entry vehicle : this.consoleSystems.entrySet()) {
                ((ConsoleSystem)vehicle.getValue()).enableIMC();
            }
        } else {
            NeptusLog.pub().warn((Object)"Error starting IMC");
        }
    }

    public void imcOff() {
        this.imcMsgManager.removeStatusListener(this.imcManagerStatus == null ? this.setupImcListener() : this.imcManagerStatus);
    }

    public CommManagerStatusChangeListener setupImcListener() {
        this.imcManagerStatus = new CommManagerStatusChangeListener(){

            @Override
            public void managerStatusChanged(int status, String msg) {
                if (status == 0 || status == 1 || status == 2) {
                    // empty if block
                }
            }

            @Override
            public void managerVehicleAdded(VehicleType vehicle) {
                ConsoleLayout.this.addSystem(vehicle.getId());
            }

            @Override
            public void managerVehicleRemoved(VehicleType vehicle) {
            }

            @Override
            public void managerVehicleStatusChanged(VehicleType vehicle, int status) {
            }

            @Override
            public void managerSystemAdded(String systemId) {
                ConsoleLayout.this.addSystem(systemId);
            }

            @Override
            public void managerSystemRemoved(String systemId) {
            }

            @Override
            public void managerSystemStatusChanged(String systemId, int status) {
            }
        };
        return this.imcManagerStatus;
    }

    public ConsoleLayout getConsole() {
        return this;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Map<String, ConsoleSystem> getSystems() {
        return this.consoleSystems;
    }

    public ConsoleSystem getSystem(String name) {
        return (ConsoleSystem)this.consoleSystems.get(name);
    }

    public ImcMsgManager getImcMsgManager() {
        return this.imcMsgManager;
    }

    public void setConsoleChanged(boolean needsToSave) {
        this.changed = needsToSave;
        ConsoleAction saveConsoleAction = this.actions.get(SaveConsoleAction.class);
        if (saveConsoleAction != null) {
            saveConsoleAction.setEnabled(needsToSave);
        }
    }

    public boolean isConsoleChanged() {
        return this.changed;
    }

    public ControllerManager getControllerManager() {
        return this.controllerManager;
    }

    public List<IConsoleLayer> getLayers() {
        return Arrays.asList(this.layers.keySet().toArray(new IConsoleLayer[0]));
    }

    public List<IConsoleInteraction> getInteractions() {
        return Arrays.asList(this.interactions.keySet().toArray(new IConsoleInteraction[0]));
    }

    public static void main(String[] args) {
        GuiUtils.setLookAndFeel();
        File[] consoles = new File("conf/consoles").listFiles();
        Vector<String> options = new Vector<String>();
        for (File f : consoles) {
            if (!FileUtil.getFileExtension(f).equalsIgnoreCase("ncon")) continue;
            options.add(FileUtil.getFileNameWithoutExtension(f));
        }
        final Collator collator = Collator.getInstance(Locale.US);
        Collections.sort(options, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return collator.compare(o1, o2);
            }
        });
        String op = "" + JOptionPane.showInputDialog(null, I18n.text("Select console to open"), I18n.text("Neptus Console"), 3, ImageUtils.getIcon("images/neptus-icon1.png"), options.toArray(new String[0]), "lauv");
        if (op.equals("null")) {
            return;
        }
        NeptusMain.main(new String[]{"-f", new File(new File("conf/consoles"), op + ".ncon").getAbsolutePath()});
    }
}

