/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.state.ImcSysState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.iridium.ImcIridiumMessage;
import pt.lsts.neptus.comm.iridium.IridiumManager;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.MainPanel;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.console.plugins.PlanChangeListener;
import pt.lsts.neptus.console.plugins.planning.MapPanel;
import pt.lsts.neptus.events.NeptusEvents;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.plugins.CheckMenuChangeListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.plugins.update.PeriodicUpdatesService;
import pt.lsts.neptus.renderer2d.CustomInteractionSupport;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.types.XmlInOutMethods;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.ListenerManager;
import pt.lsts.neptus.util.ReflectionUtil;

public abstract class ConsolePanel
extends JPanel
implements PropertiesProvider,
XmlInOutMethods,
MessageListener<MessageInfo, IMCMessage>,
MainVehicleChangeListener {
    private static final String DEFAULT_ROOT_ELEMENT = "subpanel";
    private static final long serialVersionUID = -2131046685846552482L;
    private final Vector<String> addedMenus = new Vector();
    private final ConsoleLayout console;
    private final MainPanel mainpanel;
    private ListenerManager listenerManager;
    private final Vector<Integer> messagesToListen = new Vector();
    private String mainVehicleId = null;
    protected JDialog dialog = null;
    private JMenuItem menuItem = null;
    private double percentXPos;
    private double percentYPos;
    private double percentWidth;
    private double percentHeight;
    private boolean editmode;
    private boolean fixedPosition = false;
    private boolean fixedSize = false;
    private boolean popupPositionFlag = false;
    private boolean resizable = true;
    private boolean visibility = true;
    private Collection<IPeriodicUpdates> periodicMethods = null;

    public ConsolePanel(ConsoleLayout console) {
        this.console = console;
        MainPanel mainPanel = this.mainpanel = console == null ? null : console.getMainPanel();
        if (console != null) {
            NeptusEvents.register(this, console);
        }
    }

    protected final void activateComponents() {
        this.listenerManager.turnon();
    }

    public JCheckBoxMenuItem addCheckMenuItem(String itemPath, ImageIcon icon, CheckMenuChangeListener checkListener) {
        String[] ptmp = itemPath.split(">");
        if (ptmp.length < 2) {
            NeptusLog.pub().error((Object)"Menu path has to have at least two components");
            return null;
        }
        String[] path = new String[ptmp.length - 1];
        System.arraycopy(ptmp, 0, path, 0, path.length);
        String menuName = ptmp[ptmp.length - 1];
        JMenu menu = this.getConsole().getOrCreateJMenu(path);
        final CheckMenuChangeListener l = checkListener;
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(new AbstractAction(menuName, icon == null ? null : ImageUtils.getScaledIcon(icon.getImage(), 16, 16)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    l.menuChecked(e);
                } else {
                    l.menuUnchecked(e);
                }
            }
        });
        menu.add(item);
        this.addedMenus.add(itemPath);
        return item;
    }

    public JMenu addMenu(String itemPath, ImageIcon icon) {
        String[] ptmp = itemPath.split(">");
        if (ptmp.length < 1) {
            NeptusLog.pub().error((Object)"Menu path has to have at least one component");
            return null;
        }
        String[] path = new String[ptmp.length - 1];
        System.arraycopy(ptmp, 0, path, 0, path.length);
        JMenu menu = this.getConsole().getOrCreateJMenu(path);
        this.addedMenus.add(itemPath);
        return menu;
    }

    public JMenuItem addMenuItem(String itemPath, ImageIcon icon, ActionListener actionListener) {
        this.addedMenus.add(itemPath);
        return this.getConsole().addMenuItem(itemPath, icon, actionListener);
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document doc = null;
        doc = DocumentHelper.createDocument();
        Element root = doc.addElement(rootElementName);
        root.addAttribute("class", this.getClass().getName());
        root.addAttribute("x", "" + this.getX());
        root.addAttribute("y", "" + this.getY());
        root.addAttribute("width", "" + this.getWidth());
        root.addAttribute("height", "" + this.getHeight());
        Element properties = root.addElement("properties");
        this.XML_PropertiesWrite(properties);
        this.XML_ChildsWrite(root);
        return doc;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    private void buildPopup() {
        Popup cAction = this.getClass().getAnnotation(Popup.class);
        if (cAction == null) {
            return;
        }
        final Popup.POSITION popupPosition = cAction.pos();
        String name2 = cAction.name().isEmpty() ? this.getName() : cAction.name();
        name2 = I18n.text(name2);
        String iconPath = cAction.icon().isEmpty() ? PluginUtils.getPluginIcon(this.getClass()) : cAction.icon();
        int width = cAction.width();
        int height = cAction.height();
        KeyStroke accelerator = null;
        if (cAction.accelerator() != 0) {
            int key = cAction.accelerator();
            if (key == 67 || key == 86 || key == 88) {
                NeptusLog.pub().error((Object)"Cant assign CTRL-X, CTRL-C or CTRL-V to popups.");
            } else {
                accelerator = KeyStroke.getKeyStroke(cAction.accelerator(), 128);
            }
        }
        JMenu menu = this.getConsole().getOrCreateJMenu(new String[]{I18n.text("View")});
        ImageIcon icon = ImageUtils.getIcon(iconPath);
        this.menuItem = this.createMenuItem(popupPosition, name2, icon);
        if (accelerator != null) {
            this.menuItem.setAccelerator(accelerator);
        }
        menu.add(this.menuItem);
        this.dialog = new JDialog(this.getConsole());
        this.dialog.setTitle(name2);
        this.dialog.setIconImage(icon.getImage());
        this.dialog.setDefaultCloseOperation(1);
        this.dialog.setSize(width, height);
        if (accelerator != null) {
            this.getConsole().registerGlobalKeyBinding(accelerator, new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConsolePanel.this.dialog.setVisible(!ConsolePanel.this.dialog.isVisible());
                    ConsolePanel.this.setPopupPosition(popupPosition);
                }
            });
        }
        this.dialog.add(this);
    }

    public void clean() {
        NeptusEvents.unregister(this, this.console);
        if (this instanceof MissionChangeListener) {
            this.getConsole().removeMissionListener((MissionChangeListener)((Object)this));
        }
        if (this instanceof MainVehicleChangeListener) {
            this.getConsole().removeMainVehicleListener(this);
        }
        if (this instanceof PlanChangeListener) {
            this.getConsole().removePlanListener((PlanChangeListener)((Object)this));
        }
        this.getConsole().removeMainVehicleListener(this);
        if (this instanceof IPeriodicUpdates) {
            PeriodicUpdatesService.unregister((IPeriodicUpdates)((Object)this));
        }
        if (this.periodicMethods != null) {
            for (IPeriodicUpdates i : this.periodicMethods) {
                PeriodicUpdatesService.unregister(i);
            }
            this.periodicMethods.clear();
        }
        if (this instanceof NeptusMessageListener && this.getConsole() != null) {
            this.messagesToListen.clear();
            ImcMsgManager.getManager().removeListener(this, this.getConsole().getMainSystem());
        }
        ImcMsgManager.unregisterBusListener(this);
        for (String menuPath : this.addedMenus) {
            JMenu parent = this.getConsole().removeMenuItem(menuPath.split(">"));
            if (parent == null || parent.getItemCount() != 0) continue;
            this.getConsole().removeMenuItem(menuPath.substring(0, menuPath.lastIndexOf(">")).split(">"));
        }
        if (this instanceof Renderer2DPainter) {
            Vector<MapPanel> pp = this.getConsole().getSubPanelsOfClass(MapPanel.class);
            for (MapPanel p : pp) {
                p.removePostRenderPainter((Renderer2DPainter)((Object)this));
            }
        }
        if (this.menuItem != null || this.dialog != null) {
            JMenu menu = this.getConsole().getOrCreateJMenu(new String[]{I18n.text("View")});
            menu.remove(this.menuItem);
            if (this.dialog.isVisible()) {
                NeptusLog.pub().info((Object)("<###> " + this.getName()));
                this.dialog.setDefaultCloseOperation(3);
                this.dialog.dispose();
            }
        }
        this.cleanSubPanel();
    }

    public abstract void cleanSubPanel();

    private JMenuItem createMenuItem(final Popup.POSITION popupPosition, String name2, ImageIcon icon) {
        JMenuItem menuItem = new JMenuItem(new AbstractAction(name2, ImageUtils.getScaledIcon(icon, 16, 16)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsolePanel.this.dialog.setVisible(!ConsolePanel.this.dialog.isVisible());
                ConsolePanel.this.setPopupPosition(popupPosition);
            }
        });
        return menuItem;
    }

    protected final void deactivateComponents() {
        this.listenerManager = new ListenerManager(this);
        this.listenerManager.turnoff();
    }

    protected final ConsolePanel[] getChildren() {
        return new ConsolePanel[0];
    }

    public final ConsoleLayout getConsole() {
        return this.console;
    }

    public String getDescription() {
        return PluginUtils.getPluginDescription(this.getClass());
    }

    public final boolean getEditMode() {
        return this.editmode;
    }

    public ImageIcon getImageIcon() {
        return ImageUtils.getIcon(PluginUtils.getPluginIcon(this.getClass()));
    }

    protected final MainPanel getMainpanel() {
        return this.mainpanel;
    }

    public String getMainVehicleId() {
        return this.mainVehicleId;
    }

    @Override
    public final String getName() {
        return PluginUtils.getPluginName(this.getClass());
    }

    @Override
    public DefaultProperty[] getProperties() {
        return PluginUtils.getPluginProperties(this);
    }

    @Override
    public final String getPropertiesDialogTitle() {
        return PluginUtils.getPluginName(this.getClass()) + " parameters";
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return PluginUtils.validatePluginProperties((Object)this, properties);
    }

    protected final ImcSysState getState() {
        return ImcMsgManager.getManager().getState(this.getConsole().getMainSystem());
    }

    public boolean getVisibility() {
        return this.visibility;
    }

    @Override
    public void inDocument(Document d) {
        this.inElement((Element)d);
    }

    @Override
    public void inElement(Element e) {
        this.XML_PropertiesRead(e.element("properties"));
        this.XML_ChildsRead(e);
    }

    public void init() {
        this.mainVehicleId = this.getConsole().getMainSystem();
        this.getConsole().addMainVehicleListener(this);
        if (this instanceof MissionChangeListener) {
            this.getConsole().addMissionListener((MissionChangeListener)((Object)this));
        }
        if (this instanceof PlanChangeListener) {
            this.getConsole().addPlanListener((PlanChangeListener)((Object)this));
        }
        if (this instanceof Renderer2DPainter) {
            Vector<MapPanel> pp = this.getConsole().getSubPanelsOfClass(MapPanel.class);
            for (MapPanel p : pp) {
                p.addPostRenderPainter((Renderer2DPainter)((Object)this), PluginUtils.getPluginName(this.getClass()));
            }
        }
        if (this instanceof StateRendererInteraction) {
            Vector<CustomInteractionSupport> panels = this.getConsole().getSubPanelsOfInterface(CustomInteractionSupport.class);
            for (CustomInteractionSupport cis : panels) {
                cis.addInteraction((StateRendererInteraction)((Object)this));
            }
        }
        if (!this.getVisibility()) {
            this.setVisible(false);
        }
        if (this.getParent() == null) {
            this.buildPopup();
        }
        this.initSubPanel();
        if (this instanceof IPeriodicUpdates) {
            PeriodicUpdatesService.register((IPeriodicUpdates)((Object)this));
        }
        this.periodicMethods = PeriodicUpdatesService.inspect(this);
        for (IPeriodicUpdates i : this.periodicMethods) {
            PeriodicUpdatesService.register(i);
        }
        ImcMsgManager.registerBusListener(this);
        if (this instanceof NeptusMessageListener) {
            this.getConsole().addMainVehicleListener(this);
            for (String msg : ((NeptusMessageListener)((Object)this)).getObservedMessages()) {
                int id = -1;
                try {
                    id = IMCDefinition.getInstance().getMessageId(msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (id != -1 && !this.messagesToListen.contains(id)) {
                    this.messagesToListen.add(id);
                    continue;
                }
                if (id != -1) continue;
                System.err.println("Message " + msg + " is not valid in the current IMC specification (requested by " + PluginUtils.getPluginName(this.getClass()) + ")");
            }
            if (this.getConsole() != null && !this.messagesToListen.isEmpty()) {
                ImcMsgManager.getManager().addListener(this, this.getConsole().getMainSystem());
            } else {
                NeptusLog.pub().info((Object)("<###>Console is null..." + this.getName()));
            }
        }
    }

    public abstract void initSubPanel();

    @Override
    public void parseXML(String str) {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)str);
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)("Subpanel parse XML string [" + e.getStackTrace() + "]"));
            return;
        }
        if (document != null) {
            this.inDocument(document);
        }
    }

    public boolean isFixedPosition() {
        return this.fixedPosition;
    }

    public boolean isFixedSize() {
        return this.fixedSize;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    @Override
    public final void mainVehicleChange(String id) {
        if (this.messagesToListen != null && !this.messagesToListen.isEmpty()) {
            ImcMsgManager.getManager().removeListener(this, this.mainVehicleId);
        }
        this.mainVehicleId = id;
        if (this.messagesToListen != null && !this.messagesToListen.isEmpty()) {
            ImcMsgManager.getManager().addListener(this, id);
        }
        if (this instanceof NeptusMessageListener) {
            for (Integer msgStr : this.messagesToListen) {
                IMCMessage msg = this.getConsole().getImcState().get(msgStr.intValue());
                if (msg == null) continue;
                ((NeptusMessageListener)((Object)this)).messageArrived(msg);
            }
        }
    }

    public final void onMessage(MessageInfo arg0, IMCMessage arg1) {
        if (this.messagesToListen.contains(arg1.getMessageType().getId())) {
            ((NeptusMessageListener)((Object)this)).messageArrived(arg1);
        }
    }

    protected final void parentResized(Dimension oldSize, Dimension newSize) {
        if (this.getWidth() <= 0 || oldSize.getWidth() <= 0.0 || newSize.getWidth() <= 0.0) {
            return;
        }
        if (this.percentWidth == 0.0 && this.getWidth() != 0) {
            this.percentWidth = (double)this.getWidth() / oldSize.getWidth();
            this.percentHeight = (double)this.getHeight() / oldSize.getHeight();
            this.percentXPos = (double)this.getX() / oldSize.getWidth();
            this.percentYPos = (double)this.getY() / oldSize.getHeight();
        }
        if (!this.isFixedPosition()) {
            this.setLocation((int)(this.percentXPos * newSize.getWidth()), (int)(this.percentYPos * newSize.getHeight()));
        }
        if (!this.isFixedSize()) {
            this.setSize((int)(this.percentWidth * newSize.getWidth()), (int)(this.percentHeight * newSize.getHeight()));
        }
    }

    public void post(Object event) {
        NeptusEvents.post(event, this.console);
    }

    protected final void recalculateRelativePosAndSize() {
        if (this.mainpanel == null || this.mainpanel.getWidth() <= 0) {
            return;
        }
        this.percentWidth = (double)this.getWidth() / (double)this.mainpanel.getWidth();
        this.percentHeight = (double)this.getHeight() / (double)this.mainpanel.getHeight();
        this.percentXPos = (double)this.getX() / (double)this.mainpanel.getWidth();
        this.percentYPos = (double)this.getY() / (double)this.mainpanel.getHeight();
    }

    public void removeCheckMenuItem(String itemPath) {
        this.removeMenuItem(itemPath);
    }

    public void removeMenuItem(String itemPath) {
        this.addedMenus.remove(itemPath);
        JMenu parent = this.getConsole().removeMenuItem(itemPath.split(">"));
        if (parent != null && parent.getItemCount() == 0) {
            this.getConsole().removeMenuItem(itemPath.substring(0, itemPath.lastIndexOf(">")).split(">"));
        }
    }

    public boolean send(IMCMessage message) {
        String destination = this.getConsole().getMainSystem();
        return this.send(destination, message);
    }

    public void sendViaIridium(String destination, IMCMessage message) {
        if (message.getTimestamp() == 0.0) {
            message.setTimestampMillis(System.currentTimeMillis());
        }
        Collection<Object> irMsgs = new ArrayList();
        try {
            irMsgs = IridiumManager.iridiumEncode(message);
        }
        catch (Exception e) {
            GuiUtils.errorMessage(this.getConsole(), e);
            return;
        }
        int src = ImcMsgManager.getManager().getLocalId().intValue();
        int dst = IMCDefinition.getInstance().getResolver().resolve(destination);
        int count = 0;
        try {
            NeptusLog.pub().warn((Object)(message.getAbbrev() + " resulted in " + irMsgs.size() + " iridium SBD messages."));
            for (ImcIridiumMessage imcIridiumMessage : irMsgs) {
                imcIridiumMessage.setDestination(dst);
                imcIridiumMessage.setSource(src);
                imcIridiumMessage.timestampMillis = message.getTimestampMillis();
                if (imcIridiumMessage.timestampMillis == 0L) {
                    imcIridiumMessage.timestampMillis = System.currentTimeMillis();
                }
                IridiumManager.getManager().send(imcIridiumMessage);
                ++count;
            }
            this.getConsole().post(Notification.success("Iridium message sent", count + " Iridium messages were sent using " + IridiumManager.getManager().getCurrentMessenger().getName()));
        }
        catch (Exception e) {
            GuiUtils.errorMessage(this.getConsole(), e);
            return;
        }
    }

    public boolean send(String destination, IMCMessage message) {
        if (destination == null || destination.isEmpty()) {
            NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + ": destination null or empty"));
            return false;
        }
        try {
            if (!ImcMsgManager.getManager().sendMessageToSystem(message, destination)) {
                NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + ": " + "Error while communicating with " + destination + "."));
                return false;
            }
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e);
            return false;
        }
        return true;
    }

    protected void setEditMode(boolean b) {
        this.editmode = b;
        if (!this.getEditMode() && !this.visibility) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }

    public void setFixedPosition(boolean fixedPosition) {
        this.fixedPosition = fixedPosition;
    }

    public void setFixedSize(boolean fixedSize) {
        this.fixedSize = fixedSize;
    }

    protected void setPopupPosition(Popup.POSITION popupPosition) {
        if (this.dialog.isVisible() && !this.popupPositionFlag) {
            Point p = this.getConsole().getLocationOnScreen();
            switch (popupPosition) {
                case TOP_LEFT: {
                    break;
                }
                case TOP_RIGHT: {
                    p.x += this.getConsole().getWidth() - this.dialog.getWidth();
                    break;
                }
                case BOTTOM_LEFT: {
                    p.y += this.getConsole().getHeight() - this.dialog.getHeight();
                    break;
                }
                case BOTTOM_RIGHT: {
                    p.x += this.getConsole().getWidth() - this.dialog.getWidth();
                    p.y += this.getConsole().getHeight() - this.dialog.getHeight();
                    break;
                }
                case TOP: {
                    p.x += this.getConsole().getWidth() / 2 - this.dialog.getWidth() / 2;
                    break;
                }
                case BOTTOM: {
                    p.x += this.getConsole().getWidth() / 2 - this.dialog.getWidth() / 2;
                    p.y += this.getConsole().getHeight() - this.dialog.getHeight();
                    break;
                }
                case LEFT: {
                    p.y += this.getConsole().getHeight() / 2 - this.dialog.getHeight() / 2;
                    break;
                }
                case RIGHT: {
                    p.x += this.getConsole().getWidth() - this.dialog.getWidth();
                    p.y += this.getConsole().getHeight() / 2 - this.dialog.getHeight() / 2;
                    break;
                }
                default: {
                    p.x += this.getConsole().getWidth() / 2 - this.dialog.getWidth() / 2;
                    p.y += this.getConsole().getHeight() / 2 - this.dialog.getHeight() / 2;
                }
            }
            this.dialog.setLocation(p);
            this.popupPositionFlag = true;
        }
    }

    @Override
    public void setProperties(Property[] properties) {
        PluginUtils.setPluginProperties((Object)this, properties);
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public void setVisibility(boolean visibility) {
        this.visibility = visibility;
    }

    public void XML_ChildsRead(Element e) {
    }

    public void XML_ChildsWrite(Element e) {
    }

    public void XML_PropertiesRead(Element e) {
        PluginUtils.setConfigXml(this, e.asXML());
    }

    public void XML_PropertiesWrite(Element e) {
        String xml = PluginUtils.getConfigXml(this);
        try {
            Element el = DocumentHelper.parseText((String)xml).getRootElement();
            for (Object child : el.elements()) {
                Element aux = (Element)child;
                aux.detach();
                e.add(aux);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

