/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console;

import java.util.Vector;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.events.ConsoleEventVehicleStateChanged;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.console.plugins.SubPanelChangeEvent;
import pt.lsts.neptus.console.plugins.SubPanelChangeListener;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.renderer2d.VehicleStateListener;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.ScatterPointsElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.conf.PreferencesListener;

public class ConsoleSystem
implements MissionChangeListener,
PreferencesListener,
SubPanelChangeListener,
MessageListener<MessageInfo, IMCMessage> {
    public final int POS_ONLY_XYZ = 0;
    public final int POS_ONLY_LAT_LON = 1;
    public final int POS_LAT_LON_XYZ = 2;
    protected ImcSystem imcSystem;
    private final ImcMsgManager imc;
    protected SystemPositionAndAttitude state;
    protected ConsoleLayout console;
    private LocationType vehicleHomeRef;
    private CoordinateSystem homeRef;
    private boolean neptusCommunications = false;
    protected Vector<VehicleStateListener> feedRenders = new Vector();
    protected int minDelay = -1;
    protected long lastVehicleState = -1L;
    protected MapType mapCS = new MapType();
    protected ScatterPointsElement scatter = null;
    private MissionType missionType = new MissionType();
    protected boolean tailOn = false;
    private int numberOfShownPoints = 500;
    private ConsoleEventVehicleStateChanged.STATE vehicleState = ConsoleEventVehicleStateChanged.STATE.DISCONNECTED;
    private String name;

    public ConsoleSystem(String systemName, ConsoleLayout console, ImcSystem vehicle, ImcMsgManager imcMsgManager) {
        this.imc = imcMsgManager;
        this.console = console;
        this.imcSystem = vehicle;
        this.name = systemName;
        this.state = new SystemPositionAndAttitude(new LocationType(), 0.0, 0.0, 0.0);
        if (console.getMission() != null) {
            try {
                this.vehicleHomeRef = console.getMission().getVehiclesList().get(this.getVehicleId()).getCoordinateSystem();
            }
            catch (Exception e) {
                NeptusLog.pub().debug((Object)(this + " exception while getting vehicleHomeRef " + this.getVehicleId()), (Throwable)e);
                this.vehicleHomeRef = console.getMission().getHomeRef();
            }
            this.state = new SystemPositionAndAttitude(new LocationType(this.vehicleHomeRef), 0.0, 0.0, 0.0);
            this.homeRef = console.getMission().getHomeRef();
            this.missionType = console.getMission();
        } else {
            this.state = new SystemPositionAndAttitude(new LocationType(), 0.0, 0.0, 0.0);
            this.missionType = new MissionType();
        }
        this.console.addMissionListener(this);
        this.console.addSubPanelListener(this);
        this.preferencesUpdated();
        GeneralPreferences.addPreferencesListener(this);
        NeptusLog.pub().debug((Object)(this.getClass().getSimpleName() + " [" + this.hashCode() + "] started for vehicle " + vehicle.getName()));
    }

    public ConsoleSystem enableIMC() {
        if (!this.neptusCommunications) {
            if (this.imcSystem == null) {
                NeptusLog.pub().info((Object)"<###>vehicle null");
            }
            if (this.imc == null) {
                NeptusLog.pub().info((Object)"<###>imc null");
            }
            this.imc.addListener(this, this.imcSystem.getId());
            this.neptusCommunications = true;
        }
        return this;
    }

    public ConsoleSystem disableIMC() {
        if (this.neptusCommunications) {
            this.imc.removeListener(this, this.imcSystem.getId());
            this.neptusCommunications = false;
        }
        return this;
    }

    public ConsoleSystem toggleIMC() {
        if (this.neptusCommunications) {
            this.imc.removeListener(this, this.imcSystem.getId());
            this.neptusCommunications = false;
        } else {
            this.imc.addListener(this, this.imcSystem.getId());
            this.neptusCommunications = true;
        }
        return this;
    }

    public void clean() {
        this.feedRenders.clear();
        this.disableIMC();
        GeneralPreferences.removePreferencesListener(this);
        MapGroup mgp = MapGroup.getMapGroupInstance(this.missionType);
        if (this.mapCS != null) {
            mgp.removeMap(this.mapCS.getId());
        }
        this.mapCS = null;
        this.console.removeMissionListener(this);
        this.console.removeSubPanelListener(this);
        NeptusLog.pub().debug((Object)(this.getClass().getSimpleName() + " [" + this.hashCode() + "] shutdown for vehicle " + this.imcSystem.getName()));
    }

    public boolean isTranslateClicle() {
        return false;
    }

    public String getVehicleId() {
        if (this.imcSystem != null) {
            return this.imcSystem.getName();
        }
        return null;
    }

    public void onMessage(MessageInfo info, IMCMessage msg) {
        if (msg.getAbbrev().equals("EstimatedState")) {
            EstimatedState es = (EstimatedState)msg;
            LocationType loc = new LocationType();
            loc.setLatitudeRads(es.getLat());
            loc.setLongitudeRads(es.getLon());
            loc.setHeight(loc.getHeight());
            double phi = es.getPhi();
            double theta = es.getTheta();
            double psi = es.getPsi();
            double p = es.getP();
            double q = es.getQ();
            double r = es.getR();
            double u = es.getU();
            double v = es.getV();
            double w = es.getW();
            double vx = es.getVx();
            double vy = es.getVy();
            double vz = es.getVz();
            loc.translatePosition(es.getX(), es.getY(), es.getZ());
            double time = info.getTimeReceivedNanos() / 1000000L;
            this.state.setPosition(loc);
            this.state.setRoll(phi);
            this.state.setPitch(theta);
            this.state.setYaw(psi);
            this.state.setUVW(u, v, w);
            this.state.setPQR(p, q, r);
            this.state.setVxyz(vx, vy, vz);
            if (time <= 0.0) {
                this.state.setTime(System.currentTimeMillis());
            } else {
                this.state.setTime((long)time);
            }
            long previousVehicleState = this.lastVehicleState;
            VehicleType ve = VehiclesHolder.getVehicleById(this.getVehicleId());
            if (this.minDelay <= 0 || System.currentTimeMillis() - previousVehicleState >= (long)this.minDelay) {
                this.lastVehicleState = System.currentTimeMillis();
                for (VehicleStateListener j : this.feedRenders) {
                    j.setVehicleState(ve, this.state);
                }
                if (this.isTailOn()) {
                    if (this.scatter == null) {
                        this.scatter = new ScatterPointsElement(MapGroup.getMapGroupInstance(this.missionType), this.mapCS);
                        this.scatter.setCenterLocation(new LocationType(loc));
                        this.mapCS.addObject(this.scatter);
                    }
                    this.scatter.addPoint(loc);
                } else if (this.scatter != null) {
                    this.scatter.clearPoints();
                }
            }
        }
    }

    public SystemPositionAndAttitude getState() {
        return this.state;
    }

    public boolean isTailOn() {
        return this.tailOn;
    }

    public void setTailOn(boolean tailOn) {
        this.tailOn = tailOn;
    }

    public void addRenderFeed(VehicleStateListener mr) {
        if (!this.feedRenders.contains(mr)) {
            this.feedRenders.add(mr);
        }
    }

    public void removeRenderFeed(VehicleStateListener mr) {
        this.feedRenders.remove(mr);
    }

    public ImcSystem getVehicle() {
        return this.imcSystem;
    }

    public boolean isNeptusCommunications() {
        return this.neptusCommunications;
    }

    public boolean getNeptusCommunications() {
        return this.neptusCommunications;
    }

    @Override
    public void missionReplaced(MissionType mission) {
        this.state = new SystemPositionAndAttitude(new LocationType(), 0.0, 0.0, 0.0);
        if (this.console.getMission() != null) {
            try {
                this.vehicleHomeRef = this.console.getMission().getVehiclesList().get(this.getVehicleId()).getCoordinateSystem();
            }
            catch (Exception e) {
                NeptusLog.pub().debug((Object)(this + " getting vehicleHomeRef " + this.getVehicleId()));
                this.vehicleHomeRef = this.console.getMission().getHomeRef();
            }
            this.state = new SystemPositionAndAttitude(new LocationType(this.vehicleHomeRef), 0.0, 0.0, 0.0);
            this.homeRef = this.console.getMission().getHomeRef();
        } else {
            this.state = new SystemPositionAndAttitude(new LocationType(), 0.0, 0.0, 0.0);
        }
        this.missionType = mission;
        if (this.scatter != null) {
            this.mapCS.remove(this.scatter.getId());
            this.scatter = null;
        }
    }

    public LocationType getVehicleHomeRef() {
        return this.vehicleHomeRef;
    }

    public LocationType getHomeRef() {
        return this.homeRef;
    }

    @Override
    public void preferencesUpdated() {
        this.minDelay = GeneralPreferences.rendererUpdatePeriodeForVehicleStateMillis;
        int np = 500;
        if (this.scatter != null) {
            np = GeneralPreferences.numberOfShownPoints;
            this.scatter.setNumberOfPoints(np);
            this.numberOfShownPoints = np < 0 ? Integer.MAX_VALUE : np;
        }
    }

    public int getNumberOfShownPoints() {
        return this.numberOfShownPoints;
    }

    @Override
    public void missionUpdated(MissionType mission) {
    }

    @Override
    public void subPanelChanged(SubPanelChangeEvent panelChange) {
        if (VehicleStateListener.class.isAssignableFrom(panelChange.getPanel().getClass())) {
            if (panelChange.removed()) {
                this.feedRenders.remove(panelChange.getPanel());
            }
            if (panelChange.added()) {
                this.feedRenders.add((VehicleStateListener)((Object)panelChange.getPanel()));
            }
        }
    }

    public ConsoleEventVehicleStateChanged.STATE getVehicleState() {
        return this.vehicleState;
    }

    public void setVehicleState(ConsoleEventVehicleStateChanged.STATE vehicleState) {
        this.vehicleState = vehicleState;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

