/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console;

import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.LockableSubPanel;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class ContainerSubPanel
extends ConsolePanel
implements LockableSubPanel {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="Maximize Panel", description="Use this to indicate that this panel should be maximized on load. (Only works for top level panels.)", distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public boolean maximizePanel = false;
    protected List<ConsolePanel> panels = new ArrayList<ConsolePanel>();

    public ContainerSubPanel(ConsoleLayout console) {
        super(console);
        this.setEditMode(this.getEditMode());
    }

    protected void setMaximizePanel(boolean maximize) {
        if (maximize) {
            this.getConsole().maximizePanel(this);
        } else {
            this.getConsole().minimizePanel(this);
        }
    }

    @Override
    public void init() {
        for (ConsolePanel sp : this.panels) {
            sp.init();
        }
        if (this.maximizePanel) {
            this.setMaximizePanel(true);
        }
    }

    @Override
    public void setEditMode(boolean b) {
        super.setEditMode(b);
        for (ConsolePanel sp : this.panels) {
            try {
                sp.setEditMode(b);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addSubPanel(ConsolePanel panel) {
        this.panels.add(panel);
        this.add(panel);
    }

    public void removeSubPanel(ConsolePanel sp) {
        this.panels.remove(sp);
        this.remove(sp);
        this.doLayout();
        this.invalidate();
        this.revalidate();
    }

    private List<String> subPanelNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.panels.size(); ++i) {
            int count = 0;
            for (int j = 0; j < i; ++j) {
                if (!this.panels.get(j).getName().equalsIgnoreCase(this.panels.get(i).getName())) continue;
                ++count;
            }
            String name = count > 0 ? this.panels.get(i).getName() + "_" + count : this.panels.get(i).getName();
            names.add(name);
        }
        return names;
    }

    public String[] subPanelList() {
        return this.subPanelNames().toArray(new String[0]);
    }

    public void removeSubPanel(String subPanelName) {
        ConsolePanel sp = this.getSubPanelByName(subPanelName);
        sp.clean();
        if (sp != null) {
            this.removeSubPanel(sp);
        }
    }

    public ConsolePanel getSubPanelByName(String name) {
        List<String> names = this.subPanelNames();
        int index = names.indexOf(name);
        if (index != -1) {
            return this.panels.get(index);
        }
        return null;
    }

    @Override
    public void XML_ChildsWrite(Element e) {
        for (ConsolePanel sp : this.panels) {
            try {
                e.add(sp.asElement("child"));
            }
            catch (Exception ex) {
                Container parent = SwingUtilities.getWindowAncestor(this);
                if (parent == null) {
                    parent = this;
                }
                GuiUtils.errorMessage(parent, "Error saving XML of " + sp.getName(), "[" + sp.getName() + "]: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void XML_ChildsRead(Element el) {
        List list = el.selectNodes("*");
        for (Element element : list) {
            ConsolePanel subpanel = null;
            if (!"child".equals(element.getName())) continue;
            Attribute attribute = element.attribute("class");
            ConfigFetch.mark(attribute.getValue());
            try {
                Class<?> clazz = Class.forName(attribute.getValue());
                try {
                    subpanel = (ConsolePanel)clazz.getConstructor(ConsoleLayout.class).newInstance(this.getConsole());
                    this.addSubPanel(subpanel);
                    subpanel.inElement(element);
                    ConfigFetch.benchmark(attribute.getValue());
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)("creating subpanel new instance " + clazz.getName()), (Throwable)e);
                }
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("Error parsing " + attribute.getValue()), (Throwable)e);
            }
        }
    }

    @Override
    public void XML_PropertiesWrite(Element e) {
        String xml = PluginUtils.getConfigXml(this);
        try {
            Element el = DocumentHelper.parseText((String)xml).getRootElement();
            for (Object child : el.elements()) {
                Element aux = (Element)child;
                aux.detach();
                e.add(aux);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void clean() {
        super.clean();
        this.removeAll();
        for (ConsolePanel panel : this.panels) {
            try {
                panel.clean();
                NeptusLog.pub().info((Object)("Cleaned " + panel.getName() + " in " + this.getName()));
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("Error cleaning " + panel.getName() + " in " + this.getName() + " :: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public boolean isLocked() {
        if (this.panels.size() == 0) {
            return false;
        }
        boolean ret = true;
        for (ConsolePanel subPanel : this.panels) {
            try {
                LockableSubPanel lsp = (LockableSubPanel)((Object)subPanel);
                if (ret = ret && lsp.isLocked()) continue;
                break;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    public void lock() {
        for (ConsolePanel subPanel : this.panels) {
            try {
                LockableSubPanel lsp = (LockableSubPanel)((Object)subPanel);
                lsp.lock();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void unLock() {
        for (ConsolePanel subPanel : this.panels) {
            try {
                LockableSubPanel lsp = (LockableSubPanel)((Object)subPanel);
                lsp.unLock();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<ConsolePanel> getSubPanels() {
        return this.panels;
    }

    @Override
    public void cleanSubPanel() {
    }

    @Override
    public void initSubPanel() {
    }
}

