/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.ContainerSubPanel;
import pt.lsts.neptus.console.plugins.AlarmListener;
import pt.lsts.neptus.console.plugins.SubPanelChangeEvent;
import pt.lsts.neptus.gui.MenuScroller;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.PluginsRepository;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class MainPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 7355410533809066603L;
    protected AlarmListener alarmlistener = null;
    protected String adding = "";
    protected ConsolePanel hitPanel;
    private int deltaX;
    private int deltaY;
    private int oldX;
    private int oldY;
    private final int TOL = 3;
    protected Class<?> subadd = null;
    private boolean editFlag = false;
    public boolean relayoutOnResize = false;
    private final ConsoleLayout console;

    public MainPanel(ConsoleLayout console) {
        this.console = console;
        this.setLayout((LayoutManager)new MigLayout("ins 0"));
        this.setName("MainPanel");
    }

    public void addSubPanel(ConsolePanel panel) {
        this.add((Component)panel, "width 100%!, height 100%!");
        this.console.getSubPanels().add(panel);
        this.console.informSubPanelListener(panel, SubPanelChangeEvent.SubPanelChangeAction.ADDED);
    }

    public void addSubPanel(ConsolePanel panel, int x, int y) {
        this.add(panel);
        panel.setLocation(x, y);
        this.revalidate();
        this.repaint();
        this.console.getSubPanels().add(panel);
        this.console.informSubPanelListener(panel, SubPanelChangeEvent.SubPanelChangeAction.ADDED);
    }

    public void clean() {
        this.removeAll();
        for (ConsolePanel panel : this.console.getSubPanels()) {
            try {
                panel.clean();
                NeptusLog.pub().info((Object)("Cleaned " + panel.getName() + " in " + this.getName()));
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("Error cleaning " + panel.getName() + " in " + this.getName() + " :: " + e.getMessage()), (Throwable)e);
            }
        }
        this.console.getSubPanels().clear();
    }

    public void resetPanelLocations() {
        if (!this.relayoutOnResize || this.editFlag || this.getConsole().getMaximizedPanel() != null) {
            return;
        }
        for (ConsolePanel p : this.getConsole().getSubPanels()) {
            if (!p.getParent().equals(this) || p.isFixedSize() && p.isFixedPosition()) continue;
            p.recalculateRelativePosAndSize();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Component comp;
        Component outerMostComponent = this.getComponentAt(e.getPoint());
        ConsolePanel innerMostSubPanel = null;
        ContainerSubPanel innerMostContainer = null;
        for (comp = SwingUtilities.getDeepestComponentAt(this, e.getX(), e.getY()); comp != null && !(comp instanceof ConsolePanel); comp = comp.getParent()) {
        }
        innerMostSubPanel = (ConsolePanel)comp;
        while (comp != null && !(comp instanceof ContainerSubPanel)) {
            comp = comp.getParent();
        }
        innerMostContainer = (ContainerSubPanel)comp;
        if (!this.adding.equals("")) {
            this.setEditOff();
            this.setCursor(new Cursor(0));
            ConsolePanel sub = new ConsolePanel(this.getConsole()){
                private static final long serialVersionUID = 8543725153078587308L;

                @Override
                public void cleanSubPanel() {
                }

                @Override
                public void initSubPanel() {
                }
            };
            sub.setSize(sub.getPreferredSize());
            sub.setLocation(e.getX(), e.getY());
            sub.setName(this.adding);
            if (innerMostContainer != null) {
                innerMostContainer.addSubPanel(sub);
            } else {
                this.add(sub);
            }
            this.revalidate();
            sub.init();
            this.console.getSubPanels().add(sub);
            this.console.informSubPanelListener(sub, SubPanelChangeEvent.SubPanelChangeAction.ADDED);
            this.adding = "";
            this.setEditOn();
            return;
        }
        if (this.subadd != null) {
            try {
                ConsolePanel sp = PluginsRepository.getPanelPlugin(PluginUtils.getPluginName(this.subadd), this.console);
                if (innerMostContainer != null) {
                    innerMostContainer.addSubPanel(sp);
                    NeptusLog.pub().warn((Object)("Added new plugin: " + sp.getName()));
                } else {
                    this.addSubPanel(sp, e.getX(), e.getY());
                }
                sp.init();
                sp.deactivateComponents();
                sp.setEditMode(true);
                this.console.informSubPanelListener(sp, SubPanelChangeEvent.SubPanelChangeAction.ADDED);
            }
            catch (Exception ex) {
                GuiUtils.errorMessage(this, ex);
            }
            this.subadd = null;
            return;
        }
        if (e.getButton() == 1) {
            Component c = this.getComponentAt(e.getPoint());
            if (c instanceof ConsolePanel) {
                this.hitPanel = (ConsolePanel)c;
                this.oldX = this.hitPanel.getX();
                this.oldY = this.hitPanel.getY();
                this.deltaX = e.getX() - this.oldX;
                this.deltaY = e.getY() - this.oldY;
                if (this.oldX < e.getX() - 3) {
                    this.oldX += this.hitPanel.getWidth();
                }
                if (this.oldY < e.getY() - 3) {
                    this.oldY += this.hitPanel.getHeight();
                }
            }
        } else {
            Component c;
            Component t = c = outerMostComponent;
            if (e.isShiftDown() && innerMostContainer != null) {
                t = innerMostContainer;
            } else if (innerMostSubPanel != null) {
                t = innerMostSubPanel;
            }
            final Component son = t;
            if (c instanceof ConsolePanel) {
                final ConsolePanel panel = (ConsolePanel)c;
                JPopupMenu popup = new JPopupMenu();
                popup.add(new JLabel(PluginUtils.i18nTranslate(PluginUtils.getPluginName(c.getClass())), ImageUtils.getScaledIcon(PluginUtils.getPluginIcon(c.getClass()), 16, 16), 0));
                popup.addSeparator();
                if (innerMostContainer == null) {
                    JMenuItem itemRemove = new JMenuItem(I18n.text("Remove"));
                    itemRemove.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MainPanel.this.console.getSubPanels().remove(panel);
                            MainPanel.this.console.informSubPanelListener(panel, SubPanelChangeEvent.SubPanelChangeAction.REMOVED);
                            panel.clean();
                            MainPanel.this.remove(c);
                            MainPanel.this.console.repaint();
                        }
                    });
                    JMenuItem itemProperties = new JMenuItem(I18n.textf("%panel properties", PluginUtils.i18nTranslate(son.getName())));
                    itemProperties.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertiesEditor.editProperties((PropertiesProvider)((ConsolePanel)son), MainPanel.this.getConsole(), true);
                        }
                    });
                    if (((ConsolePanel)son).getProperties().length > 0) {
                        popup.add(itemProperties);
                    }
                    popup.addSeparator();
                    popup.add(itemRemove);
                } else {
                    JMenu remove = new JMenu(I18n.text("Remove"));
                    JMenu properties = new JMenu(I18n.text("Properties"));
                    final ContainerSubPanel container = innerMostContainer;
                    JMenuItem itemRemove = new JMenuItem(PluginUtils.i18nTranslate(PluginUtils.getPluginName(c.getClass())), ImageUtils.getScaledIcon(PluginUtils.getPluginIcon(c.getClass()), 16, 16));
                    itemRemove.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            container.removeSubPanel(panel);
                            MainPanel.this.console.informSubPanelListener(panel, SubPanelChangeEvent.SubPanelChangeAction.REMOVED);
                        }
                    });
                    remove.add(itemRemove);
                    JMenuItem itemProps = new JMenuItem(PluginUtils.i18nTranslate(PluginUtils.getPluginName(c.getClass())), ImageUtils.getScaledIcon(PluginUtils.getPluginIcon(c.getClass()), 16, 16));
                    itemProps.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertiesEditor.editProperties((ConsolePanel)c, true);
                        }
                    });
                    properties.add(itemProps);
                    boolean add = false;
                    String[] ip = innerMostContainer.subPanelList();
                    Arrays.sort(ip, new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            Collator collator = Collator.getInstance(Locale.US);
                            return collator.compare(PluginUtils.i18nTranslate(o1), PluginUtils.i18nTranslate(o2));
                        }
                    });
                    for (String name : ip) {
                        if (!add) {
                            add = true;
                        }
                        final String spname = name;
                        final ContainerSubPanel cont = innerMostContainer;
                        ConsolePanel sp = cont.getSubPanelByName(spname);
                        itemRemove = new JMenuItem(PluginUtils.i18nTranslate(spname), ImageUtils.getScaledIcon(PluginUtils.getPluginIcon(sp.getClass()), 16, 16));
                        itemRemove.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ConsolePanel sp = cont.getSubPanelByName(spname);
                                if (sp != null) {
                                    MainPanel.this.getConsole().getSubPanels().remove(sp);
                                }
                                MainPanel.this.getConsole().informSubPanelListener(sp, SubPanelChangeEvent.SubPanelChangeAction.REMOVED);
                                sp.clean();
                                cont.removeSubPanel(sp);
                                MainPanel.this.repaint();
                            }
                        });
                        remove.add(itemRemove);
                        itemProps = new JMenuItem(PluginUtils.i18nTranslate(spname), ImageUtils.getScaledIcon(PluginUtils.getPluginIcon(sp.getClass()), 16, 16));
                        itemProps.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ConsolePanel sp = cont.getSubPanelByName(spname);
                                if (MainPanel.this.getConsole() != null) {
                                    PropertiesEditor.editProperties((PropertiesProvider)sp, MainPanel.this.getConsole(), true);
                                }
                            }
                        });
                        properties.add(itemProps);
                    }
                    MenuScroller.setScrollerFor(properties, (Component)this, 150, 1, 0);
                    MenuScroller.setScrollerFor(remove, (Component)this, 150, 1, 0);
                    popup.add(properties);
                    popup.addSeparator();
                    popup.add(remove);
                }
                popup.show(this, e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.editFlag) {
            return;
        }
        if (this.hitPanel != null) {
            this.hitPanel.revalidate();
            int x = e.getX();
            int y = e.getY();
            int xDiff = x - this.oldX;
            int yDiff = y - this.oldY;
            int xH = this.hitPanel.getX();
            int yH = this.hitPanel.getY();
            int w = this.hitPanel.getWidth();
            int h = this.hitPanel.getHeight();
            Dimension min = this.hitPanel.getMinimumSize();
            Dimension max = this.hitPanel.getMaximumSize();
            int wMin = (int)min.getWidth();
            int wMax = (int)max.getWidth();
            int hMin = (int)min.getHeight();
            int hMax = (int)max.getHeight();
            int cursorType = this.hitPanel.getCursor().getType();
            if (cursorType == 10) {
                if (!(w <= wMin && xDiff > 0 || w >= wMax && xDiff < 0)) {
                    this.hitPanel.setBounds(x, yH, w - xDiff, h);
                }
            } else if (cursorType == 8) {
                if (!(h <= hMin && yDiff > 0 || h >= hMax && yDiff < 0)) {
                    this.hitPanel.setBounds(xH, y, w, h - yDiff);
                }
            } else if (cursorType == 9) {
                if (!(h <= hMin && yDiff < 0 || h >= hMax && yDiff > 0)) {
                    this.hitPanel.setSize(w, h + yDiff);
                }
            } else if (cursorType == 11) {
                if (!(w <= wMin && xDiff < 0 || w >= wMax && xDiff > 0)) {
                    this.hitPanel.setSize(w + xDiff, h);
                }
            } else if (cursorType == 6) {
                if (!(h <= hMin && yDiff > 0 || h >= hMax && yDiff < 0 || w <= wMin && xDiff > 0 || w >= wMax && xDiff < 0)) {
                    this.hitPanel.setBounds(x, y, w - xDiff, h - yDiff);
                }
            } else if (cursorType == 7) {
                if (!(h <= hMin && yDiff > 0 || h >= hMax && yDiff < 0 || w <= wMin && xDiff < 0 || w >= wMax && xDiff > 0)) {
                    this.hitPanel.setBounds(xH, y, w + xDiff, h - yDiff);
                }
            } else if (cursorType == 4) {
                if (!(h <= hMin && yDiff < 0 || h >= hMax && yDiff > 0 || w <= wMin && xDiff > 0 || w >= wMax && xDiff < 0)) {
                    this.hitPanel.setBounds(x, yH, w - xDiff, h + yDiff);
                }
            } else if (cursorType == 5) {
                if (!(h <= hMin && yDiff < 0 || h >= hMax && yDiff > 0 || w <= wMin && xDiff < 0 || w >= wMax && xDiff > 0)) {
                    this.hitPanel.setSize(w + xDiff, h + yDiff);
                }
            } else {
                this.hitPanel.setLocation(x - this.deltaX, y - this.deltaY);
            }
            this.oldX = e.getX();
            this.oldY = e.getY();
            this.hitPanel.doLayout();
            this.invalidate();
            this.hitPanel.repaint();
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.editFlag) {
            return;
        }
        Component c = this.getComponentAt(e.getPoint());
        if (!(c instanceof ConsolePanel)) {
            c.setCursor(new Cursor(0));
            return;
        }
        if (c instanceof ConsolePanel) {
            int x = e.getX();
            int y = e.getY();
            int xC = c.getX();
            int yC = c.getY();
            int w = c.getWidth();
            int h = c.getHeight();
            if (y >= yC - 3 && y <= yC + 3 && x >= xC - 3 && x <= xC + 3) {
                c.setCursor(new Cursor(6));
            } else if (y >= yC - 3 && y <= yC + 3 && x >= xC - 3 + w && x <= xC + 3 + w) {
                c.setCursor(new Cursor(7));
            } else if (y >= yC - 3 + h && y <= yC + 3 + h && x >= xC - 3 && x <= xC + 3) {
                c.setCursor(new Cursor(4));
            } else if (y >= yC - 3 + h && y <= yC + 3 + h && x >= xC - 3 + w && x <= xC + 3 + w) {
                c.setCursor(new Cursor(5));
            } else if (x >= xC - 3 && x <= xC + 3) {
                c.setCursor(new Cursor(10));
            } else if (y >= yC - 3 && y <= yC + 3) {
                c.setCursor(new Cursor(8));
            } else if (x >= xC - 3 + w && x <= xC + 3 + w) {
                c.setCursor(new Cursor(11));
            } else if (y >= yC - 3 + h && y <= yC + 3 + h) {
                c.setCursor(new Cursor(9));
            } else {
                c.setCursor(new Cursor(13));
            }
            if (!((ConsolePanel)c).isResizable()) {
                c.setCursor(new Cursor(13));
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.hitPanel = null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void setAdding(String string) {
        NeptusLog.pub().info((Object)"<###>adding");
        this.adding = string;
        this.setCursor(new Cursor(12));
    }

    public void setAdding(Class<?> sub) {
        this.setCursor(new Cursor(12));
        this.subadd = sub;
    }

    public void setEditOn() {
        Component[] a;
        this.editFlag = true;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        for (Component c : a = this.getComponents()) {
            if (!(c instanceof ConsolePanel)) continue;
            ConsolePanel panel = (ConsolePanel)c;
            panel.setCursor(new Cursor(0));
            panel.deactivateComponents();
            panel.setEditMode(true);
        }
    }

    public void setEditOff() {
        Component[] a;
        this.editFlag = false;
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        for (Component c : a = this.getComponents()) {
            if (!(c instanceof ConsolePanel)) continue;
            ConsolePanel panel = (ConsolePanel)c;
            panel.setEditMode(false);
            panel.setCursor(new Cursor(0));
            panel.activateComponents();
        }
    }

    public ConsoleLayout getConsole() {
        return this.console;
    }

    public AlarmListener getAlarmlistener() {
        if (this.alarmlistener != null) {
            return this.alarmlistener;
        }
        return null;
    }

    public boolean isEditFlag() {
        return this.editFlag;
    }

    public void setAlarmlistener(AlarmListener alarmlistener) {
        this.alarmlistener = alarmlistener;
    }

    public boolean isRelayoutOnResize() {
        return this.relayoutOnResize;
    }

    public void setRelayoutOnResize(boolean relayoutOnResize) {
        this.relayoutOnResize = relayoutOnResize;
    }
}

