/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console;

import com.google.common.eventbus.Subscribe;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.events.ConsoleEventNewNotification;
import pt.lsts.neptus.console.events.ConsoleEventPlanChange;
import pt.lsts.neptus.console.notifications.NotificationsDialog;
import pt.lsts.neptus.events.NeptusEvents;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.DateTimeUtil;

public class StatusBar
extends JPanel {
    private static final long serialVersionUID = -945440076259058094L;
    private static final int FONT_SIZE = 12;
    private JLabel clock;
    private JLabel mainSystem;
    private JLabel plan;
    protected JButton notificationButton;
    private ConsoleLayout console;
    private NotificationsDialog notificationsDialog;
    private int notificationCount = 0;
    protected Timer clockTimer = null;
    protected TimerTask clockTimerTask = null;

    public StatusBar(ConsoleLayout console, NotificationsDialog notificationsDialog) {
        this.setBorder(new BevelBorder(1));
        this.setPreferredSize(new Dimension(console.getWidth(), 25));
        this.setLayout(new BoxLayout(this, 0));
        this.notificationsDialog = notificationsDialog;
        this.console = console;
        this.initialize();
        NeptusEvents.register(this, console);
        this.setVisible(true);
    }

    public void initialize() {
        JLabel labelMainSystem = new JLabel(I18n.text("System") + ": ");
        labelMainSystem.setFont(new Font("Arial", 1, 12));
        this.add(labelMainSystem);
        this.mainSystem = new JLabel(I18n.text("N/A"));
        this.mainSystem.setFont(new Font("Arial", 0, 12));
        this.add(this.mainSystem);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        JLabel labelPlanVehicle = new JLabel(I18n.text("Plan") + ": ");
        labelPlanVehicle.setFont(new Font("Arial", 1, 12));
        this.add(labelPlanVehicle);
        this.plan = new JLabel(I18n.text("N/A"));
        this.plan.setFont(new Font("Arial", 0, 12));
        this.add(this.plan);
        this.add(Box.createHorizontalGlue());
        this.clock = new JLabel();
        this.clock.setFont(new Font("Arial", 0, 12));
        this.clock.setHorizontalAlignment(4);
        this.add(this.clock);
        this.startClock();
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.notificationButton = new JButton(I18n.text("Notifications"));
        this.notificationButton.setName("notification");
        this.notificationButton.setFont(new Font("Arial", 0, 12));
        this.notificationButton.setAction(new AbstractAction(I18n.text("Notifications")){
            private static final long serialVersionUID = 1L;
            private boolean show;
            {
                this.show = false;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean bl = this.show = !this.show;
                if (!this.show && !StatusBar.this.notificationsDialog.isVisible()) {
                    this.show = true;
                }
                StatusBar.this.notificationsDialog.visible(this.show);
                StatusBar.this.notificationCount = 0;
                StatusBar.this.notificationButton.setText(I18n.text("Notifications"));
                StatusBar.this.notificationButton.setFont(new Font("Arial", 0, 12));
            }
        });
        this.add(this.notificationButton);
    }

    public void startClock() {
        this.clockTimer = new Timer("status bar clock", true);
        this.clockTimerTask = new TimerTask(){

            @Override
            public void run() {
                String clockStr = DateTimeUtil.timeUTCFormaterNoSegs3.format(new Date(System.currentTimeMillis())) + " " + I18n.text("UTC");
                StatusBar.this.clock.setText(clockStr);
            }
        };
        this.clockTimer.schedule(this.clockTimerTask, 100L, 800L);
    }

    public void stopClock() {
        this.clock.setText("");
        if (this.clockTimerTask != null) {
            this.clockTimerTask.cancel();
        }
        if (this.clockTimer != null) {
            this.clockTimer.cancel();
        }
    }

    public void clean() {
        this.stopClock();
        NeptusEvents.unregister(this, this.console);
    }

    @Subscribe
    public void onMainSystemChange(ConsoleEventMainSystemChange e) {
        this.mainSystem.setText(e.getCurrent());
    }

    @Subscribe
    public void onPlanChange(ConsoleEventPlanChange e) {
        this.plan.setText(e.getCurrent() != null ? e.getCurrent().getId() : I18n.text("N/A"));
    }

    @Subscribe
    public void onNewNotification(ConsoleEventNewNotification e) {
        ++this.notificationCount;
        this.notificationButton.setText(I18n.textf("%n Notifications", this.notificationCount));
        this.notificationButton.setFont(new Font("Arial", 1, 12));
    }
}

