/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.actions;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.actions.ConsoleAction;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.PeriodicSnapshotWorker;

public class AutoSnapshotConsoleAction
extends ConsoleAction {
    private static final long serialVersionUID = 5741528409297995492L;
    protected PeriodicSnapshotWorker snapshotHelper = new PeriodicSnapshotWorker();
    private static ImageIcon ICON_SNAPSHOT;
    private static ImageIcon ICON_SNAPSHOT_NO;
    private static String nameTurnOn;
    private static String nameTurnOff;
    private boolean running = false;

    public AutoSnapshotConsoleAction(ConsoleLayout console) {
        super(nameTurnOn, ICON_SNAPSHOT);
        this.snapshotHelper.setPrefix("Console");
        this.snapshotHelper.setComponentToSnapshot(console);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.running) {
            this.stopAutoSnapshot();
        } else {
            this.startAutoSnapshot();
        }
    }

    public void cleanClose() {
        if (this.snapshotHelper != null) {
            this.snapshotHelper.stopWorking();
        }
    }

    private void stopAutoSnapshot() {
        this.putValue("Name", nameTurnOn);
        this.putValue("SmallIcon", ICON_SNAPSHOT);
        this.running = false;
        this.snapshotHelper.stopWorking();
    }

    private void startAutoSnapshot() {
        this.putValue("Name", nameTurnOff);
        this.putValue("SmallIcon", ICON_SNAPSHOT_NO);
        this.running = true;
        this.snapshotHelper.startWorking();
    }

    static {
        ICON_SNAPSHOT_NO = ICON_SNAPSHOT = ImageUtils.createImageIcon("images/menus/snapshot.png");
        nameTurnOn = I18n.text("Start Auto Snapshot");
        nameTurnOff = I18n.text("Stop Auto Snapshot");
    }
}

