/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.actions.ConsoleAction;
import pt.lsts.neptus.gui.LocationPanel;
import pt.lsts.neptus.gui.swing.NeptusFileView;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.HomeReference;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class CreateMissionConsoleAction
extends ConsoleAction {
    protected ConsoleLayout console;

    public CreateMissionConsoleAction(ConsoleLayout console) {
        super(I18n.text("Create Mission"), new ImageIcon(ImageUtils.getImage("images/menus/new.png")), KeyStroke.getKeyStroke(78, 10, true));
        this.console = console;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LocationType lt = new LocationType();
        HomeReference hRef = null;
        if (this.console.getMission() != null && (hRef = this.console.getMission().getHomeRef()) != null) {
            lt.setLocation(hRef);
        }
        if ((lt = LocationPanel.showLocationDialog(this.console, I18n.text("Set mission home"), lt, null, true)) == null) {
            return;
        }
        JFileChooser chooser = new JFileChooser(ConfigFetch.getConfigFile());
        chooser.setFileView(new NeptusFileView());
        chooser.setFileFilter(GuiUtils.getCustomFileFilter(I18n.text("Mission Files ('nmisz')"), "nmisz"));
        int resp = chooser.showDialog(this.console, I18n.text("Save"));
        if (resp == 0) {
            if (chooser.getSelectedFile().exists() && (resp = JOptionPane.showConfirmDialog(this.console, I18n.text("Do you want to overwrite the existing file?"), I18n.text("Save Mission As..."), 1)) != 0) {
                return;
            }
            File dst = chooser.getSelectedFile();
            if (!dst.getAbsolutePath().endsWith(".nmisz")) {
                dst = new File(dst.getAbsolutePath() + ".nmisz");
            }
            MissionType tmp = MissionType.createZippedMission(dst);
            tmp.getHomeRef().setLocation(lt);
            this.console.setMission(tmp);
            this.console.setPlan(null);
            tmp.save(false);
            HomeReference newHr = tmp.getHomeRef();
            double dist = newHr.getDistanceInMeters(MyState.getLocation());
            if (dist > 1000.0) {
                MyState.setLocation(newHr);
            }
            this.console.setConsoleChanged(true);
        }
    }
}

