/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import pt.lsts.imc.gui.ImcStatePanel;
import pt.lsts.imc.state.ImcSystemState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsoleSystem;
import pt.lsts.neptus.console.actions.ConsoleAction;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.ImageUtils;

public class IncomingDataAction
extends ConsoleAction {
    private static final long serialVersionUID = 1L;
    protected ConsoleLayout console;
    protected ImcStatePanel imcStatePanel;

    public IncomingDataAction(ConsoleLayout console) {
        super(I18n.text("Incoming Data"), ImageUtils.createImageIcon("images/menus/view_tree.png"), I18n.text("Incoming IMC Data"), KeyStroke.getKeyStroke(84, 2, true));
        this.console = console;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JDialog dialog = new JDialog(this.console);
        dialog.setResizable(true);
        dialog.setLocationRelativeTo(null);
        dialog.setDefaultCloseOperation(2);
        dialog.setIconImage(ImageUtils.getImage("images/menus/view_tree.png"));
        dialog.setName(I18n.text("Incoming Data"));
        dialog.setTitle(I18n.text("Incoming Data"));
        dialog.setSize(600, 400);
        dialog.setLayout(new BorderLayout());
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (IncomingDataAction.this.imcStatePanel != null) {
                    IncomingDataAction.this.imcStatePanel.cleanup();
                }
            }
        });
        final JScrollPane statePanel = new JScrollPane();
        dialog.add((Component)statePanel, "Center");
        JComboBox<String> combovt = new JComboBox<String>();
        dialog.add(combovt, "North");
        ImcSystem[] active = ImcSystemsHolder.lookupAllActiveSystems();
        final HashSet<String> systems = new HashSet<String>();
        for (ImcSystem s : active) {
            systems.add(s.getName());
        }
        for (String s : this.console.getSystems().keySet()) {
            systems.add(s);
        }
        for (String s : systems) {
            combovt.addItem(s);
        }
        String mainVehicle = this.console.getMainSystem();
        if (mainVehicle == null) {
            NeptusLog.pub().warn((Object)(this + "Main vehicle N/A"));
        } else {
            ConsoleSystem vtl = this.console.getSystem(mainVehicle);
            if (this.imcStatePanel != null) {
                this.imcStatePanel.cleanup();
            }
            this.imcStatePanel = new ImcStatePanel((ImcSystemState)ImcMsgManager.getManager().getState(vtl.getVehicle().getId()));
            statePanel.setViewportView((Component)this.imcStatePanel);
        }
        combovt.setSelectedItem(mainVehicle);
        combovt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JComboBox cbox = (JComboBox)evt.getSource();
                for (String s : systems) {
                    if (!s.equals((String)cbox.getSelectedItem())) continue;
                    if (IncomingDataAction.this.imcStatePanel != null) {
                        IncomingDataAction.this.imcStatePanel.cleanup();
                    }
                    IncomingDataAction.this.imcStatePanel = new ImcStatePanel((ImcSystemState)ImcMsgManager.getManager().getState(s));
                    statePanel.setViewportView((Component)IncomingDataAction.this.imcStatePanel);
                    statePanel.revalidate();
                    statePanel.repaint();
                    break;
                }
            }
        });
        dialog.setVisible(true);
    }
}

