/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.actions.ConsoleAction;
import pt.lsts.neptus.gui.ConsoleFileChooser;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.ImageUtils;

public class OpenConsoleAction
extends ConsoleAction {
    protected ConsoleLayout console;

    public OpenConsoleAction(ConsoleLayout console) {
        super(I18n.text("Open Console"), new ImageIcon(ImageUtils.getImage("images/menus/open.png")));
        this.console = console;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        final File file = ConsoleFileChooser.showOpenConsoleDialog(this.console);
        if (file != null) {
            this.setEnabled(false);
            this.console.getContentPane().setVisible(false);
            this.console.reset();
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    ConsoleParse.parseFile(file.getAbsolutePath().toString(), OpenConsoleAction.this.console);
                    return null;
                }

                @Override
                protected void done() {
                    OpenConsoleAction.this.setEnabled(true);
                    try {
                        this.get();
                    }
                    catch (Exception e) {
                        NeptusLog.pub().error((Object)e);
                    }
                    OpenConsoleAction.this.console.getContentPane().setVisible(true);
                    OpenConsoleAction.this.console.setConsoleChanged(false);
                }
            };
            worker.execute();
        }
    }
}

