/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.MonitorIMCComms;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.actions.ConsoleAction;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class OpenImcMonitorAction
extends ConsoleAction {
    private ConsoleLayout console = null;
    private JFrame imcMonitorFrame = null;

    public OpenImcMonitorAction(ConsoleLayout console) {
        super(I18n.text("IMC Monitor"), ImageUtils.createScaleImageIcon("images/imc.png", 16, 16), I18n.text("IMC Monitor"));
        this.console = console;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.imcMonitorFrame == null) {
            final MonitorIMCComms imcPanel = new MonitorIMCComms(ImcMsgManager.getManager());
            this.imcMonitorFrame = new JFrame(I18n.text("IMC Monitor"));
            this.imcMonitorFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    imcPanel.cleanup();
                    OpenImcMonitorAction.this.console.removeWindowToOppenedList(OpenImcMonitorAction.this.imcMonitorFrame);
                    OpenImcMonitorAction.this.imcMonitorFrame = null;
                    super.windowClosing(e);
                }
            });
            this.imcMonitorFrame.setSize(new Dimension(imcPanel.getWidth() + 220, imcPanel.getHeight() + 220));
            this.imcMonitorFrame.setResizable(true);
            this.imcMonitorFrame.add(imcPanel);
            this.imcMonitorFrame.setIconImages(ConfigFetch.getIconImagesForFrames());
            this.imcMonitorFrame.setDefaultCloseOperation(2);
            this.console.addWindowToOppenedList(this.imcMonitorFrame);
        }
        this.imcMonitorFrame.setVisible(true);
        this.imcMonitorFrame.requestFocus();
    }
}

