/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.actions;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.actions.ConsoleAction;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.checklist.ChecklistType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class RunChecklistConsoleAction
extends ConsoleAction {
    ConsoleLayout console;

    public RunChecklistConsoleAction(final ConsoleLayout console) {
        super(I18n.text("Run CheckList"), new ImageIcon(ImageUtils.getImage("images/buttons/checklist.png")));
        this.console = console;
        console.addMissionListener(new MissionChangeListener(){

            @Override
            public void missionUpdated(MissionType mission) {
                this.updateStatus(console);
            }

            private void updateStatus(ConsoleLayout console2) {
                if (console2.getMission() != null && console2.getMission().getChecklistsList().size() > 0) {
                    RunChecklistConsoleAction.this.setEnabled(true);
                } else {
                    RunChecklistConsoleAction.this.setEnabled(false);
                }
            }

            @Override
            public void missionReplaced(MissionType mission) {
                this.updateStatus(console);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setEnabled(false);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                String checkl;
                if (RunChecklistConsoleAction.this.console.getMission() == null) {
                    GuiUtils.errorMessage(null, I18n.text("Console error"), I18n.text("Selecting Plan: no Mission Loaded in console"));
                    return null;
                }
                String string = checkl = RunChecklistConsoleAction.this.console.getMission().getChecklistsList().size() == 0 ? null : (String)JOptionPane.showInputDialog(RunChecklistConsoleAction.this.console, I18n.text("Choose one of the available Checklists"), I18n.text("Select Checklist"), 3, new ImageIcon(), RunChecklistConsoleAction.this.console.getMission().getChecklistsList().keySet().toArray(), RunChecklistConsoleAction.this.console.getMission().getChecklistsList().keySet().iterator().next());
                if (checkl != null) {
                    ChecklistType newClone = RunChecklistConsoleAction.this.console.getMission().getChecklistsList().get(checkl).getChecklist().createCopy();
                    RunChecklistConsoleAction.this.console.executeCheckList(newClone);
                }
                return null;
            }
        };
        worker.execute();
    }
}

