/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.actions.ConsoleAction;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.NameNormalizer;

public class SaveMissionAsConsoleAction
extends ConsoleAction {
    protected ConsoleLayout console;

    public SaveMissionAsConsoleAction(ConsoleLayout console) {
        super(I18n.text("Save Mission As..."), new ImageIcon(ImageUtils.getImage("images/menus/saveas.png")));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 10, true));
        this.console = console;
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser(this.console.getMission().getMissionFile());
        chooser.setFileFilter(GuiUtils.getCustomFileFilter(I18n.text("Mission Files ") + "('nmisz')", "nmisz"));
        int resp = chooser.showDialog(this.console, I18n.text("Save"));
        if (resp == 0) {
            if (chooser.getSelectedFile().exists() && (resp = JOptionPane.showConfirmDialog(this.console, I18n.text("Do you want to overwrite the existing file?"), I18n.text("Save Mission As..."), 1)) != 0) {
                return;
            }
            File dst = chooser.getSelectedFile();
            if (!dst.getAbsolutePath().endsWith(".nmisz")) {
                dst = new File(dst.getAbsolutePath() + ".nmisz");
            }
            this.console.getMission().setMissionFile(dst);
            this.console.getMission().setId(NameNormalizer.getRandomID());
            this.console.getMission().save(false);
            MapGroup.resetMissionInstance(this.console.getMission());
        }
    }
}

