/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.actions;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.actions.ConsoleAction;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class SetMainVehicleConsoleAction
extends ConsoleAction {
    ConsoleLayout console;

    public SetMainVehicleConsoleAction(ConsoleLayout console) {
        super(I18n.text("Set Main Vehicle..."), new ImageIcon(ImageUtils.getImage("images/menus/vehicle.png")));
        this.console = console;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setEnabled(false);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                String mv;
                if (VehiclesHolder.getVehiclesArray().length == 0) {
                    GuiUtils.errorMessage(SetMainVehicleConsoleAction.this.console, I18n.text("Console error"), I18n.text("Selecting Main Vehicle: no Vehicles configured/loaded in Neptus"));
                }
                if ((mv = (String)JOptionPane.showInputDialog(SetMainVehicleConsoleAction.this.console, I18n.text("Choose one of the available Vehicles"), I18n.text("Select Vehicle"), 3, null, VehiclesHolder.getVehiclesArray(), null)) != null) {
                    SetMainVehicleConsoleAction.this.console.addSystem(mv);
                    SetMainVehicleConsoleAction.this.console.setMainSystem(mv);
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e);
                }
                SetMainVehicleConsoleAction.this.setEnabled(true);
            }
        };
        worker.execute();
    }
}

