/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.notifications;

import java.text.SimpleDateFormat;
import pt.lsts.neptus.i18n.I18n;

public class Notification
implements Comparable<Notification> {
    private final NotificationType type;
    private final long timestamp;
    private final String timeText;
    private final String title;
    private final String text;
    private final SimpleDateFormat formater = new SimpleDateFormat("HH:mm:ss");
    private boolean requireHumanAction = false;
    private String src = I18n.text("Console");

    public static Notification error(String title, String text) {
        return new Notification(title, text, NotificationType.ERROR).requireHumanAction(true);
    }

    public static Notification info(String title, String text) {
        return new Notification(title, text, NotificationType.INFO);
    }

    public static Notification success(String title, String text) {
        return new Notification(title, text, NotificationType.SUCCESS);
    }

    public static Notification warning(String title, String text) {
        return new Notification(title, text, NotificationType.WARNING);
    }

    private Notification(String title, String text, NotificationType type) {
        this.timestamp = System.currentTimeMillis();
        this.text = text;
        this.title = title;
        this.timeText = this.formater.format(this.timestamp);
        this.type = type;
    }

    public Notification requireHumanAction(boolean flag) {
        this.requireHumanAction = flag;
        return this;
    }

    public Notification src(String src) {
        this.src = src;
        return this;
    }

    public boolean needsHumanAction() {
        return this.requireHumanAction;
    }

    public String getSrc() {
        return this.src;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTimeText() {
        return this.timeText;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public NotificationType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Notification other = (Notification)obj;
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return this.timeText + " [" + (Object)((Object)this.type) + "] " + this.text;
    }

    @Override
    public int compareTo(Notification o) {
        return (int)(o.getTimestamp() - this.timestamp);
    }

    public static enum NotificationType {
        SUCCESS,
        INFO,
        WARNING,
        ERROR;

    }
}

