/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.notifications;

import com.google.common.eventbus.Subscribe;
import java.util.LinkedList;
import java.util.List;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.events.ConsoleEventNewNotification;
import pt.lsts.neptus.console.events.ConsoleEventVehicleStateChanged;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.events.NeptusEventHiddenMenus;
import pt.lsts.neptus.events.NeptusEvents;
import pt.lsts.neptus.i18n.I18n;

public class NotificationsCollection {
    public static final int MAX_SIZE = 20;
    private List<Notification> list = new LinkedList<Notification>();
    private ConsoleLayout console;

    public NotificationsCollection(ConsoleLayout console) {
        this.console = console;
        NeptusEvents.register(this, console);
    }

    private synchronized void add(Notification noty) {
        if (this.list.size() > 20) {
            this.list.clear();
        }
        this.list.add(noty);
        this.console.post(new ConsoleEventNewNotification(noty));
    }

    public synchronized List<Notification> getList() {
        LinkedList<Notification> clone = new LinkedList<Notification>();
        clone.addAll(this.list);
        return clone;
    }

    public void clear() {
        this.list.clear();
    }

    @Subscribe
    public void onNotification(Notification e) {
        this.add(e);
    }

    @Subscribe
    public void handleHiddenMenus(NeptusEventHiddenMenus e) {
        this.add(Notification.warning("Hidden menus", "sadfsdfsdf"));
    }

    @Subscribe
    public void onVehicleStateChanged(ConsoleEventVehicleStateChanged e) {
        switch (e.getState()) {
            case DISCONNECTED: {
                this.add(Notification.warning(I18n.text("Lost connection"), e.getDescription()).src(e.getVehicle()));
                break;
            }
            case TELEOPERATION: {
                this.add(Notification.warning(I18n.text("Started Teleoperation"), e.getDescription()).src(e.getVehicle()));
                break;
            }
            case ERROR: {
                this.add(Notification.error(I18n.text("System in error"), e.getDescription()).src(e.getVehicle()));
                break;
            }
            case SERVICE: {
                this.add(Notification.success(I18n.text("System in service"), e.getDescription()).src(e.getVehicle()));
                break;
            }
            case MANEUVER: {
                this.add(Notification.success(I18n.text("Started Operation"), e.getDescription()).src(e.getVehicle()));
                break;
            }
            default: {
                this.add(Notification.info(e.getState().toString(), e.getDescription()).src(e.getVehicle()));
            }
        }
    }
}

