/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.notifications;

import com.google.common.eventbus.Subscribe;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.events.ConsoleEventNewNotification;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.console.notifications.NotificationsCollection;
import pt.lsts.neptus.console.notifications.NotificationsGlassPane;
import pt.lsts.neptus.events.NeptusEvents;
import pt.lsts.neptus.i18n.I18n;

public class NotificationsDialog
extends JDialog
implements WindowFocusListener,
AWTEventListener {
    private static final long serialVersionUID = -344983838194932720L;
    private ConsoleLayout console;
    private JList<Notification> jList;
    private JPanel options;
    private JCheckBox check;
    private JButton clear;
    private JScrollPane listScroller;
    private NotificationsCollection notifications;
    private NotificationsGlassPane glassPane;
    private boolean popupsEnabled = true;
    private boolean focus = false;

    public NotificationsDialog(NotificationsCollection notifications, ConsoleLayout console) {
        super(console);
        this.console = console;
        this.notifications = notifications;
        NeptusEvents.register(this, console);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
        this.glassPane = new NotificationsGlassPane(console);
        this.setVisible(false);
        this.setUndecorated(true);
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(500, 200));
        this.addWindowFocusListener(this);
        this.jList = new JList();
        this.jList.setSelectionMode(1);
        this.jList.setLayoutOrientation(0);
        this.jList.setCellRenderer(new NotificationRenderer());
        this.jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && NotificationsDialog.this.jList.getSelectedIndex() != -1) {
                    Notification noty = (Notification)NotificationsDialog.this.jList.getSelectedValue();
                    NotificationsDialog.this.glassPane.addAtomic(noty);
                }
            }
        });
        this.listScroller = new JScrollPane(this.jList);
        this.add((Component)this.listScroller, "Center");
        this.options = new JPanel();
        this.options.setName("options");
        this.options.setLayout(new BoxLayout(this.options, 0));
        this.check = new JCheckBox(new AbstractAction(I18n.text("Disable popups")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationsDialog.this.popupsEnabled = !NotificationsDialog.this.popupsEnabled;
            }
        });
        this.clear = new JButton(new AbstractAction(I18n.text("Clear")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationsDialog.this.clear();
            }
        });
        this.options.add(Box.createRigidArea(new Dimension(5, 0)));
        this.options.add(this.check);
        this.options.add(Box.createHorizontalGlue());
        this.options.add(this.clear);
        this.add((Component)this.options, "South");
    }

    public void position() {
        Point p = this.console.getLocationOnScreen();
        p.x += this.console.getWidth() - (this.getWidth() + 10);
        p.y += this.console.getHeight() - (this.getHeight() + 32);
        this.setLocation(p);
    }

    public void visible(boolean flag) {
        this.setVisible(flag);
        this.glassPane.clear();
        if (flag) {
            this.position();
        }
    }

    public void clear() {
        this.notifications.clear();
        this.jList.setListData((Notification[])new Notification[0]);
        this.jList.repaint();
        this.glassPane.clear();
    }

    @Subscribe
    public void onNewNotification(ConsoleEventNewNotification e) {
        List<Notification> n = this.notifications.getList();
        Collections.sort(n);
        this.jList.setListData((Notification[])n.toArray(new Notification[0]));
        if (this.popupsEnabled) {
            this.glassPane.add(e.getNoty());
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.focus = true;
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.focus = false;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event instanceof MouseEvent && this.isVisible()) {
            String name;
            MouseEvent me = (MouseEvent)event;
            String string = name = me.getComponent().getName() == null ? "" : me.getComponent().getName();
            if (!name.equals("notification") && !this.focus) {
                this.visible(false);
            }
        }
    }

    private class NotificationRenderer
    extends JLabel
    implements ListCellRenderer<Notification> {
        private static final long serialVersionUID = 1L;

        private NotificationRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Notification> list, Notification value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText("<html> " + value.getTimeText() + " [ <b width='100px; display: inline'>" + value.getSrc() + "</b> ] " + value.getTitle() + "</html>");
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                switch (value.getType()) {
                    case ERROR: {
                        this.setBackground(new Color(15122624));
                        break;
                    }
                    case SUCCESS: {
                        this.setBackground(new Color(12969145));
                        break;
                    }
                    case INFO: {
                        this.setBackground(new Color(9817576));
                        break;
                    }
                    case WARNING: {
                        this.setBackground(new Color(16314563));
                        break;
                    }
                }
                this.setForeground(new Color(0x333333));
            }
            this.setEnabled(list.isEnabled());
            this.setFont(new Font("Arial", 0, 12));
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            return this;
        }
    }
}

