/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.notifications;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.View;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.util.ImageUtils;

public class NotificationsGlassPane
extends JPanel {
    private static final long serialVersionUID = -1397790967075620867L;
    private static final int MARGIN_BOTTOM = 5;
    private static final int MARGIN_RIGHT = 2;
    private static final int BOTTOM_GAP = 25;
    private final JFrame frame;
    private List<Notification> list = new ArrayList<Notification>();
    private int currentHeight = 25;

    public NotificationsGlassPane(JFrame frame) {
        super(null);
        this.frame = frame;
        this.setupListeners();
        this.setOpaque(false);
        frame.setGlassPane(this);
        this.setVisible(true);
    }

    public void refresh() {
        this.currentHeight = 25;
        List<Component> comps = Arrays.asList(this.getComponents());
        for (Component component : comps) {
            component.setLocation(this.getWidth() - (component.getWidth() + 2), this.getHeight() - (component.getHeight() + 5) - this.currentHeight);
            this.currentHeight += component.getHeight() + 5;
        }
    }

    public void clear() {
        this.removeAll();
        this.list.clear();
        this.currentHeight = 25;
        this.repaint();
    }

    public void add(Notification noty) {
        if (this.list.size() > 20) {
            this.clear();
        }
        if (noty.getType() == Notification.NotificationType.INFO) {
            return;
        }
        this.frame.setGlassPane(this);
        this.setVisible(true);
        this.list.add(noty);
        this.add(this.build(noty, false));
        this.repaint();
    }

    public void addAtomic(Notification noty) {
        this.clear();
        this.currentHeight = 232;
        this.frame.setGlassPane(this);
        this.setVisible(true);
        this.list.add(noty);
        this.add(this.build(noty, true));
        this.repaint();
    }

    private JLabel build(final Notification noty, boolean atomic) {
        LineBorder border;
        JLabel label;
        Border paddingBorder = BorderFactory.createEmptyBorder(6, 10, 6, 10);
        switch (noty.getType()) {
            case SUCCESS: {
                String html = "<html> <b>" + noty.getSrc() + "</b> " + noty.getTitle() + "<br>" + noty.getText() + "</html>";
                label = new JLabel(html, ImageUtils.createImageIcon("images/icons/noty-success.png"), 2);
                label.setBackground(new Color(14676184));
                label.setForeground(new Color(0x333333));
                border = new LineBorder(new Color(4622407), 1);
                break;
            }
            case ERROR: {
                String html = "<html> <b>" + noty.getSrc() + "</b> " + noty.getTitle() + "<br>" + noty.getText() + "</html>";
                label = new JLabel(html, ImageUtils.createImageIcon("images/icons/noty-error.png"), 2);
                label.setBackground(new Color(15916766));
                label.setForeground(new Color(0x333333));
                border = new LineBorder(new Color(12143176), 1);
                break;
            }
            case WARNING: {
                String html = "<html> <b>" + noty.getSrc() + "</b> " + noty.getTitle() + "<br>" + noty.getText() + "</html>";
                label = new JLabel(html, ImageUtils.createImageIcon("images/icons/noty-warning.png"), 2);
                label.setBackground(new Color(16578787));
                label.setForeground(new Color(0x333333));
                border = new LineBorder(new Color(12621907), 1);
                break;
            }
            case INFO: {
                String html = "<html> <b>" + noty.getSrc() + "</b> " + noty.getTitle() + "<br>" + noty.getText() + "</html>";
                label = new JLabel(html, ImageUtils.createImageIcon("images/icons/noty-info.png"), 2);
                label.setBackground(new Color(14282231));
                label.setForeground(new Color(0x333333));
                border = new LineBorder(new Color(3835821), 1);
                break;
            }
            default: {
                String html = "<html> <b>" + noty.getSrc() + "</b> " + noty.getTitle() + "<br>" + noty.getText() + "</html>";
                label = new JLabel(html, ImageUtils.createImageIcon("images/icons/info.png"), 2);
                label.setBackground(new Color(14282231));
                label.setForeground(new Color(0x333333));
                border = new LineBorder(new Color(3835821), 1);
            }
        }
        label.setBorder(BorderFactory.createCompoundBorder(border, paddingBorder));
        label.setOpaque(true);
        label.setFont(new Font("Arial", 0, 12));
        label.setIconTextGap(10);
        View view = (View)label.getClientProperty("html");
        view.setSize(500.0f, 0.0f);
        float w = view.getPreferredSpan(0);
        float h = view.getPreferredSpan(1);
        label.setSize(new Dimension((int)Math.ceil(w), (int)Math.ceil(h) + 30));
        label.setLocation(this.getWidth() - (label.getWidth() + 2), this.getHeight() - (label.getHeight() + 5) - this.currentHeight);
        if (!atomic) {
            this.currentHeight += label.getHeight() + 5;
            if (noty.needsHumanAction()) {
                label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        NotificationsGlassPane.this.list.remove(noty);
                        NotificationsGlassPane.this.remove(label);
                        NotificationsGlassPane.this.currentHeight -= label.getHeight() + 5;
                        NotificationsGlassPane.this.refresh();
                        NotificationsGlassPane.this.repaint();
                    }
                });
            } else {
                final Timer timer = new Timer("notification timer");
                TimerTask tt = new TimerTask(){

                    @Override
                    public void run() {
                        NotificationsGlassPane.this.list.remove(noty);
                        NotificationsGlassPane.this.remove(label);
                        NotificationsGlassPane.this.currentHeight -= label.getHeight() + 5;
                        NotificationsGlassPane.this.refresh();
                        NotificationsGlassPane.this.repaint();
                        timer.cancel();
                    }
                };
                timer.schedule(tt, 4000L);
                label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        timer.cancel();
                        NotificationsGlassPane.this.list.remove(noty);
                        NotificationsGlassPane.this.remove(label);
                        NotificationsGlassPane.this.currentHeight -= label.getHeight() + 5;
                        NotificationsGlassPane.this.refresh();
                        NotificationsGlassPane.this.repaint();
                    }
                });
            }
        }
        return label;
    }

    private void setupListeners() {
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                NotificationsGlassPane.this.refresh();
            }
        });
    }
}

