/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.SwingWorker;
import org.jdesktop.swingx.JXButton;
import pt.lsts.imc.Abort;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.console.plugins.LockableSubPanel;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.gui.swing.PanicButton;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.IAbortSenderProvider;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.ColorUtils;

@PluginDescription(icon="images/buttons/important.png", name="Abort Button", version="1.6", documentation="abort/abort-button.html")
public class AbortPanel
extends ConsolePanel
implements MainVehicleChangeListener,
LockableSubPanel,
ConfigurationListener {
    @NeptusProperty(name="Button Shape", userLevel=NeptusProperty.LEVEL.ADVANCED, distribution=NeptusProperty.DistributionEnum.DEVELOPER)
    public AbortButtonShapeEnum buttonShape = AbortButtonShapeEnum.ROUND;
    private PanicButton abortButton = null;
    private JXButton abortButtonRectangular = null;
    private ActionListener abortAction = null;
    private final String tooltip = I18n.text("Send abort to the main vehicle (Ctrl+click to send to all known vehicles)");

    public AbortPanel(ConsoleLayout console) {
        super(console);
        this.initialize();
    }

    private void initialize() {
        this.removeAll();
        this.setResizable(true);
        this.setSize(100, 100);
        this.setPreferredSize(new Dimension(100, 100));
        this.repaint();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getAbortButton(), "Center");
        this.propertiesChanged();
    }

    @Override
    public void propertiesChanged() {
        this.removeAll();
        switch (this.buttonShape) {
            case RECTANGULAR: {
                this.add((Component)this.getAbortButtonRectangular(), "Center");
                break;
            }
            default: {
                this.removeAll();
                this.add((Component)this.getAbortButton(), "Center");
            }
        }
        this.invalidate();
        this.revalidate();
        this.repaint(50L);
    }

    private PanicButton getAbortButton() {
        if (this.abortButton == null) {
            this.abortButton = new PanicButton(I18n.textc("Abort", "Abort button. Make it with less letters as possible."));
            this.abortButton.setCircular(true);
            this.abortButton.addActionListener(this.getAbortAction());
            this.abortButton.setToolTipText(this.tooltip);
        }
        return this.abortButton;
    }

    public JXButton getAbortButtonRectangular() {
        if (this.abortButtonRectangular == null) {
            this.abortButtonRectangular = new JXButton(I18n.textc("Abort", "Abort button. Make it with less letters as possible.")){
                private Paint[] paints;
                private Dimension dim;
                private Color redTransp;
                private Color redTranspDarker;
                private BufferedImage buffImg;
                private boolean state;
                private boolean pressed;
                {
                    this.paints = null;
                    this.dim = null;
                    this.redTransp = ColorUtils.setTransparencyToColor(new Color(232, 28, 28), 210);
                    this.redTranspDarker = this.redTransp.darker();
                    this.buffImg = null;
                    this.state = false;
                    this.pressed = false;
                }

                protected void paintComponent(Graphics go) {
                    if (this.dim == null) {
                        Dimension dimN = this.getSize(new Dimension());
                        if (dimN.height != 0 && dimN.width != 0) {
                            this.dim = dimN;
                        }
                        this.buffImg = null;
                    } else if (!this.dim.equals(this.getSize())) {
                        this.paints = null;
                        this.dim = this.getSize(new Dimension());
                        this.buffImg = null;
                    }
                    if (this.state != this.getModel().isEnabled()) {
                        this.state = this.getModel().isEnabled();
                        this.buffImg = null;
                    }
                    if (this.pressed != this.getModel().isPressed()) {
                        this.pressed = this.getModel().isPressed();
                        this.buffImg = null;
                    }
                    if (this.paints == null) {
                        this.paints = PanicButton.createStripesEnableDisablePaints(this.dim, AbortPanel.this.getAbortButton().getBackgroundOutter());
                    }
                    Graphics2D g = (Graphics2D)go;
                    if (this.buffImg == null) {
                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        GraphicsDevice gs = ge.getDefaultScreenDevice();
                        GraphicsConfiguration gc = gs.getDefaultConfiguration();
                        this.buffImg = gc.createCompatibleImage((int)this.dim.getWidth(), (int)this.dim.getHeight(), 2);
                        g = this.buffImg.createGraphics();
                        Graphics2D g2 = (Graphics2D)g.create();
                        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(1.0, 1.0, this.getWidth() - 2, this.getHeight() - 2, 10.0, 10.0);
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g2.setPaint(this.getModel().isEnabled() ? this.paints[0] : this.paints[1]);
                        g2.fill(rect);
                        g2.setColor(!this.getModel().isPressed() ? this.redTransp : this.redTranspDarker);
                        rect = new RoundRectangle2D.Double(10.0, 10.0, this.getWidth() - 20, this.getHeight() - 20, 10.0, 10.0);
                        g2.fill(rect);
                        g2.dispose();
                        g2 = (Graphics2D)g.create();
                        g2.setFont(new Font("Arial", 1, 5));
                        Rectangle2D sB1 = g2.getFontMetrics().getStringBounds(this.getText(), g2);
                        double sw0 = (double)(this.getWidth() - 20) / sB1.getWidth();
                        double sh0 = (double)(this.getHeight() - 20) / sB1.getHeight();
                        g2.translate(10, 10);
                        double scale = Math.min(sw0, sh0);
                        g2.scale(scale, scale);
                        g2.setColor(this.getForeground());
                        sB1 = g2.getFontMetrics().getStringBounds(this.getText(), g2);
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        g2.drawString(this.getText(), (float)((double)(this.getWidth() - 20) / scale / 2.0 - sB1.getWidth() / 2.0), (float)((double)(this.getHeight() - 20) / scale / 2.0 + sB1.getHeight() / 4.0));
                        g2.dispose();
                    }
                    go.drawImage(this.buffImg, 0, 0, null);
                }
            };
            this.abortButtonRectangular.setForeground(this.getAbortButton().getBackgroundOutter());
            this.abortButtonRectangular.addActionListener(this.getAbortAction());
            this.abortButtonRectangular.setToolTipText(this.tooltip);
        }
        return this.abortButtonRectangular;
    }

    private ActionListener getAbortAction() {
        if (this.abortAction == null) {
            this.abortAction = new ActionListener(){

                @Override
                public void actionPerformed(final ActionEvent e) {
                    AbortPanel.this.abortButton.setEnabled(false);
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            AbortPanel.this.send(new IMCMessage("Abort"));
                            boolean sentToAll = false;
                            if ((e.getModifiers() & 2) != 0) {
                                sentToAll = true;
                            }
                            Vector<String> systemsToAbort = new Vector<String>();
                            if (sentToAll) {
                                ImcSystem[] allSys;
                                for (ImcSystem imcSystem : allSys = ImcSystemsHolder.lookupSystemByType(VehicleType.SystemTypeEnum.VEHICLE)) {
                                    if (AbortPanel.this.getMainVehicleId().equalsIgnoreCase(imcSystem.getName())) continue;
                                    AbortPanel.this.send(imcSystem.getName(), (IMCMessage)new Abort());
                                    systemsToAbort.add(imcSystem.getName());
                                }
                            }
                            boolean aSent = true;
                            try {
                                Vector<IAbortSenderProvider> newTrackers = AbortPanel.this.getConsole().getSubPanelsOfInterface(IAbortSenderProvider.class);
                                for (IAbortSenderProvider t : newTrackers) {
                                    boolean sent = t.sendAbortRequest();
                                    aSent &= sent;
                                    for (String sysTA : systemsToAbort) {
                                        try {
                                            t.sendAbortRequest(sysTA);
                                        }
                                        catch (Exception e2) {
                                            NeptusLog.pub().error((Object)e2);
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                NeptusLog.pub().error((Object)ex);
                            }
                            catch (Error ex) {
                                NeptusLog.pub().error((Object)ex);
                            }
                            if (!aSent) {
                                AbortPanel.this.post(Notification.error(I18n.text("Abort"), I18n.text("Couldn't find a system to send an accoustic abort!")));
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e2) {
                                NeptusLog.pub().error((Object)e2);
                            }
                            AbortPanel.this.abortButton.setEnabled(true);
                        }
                    };
                    worker.execute();
                }
            };
        }
        return this.abortAction;
    }

    @Override
    public boolean isLocked() {
        return !this.getAbortButton().isEnabled();
    }

    @Override
    public void lock() {
        if (this.abortButton != null) {
            this.abortButton.setEnabled(false);
        }
        if (this.abortButtonRectangular != null) {
            this.abortButtonRectangular.setEnabled(false);
        }
    }

    @Override
    public void unLock() {
        if (this.abortButton != null) {
            this.abortButton.setEnabled(true);
        }
        if (this.abortButtonRectangular != null) {
            this.abortButtonRectangular.setEnabled(true);
        }
    }

    @Override
    public void initSubPanel() {
    }

    @Override
    public void cleanSubPanel() {
    }

    public static enum AbortButtonShapeEnum {
        ROUND,
        RECTANGULAR;

    }
}

