/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(icon="images/buttons/compassbutt.png", name="Alternative Compass")
public class AlternativeCompass
extends ConsolePanel
implements MainVehicleChangeListener,
NeptusMessageListener {
    private static final long serialVersionUID = 1L;
    @NeptusProperty
    float factor = 1.0f;
    private Image image = ImageUtils.getImage("images/grad_compass.png");
    private double yaw_degs = 0.0;

    public AlternativeCompass(ConsoleLayout console) {
        super(console);
        this.initialize();
        this.getMainpanel().getConsole().addMainVehicleListener(this);
    }

    public float getFactor() {
        return this.factor;
    }

    public void setFactor(float factor) {
        this.factor = factor;
    }

    @Override
    public void paint(Graphics g) {
        int curLoc;
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        double northLocation = (double)this.getWidth() / 2.0 - this.yaw_degs;
        for (curLoc = (int)northLocation; curLoc < this.getWidth(); curLoc += 360) {
            g.drawImage(this.image, curLoc, 1, this.getBackground(), this);
        }
        for (curLoc = (int)northLocation; curLoc > 0; curLoc -= 360) {
            g.drawImage(this.image, curLoc - 360, 1, this.getBackground(), this);
        }
        Polygon p = new Polygon(new int[]{0, 4, -4}, new int[]{10, 25, 25}, 3);
        g.setColor(new Color(255, 0, 0, 100));
        g.translate(this.getWidth() / 2, 0);
        g.fillPolygon(p);
        g.setColor(Color.black);
        g.drawPolygon(p);
        Font oldFont = g2d.getFont();
        String txt = "" + (int)this.yaw_degs + "\u00b0";
        Rectangle2D r = g2d.getFontMetrics().getStringBounds(txt, g2d);
        g2d.setColor(Color.gray);
        g2d.drawString(txt, (int)(-r.getWidth() / 2.0) + 1, 37);
        g2d.setColor(Color.black);
        g2d.drawString(txt, (int)(-r.getWidth() / 2.0), 36);
        g2d.setFont(oldFont);
    }

    private void initialize() {
        this.setBounds(new Rectangle(0, 0, 50, 30));
        this.setPreferredSize(new Dimension(50, 30));
        this.setSize(this.getPreferredSize());
        this.setDoubleBuffered(true);
    }

    public double getYawDegs() {
        return this.yaw_degs;
    }

    public void setYawDegs(double yaw_degs) {
        double last_degs = this.yaw_degs;
        this.yaw_degs = (int)(yaw_degs % 360.0);
        if (last_degs != this.yaw_degs) {
            this.repaint();
        }
    }

    public double getYawRads() {
        return Math.toRadians(this.yaw_degs);
    }

    @Override
    public String[] getObservedMessages() {
        return new String[]{"EstimatedState"};
    }

    @Override
    public void messageArrived(IMCMessage message) {
        this.setYawRads(message.getDouble("psi"));
    }

    public void setYawRads(double yaw_degs) {
        this.setYawDegs(Math.toDegrees(yaw_degs));
    }

    @Override
    public void cleanSubPanel() {
    }

    @Override
    public void initSubPanel() {
    }
}

