/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.GridLayout;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pt.lsts.neptus.util.GuiUtils;

public class AttStatePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected String varroll;
    public boolean viewroll = true;
    private JLabel rolllabel = null;
    public JLabel rolltext = null;
    public boolean viewpitch = true;
    private JLabel pitchlabel = null;
    public JLabel pitchtext = null;
    public boolean viewyaw = true;
    private JLabel yawlabel = null;
    public JLabel yawtext = null;
    public float roll = 0.0f;
    public float pitch = 0.0f;
    public float yaw = 0.0f;
    public int precision = 2;
    protected NumberFormat nf = GuiUtils.getNeptusDecimalFormat(this.precision);

    public void refres() {
        this.rolltext.setText("" + this.nf.format(Math.toDegrees(this.roll) % 360.0));
        this.pitchtext.setText("" + this.nf.format(Math.toDegrees(this.pitch) % 360.0));
        this.yawtext.setText("" + this.nf.format(Math.toDegrees(this.yaw) % 360.0));
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
        this.nf = GuiUtils.getNeptusDecimalFormat(this.precision);
        this.refres();
    }

    public AttStatePanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridLayout(3, 2));
        this.getAttLabels();
    }

    private void getAttLabels() {
        this.yawtext = new JLabel("Texto yaw", 0);
        this.yawtext.setText("-");
        this.yawlabel = new JLabel("yaw:", 0);
        this.yawlabel.setText("yaw:");
        this.pitchtext = new JLabel("Texto picth", 0);
        this.pitchtext.setText("-");
        this.pitchlabel = new JLabel("pitch:", 0);
        this.pitchlabel.setText("pitch:");
        this.rolltext = new JLabel("Texto roll", 0);
        this.rolltext.setText("-");
        this.rolllabel = new JLabel("roll:", 0);
        this.resetdisplay();
    }

    public void resetdisplay() {
        int x = 0;
        this.removeAll();
        if (this.viewroll) {
            this.add(this.rolllabel);
            this.add(this.rolltext);
            ++x;
        }
        if (this.viewpitch) {
            this.add(this.pitchlabel);
            this.add(this.pitchtext);
            ++x;
        }
        if (this.viewyaw) {
            this.add(this.yawlabel);
            this.add(this.yawtext);
            ++x;
        }
        this.setLayout(new GridLayout(x, 2));
        this.doLayout();
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
        this.refres();
    }

    public float getRoll() {
        return this.roll;
    }

    public void setRoll(float roll) {
        this.roll = roll;
        this.refres();
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
        this.refres();
    }

    public static void main(String[] arg) {
        AttStatePanel buss = new AttStatePanel();
        GuiUtils.testFrame(buss, "Atitude");
        buss.setPrecision(0);
        int i = 0;
        while (true) {
            buss.setYaw(i / 11);
            buss.setPitch(i / 12);
            buss.setRoll(i / 13);
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public boolean isViewpitch() {
        return this.viewpitch;
    }

    public void setViewpitch(boolean viewpitch) {
        this.viewpitch = viewpitch;
        this.resetdisplay();
    }

    public boolean isViewroll() {
        return this.viewroll;
    }

    public void setViewroll(boolean viewroll) {
        this.viewroll = viewroll;
        this.resetdisplay();
    }

    public boolean isViewyaw() {
        return this.viewyaw;
    }

    public void setViewyaw(boolean viewyaw) {
        this.viewyaw = viewyaw;
        this.resetdisplay();
    }

    public void variablesChanged(String[] variableNames, Object[] oldValues, Object[] newValues) {
    }

    public void variablesUpdated(String[] variableNames, Object[] currentValues) {
    }
}

