/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import pt.lsts.neptus.console.plugins.SideVehiclePanel;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class BackVehiclePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public float roll = 0.0f;
    public Graphics2D g2 = null;
    private Image image = null;
    private BufferedImage bi = null;
    int lastWidth = 0;

    public BackVehiclePanel() {
        this.initialize();
    }

    public void setVehicle(String id) {
        VehicleType veh = VehiclesHolder.getVehicleById(id);
        if (veh == null) {
            return;
        }
        String backHref = veh.getBackImageHref();
        this.image = "".equalsIgnoreCase(backHref) ? ImageUtils.getImage("images/lauv-black-back.png") : ImageUtils.getImage(VehiclesHolder.getVehicleById(id).getBackImageHref());
        this.roll = 0.0f;
        this.repaint();
    }

    private void initialize() {
        this.setLayout(null);
        this.setDoubleBuffered(true);
    }

    public float getRoll() {
        return this.roll;
    }

    @Override
    public void paint(Graphics arg0) {
        super.paint(arg0);
        this.update(arg0);
    }

    public void setRoll(float y) {
        this.roll = y;
        this.repaint();
    }

    @Override
    public void update(Graphics arg0) {
        if (this.image == null) {
            return;
        }
        try {
            this.g2 = (Graphics2D)arg0;
            if (this.g2 == null) {
                return;
            }
            if (this.bi == null || this.bi.getWidth() < this.getWidth() || this.bi.getHeight() < this.getHeight()) {
                this.bi = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
            }
            Graphics2D g = (Graphics2D)this.bi.getGraphics();
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.translate(this.getWidth() / 2, this.getHeight() / 2);
            g.rotate(this.roll);
            double factorthis = (double)this.getWidth() / (double)this.getHeight();
            double factorim = (double)this.image.getWidth(null) / (double)this.image.getHeight(null);
            double scale = 1.0;
            scale = factorthis < factorim ? (double)this.getWidth() / (double)this.image.getWidth(null) : (double)this.getHeight() / (double)this.image.getHeight(this);
            g.scale(scale, scale);
            g.drawImage(this.image, -this.image.getWidth(this) / 2, -this.image.getHeight(this) / 2, this);
            g.scale(1.0 / scale, 1.0 / scale);
            g.rotate(-this.roll);
            g.translate(-this.getWidth() / 2, -this.getHeight() / 2);
            g.setColor(Color.BLACK);
            g.setStroke(new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{2.0f, 5.0f, 2.0f, 5.0f}, 0.0f));
            g.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
            this.g2.drawImage((Image)this.bi, 0, 0, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drawImage(Graphics2D g, Image img, int imgx, int imgy, int x, int y, int w, int h) {
        Graphics2D ng = (Graphics2D)g.create();
        ng.clipRect(x, y, w, h);
        ng.drawImage(img, imgx, imgy, this);
    }

    public static void main(String[] arg) {
        SideVehiclePanel buss = new SideVehiclePanel();
        GuiUtils.testFrame(buss, "compass");
        int i = 0;
        while (true) {
            buss.setPitch((float)Math.toRadians(i));
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            i -= 2;
        }
    }
}

