/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.util.Vector;
import pt.lsts.neptus.comm.CommUtil;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsoleSystem;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;

public class CommunicationsControlsProvider
implements PropertiesProvider {
    ConsoleLayout console;

    public CommunicationsControlsProvider(ConsoleLayout cons) {
        this.console = cons;
    }

    @Override
    public DefaultProperty[] getProperties() {
        Vector<DefaultProperty> props = new Vector<DefaultProperty>();
        for (ConsoleSystem j : this.console.getSystems().values()) {
            if (!CommUtil.isProtocolSupported(j.getVehicleId(), "imc")) continue;
            props.add(PropertiesEditor.getPropertyInstance(j.getVehicleId(), "IMC Communications", Boolean.class, j.isNeptusCommunications(), true));
        }
        return props.toArray(new DefaultProperty[0]);
    }

    @Override
    public void setProperties(Property[] properties) {
        for (Property p : properties) {
            for (ConsoleSystem j : this.console.getSystems().values()) {
                if (!j.getVehicleId().equals(p.getName()) || !p.getCategory().equals("IMC Communications")) continue;
                boolean imc = (Boolean)p.getValue();
                if (imc) {
                    j.enableIMC();
                    continue;
                }
                j.disableIMC();
            }
        }
    }

    @Override
    public String getPropertiesDialogTitle() {
        return "Communications Panel";
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }
}

