/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class CompassPanel
extends JPanel {
    private static final long serialVersionUID = 4060353229890430778L;
    public float yaw = 0.0f;
    public Graphics2D g2 = null;
    private Image image = ImageUtils.getImage("images/bussola.png");
    private BufferedImage bi = (BufferedImage)this.createImage(this.image.getWidth(null), this.image.getHeight(null));
    int lastWidth = 0;

    public CompassPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(null);
        this.setBounds(new Rectangle(0, 0, this.image.getWidth(null), this.image.getHeight(null)));
        this.setSize(this.image.getWidth(null), this.image.getHeight(null));
        this.setPreferredSize(new Dimension(140, 140));
        this.setDoubleBuffered(true);
    }

    public float getYaw() {
        return this.yaw;
    }

    @Override
    public void paint(Graphics arg0) {
        super.paint(arg0);
        this.update(arg0);
    }

    public void setYaw(float y) {
        this.yaw = y;
        this.repaint();
    }

    @Override
    public void update(Graphics arg0) {
        if (this.image == null) {
            NeptusLog.pub().error((Object)(this + ": Tried to draw a null image."));
            return;
        }
        try {
            this.g2 = (Graphics2D)arg0;
            if (this.g2 == null) {
                return;
            }
            if (this.bi == null || this.bi.getWidth() < this.getWidth() || this.bi.getHeight() < this.getHeight()) {
                this.bi = (BufferedImage)this.createImage(this.image.getWidth(null), this.image.getHeight(null));
            }
            Graphics2D g = (Graphics2D)this.bi.getGraphics();
            g.clearRect(0, 0, this.image.getWidth(null), this.image.getHeight(null));
            g.rotate(-this.yaw, this.image.getWidth(null) / 2, this.image.getHeight(null) / 2);
            g.drawImage(this.image, 0, 0, null);
            g.rotate(this.yaw, this.image.getWidth(null) / 2, this.image.getHeight(null) / 2);
            int yaux = (int)Math.toDegrees(this.yaw);
            Rectangle2D stringBounds = this.g2.getFontMetrics().getStringBounds("yaw:" + (yaux %= 360) + "\u00b0", this.g2);
            g.drawString("yaw:" + yaux + "\u00b0", (int)((double)(this.image.getWidth(null) / 2) - stringBounds.getCenterX()), (int)((double)(this.image.getHeight(null) / 2) - stringBounds.getCenterY()));
            this.g2.drawImage(this.bi, 0, 0, this.getWidth(), this.getHeight(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drawImage(Graphics2D g, Image img, int imgx, int imgy, int x, int y, int w, int h) {
        Graphics2D ng = (Graphics2D)g.create();
        ng.clipRect(x, y, w, h);
        ng.drawImage(img, imgx, imgy, this);
    }

    public static void main(String[] arg) {
        CompassPanel buss = new CompassPanel();
        GuiUtils.testFrame(buss, "compass");
        int i = 0;
        while (true) {
            buss.setYaw((float)Math.toRadians(i));
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            i -= 2;
        }
    }
}

