/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.console.plugins;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import net.miginfocom.swing.MigLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.MainPanel;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.PluginsRepository;
import pt.lsts.neptus.util.ImageUtils;

public class ComponentSelector
extends JComboBox<Class<?>> {
    private static final long serialVersionUID = 5643009716126585165L;

    public ComponentSelector(final MainPanel mainPanel) {
        for (Class<? extends ConsolePanel> sp : PluginsRepository.getPanelPlugins().values()) {
            if (sp.getAnnotation(PluginDescription.class) == null) continue;
            PluginsRepository.addPlugin(sp.getCanonicalName());
        }
        String[] subPanelList = PluginsRepository.getPanelPlugins().keySet().toArray(new String[0]);
        Arrays.sort(subPanelList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Collator collator = Collator.getInstance(Locale.US);
                return collator.compare(PluginUtils.i18nTranslate(o1), PluginUtils.i18nTranslate(o2));
            }
        });
        int c = 0;
        for (String plugin : subPanelList) {
            Class<? extends ConsolePanel> clazz = PluginsRepository.getPanelPlugins().get(plugin);
            this.insertItemAt(clazz, c++);
        }
        this.setRenderer(new ComponentSelectorRenderer());
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    mainPanel.setAdding((Class)e.getItem());
                }
            }
        });
    }

    class ComponentSelectorRenderer
    extends JPanel
    implements ListCellRenderer<Class<?>> {
        private static final long serialVersionUID = 1L;

        public ComponentSelectorRenderer() {
            this.setLayout((LayoutManager)new MigLayout());
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Class<?>> list, Class<?> value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                this.removeAll();
                JLabel icon = new JLabel();
                icon.setIcon(ImageUtils.createScaleImageIcon(PluginUtils.getPluginIcon(value), 16, 16));
                this.add(icon);
                this.add(new JLabel(PluginUtils.i18nTranslate(PluginUtils.getPluginName(value))));
            }
            return this;
        }
    }
}

